/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.encoder;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.parosproxy.paros.extension.encoder.Base64;

public class Encoder {
    private static final String CODEPAGE = "8859_1";

    public String getURLEncode(String string) {
        String string2 = "";
        try {
            string2 = URLEncoder.encode(string, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return string2;
    }

    public String getURLDecode(String string) {
        String string2 = "";
        try {
            string2 = URLDecoder.decode(string, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return string2;
    }

    public byte[] getHashSHA1(byte[] byArray) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        messageDigest.update(byArray);
        return messageDigest.digest();
    }

    public byte[] getHashMD5(byte[] byArray) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.update(byArray);
        return messageDigest.digest();
    }

    public String getHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(20);
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            String string = Integer.toHexString(n).toUpperCase();
            if (string.length() == 1) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public byte[] getBytes(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes(CODEPAGE);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return byArray;
    }

    public boolean isValidBase64(String string) {
        String string2 = Base64.encodeBytes(Base64.decode(string));
        return string.equals(string2);
    }

    public String getBase64Encode(String string) {
        String string2 = "";
        string2 = Base64.encodeBytes(this.getBytes(string));
        return string2;
    }

    public String getBase64Decode(String string) {
        String string2 = "";
        if (!this.isValidBase64(string)) {
            return string2;
        }
        try {
            string2 = new String(Base64.decode(string), CODEPAGE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }
}

