/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.scanner;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.parosproxy.paros.core.scanner.HostProcess;
import org.parosproxy.paros.extension.AbstractDialog;
import org.parosproxy.paros.extension.scanner.ExtensionScanner;
import org.parosproxy.paros.extension.scanner.HostProgressMeter;

public class ProgressDialog
extends AbstractDialog {
    private JPanel jPanel = null;
    private JScrollPane paneScroll = null;
    private JButton btnStopAllHost = null;
    private JPanel paneProgress = null;
    private ExtensionScanner pluginScanner = null;

    public ProgressDialog() throws HeadlessException {
        this.initialize();
    }

    public ProgressDialog(Frame frame, boolean bl) throws HeadlessException {
        super(frame, bl);
        this.initialize();
    }

    private void initialize() {
        this.setTitle("Scanning");
        this.setName("ProgressDialog");
        this.setDefaultCloseOperation(2);
        this.setContentPane(this.getJPanel());
        this.setSize(440, 550);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ProgressDialog.this.getBtnStopAllHost().doClick();
            }
        });
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints2.anchor = 18;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.anchor = 16;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.jPanel.add((Component)this.getPaneScroll(), gridBagConstraints2);
            this.jPanel.add((Component)this.getBtnStopAllHost(), gridBagConstraints);
        }
        return this.jPanel;
    }

    private JScrollPane getPaneScroll() {
        if (this.paneScroll == null) {
            this.paneScroll = new JScrollPane();
            this.paneScroll.setHorizontalScrollBarPolicy(31);
            this.paneScroll.setViewportView(this.getPaneProgress());
        }
        return this.paneScroll;
    }

    private JButton getBtnStopAllHost() {
        if (this.btnStopAllHost == null) {
            this.btnStopAllHost = new JButton();
            this.btnStopAllHost.setText("Stop all hosts");
            this.btnStopAllHost.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (ProgressDialog.this.pluginScanner != null) {
                        ProgressDialog.this.btnStopAllHost.setEnabled(false);
                        ProgressDialog.this.pluginScanner.getScanner().stop();
                    }
                }
            });
        }
        return this.btnStopAllHost;
    }

    private JPanel getPaneProgress() {
        if (this.paneProgress == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setColumns(1);
            gridLayout.setRows(5);
            this.paneProgress = new JPanel();
            this.paneProgress.setLayout(gridLayout);
        }
        return this.paneProgress;
    }

    void addHostProgress(final String string, final HostProcess hostProcess) {
        if (EventQueue.isDispatchThread()) {
            this.addHostProgressNonEvent(string, hostProcess);
            return;
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    ProgressDialog.this.addHostProgressNonEvent(string, hostProcess);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void removeHostProgress(final String string) {
        if (EventQueue.isDispatchThread()) {
            this.removeHostProgressNonEvent(string);
            return;
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    ProgressDialog.this.removeHostProgressNonEvent(string);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void updateHostProgress(final String string, final String string2, final int n) {
        if (EventQueue.isDispatchThread()) {
            this.updateHostProgressNonEvent(string, string2, n);
            return;
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    ProgressDialog.this.updateHostProgressNonEvent(string, string2, n);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHostProgressNonEvent(String string, HostProcess hostProcess) {
        HostProgressMeter hostProgressMeter = new HostProgressMeter();
        hostProgressMeter.setHostProcess(hostProcess);
        hostProgressMeter.setName(string);
        hostProgressMeter.getTxtHost().setText(string);
        JPanel jPanel = this.getPaneProgress();
        synchronized (jPanel) {
            this.getPaneProgress().add(hostProgressMeter);
            this.getPaneProgress().validate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeHostProgressNonEvent(String string) {
        HostProgressMeter hostProgressMeter = this.getMeter(string);
        if (hostProgressMeter == null) {
            return;
        }
        JPanel jPanel = this.getPaneProgress();
        synchronized (jPanel) {
            this.getPaneProgress().remove(hostProgressMeter);
            this.getPaneProgress().validate();
        }
    }

    private void updateHostProgressNonEvent(String string, String string2, int n) {
        HostProgressMeter hostProgressMeter = this.getMeter(string);
        if (hostProgressMeter == null) {
            return;
        }
        hostProgressMeter.setProgress(string2, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HostProgressMeter getMeter(String string) {
        JPanel jPanel = this.getPaneProgress();
        synchronized (jPanel) {
            for (int i = 0; i < this.getPaneProgress().getComponentCount(); ++i) {
                Component component = this.getPaneProgress().getComponent(i);
                if (!component.getName().equals(string)) continue;
                return (HostProgressMeter)component;
            }
        }
        return null;
    }

    public void setPluginScanner(ExtensionScanner extensionScanner) {
        this.pluginScanner = extensionScanner;
    }
}

