/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.FrameStateListener;
import com.intellij.ide.FrameStateManager;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileChangedNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(FileChangedNotificationProvider.class);
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"file.changed.notification.panel");
    private final Project myProject;

    public FileChangedNotificationProvider(@NotNull Project project, @NotNull FrameStateManager frameStateManager) {
        if (project == null) {
            FileChangedNotificationProvider.$$$reportNull$$$0(0);
        }
        if (frameStateManager == null) {
            FileChangedNotificationProvider.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        frameStateManager.addListener(new FrameStateListener(){

            public void onFrameActivated() {
                if (!FileChangedNotificationProvider.this.myProject.isDisposed() && !GeneralSettings.getInstance().isSyncOnFrameActivation()) {
                    EditorNotifications notifications = EditorNotifications.getInstance((Project)FileChangedNotificationProvider.this.myProject);
                    for (VirtualFile file2 : FileEditorManager.getInstance((Project)FileChangedNotificationProvider.this.myProject).getSelectedFiles()) {
                        notifications.updateNotifications(file2);
                    }
                }
            }
        }, (Disposable)project);
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.myProject);
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!FileChangedNotificationProvider.this.myProject.isDisposed() && !GeneralSettings.getInstance().isSyncOnFrameActivation()) {
                    HashSet openFiles = ContainerUtil.newHashSet((Object[])FileEditorManager.getInstance((Project)FileChangedNotificationProvider.this.myProject).getSelectedFiles());
                    EditorNotifications notifications = EditorNotifications.getInstance((Project)FileChangedNotificationProvider.this.myProject);
                    for (VFileEvent vFileEvent : events) {
                        VirtualFile file2 = vFileEvent.getFile();
                        if (file2 == null || !openFiles.contains(file2)) continue;
                        notifications.updateNotifications(file2);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/ide/FileChangedNotificationProvider$2", "after"));
            }
        });
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            FileChangedNotificationProvider.$$$reportNull$$$0(2);
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor) {
        FileAttributes attributes;
        VirtualFileSystem fs;
        if (file2 == null) {
            FileChangedNotificationProvider.$$$reportNull$$$0(3);
        }
        if (fileEditor == null) {
            FileChangedNotificationProvider.$$$reportNull$$$0(4);
        }
        if (!(this.myProject.isDisposed() || GeneralSettings.getInstance().isSyncOnFrameActivation() || !((fs = file2.getFileSystem()) instanceof LocalFileSystem) || (attributes = ((LocalFileSystem)fs).getAttributes(file2)) != null && file2.getTimeStamp() == attributes.lastModified && file2.getLength() == attributes.length)) {
            LogUtil.debug((Logger)LOG, (String)"%s: (%s,%s) -> %s", (Object[])new Object[]{file2, file2.getTimeStamp(), file2.getLength(), attributes});
            return this.createPanel(file2);
        }
        return null;
    }

    private EditorNotificationPanel createPanel(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileChangedNotificationProvider.$$$reportNull$$$0(5);
        }
        EditorNotificationPanel panel2 = new EditorNotificationPanel();
        panel2.setText(IdeBundle.message((String)"file.changed.externally.message", (Object[])new Object[0]));
        panel2.createActionLabel(IdeBundle.message((String)"file.changed.externally.reload", (Object[])new Object[0]), () -> {
            if (file2 == null) {
                FileChangedNotificationProvider.$$$reportNull$$$0(6);
            }
            if (!this.myProject.isDisposed()) {
                file2.refresh(false, false);
                EditorNotifications.getInstance((Project)this.myProject).updateNotifications(file2);
            }
        });
        return panel2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameStateManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/FileChangedNotificationProvider";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/FileChangedNotificationProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPanel";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createPanel$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

