/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.customization;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.customization.ActionUrl;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.ide.ui.customization.CustomizationUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.actionSystem.ex.QuickListsManager;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.ui.ActionsTree;
import com.intellij.openapi.keymap.impl.ui.ActionsTreeUtil;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.ui.TreeExpansionMonitor;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.FilterComponent;
import com.intellij.ui.InsertPathAction;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.mac.touchbar.TouchBarsManager;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ImageLoader;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomizableActionsPanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.ui.customization.CustomizableActionsPanel");
    private JPanel myPanel;
    private JTree myActionsTree;
    private JPanel myTopPanel;
    private CustomActionsSchema mySelectedSchema;

    public CustomizableActionsPanel() {
        this.$$$setupUI$$$();
        Group rootGroup = new Group("root", null, null);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(rootGroup);
        DefaultTreeModel model = new DefaultTreeModel(root);
        this.myActionsTree.setModel(model);
        this.myActionsTree.setRootVisible(false);
        this.myActionsTree.setShowsRootHandles(true);
        UIUtil.setLineStyleAngled((JTree)this.myActionsTree);
        this.myActionsTree.setCellRenderer((TreeCellRenderer)((Object)new MyTreeCellRenderer()));
        this.patchActionsTreeCorrespondingToSchema(root);
        TreeExpansionMonitor.install(this.myActionsTree);
        this.myTopPanel.setLayout(new BorderLayout());
        this.myTopPanel.add((Component)CustomizableActionsPanel.setupFilterComponent(this.myActionsTree), "West");
        this.myTopPanel.add((Component)this.createToolbar(), "Center");
    }

    private ActionToolbarImpl createToolbar() {
        DefaultActionGroup addGroup = new DefaultActionGroup(new AnAction[]{new AddActionActionTreeSelectionAction(), new AddSeparatorAction()});
        addGroup.getTemplatePresentation().setIcon(AllIcons.General.Add);
        addGroup.setPopup(true);
        DefaultActionGroup restoreGroup = new DefaultActionGroup(new AnAction[]{new RestoreSelectionAction(), new RestoreAllAction()});
        restoreGroup.setPopup(true);
        restoreGroup.getTemplatePresentation().setIcon(AllIcons.Actions.Rollback);
        ActionToolbarImpl toolbar = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)new DefaultActionGroup(new AnAction[]{addGroup, new RemoveAction(), new EditIconAction(), new MoveUpAction(), new MoveDownAction(), restoreGroup}), true);
        toolbar.setForceMinimumSize(true);
        toolbar.setLayoutPolicy(0);
        return toolbar;
    }

    private static FilterComponent setupFilterComponent(JTree tree) {
        int[] keyCodes;
        final TreeSpeedSearch mySpeedSearch = new TreeSpeedSearch(tree, new TreePathStringConvertor(), true){

            @Override
            public boolean isPopupActive() {
                return true;
            }

            @Override
            public void showPopup(String searchText) {
            }

            @Override
            protected boolean isSpeedSearchEnabled() {
                return false;
            }

            @Override
            public void showPopup() {
            }
        };
        final FilterComponent filterComponent = new FilterComponent("CUSTOMIZE_ACTIONS", 5){

            public void filter() {
                mySpeedSearch.findAndSelectElement(this.getFilter());
            }
        };
        JTextField textField2 = filterComponent.getTextEditor();
        for (final int keyCode : keyCodes = new int[]{36, 35, 38, 40}) {
            new DumbAwareAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    String filter;
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (!StringUtil.isEmpty((String)(filter = filterComponent.getFilter()))) {
                        mySpeedSearch.adjustSelection(keyCode, filter);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/ui/customization/CustomizableActionsPanel$3", "actionPerformed"));
                }
            }.registerCustomShortcutSet(keyCode, 0, (JComponent)textField2);
        }
        return filterComponent;
    }

    private void addCustomizedAction(ActionUrl url) {
        this.mySelectedSchema.addAction(url);
    }

    private static boolean isMoveSupported(JTree tree, int dir) {
        TreePath[] selectionPaths = tree.getSelectionPaths();
        if (selectionPaths != null) {
            DefaultMutableTreeNode parent = null;
            for (TreePath treePath : selectionPaths) {
                if (treePath.getLastPathComponent() == null) continue;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                if (parent == null) {
                    parent = (DefaultMutableTreeNode)node.getParent();
                }
                if (parent != node.getParent()) {
                    return false;
                }
                if (!(dir > 0 ? parent.getIndex(node) == parent.getChildCount() - 1 : parent.getIndex(node) == 0)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    public void apply() throws ConfigurationException {
        List treePaths = TreeUtil.collectExpandedPaths((JTree)this.myActionsTree);
        if (this.mySelectedSchema != null) {
            CustomizationUtil.optimizeSchema(this.myActionsTree, this.mySelectedSchema);
        }
        this.restorePathsAfterTreeOptimization(treePaths);
        CustomActionsSchema.getInstance().copyFrom(this.mySelectedSchema);
        CustomActionsSchema.setCustomizationSchemaForCurrentProjects();
        TouchBarsManager.reloadAll();
    }

    private void restorePathsAfterTreeOptimization(List<TreePath> treePaths) {
        for (TreePath treePath : treePaths) {
            this.myActionsTree.expandPath(CustomizationUtil.getPathByUserObjects(this.myActionsTree, treePath));
        }
    }

    public void reset() {
        this.mySelectedSchema = new CustomActionsSchema();
        this.mySelectedSchema.copyFrom(CustomActionsSchema.getInstance());
        this.patchActionsTreeCorrespondingToSchema((DefaultMutableTreeNode)this.myActionsTree.getModel().getRoot());
        this.myActionsTree.setSelectionRow(0);
    }

    public boolean isModified() {
        CustomizationUtil.optimizeSchema(this.myActionsTree, this.mySelectedSchema);
        return CustomActionsSchema.getInstance().isModified(this.mySelectedSchema);
    }

    private void patchActionsTreeCorrespondingToSchema(DefaultMutableTreeNode root) {
        root.removeAllChildren();
        if (this.mySelectedSchema != null) {
            this.mySelectedSchema.fillActionGroups(root);
            for (ActionUrl actionUrl : this.mySelectedSchema.getActions()) {
                ActionUrl.changePathInActionsTree(this.myActionsTree, actionUrl);
            }
        }
        ((DefaultTreeModel)this.myActionsTree.getModel()).reload();
    }

    @Nullable
    private static String getActionId(DefaultMutableTreeNode node) {
        return (String)(node.getUserObject() instanceof String ? node.getUserObject() : (node.getUserObject() instanceof Pair ? ((Pair)node.getUserObject()).first : null));
    }

    protected boolean doSetIcon(DefaultMutableTreeNode node, @Nullable String path, Component component) {
        if (StringUtil.isNotEmpty((String)path) && !new File(path).isFile()) {
            Messages.showErrorDialog((Component)component, (String)IdeBundle.message((String)"error.file.not.found.message", (Object[])new Object[]{path}), (String)IdeBundle.message((String)"title.choose.action.icon", (Object[])new Object[0]));
            return false;
        }
        String actionId = CustomizableActionsPanel.getActionId(node);
        if (actionId == null) {
            return false;
        }
        AnAction action = ActionManager.getInstance().getAction(actionId);
        if (action != null) {
            if (StringUtil.isNotEmpty((String)path)) {
                Icon icon;
                Image image = null;
                try {
                    image = ImageLoader.loadFromStream((InputStream)VfsUtilCore.convertToURL((String)VfsUtilCore.pathToUrl((String)path.replace(File.separatorChar, '/'))).openStream());
                }
                catch (IOException e) {
                    LOG.debug((Throwable)e);
                }
                Icon icon2 = icon = new File(path).exists() ? IconLoader.getIcon((Image)image) : null;
                if (icon != null) {
                    if (icon.getIconWidth() > EmptyIcon.ICON_18.getIconWidth() || icon.getIconHeight() > EmptyIcon.ICON_18.getIconHeight()) {
                        Messages.showErrorDialog((Component)component, (String)IdeBundle.message((String)"custom.icon.validation.message", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.choose.action.icon", (Object[])new Object[0]));
                        return false;
                    }
                    node.setUserObject(Pair.create((Object)actionId, (Object)icon));
                    this.mySelectedSchema.addIconCustomization(actionId, path);
                }
            } else {
                node.setUserObject(Pair.create((Object)actionId, null));
                this.mySelectedSchema.removeIconCustomization(actionId);
                DefaultMutableTreeNode nodeOnToolbar = this.findNodeOnToolbar(actionId);
                if (nodeOnToolbar != null) {
                    node.setUserObject(nodeOnToolbar.getUserObject());
                }
            }
            return true;
        }
        return false;
    }

    private static TextFieldWithBrowseButton createBrowseField() {
        TextFieldWithBrowseButton textField2 = new TextFieldWithBrowseButton();
        textField2.setPreferredSize(new Dimension(200, textField2.getPreferredSize().height));
        textField2.setMinimumSize(new Dimension(200, textField2.getPreferredSize().height));
        FileChooserDescriptor fileChooserDescriptor2 = new FileChooserDescriptor(true, false, false, false, false, false){

            public boolean isFileSelectable(VirtualFile file2) {
                return file2.getName().endsWith(".png");
            }
        };
        textField2.addBrowseFolderListener(IdeBundle.message((String)"title.browse.icon", (Object[])new Object[0]), IdeBundle.message((String)"prompt.browse.icon.for.selected.action", (Object[])new Object[0]), null, fileChooserDescriptor2);
        InsertPathAction.addTo((JTextComponent)textField2.getTextField(), (FileChooserDescriptor)fileChooserDescriptor2);
        return textField2;
    }

    @Nullable
    private DefaultMutableTreeNode findNodeOnToolbar(String actionId) {
        TreeNode toolbar = ((DefaultMutableTreeNode)this.myActionsTree.getModel().getRoot()).getChildAt(1);
        for (int i = 0; i < toolbar.getChildCount(); ++i) {
            DefaultMutableTreeNode child2 = (DefaultMutableTreeNode)toolbar.getChildAt(i);
            String childId = CustomizableActionsPanel.getActionId(child2);
            if (childId == null || !childId.equals(actionId)) continue;
            return child2;
        }
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(9, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel3.add((Component)jBScrollPane, new GridConstraints(0, 0, 9, 1, 0, 3, 7, 7, null, null, null));
        Tree tree = new Tree();
        this.myActionsTree = tree;
        jBScrollPane.setViewportView((Component)tree);
        this.myTopPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private class RestoreAllAction
    extends DumbAwareAction {
        private RestoreAllAction() {
            super(IdeBundle.message((String)"button.restore.all", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RestoreAllAction.$$$reportNull$$$0(0);
            }
            CustomizableActionsPanel.this.mySelectedSchema.copyFrom(new CustomActionsSchema());
            CustomizableActionsPanel.this.patchActionsTreeCorrespondingToSchema((DefaultMutableTreeNode)CustomizableActionsPanel.this.myActionsTree.getModel().getRoot());
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RestoreAllAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(CustomizableActionsPanel.this.mySelectedSchema.isModified(new CustomActionsSchema()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/ui/customization/CustomizableActionsPanel$RestoreAllAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class RestoreSelectionAction
    extends DumbAwareAction {
        private RestoreSelectionAction() {
            super(IdeBundle.message((String)"button.restore.selected.groups", (Object[])new Object[0]));
        }

        private Pair<TreeSet<String>, List<ActionUrl>> findActionsUnderSelection() {
            ArrayList<ActionUrl> actions = new ArrayList<ActionUrl>();
            TreeSet<String> selectedNames = new TreeSet<String>();
            TreePath[] selectionPaths = CustomizableActionsPanel.this.myActionsTree.getSelectionPaths();
            if (selectionPaths != null) {
                for (TreePath path : selectionPaths) {
                    ActionUrl selectedUrl = CustomizationUtil.getActionUrl(path, 2);
                    ArrayList<String> selectedGroupPath = new ArrayList<String>(selectedUrl.getGroupPath());
                    Object component = selectedUrl.getComponent();
                    if (!(component instanceof Group)) continue;
                    selectedGroupPath.add(((Group)component).getName());
                    selectedNames.add(((Group)component).getName());
                    for (ActionUrl action : CustomizableActionsPanel.this.mySelectedSchema.getActions()) {
                        ArrayList<String> groupPath = action.getGroupPath();
                        int idx = Collections.indexOfSubList(groupPath, selectedGroupPath);
                        if (idx <= -1) continue;
                        actions.add(action);
                    }
                }
            }
            return Pair.create(selectedNames, actions);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RestoreSelectionAction.$$$reportNull$$$0(0);
            }
            ArrayList<ActionUrl> otherActions = new ArrayList<ActionUrl>(CustomizableActionsPanel.this.mySelectedSchema.getActions());
            otherActions.removeAll((Collection)this.findActionsUnderSelection().second);
            CustomizableActionsPanel.this.mySelectedSchema.copyFrom(new CustomActionsSchema());
            for (ActionUrl otherAction : otherActions) {
                CustomizableActionsPanel.this.mySelectedSchema.addAction(otherAction);
            }
            List treePaths = TreeUtil.collectExpandedPaths((JTree)CustomizableActionsPanel.this.myActionsTree);
            CustomizableActionsPanel.this.patchActionsTreeCorrespondingToSchema((DefaultMutableTreeNode)CustomizableActionsPanel.this.myActionsTree.getModel().getRoot());
            CustomizableActionsPanel.this.restorePathsAfterTreeOptimization(treePaths);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RestoreSelectionAction.$$$reportNull$$$0(1);
            }
            Pair<TreeSet<String>, List<ActionUrl>> selection = this.findActionsUnderSelection();
            e.getPresentation().setEnabled(!((List)selection.second).isEmpty());
            if (((TreeSet)selection.first).size() != 1) {
                e.getPresentation().setText(IdeBundle.message((String)"button.restore.selected.groups", (Object[])new Object[0]));
            } else {
                e.getPresentation().setText(IdeBundle.message((String)"button.restore.selection", (Object[])new Object[]{((TreeSet)selection.first).iterator().next()}));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/ui/customization/CustomizableActionsPanel$RestoreSelectionAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MoveDownAction
    extends TreeSelectionAction {
        private MoveDownAction() {
            super(IdeBundle.message((String)"button.move.down", (Object[])new Object[0]), null, AllIcons.Actions.MoveDown);
            this.registerCustomShortcutSet(CommonShortcuts.MOVE_DOWN, CustomizableActionsPanel.this.myPanel);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MoveDownAction.$$$reportNull$$$0(0);
            }
            List expandedPaths = TreeUtil.collectExpandedPaths((JTree)CustomizableActionsPanel.this.myActionsTree);
            TreePath[] selectionPath = CustomizableActionsPanel.this.myActionsTree.getSelectionPaths();
            if (selectionPath != null) {
                for (int i = selectionPath.length - 1; i >= 0; --i) {
                    TreePath treePath = selectionPath[i];
                    ActionUrl url = CustomizationUtil.getActionUrl(treePath, 2);
                    int absolutePosition = url.getAbsolutePosition();
                    url.setInitialPosition(absolutePosition);
                    url.setAbsolutePosition(absolutePosition + 1);
                    ActionUrl.changePathInActionsTree(CustomizableActionsPanel.this.myActionsTree, url);
                    CustomizableActionsPanel.this.addCustomizedAction(url);
                }
                ((DefaultTreeModel)CustomizableActionsPanel.this.myActionsTree.getModel()).reload();
                TreeUtil.restoreExpandedPaths((JTree)CustomizableActionsPanel.this.myActionsTree, (List)expandedPaths);
                for (TreePath path : selectionPath) {
                    CustomizableActionsPanel.this.myActionsTree.addSelectionPath(path);
                }
            }
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MoveDownAction.$$$reportNull$$$0(1);
            }
            super.update(e);
            e.getPresentation().setEnabled(e.getPresentation().isEnabled() && CustomizableActionsPanel.isMoveSupported(CustomizableActionsPanel.this.myActionsTree, 1));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/ui/customization/CustomizableActionsPanel$MoveDownAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MoveUpAction
    extends TreeSelectionAction {
        private MoveUpAction() {
            super(IdeBundle.message((String)"button.move.up", (Object[])new Object[0]), null, AllIcons.Actions.MoveUp);
            this.registerCustomShortcutSet(CommonShortcuts.MOVE_UP, CustomizableActionsPanel.this.myPanel);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MoveUpAction.$$$reportNull$$$0(0);
            }
            List expandedPaths = TreeUtil.collectExpandedPaths((JTree)CustomizableActionsPanel.this.myActionsTree);
            TreePath[] selectionPath = CustomizableActionsPanel.this.myActionsTree.getSelectionPaths();
            if (selectionPath != null) {
                for (TreePath treePath : selectionPath) {
                    ActionUrl url = CustomizationUtil.getActionUrl(treePath, 2);
                    int absolutePosition = url.getAbsolutePosition();
                    url.setInitialPosition(absolutePosition);
                    url.setAbsolutePosition(absolutePosition - 1);
                    ActionUrl.changePathInActionsTree(CustomizableActionsPanel.this.myActionsTree, url);
                    CustomizableActionsPanel.this.addCustomizedAction(url);
                }
                ((DefaultTreeModel)CustomizableActionsPanel.this.myActionsTree.getModel()).reload();
                TreeUtil.restoreExpandedPaths((JTree)CustomizableActionsPanel.this.myActionsTree, (List)expandedPaths);
                for (TreePath path : selectionPath) {
                    CustomizableActionsPanel.this.myActionsTree.addSelectionPath(path);
                }
            }
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MoveUpAction.$$$reportNull$$$0(1);
            }
            super.update(e);
            e.getPresentation().setEnabled(e.getPresentation().isEnabled() && CustomizableActionsPanel.isMoveSupported(CustomizableActionsPanel.this.myActionsTree, -1));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/ui/customization/CustomizableActionsPanel$MoveUpAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class EditIconAction
    extends TreeSelectionAction {
        private EditIconAction() {
            super(IdeBundle.message((String)"button.edit.action.icon", (Object[])new Object[0]), null, AllIcons.Actions.Edit);
            this.registerCustomShortcutSet(CommonShortcuts.getEditSource(), CustomizableActionsPanel.this.myPanel);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            EditIconDialog dlg;
            if (e == null) {
                EditIconAction.$$$reportNull$$$0(0);
            }
            List expandedPaths = TreeUtil.collectExpandedPaths((JTree)CustomizableActionsPanel.this.myActionsTree);
            TreePath selectionPath = CustomizableActionsPanel.this.myActionsTree.getLeadSelectionPath();
            if (selectionPath != null && (dlg = new EditIconDialog((DefaultMutableTreeNode)selectionPath.getLastPathComponent())).showAndGet()) {
                CustomizableActionsPanel.this.myActionsTree.repaint();
            }
            TreeUtil.restoreExpandedPaths((JTree)CustomizableActionsPanel.this.myActionsTree, (List)expandedPaths);
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                EditIconAction.$$$reportNull$$$0(1);
            }
            super.update(e);
            if (e.getPresentation().isEnabled()) {
                ActionManager actionManager = ActionManager.getInstance();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)CustomizableActionsPanel.this.myActionsTree.getLeadSelectionPath().getLastPathComponent();
                String actionId = CustomizableActionsPanel.getActionId(node);
                if (actionId != null) {
                    AnAction action = actionManager.getAction(actionId);
                    e.getPresentation().setEnabled(action != null);
                } else {
                    e.getPresentation().setEnabled(false);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/ui/customization/CustomizableActionsPanel$EditIconAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class RemoveAction
    extends TreeSelectionAction {
        private RemoveAction() {
            super(IdeBundle.message((String)"button.remove", (Object[])new Object[0]), null, AllIcons.General.Remove);
            ShortcutSet shortcutSet = KeymapUtil.filterKeyStrokes((ShortcutSet)CommonShortcuts.getDelete(), (KeyStroke[])new KeyStroke[]{KeyStroke.getKeyStroke(127, 0), KeyStroke.getKeyStroke(8, 0)});
            if (shortcutSet != null) {
                this.registerCustomShortcutSet(shortcutSet, CustomizableActionsPanel.this.myPanel);
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RemoveAction.$$$reportNull$$$0(0);
            }
            List expandedPaths = TreeUtil.collectExpandedPaths((JTree)CustomizableActionsPanel.this.myActionsTree);
            TreePath[] selectionPath = CustomizableActionsPanel.this.myActionsTree.getSelectionPaths();
            if (selectionPath != null) {
                for (TreePath treePath : selectionPath) {
                    ActionUrl url = CustomizationUtil.getActionUrl(treePath, -1);
                    ActionUrl.changePathInActionsTree(CustomizableActionsPanel.this.myActionsTree, url);
                    CustomizableActionsPanel.this.addCustomizedAction(url);
                }
                ((DefaultTreeModel)CustomizableActionsPanel.this.myActionsTree.getModel()).reload();
            }
            TreeUtil.restoreExpandedPaths((JTree)CustomizableActionsPanel.this.myActionsTree, (List)expandedPaths);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/ui/customization/CustomizableActionsPanel$RemoveAction", "actionPerformed"));
        }
    }

    private class AddSeparatorAction
    extends TreeSelectionAction {
        private AddSeparatorAction() {
            super(IdeBundle.message((String)"button.add.separator", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddSeparatorAction.$$$reportNull$$$0(0);
            }
            List expandedPaths = TreeUtil.collectExpandedPaths((JTree)CustomizableActionsPanel.this.myActionsTree);
            TreePath selectionPath = CustomizableActionsPanel.this.myActionsTree.getLeadSelectionPath();
            if (selectionPath != null) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
                ActionUrl url = new ActionUrl(ActionUrl.getGroupPath(selectionPath), Separator.getInstance(), 1, node.getParent().getIndex(node) + 1);
                ActionUrl.changePathInActionsTree(CustomizableActionsPanel.this.myActionsTree, url);
                CustomizableActionsPanel.this.addCustomizedAction(url);
                ((DefaultTreeModel)CustomizableActionsPanel.this.myActionsTree.getModel()).reload();
            }
            TreeUtil.restoreExpandedPaths((JTree)CustomizableActionsPanel.this.myActionsTree, (List)expandedPaths);
            CustomizableActionsPanel.this.myActionsTree.setSelectionRow(CustomizableActionsPanel.this.myActionsTree.getRowForPath(selectionPath) + 1);
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                AddSeparatorAction.$$$reportNull$$$0(1);
            }
            super.update(e);
            if (e.getPresentation().isEnabled()) {
                e.getPresentation().setEnabled(this.isSingleSelection());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/ui/customization/CustomizableActionsPanel$AddSeparatorAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class AddGroupAction
    extends TreeSelectionAction {
        private AddGroupAction() {
            super(IdeBundle.message((String)"button.add.group", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddGroupAction.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/ui/customization/CustomizableActionsPanel$AddGroupAction", "actionPerformed"));
        }
    }

    private class AddActionActionTreeSelectionAction
    extends TreeSelectionAction {
        private AddActionActionTreeSelectionAction() {
            super(IdeBundle.message((String)"button.add.action", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddActionActionTreeSelectionAction.$$$reportNull$$$0(0);
            }
            List expandedPaths = TreeUtil.collectExpandedPaths((JTree)CustomizableActionsPanel.this.myActionsTree);
            TreePath selectionPath = CustomizableActionsPanel.this.myActionsTree.getLeadSelectionPath();
            int row2 = CustomizableActionsPanel.this.myActionsTree.getRowForPath(selectionPath);
            if (selectionPath != null) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
                FindAvailableActionsDialog dlg = new FindAvailableActionsDialog();
                if (dlg.showAndGet()) {
                    Set<Object> toAdd = dlg.getTreeSelectedActionIds();
                    if (toAdd == null) {
                        return;
                    }
                    for (Object o : toAdd) {
                        ActionUrl url = new ActionUrl(ActionUrl.getGroupPath(new TreePath(node.getPath())), o, 1, node.getParent().getIndex(node) + 1);
                        CustomizableActionsPanel.this.addCustomizedAction(url);
                        ActionUrl.changePathInActionsTree(CustomizableActionsPanel.this.myActionsTree, url);
                        if (!(o instanceof String)) continue;
                        DefaultMutableTreeNode current = new DefaultMutableTreeNode(url.getComponent());
                        current.setParent((DefaultMutableTreeNode)node.getParent());
                        selectionPath = selectionPath.getParentPath().pathByAddingChild(url.getComponent());
                    }
                    ((DefaultTreeModel)CustomizableActionsPanel.this.myActionsTree.getModel()).reload();
                    TreeUtil.restoreExpandedPaths((JTree)CustomizableActionsPanel.this.myActionsTree, (List)expandedPaths);
                    CustomizableActionsPanel.this.myActionsTree.setSelectionRow(row2 + 1);
                }
            }
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                AddActionActionTreeSelectionAction.$$$reportNull$$$0(1);
            }
            super.update(e);
            if (e.getPresentation().isEnabled()) {
                e.getPresentation().setEnabled(this.isSingleSelection());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/ui/customization/CustomizableActionsPanel$AddActionActionTreeSelectionAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private abstract class TreeSelectionAction
    extends DumbAwareAction {
        private TreeSelectionAction(String text) {
            super(text);
        }

        private TreeSelectionAction(@Nullable String text, @Nullable String description, Icon icon) {
            super(text, description, icon);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                TreeSelectionAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(true);
            TreePath[] selectionPaths = CustomizableActionsPanel.this.myActionsTree.getSelectionPaths();
            if (selectionPaths == null) {
                e.getPresentation().setEnabled(false);
                return;
            }
            for (TreePath path : selectionPaths) {
                if (path.getPath().length > 2) continue;
                e.getPresentation().setEnabled(false);
                return;
            }
        }

        protected final boolean isSingleSelection() {
            TreePath[] selectionPaths = CustomizableActionsPanel.this.myActionsTree.getSelectionPaths();
            return selectionPaths != null && selectionPaths.length == 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/ui/customization/CustomizableActionsPanel$TreeSelectionAction", "update"));
        }
    }

    private class FindAvailableActionsDialog
    extends DialogWrapper {
        private JTree myTree;
        private JButton mySetIconButton;
        private TextFieldWithBrowseButton myTextField;
        private FilterComponent myFilterComponent;

        FindAvailableActionsDialog() {
            super(false);
            this.setTitle(IdeBundle.message((String)"action.choose.actions.to.add", (Object[])new Object[0]));
            this.init();
        }

        protected JComponent createCenterPanel() {
            Group rootGroup = ActionsTreeUtil.createMainGroup(null, null, QuickListsManager.getInstance().getAllQuickLists());
            DefaultMutableTreeNode root = ActionsTreeUtil.createNode(rootGroup);
            DefaultTreeModel model = new DefaultTreeModel(root);
            this.myTree = new Tree();
            TreeUIHelper.getInstance().installTreeSpeedSearch(this.myTree, (Convertor)new TreePathStringConvertor(), true);
            this.myTree.setModel(model);
            this.myTree.setRootVisible(false);
            this.myTree.setCellRenderer((TreeCellRenderer)((Object)new MyTreeCellRenderer()));
            final ActionManager actionManager = ActionManager.getInstance();
            this.mySetIconButton = new JButton(IdeBundle.message((String)"button.set.icon", (Object[])new Object[0]));
            this.mySetIconButton.setEnabled(false);
            this.mySetIconButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TreePath selectionPath = FindAvailableActionsDialog.this.myTree.getSelectionPath();
                    if (selectionPath != null) {
                        CustomizableActionsPanel.this.doSetIcon((DefaultMutableTreeNode)selectionPath.getLastPathComponent(), FindAvailableActionsDialog.this.myTextField.getText(), FindAvailableActionsDialog.this.getContentPane());
                        FindAvailableActionsDialog.this.myTree.repaint();
                    }
                }
            });
            this.myTextField = CustomizableActionsPanel.createBrowseField();
            this.myTextField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    FindAvailableActionsDialog.this.enableSetIconButton(actionManager);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/ui/customization/CustomizableActionsPanel$FindAvailableActionsDialog$2", "textChanged"));
                }
            });
            JPanel southPanel = new JPanel(new BorderLayout());
            southPanel.add((Component)this.myTextField, "Center");
            JLabel label2 = new JLabel(IdeBundle.message((String)"label.icon.path", (Object[])new Object[0]));
            label2.setLabelFor(this.myTextField.getChildComponent());
            southPanel.add((Component)label2, "West");
            southPanel.add((Component)this.mySetIconButton, "East");
            southPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.add((Component)southPanel, "South");
            this.myFilterComponent = CustomizableActionsPanel.setupFilterComponent(this.myTree);
            panel2.add((Component)this.myFilterComponent, "North");
            panel2.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myTree), "Center");
            this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    DefaultMutableTreeNode node;
                    String actionId;
                    FindAvailableActionsDialog.this.enableSetIconButton(actionManager);
                    TreePath selectionPath = FindAvailableActionsDialog.this.myTree.getSelectionPath();
                    if (selectionPath != null && (actionId = CustomizableActionsPanel.getActionId(node = (DefaultMutableTreeNode)selectionPath.getLastPathComponent())) != null) {
                        String iconPath = CustomizableActionsPanel.this.mySelectedSchema.getIconPath(actionId);
                        FindAvailableActionsDialog.this.myTextField.setText(FileUtil.toSystemDependentName((String)iconPath));
                    }
                }
            });
            new DoubleClickListener(){

                protected boolean onDoubleClick(MouseEvent event) {
                    FindAvailableActionsDialog.this.doOKAction();
                    return true;
                }
            }.installOn((Component)this.myTree);
            return panel2;
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myFilterComponent.getTextEditor();
        }

        protected void doOKAction() {
            ActionManager actionManager = ActionManager.getInstance();
            TreeUtil.traverseDepth((TreeNode)((TreeNode)this.myTree.getModel().getRoot()), node -> {
                DefaultMutableTreeNode mutableNode;
                Object userObject;
                if (node instanceof DefaultMutableTreeNode && (userObject = (mutableNode = (DefaultMutableTreeNode)node).getUserObject()) instanceof Pair) {
                    String actionId = (String)((Pair)userObject).first;
                    AnAction action = actionManager.getAction(actionId);
                    Icon icon = (Icon)((Pair)userObject).second;
                    action.getTemplatePresentation().setIcon(icon);
                    action.setDefaultIcon(icon == null);
                }
                return true;
            });
            super.doOKAction();
            CustomActionsSchema.setCustomizationSchemaForCurrentProjects();
        }

        protected void enableSetIconButton(ActionManager actionManager) {
            AnAction action;
            TreePath selectionPath = this.myTree.getSelectionPath();
            Object userObject = null;
            if (selectionPath != null && (userObject = ((DefaultMutableTreeNode)selectionPath.getLastPathComponent()).getUserObject()) instanceof String && (action = actionManager.getAction((String)userObject)) != null && action.getTemplatePresentation().getIcon() != null) {
                this.mySetIconButton.setEnabled(true);
                return;
            }
            this.mySetIconButton.setEnabled(this.myTextField.getText().length() != 0 && selectionPath != null && new DefaultMutableTreeNode(selectionPath).isLeaf() && !(userObject instanceof Separator));
        }

        @Nullable
        public Set<Object> getTreeSelectedActionIds() {
            TreePath[] paths = this.myTree.getSelectionPaths();
            if (paths == null) {
                return null;
            }
            HashSet<Object> actions = new HashSet<Object>();
            for (TreePath path : paths) {
                Object node = path.getLastPathComponent();
                if (!(node instanceof DefaultMutableTreeNode)) continue;
                DefaultMutableTreeNode defNode = (DefaultMutableTreeNode)node;
                Object userObject = defNode.getUserObject();
                actions.add(userObject);
            }
            return actions;
        }

        protected String getDimensionServiceKey() {
            return "#com.intellij.ide.ui.customization.CustomizableActionsPanel.FindAvailableActionsDialog";
        }
    }

    private class EditIconDialog
    extends DialogWrapper {
        private final DefaultMutableTreeNode myNode;
        protected TextFieldWithBrowseButton myTextField;

        protected EditIconDialog(DefaultMutableTreeNode node) {
            super(false);
            this.setTitle(IdeBundle.message((String)"title.choose.action.icon", (Object[])new Object[0]));
            this.init();
            this.myNode = node;
            String actionId = CustomizableActionsPanel.getActionId(node);
            if (actionId != null) {
                String iconPath = CustomizableActionsPanel.this.mySelectedSchema.getIconPath(actionId);
                this.myTextField.setText(FileUtil.toSystemDependentName((String)iconPath));
            }
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myTextField.getChildComponent();
        }

        protected String getDimensionServiceKey() {
            return ((Object)((Object)this)).getClass().getName();
        }

        protected JComponent createCenterPanel() {
            this.myTextField = CustomizableActionsPanel.createBrowseField();
            JPanel northPanel = new JPanel(new BorderLayout());
            northPanel.add((Component)this.myTextField, "North");
            return northPanel;
        }

        protected void doOKAction() {
            if (this.myNode != null) {
                if (!CustomizableActionsPanel.this.doSetIcon(this.myNode, this.myTextField.getText(), this.getContentPane())) {
                    return;
                }
                Object userObject = this.myNode.getUserObject();
                if (userObject instanceof Pair) {
                    String actionId = (String)((Pair)userObject).first;
                    AnAction action = ActionManager.getInstance().getAction(actionId);
                    Icon icon = (Icon)((Pair)userObject).second;
                    action.getTemplatePresentation().setIcon(icon);
                    action.setDefaultIcon(icon == null);
                }
                CustomizableActionsPanel.this.myActionsTree.repaint();
            }
            CustomActionsSchema.setCustomizationSchemaForCurrentProjects();
            super.doOKAction();
        }
    }

    private class MyTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private MyTreeCellRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            if (tree == null) {
                MyTreeCellRenderer.$$$reportNull$$$0(0);
            }
            if (value instanceof DefaultMutableTreeNode) {
                Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
                Icon icon = null;
                if (userObject instanceof Group) {
                    Group group = (Group)userObject;
                    String name = group.getName();
                    this.append(name != null ? name : (String)ObjectUtils.notNull((Object)group.getId(), (Object)"<unnamed group>"));
                    icon = (Icon)ObjectUtils.notNull((Object)group.getIcon(), (Object)AllIcons.Nodes.Folder);
                } else if (userObject instanceof String) {
                    Icon actionIcon;
                    String actionId = (String)userObject;
                    AnAction action = ActionManager.getInstance().getAction(actionId);
                    String name = action != null ? action.getTemplatePresentation().getText() : null;
                    this.append(!StringUtil.isEmptyOrSpaces((String)name) ? name : actionId);
                    if (action != null && (actionIcon = action.getTemplatePresentation().getIcon()) != null) {
                        icon = actionIcon;
                    }
                } else if (userObject instanceof Pair) {
                    String actionId = (String)((Pair)userObject).first;
                    AnAction action = ActionManager.getInstance().getAction(actionId);
                    this.append(action != null ? action.getTemplatePresentation().getText() : actionId);
                    icon = (Icon)((Pair)userObject).second;
                } else if (userObject instanceof Separator) {
                    this.append("-------------");
                } else if (userObject instanceof QuickList) {
                    this.append(((QuickList)userObject).getName());
                    icon = null;
                } else if (userObject != null) {
                    throw new IllegalArgumentException("unknown userObject: " + userObject);
                }
                this.setIcon(ActionsTree.getEvenIcon(icon));
                this.setForeground(UIUtil.getTreeForeground((boolean)selected, (boolean)hasFocus));
                this.setIcon(icon);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ide/ui/customization/CustomizableActionsPanel$MyTreeCellRenderer", "customizeCellRenderer"));
        }
    }

    private static class TreePathStringConvertor
    implements Convertor<TreePath, String> {
        private TreePathStringConvertor() {
        }

        public String convert(TreePath o) {
            Object node = o.getLastPathComponent();
            if (node instanceof DefaultMutableTreeNode) {
                String actionId;
                Object object = ((DefaultMutableTreeNode)node).getUserObject();
                if (object instanceof Group) {
                    return ((Group)object).getName();
                }
                if (object instanceof QuickList) {
                    return ((QuickList)object).getName();
                }
                if (object instanceof String) {
                    actionId = (String)object;
                } else if (object instanceof Pair) {
                    actionId = (String)((Pair)object).first;
                } else {
                    return "";
                }
                AnAction action = ActionManager.getInstance().getAction(actionId);
                if (action != null) {
                    return action.getTemplatePresentation().getText();
                }
            }
            return "";
        }
    }
}

