/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.ide.ui.laf.intellij.MacIntelliJTextBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

public class MacIntelliJButtonBorder
implements Border,
UIResource {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (!c.hasFocus() || c instanceof JComponent && UIUtil.isHelpButton((Component)c)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.translate(x, y);
            float arc = MacIntelliJTextBorder.ARC.getFloat();
            if (DarculaButtonUI.isSmallComboButton(c) && c.isFocusable() && c.hasFocus()) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
                float lw = JBUI.scale((float)(UIUtil.isRetina((Graphics2D)g2) ? 0.5f : 1.0f));
                Path2D.Float border = new Path2D.Float(0);
                border.append(new RoundRectangle2D.Float(0.0f, 0.0f, width, height, arc + lw, arc + lw), false);
                border.append(new RoundRectangle2D.Float(lw * 2.0f, lw * 2.0f, (float)width - lw * 4.0f, (float)height - lw * 4.0f, arc, arc), false);
                g2.setColor(JBUI.CurrentTheme.Focus.focusColor());
                g2.fill(border);
            } else {
                DarculaUIUtil.paintFocusBorder(g2, width, height, arc, true);
            }
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return JBUI.insets((int)3).asUIResource();
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

