/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.concurrency.AsyncUtil;
import com.intellij.concurrency.JobLauncher;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.util.TooManyUsagesStatus;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.impl.search.BulkOccurrenceProcessor;
import com.intellij.psi.impl.search.LowLevelSearchUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiNonJavaFileReferenceProcessor;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.PsiSearchRequest;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.QuerySearchRequest;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.ScopeOptimizer;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.search.UseScopeEnlarger;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageInfoFactory;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.codeInsight.CommentUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.text.StringSearcher;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiSearchHelperImpl
implements PsiSearchHelper {
    private static final ExtensionPointName<ScopeOptimizer> USE_SCOPE_OPTIMIZER_EP_NAME = ExtensionPointName.create((String)"com.intellij.useScopeOptimizer");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.search.PsiSearchHelperImpl");
    private final PsiManagerEx myManager;
    private final DumbService myDumbService;

    @NotNull
    public SearchScope getUseScope(@NotNull PsiElement element) {
        if (element == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(0);
        }
        SearchScope scope = element.getUseScope();
        for (UseScopeEnlarger enlarger : (UseScopeEnlarger[])UseScopeEnlarger.EP_NAME.getExtensions()) {
            ProgressManager.checkCanceled();
            SearchScope additionalScope = enlarger.getAdditionalUseScope(element);
            if (additionalScope == null) continue;
            scope = scope.union(additionalScope);
        }
        SearchScope scopeToRestrict = ScopeOptimizer.calculateOverallRestrictedUseScope((ScopeOptimizer[])((ScopeOptimizer[])USE_SCOPE_OPTIMIZER_EP_NAME.getExtensions()), (PsiElement)element);
        if (scopeToRestrict != null) {
            scope = scope.intersectWith(scopeToRestrict);
        }
        SearchScope searchScope = scope;
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(1);
        }
        return searchScope;
    }

    public PsiSearchHelperImpl(@NotNull PsiManagerEx manager) {
        if (manager == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(2);
        }
        this.myManager = manager;
        this.myDumbService = DumbService.getInstance((Project)this.myManager.getProject());
    }

    @NotNull
    public PsiElement[] findCommentsContainingIdentifier(@NotNull String identifier, @NotNull SearchScope searchScope) {
        if (identifier == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(3);
        }
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(4);
        }
        List result2 = Collections.synchronizedList(new ArrayList());
        Processor processor2 = Processors.cancelableCollectProcessor(result2);
        this.processCommentsContainingIdentifier(identifier, searchScope, (Processor<? super PsiElement>)processor2);
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(result2);
        if (psiElementArray == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(5);
        }
        return psiElementArray;
    }

    public boolean processCommentsContainingIdentifier(@NotNull String identifier, @NotNull SearchScope searchScope, @NotNull Processor<? super PsiElement> processor2) {
        if (identifier == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(6);
        }
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(7);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(8);
        }
        TextOccurenceProcessor occurrenceProcessor = (element, offsetInElement) -> {
            if (processor2 == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(162);
            }
            if (CommentUtilCore.isCommentTextElement(element) && element.findReferenceAt(offsetInElement) == null) {
                return processor2.process((Object)element);
            }
            return true;
        };
        return this.processElementsWithWord(occurrenceProcessor, searchScope, identifier, (short)2, true);
    }

    public boolean processElementsWithWord(@NotNull TextOccurenceProcessor processor2, @NotNull SearchScope searchScope, @NotNull String text, short searchContext, boolean caseSensitive) {
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(9);
        }
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(10);
        }
        if (text == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(11);
        }
        return this.processElementsWithWord(processor2, searchScope, text, searchContext, caseSensitive, PsiSearchHelperImpl.shouldProcessInjectedPsi(searchScope));
    }

    public boolean processElementsWithWord(@NotNull TextOccurenceProcessor processor2, @NotNull SearchScope searchScope, @NotNull String text, short searchContext, boolean caseSensitive, boolean processInjectedPsi) {
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(12);
        }
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(13);
        }
        if (text == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(14);
        }
        EnumSet<Options> options = EnumSet.of(Options.PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE);
        if (caseSensitive) {
            options.add(Options.CASE_SENSITIVE_SEARCH);
        }
        if (processInjectedPsi) {
            options.add(Options.PROCESS_INJECTED_PSI);
        }
        return this.processElementsWithWord(processor2, searchScope, text, searchContext, options, null);
    }

    @NotNull
    public AsyncFuture<Boolean> processElementsWithWordAsync(@NotNull TextOccurenceProcessor processor2, @NotNull SearchScope searchScope, @NotNull String text, short searchContext, boolean caseSensitively) {
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(15);
        }
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(16);
        }
        if (text == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(17);
        }
        boolean result2 = this.processElementsWithWord(processor2, searchScope, text, searchContext, caseSensitively, PsiSearchHelperImpl.shouldProcessInjectedPsi(searchScope));
        AsyncFuture asyncFuture = AsyncUtil.wrapBoolean((boolean)result2);
        if (asyncFuture == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(18);
        }
        return asyncFuture;
    }

    public boolean processElementsWithWord(@NotNull TextOccurenceProcessor processor2, @NotNull SearchScope searchScope, @NotNull String text, short searchContext, @NotNull EnumSet<Options> options, @Nullable String containerName) {
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(19);
        }
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(20);
        }
        if (text == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(21);
        }
        if (options == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(22);
        }
        return this.bulkProcessElementsWithWord(searchScope, text, searchContext, options, containerName, (scope, offsetsInScope, searcher) -> {
            if (options == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(160);
            }
            if (processor2 == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(161);
            }
            return LowLevelSearchUtil.processElementsAtOffsets(scope, searcher, options.contains((Object)Options.PROCESS_INJECTED_PSI), PsiSearchHelperImpl.getOrCreateIndicator(), offsetsInScope, processor2);
        });
    }

    private boolean bulkProcessElementsWithWord(@NotNull SearchScope searchScope, @NotNull String text, short searchContext, @NotNull EnumSet<Options> options, @Nullable String containerName, final @NotNull BulkOccurrenceProcessor processor2) {
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(23);
        }
        if (text == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(24);
        }
        if (options == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(25);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(26);
        }
        if (text.isEmpty()) {
            throw new IllegalArgumentException("Cannot search for elements with empty text");
        }
        final ProgressIndicator progress = PsiSearchHelperImpl.getOrCreateIndicator();
        if (searchScope instanceof GlobalSearchScope) {
            StringSearcher searcher = new StringSearcher(text, options.contains((Object)Options.CASE_SENSITIVE_SEARCH), true, searchContext == 4, options.contains((Object)Options.PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE));
            return this.processElementsWithTextInGlobalScope((GlobalSearchScope)searchScope, searcher, searchContext, options.contains((Object)Options.CASE_SENSITIVE_SEARCH), containerName, progress, processor2);
        }
        LocalSearchScope scope = (LocalSearchScope)searchScope;
        PsiElement[] scopeElements = scope.getScope();
        final StringSearcher searcher = new StringSearcher(text, options.contains((Object)Options.CASE_SENSITIVE_SEARCH), true, searchContext == 4, options.contains((Object)Options.PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE));
        ReadActionProcessor<PsiElement> localProcessor = new ReadActionProcessor<PsiElement>(){

            public boolean processInReadAction(PsiElement scopeElement) {
                if (!scopeElement.isValid()) {
                    return true;
                }
                if (!scopeElement.isPhysical() || scopeElement instanceof PsiCompiledElement) {
                    scopeElement = scopeElement.getNavigationElement();
                }
                if (scopeElement instanceof PsiCompiledElement) {
                    return true;
                }
                if (scopeElement.getTextRange() == null) {
                    LOG.debug("Element " + scopeElement + " of class " + scopeElement.getClass() + " has null range");
                    return true;
                }
                return processor2.execute(scopeElement, LowLevelSearchUtil.getTextOccurrencesInScope(scopeElement, searcher, progress), searcher);
            }

            public String toString() {
                return processor2.toString();
            }
        };
        return JobLauncher.getInstance().invokeConcurrentlyUnderProgress(Arrays.asList(scopeElements), progress, localProcessor);
    }

    @NotNull
    private static ProgressIndicator getOrCreateIndicator() {
        ProgressIndicator progress = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (progress == null) {
            progress = new EmptyProgressIndicator();
        }
        progress.setIndeterminate(false);
        ProgressIndicator progressIndicator = progress;
        if (progressIndicator == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(27);
        }
        return progressIndicator;
    }

    static boolean shouldProcessInjectedPsi(@NotNull SearchScope scope) {
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(28);
        }
        return !(scope instanceof LocalSearchScope) || !((LocalSearchScope)scope).isIgnoreInjectedPsi();
    }

    @NotNull
    private static Processor<PsiElement> localProcessor(final @NotNull ProgressIndicator progress, final @NotNull StringSearcher searcher, final @NotNull BulkOccurrenceProcessor processor2) {
        if (progress == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(29);
        }
        if (searcher == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(30);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(31);
        }
        ReadActionProcessor<PsiElement> readActionProcessor = new ReadActionProcessor<PsiElement>(){

            public boolean processInReadAction(PsiElement scopeElement) {
                if (scopeElement instanceof PsiCompiledElement) {
                    return true;
                }
                return scopeElement.isValid() && processor2.execute(scopeElement, LowLevelSearchUtil.getTextOccurrencesInScope(scopeElement, searcher, progress), searcher);
            }

            public String toString() {
                return processor2.toString();
            }
        };
        if (readActionProcessor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(32);
        }
        return readActionProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processElementsWithTextInGlobalScope(@NotNull GlobalSearchScope scope, @NotNull StringSearcher searcher, short searchContext, boolean caseSensitively, @Nullable String containerName, @NotNull ProgressIndicator progress, @NotNull BulkOccurrenceProcessor processor2) {
        boolean result2;
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(33);
        }
        if (searcher == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(34);
        }
        if (progress == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(35);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(36);
        }
        progress.pushState();
        try {
            progress.setText(PsiBundle.message((String)"psi.scanning.files.progress", (Object[])new Object[0]));
            String text = searcher.getPattern();
            THashSet fileSet = new THashSet();
            this.getFilesWithText(scope, searchContext, caseSensitively, text, (Collection<VirtualFile>)fileSet);
            progress.setText(PsiBundle.message((String)"psi.search.for.word.progress", (Object[])new Object[]{text}));
            Processor<PsiElement> localProcessor = PsiSearchHelperImpl.localProcessor(progress, searcher, processor2);
            if (containerName != null) {
                ArrayList<VirtualFile> intersectionWithContainerFiles = new ArrayList<VirtualFile>();
                this.getFilesWithText(scope, searchContext, caseSensitively, text + " " + containerName, intersectionWithContainerFiles);
                if (!intersectionWithContainerFiles.isEmpty()) {
                    int totalSize = fileSet.size();
                    boolean result3 = this.processPsiFileRoots(intersectionWithContainerFiles, totalSize, 0, progress, localProcessor);
                    if (result3) {
                        fileSet.removeAll(intersectionWithContainerFiles);
                        if (!fileSet.isEmpty()) {
                            result3 = this.processPsiFileRoots(new ArrayList(fileSet), totalSize, intersectionWithContainerFiles.size(), progress, localProcessor);
                        }
                    }
                    boolean bl = result3;
                    return bl;
                }
            }
            result2 = fileSet.isEmpty() || this.processPsiFileRoots(new ArrayList(fileSet), fileSet.size(), 0, progress, localProcessor);
        }
        finally {
            progress.popState();
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processPsiFileRoots(@NotNull List<? extends VirtualFile> files2, int totalSize, int alreadyProcessedFiles, @NotNull ProgressIndicator progress, @NotNull Processor<? super PsiFile> localProcessor) {
        if (files2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(37);
        }
        if (progress == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(38);
        }
        if (localProcessor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(39);
        }
        this.myManager.startBatchFilesProcessingMode();
        try {
            AtomicInteger counter = new AtomicInteger(alreadyProcessedFiles);
            AtomicBoolean stopped = new AtomicBoolean(false);
            boolean bl = PsiSearchHelperImpl.processFilesConcurrentlyDespiteWriteActions(this.myManager.getProject(), files2, progress, stopped, (Processor<? super VirtualFile>)((Processor)vfile -> {
                if (progress == null) {
                    PsiSearchHelperImpl.$$$reportNull$$$0(158);
                }
                if (localProcessor == null) {
                    PsiSearchHelperImpl.$$$reportNull$$$0(159);
                }
                TooManyUsagesStatus.getFrom(progress).pauseProcessingIfTooManyUsages();
                try {
                    this.processVirtualFile((VirtualFile)vfile, localProcessor, stopped);
                }
                catch (ProcessCanceledException | IndexNotReadyException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error("Error during processing of: " + vfile.getName(), e);
                    throw e;
                }
                if (progress.isRunning()) {
                    double fraction = (double)counter.incrementAndGet() / (double)totalSize;
                    progress.setFraction(fraction);
                }
                return !stopped.get();
            }));
            return bl;
        }
        finally {
            this.myManager.finishBatchFilesProcessingMode();
        }
    }

    public static boolean processFilesConcurrentlyDespiteWriteActions(@NotNull Project project, @NotNull List<? extends VirtualFile> files2, @NotNull ProgressIndicator progress, @NotNull AtomicBoolean stopped, @NotNull Processor<? super VirtualFile> localProcessor) {
        ApplicationEx app;
        if (project == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(40);
        }
        if (files2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(41);
        }
        if (progress == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(42);
        }
        if (stopped == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(43);
        }
        if (localProcessor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(44);
        }
        if (!(app = (ApplicationEx)ApplicationManager.getApplication()).isDispatchThread()) {
            CoreProgressManager.assertUnderProgress(progress);
        }
        while (true) {
            boolean completed;
            ProgressManager.checkCanceled();
            SmartList failedList = new SmartList();
            List failedFiles = Collections.synchronizedList(failedList);
            if (app.isWriteAccessAllowed() || app.isReadAccessAllowed() && app.isWriteActionPending()) {
                completed = ContainerUtil.process(files2, localProcessor);
            } else if (app.isWriteActionPending()) {
                completed = true;
                failedFiles.addAll(files2);
            } else {
                Processor processor2 = vfile -> {
                    if (localProcessor == null) {
                        PsiSearchHelperImpl.$$$reportNull$$$0(154);
                    }
                    if (stopped == null) {
                        PsiSearchHelperImpl.$$$reportNull$$$0(155);
                    }
                    ProgressManager.checkCanceled();
                    if (failedFiles.isEmpty()) {
                        try {
                            app.executeByImpatientReader(() -> {
                                if (localProcessor == null) {
                                    PsiSearchHelperImpl.$$$reportNull$$$0(156);
                                }
                                if (stopped == null) {
                                    PsiSearchHelperImpl.$$$reportNull$$$0(157);
                                }
                                if (!localProcessor.process(vfile)) {
                                    stopped.set(true);
                                }
                            });
                        }
                        catch (ApplicationUtil.CannotRunReadActionException action) {
                            failedFiles.add(vfile);
                        }
                    } else {
                        failedFiles.add(vfile);
                    }
                    return !stopped.get();
                };
                completed = JobLauncher.getInstance().invokeConcurrentlyUnderProgress(files2, progress, processor2);
            }
            if (!completed) {
                return false;
            }
            if (failedFiles.isEmpty()) break;
            DumbService.getInstance((Project)project).runReadActionInSmartMode(EmptyRunnable.getInstance());
            files2 = failedList;
        }
        return true;
    }

    private void processVirtualFile(@NotNull VirtualFile vfile, @NotNull Processor<? super PsiFile> localProcessor, @NotNull AtomicBoolean stopped) throws ApplicationUtil.CannotRunReadActionException {
        PsiFile file2;
        if (vfile == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(45);
        }
        if (localProcessor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(46);
        }
        if (stopped == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(47);
        }
        if ((file2 = (PsiFile)ApplicationUtil.tryRunReadAction(() -> {
            if (vfile == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(153);
            }
            return vfile.isValid() ? this.myManager.findFile(vfile) : null;
        })) != null && !(file2 instanceof PsiBinaryFile)) {
            if (FileDocumentManager.getInstance().getCachedDocument(vfile) == null) {
                try {
                    vfile.contentsToByteArray();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ApplicationUtil.tryRunReadAction(() -> {
                Project project;
                if (localProcessor == null) {
                    PsiSearchHelperImpl.$$$reportNull$$$0(151);
                }
                if (stopped == null) {
                    PsiSearchHelperImpl.$$$reportNull$$$0(152);
                }
                if ((project = this.myManager.getProject()).isDisposed()) {
                    throw new ProcessCanceledException();
                }
                if (DumbService.isDumb((Project)project)) {
                    throw ApplicationUtil.CannotRunReadActionException.create();
                }
                List psiRoots = file2.getViewProvider().getAllFiles();
                THashSet processed2 = new THashSet(psiRoots.size() * 2, 0.5f);
                for (PsiFile psiRoot : psiRoots) {
                    ProgressManager.checkCanceled();
                    assert (psiRoot != null) : "One of the roots of file " + file2 + " is null. All roots: " + psiRoots + "; ViewProvider: " + file2.getViewProvider() + "; Virtual file: " + file2.getViewProvider().getVirtualFile();
                    if (!processed2.add(psiRoot) || !psiRoot.isValid() || localProcessor.process((Object)psiRoot)) continue;
                    stopped.set(true);
                    break;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getFilesWithText(@NotNull GlobalSearchScope scope, short searchContext, boolean caseSensitively, @NotNull String text, @NotNull Collection<VirtualFile> result2) {
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(48);
        }
        if (text == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(49);
        }
        if (result2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(50);
        }
        this.myManager.startBatchFilesProcessingMode();
        try {
            Processor processor2 = Processors.cancelableCollectProcessor(result2);
            boolean bl = this.processFilesWithText(scope, searchContext, caseSensitively, text, (Processor<VirtualFile>)processor2);
        }
        finally {
            this.myManager.finishBatchFilesProcessingMode();
        }
    }

    public boolean processFilesWithText(@NotNull GlobalSearchScope scope, short searchContext, boolean caseSensitively, @NotNull String text, @NotNull Processor<VirtualFile> processor2) {
        List<IdIndexEntry> entries2;
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(51);
        }
        if (text == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(52);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(53);
        }
        if ((entries2 = PsiSearchHelperImpl.getWordEntries(text, caseSensitively)).isEmpty()) {
            return true;
        }
        Condition contextMatches = integer -> (integer & searchContext) != 0;
        return PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), scope, (Condition<Integer>)contextMatches, entries2, processor2);
    }

    @NotNull
    public PsiFile[] findFilesWithPlainTextWords(@NotNull String word) {
        if (word == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(54);
        }
        PsiFile[] psiFileArray = CacheManager.SERVICE.getInstance(this.myManager.getProject()).getFilesWithWord(word, (short)16, GlobalSearchScope.projectScope((Project)this.myManager.getProject()), true);
        if (psiFileArray == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(55);
        }
        return psiFileArray;
    }

    public boolean processUsagesInNonJavaFiles(@NotNull String qName, @NotNull PsiNonJavaFileReferenceProcessor processor2, @NotNull GlobalSearchScope searchScope) {
        if (qName == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(56);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(57);
        }
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(58);
        }
        return this.processUsagesInNonJavaFiles(null, qName, processor2, searchScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processUsagesInNonJavaFiles(@Nullable PsiElement originalElement, @NotNull String qName, @NotNull PsiNonJavaFileReferenceProcessor processor2, @NotNull GlobalSearchScope initialScope) {
        int dollarIndex;
        if (qName == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(59);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(60);
        }
        if (initialScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(61);
        }
        if (qName.isEmpty()) {
            throw new IllegalArgumentException("Cannot search for elements with empty text. Element: " + originalElement + "; " + (originalElement == null ? null : originalElement.getClass()));
        }
        ProgressIndicator progress = PsiSearchHelperImpl.getOrCreateIndicator();
        int dotIndex = qName.lastIndexOf(46);
        int maxIndex = Math.max(dotIndex, dollarIndex = qName.lastIndexOf(36));
        String wordToSearch = maxIndex >= 0 ? qName.substring(maxIndex + 1) : qName;
        GlobalSearchScope theSearchScope = (GlobalSearchScope)ReadAction.compute(() -> {
            if (initialScope == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(150);
            }
            if (originalElement != null && this.myManager.isInProject(originalElement) && initialScope.isSearchInLibraries()) {
                return initialScope.intersectWith(GlobalSearchScope.projectScope((Project)this.myManager.getProject()));
            }
            return initialScope;
        });
        PsiFile[] files2 = (PsiFile[])this.myDumbService.runReadActionInSmartMode(() -> CacheManager.SERVICE.getInstance(this.myManager.getProject()).getFilesWithWord(wordToSearch, (short)16, theSearchScope, true));
        StringSearcher searcher = new StringSearcher(qName, true, true, false);
        progress.pushState();
        Ref stopped = Ref.create((Object)Boolean.FALSE);
        try {
            progress.setText(PsiBundle.message((String)"psi.search.in.non.java.files.progress", (Object[])new Object[0]));
            SearchScope useScope = originalElement == null ? null : (SearchScope)this.myDumbService.runReadActionInSmartMode(() -> this.getUseScope(originalElement));
            int patternLength = qName.length();
            for (int i = 0; i < files2.length; ++i) {
                ProgressManager.checkCanceled();
                PsiFile psiFile = files2[i];
                if (psiFile instanceof PsiBinaryFile) continue;
                CharSequence text = (CharSequence)ReadAction.compute(() -> psiFile.getViewProvider().getContents());
                LowLevelSearchUtil.processTextOccurrences(text, 0, text.length(), searcher, progress, index -> {
                    boolean isReferenceOK;
                    if (initialScope == null) {
                        PsiSearchHelperImpl.$$$reportNull$$$0(147);
                    }
                    if (processor2 == null) {
                        PsiSearchHelperImpl.$$$reportNull$$$0(148);
                    }
                    if ((isReferenceOK = ((Boolean)this.myDumbService.runReadActionInSmartMode(() -> {
                        PsiReference referenceAt;
                        if (initialScope == null) {
                            PsiSearchHelperImpl.$$$reportNull$$$0(149);
                        }
                        return (referenceAt = psiFile.findReferenceAt(index)) == null || useScope == null || !PsiSearchScopeUtil.isInScope((SearchScope)useScope.intersectWith((SearchScope)initialScope), (PsiElement)psiFile);
                    })).booleanValue()) && !processor2.process(psiFile, index, index + patternLength)) {
                        stopped.set((Object)Boolean.TRUE);
                        return false;
                    }
                    return true;
                });
                if (((Boolean)stopped.get()).booleanValue()) {
                    break;
                }
                progress.setFraction((double)(i + 1) / (double)files2.length);
            }
        }
        finally {
            progress.popState();
        }
        return (Boolean)stopped.get() == false;
    }

    public boolean processAllFilesWithWord(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiFile> processor2, boolean caseSensitively) {
        if (word == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(62);
        }
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(63);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(64);
        }
        return CacheManager.SERVICE.getInstance(this.myManager.getProject()).processFilesWithWord(processor2, word, (short)1, scope, caseSensitively);
    }

    public boolean processAllFilesWithWordInText(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiFile> processor2, boolean caseSensitively) {
        if (word == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(65);
        }
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(66);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(67);
        }
        return CacheManager.SERVICE.getInstance(this.myManager.getProject()).processFilesWithWord(processor2, word, (short)16, scope, caseSensitively);
    }

    public boolean processAllFilesWithWordInComments(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiFile> processor2) {
        if (word == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(68);
        }
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(69);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(70);
        }
        return CacheManager.SERVICE.getInstance(this.myManager.getProject()).processFilesWithWord(processor2, word, (short)2, scope, true);
    }

    public boolean processAllFilesWithWordInLiterals(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiFile> processor2) {
        if (word == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(71);
        }
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(72);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(73);
        }
        return CacheManager.SERVICE.getInstance(this.myManager.getProject()).processFilesWithWord(processor2, word, (short)4, scope, true);
    }

    public boolean processRequests(@NotNull SearchRequestCollector collector, @NotNull Processor<? super PsiReference> processor2) {
        QueryRequestsRunResult result2;
        if (collector == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(74);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(75);
        }
        HashMap collectors = ContainerUtil.newHashMap();
        collectors.put(collector, processor2);
        ProgressIndicator progress = PsiSearchHelperImpl.getOrCreateIndicator();
        if (PsiSearchHelperImpl.appendCollectorsFromQueryRequests(progress, collectors) == QueryRequestsRunResult.STOPPED) {
            return false;
        }
        do {
            MultiMap globals = new MultiMap();
            ArrayList customs = ContainerUtil.newArrayList();
            LinkedHashSet locals = ContainerUtil.newLinkedHashSet();
            THashMap localProcessors = new THashMap();
            PsiSearchHelperImpl.distributePrimitives(collectors, locals, (MultiMap<Set<IdIndexEntry>, RequestWithProcessor>)globals, customs, (Map<RequestWithProcessor, Processor<? super PsiElement>>)localProcessors, progress);
            if (!this.processGlobalRequestsOptimized((MultiMap<Set<IdIndexEntry>, RequestWithProcessor>)globals, progress, (Map<RequestWithProcessor, Processor<? super PsiElement>>)localProcessors)) {
                return false;
            }
            for (RequestWithProcessor local : locals) {
                progress.checkCanceled();
                if (this.processSingleRequest(local.request, (Processor<? super PsiReference>)local.refProcessor)) continue;
                return false;
            }
            for (Computable custom : customs) {
                progress.checkCanceled();
                if (((Boolean)custom.compute()).booleanValue()) continue;
                return false;
            }
            result2 = PsiSearchHelperImpl.appendCollectorsFromQueryRequests(progress, collectors);
            if (result2 != QueryRequestsRunResult.STOPPED) continue;
            return false;
        } while (result2 != QueryRequestsRunResult.UNCHANGED);
        return true;
    }

    @NotNull
    public AsyncFuture<Boolean> processRequestsAsync(@NotNull SearchRequestCollector collector, @NotNull Processor<? super PsiReference> processor2) {
        if (collector == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(76);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(77);
        }
        AsyncFuture asyncFuture = AsyncUtil.wrapBoolean((boolean)this.processRequests(collector, processor2));
        if (asyncFuture == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(78);
        }
        return asyncFuture;
    }

    @NotNull
    private static QueryRequestsRunResult appendCollectorsFromQueryRequests(@NotNull ProgressIndicator progress, @NotNull Map<SearchRequestCollector, Processor<? super PsiReference>> collectors) {
        if (progress == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(79);
        }
        if (collectors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(80);
        }
        boolean changed = false;
        LinkedList<SearchRequestCollector> queue2 = new LinkedList<SearchRequestCollector>(collectors.keySet());
        while (!queue2.isEmpty()) {
            progress.checkCanceled();
            SearchRequestCollector each = (SearchRequestCollector)queue2.removeFirst();
            for (QuerySearchRequest request : each.takeQueryRequests()) {
                progress.checkCanceled();
                if (!request.runQuery()) {
                    QueryRequestsRunResult queryRequestsRunResult = QueryRequestsRunResult.STOPPED;
                    if (queryRequestsRunResult == null) {
                        PsiSearchHelperImpl.$$$reportNull$$$0(81);
                    }
                    return queryRequestsRunResult;
                }
                assert (!collectors.containsKey(request.collector) || collectors.get(request.collector) == request.processor);
                collectors.put(request.collector, (Processor<? super PsiReference>)request.processor);
                queue2.addLast(request.collector);
                changed = true;
            }
        }
        QueryRequestsRunResult queryRequestsRunResult = changed ? QueryRequestsRunResult.CHANGED : QueryRequestsRunResult.UNCHANGED;
        if (queryRequestsRunResult == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(82);
        }
        return queryRequestsRunResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processGlobalRequestsOptimized(@NotNull MultiMap<Set<IdIndexEntry>, RequestWithProcessor> singles, @NotNull ProgressIndicator progress, @NotNull Map<RequestWithProcessor, Processor<? super PsiElement>> localProcessors) {
        boolean result2;
        Collection requests;
        if (singles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(83);
        }
        if (progress == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(84);
        }
        if (localProcessors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(85);
        }
        if (singles.isEmpty()) {
            return true;
        }
        if (singles.size() == 1 && (requests = singles.values()).size() == 1) {
            RequestWithProcessor theOnly = (RequestWithProcessor)requests.iterator().next();
            return this.processSingleRequest(theOnly.request, (Processor<? super PsiReference>)theOnly.refProcessor);
        }
        progress.pushState();
        progress.setText(PsiBundle.message((String)"psi.scanning.files.progress", (Object[])new Object[0]));
        try {
            MultiMap<VirtualFile, RequestWithProcessor> intersectionCandidateFiles = PsiSearchHelperImpl.createMultiMap();
            MultiMap<VirtualFile, RequestWithProcessor> restCandidateFiles = PsiSearchHelperImpl.createMultiMap();
            this.collectFiles(singles, intersectionCandidateFiles, restCandidateFiles);
            if (intersectionCandidateFiles.isEmpty() && restCandidateFiles.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            TreeSet<String> allWords = new TreeSet<String>();
            for (RequestWithProcessor singleRequest : localProcessors.keySet()) {
                ProgressManager.checkCanceled();
                allWords.add(((RequestWithProcessor)singleRequest).request.word);
            }
            progress.setText(PsiBundle.message((String)"psi.search.for.word.progress", (Object[])new Object[]{PsiSearchHelperImpl.getPresentableWordsDescription(allWords)}));
            if (intersectionCandidateFiles.isEmpty()) {
                result2 = this.processCandidates(localProcessors, restCandidateFiles, progress, restCandidateFiles.size(), 0);
            } else {
                int totalSize = restCandidateFiles.size() + intersectionCandidateFiles.size();
                result2 = this.processCandidates(localProcessors, intersectionCandidateFiles, progress, totalSize, 0);
                if (result2) {
                    result2 = this.processCandidates(localProcessors, restCandidateFiles, progress, totalSize, intersectionCandidateFiles.size());
                }
            }
        }
        finally {
            progress.popState();
        }
        return result2;
    }

    private boolean processCandidates(@NotNull Map<RequestWithProcessor, Processor<? super PsiElement>> localProcessors, @NotNull MultiMap<VirtualFile, RequestWithProcessor> candidateFiles, @NotNull ProgressIndicator progress, int totalSize, int alreadyProcessedFiles) {
        if (localProcessors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(86);
        }
        if (candidateFiles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(87);
        }
        if (progress == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(88);
        }
        ArrayList files2 = new ArrayList(candidateFiles.keySet());
        return this.processPsiFileRoots(files2, totalSize, alreadyProcessedFiles, progress, (Processor<? super PsiFile>)((Processor)psiRoot -> {
            if (candidateFiles == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(145);
            }
            if (localProcessors == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(146);
            }
            VirtualFile vfile = psiRoot.getVirtualFile();
            for (RequestWithProcessor singleRequest : candidateFiles.get((Object)vfile)) {
                ProgressManager.checkCanceled();
                Processor localProcessor = (Processor)localProcessors.get(singleRequest);
                if (localProcessor.process(psiRoot)) continue;
                return false;
            }
            return true;
        }));
    }

    @NotNull
    private static String getPresentableWordsDescription(@NotNull Set<String> allWords) {
        if (allWords == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(89);
        }
        StringBuilder result2 = new StringBuilder();
        for (String string : allWords) {
            ProgressManager.checkCanceled();
            if (string == null || string.isEmpty()) continue;
            if (result2.length() > 50) {
                result2.append("...");
                break;
            }
            if (result2.length() != 0) {
                result2.append(", ");
            }
            result2.append(string);
        }
        String string = result2.toString();
        if (string == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(90);
        }
        return string;
    }

    @NotNull
    private static BulkOccurrenceProcessor adaptProcessor(@NotNull PsiSearchRequest singleRequest, final @NotNull Processor<? super PsiReference> consumer) {
        SearchScope searchScope;
        if (singleRequest == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(91);
        }
        if (consumer == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(92);
        }
        final boolean ignoreInjectedPsi = (searchScope = singleRequest.searchScope) instanceof LocalSearchScope && ((LocalSearchScope)searchScope).isIgnoreInjectedPsi();
        final RequestResultProcessor wrapped = singleRequest.processor;
        BulkOccurrenceProcessor bulkOccurrenceProcessor = new BulkOccurrenceProcessor(){

            @Override
            public boolean execute(@NotNull PsiElement scope, @NotNull int[] offsetsInScope, @NotNull StringSearcher searcher) {
                if (scope == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (offsetsInScope == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (searcher == null) {
                    3.$$$reportNull$$$0(2);
                }
                try {
                    ProgressManager.checkCanceled();
                    if (wrapped instanceof RequestResultProcessor.BulkResultProcessor) {
                        return ((RequestResultProcessor.BulkResultProcessor)wrapped).processTextOccurrences(scope, offsetsInScope, consumer);
                    }
                    return LowLevelSearchUtil.processElementsAtOffsets(scope, searcher, !ignoreInjectedPsi, PsiSearchHelperImpl.getOrCreateIndicator(), offsetsInScope, (element, offsetInElement) -> {
                        if (consumer == null) {
                            3.$$$reportNull$$$0(3);
                        }
                        if (ignoreInjectedPsi && element instanceof PsiLanguageInjectionHost) {
                            return true;
                        }
                        return wrapped.processTextOccurrence(element, offsetInElement, consumer);
                    });
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Error | Exception e) {
                    LOG.error(e);
                    return true;
                }
            }

            public String toString() {
                return consumer.toString();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scope";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "offsetsInScope";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "searcher";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "consumer";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/impl/search/PsiSearchHelperImpl$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "execute";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$execute$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (bulkOccurrenceProcessor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(93);
        }
        return bulkOccurrenceProcessor;
    }

    private void collectFiles(@NotNull MultiMap<Set<IdIndexEntry>, RequestWithProcessor> singles, @NotNull MultiMap<VirtualFile, RequestWithProcessor> intersectionResult, @NotNull MultiMap<VirtualFile, RequestWithProcessor> restResult) {
        if (singles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(94);
        }
        if (intersectionResult == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(95);
        }
        if (restResult == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(96);
        }
        for (Map.Entry entry : singles.entrySet()) {
            ProgressManager.checkCanceled();
            Set keys = (Set)entry.getKey();
            if (keys.isEmpty()) continue;
            Collection processors = (Collection)entry.getValue();
            GlobalSearchScope commonScope = PsiSearchHelperImpl.uniteScopes(processors);
            Set<VirtualFile> intersectionWithContainerNameFiles = this.intersectionWithContainerNameFiles(commonScope, processors, keys);
            ArrayList result2 = new ArrayList();
            Processor processor2 = Processors.cancelableCollectProcessor(result2);
            PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), commonScope, null, keys, (Processor<? super VirtualFile>)processor2);
            for (VirtualFile file2 : result2) {
                ProgressManager.checkCanceled();
                for (IdIndexEntry indexEntry : keys) {
                    ProgressManager.checkCanceled();
                    this.myDumbService.runReadActionInSmartMode(() -> {
                        if (restResult == null) {
                            PsiSearchHelperImpl.$$$reportNull$$$0(141);
                        }
                        if (intersectionResult == null) {
                            PsiSearchHelperImpl.$$$reportNull$$$0(142);
                        }
                        return FileBasedIndex.getInstance().processValues(IdIndex.NAME, (Object)indexEntry, file2, (file1, value) -> {
                            if (restResult == null) {
                                PsiSearchHelperImpl.$$$reportNull$$$0(143);
                            }
                            if (intersectionResult == null) {
                                PsiSearchHelperImpl.$$$reportNull$$$0(144);
                            }
                            int mask = value;
                            for (RequestWithProcessor single : processors) {
                                ProgressManager.checkCanceled();
                                PsiSearchRequest request = single.request;
                                if ((mask & request.searchContext) == 0 || !request.searchScope.contains(file1)) continue;
                                MultiMap result1 = intersectionWithContainerNameFiles == null || !intersectionWithContainerNameFiles.contains(file1) ? restResult : intersectionResult;
                                result1.putValue((Object)file1, (Object)single);
                            }
                            return true;
                        }, commonScope);
                    });
                }
            }
        }
    }

    @Nullable(value="null means we did not find common container files")
    private Set<VirtualFile> intersectionWithContainerNameFiles(@NotNull GlobalSearchScope commonScope, @NotNull Collection<? extends RequestWithProcessor> data, @NotNull Set<IdIndexEntry> keys) {
        if (commonScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(97);
        }
        if (data == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(98);
        }
        if (keys == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(99);
        }
        String commonName = null;
        short searchContext = 0;
        boolean caseSensitive = true;
        for (RequestWithProcessor requestWithProcessor : data) {
            ProgressManager.checkCanceled();
            String containerName = ((RequestWithProcessor)requestWithProcessor).request.containerName;
            if (containerName == null) continue;
            if (commonName == null) {
                commonName = containerName;
                searchContext = ((RequestWithProcessor)requestWithProcessor).request.searchContext;
                caseSensitive = ((RequestWithProcessor)requestWithProcessor).request.caseSensitive;
                continue;
            }
            if (commonName.equals(containerName)) {
                searchContext = (short)(searchContext | ((RequestWithProcessor)requestWithProcessor).request.searchContext);
                caseSensitive &= ((RequestWithProcessor)requestWithProcessor).request.caseSensitive;
                continue;
            }
            return null;
        }
        if (commonName == null) {
            return null;
        }
        List<IdIndexEntry> entries2 = PsiSearchHelperImpl.getWordEntries(commonName, caseSensitive);
        if (entries2.isEmpty()) {
            return null;
        }
        entries2.addAll(keys);
        short s = searchContext;
        Condition contextMatches = context -> (context & finalSearchContext) != 0;
        THashSet containerFiles = new THashSet();
        Processor processor2 = Processors.cancelableCollectProcessor((Collection)containerFiles);
        PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), commonScope, (Condition<Integer>)contextMatches, entries2, (Processor<? super VirtualFile>)processor2);
        return containerFiles;
    }

    @NotNull
    private static MultiMap<VirtualFile, RequestWithProcessor> createMultiMap() {
        MultiMap multiMap = MultiMap.createSmart();
        if (multiMap == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(100);
        }
        return multiMap;
    }

    @NotNull
    private static GlobalSearchScope uniteScopes(@NotNull Collection<RequestWithProcessor> requests) {
        if (requests == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(101);
        }
        Set scopes = ContainerUtil.map2LinkedSet(requests, r -> (GlobalSearchScope)((RequestWithProcessor)r).request.searchScope);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.union((GlobalSearchScope[])scopes.toArray(GlobalSearchScope.EMPTY_ARRAY));
        if (globalSearchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(102);
        }
        return globalSearchScope;
    }

    private static void distributePrimitives(@NotNull Map<SearchRequestCollector, Processor<? super PsiReference>> collectors, @NotNull Set<RequestWithProcessor> locals, @NotNull MultiMap<Set<IdIndexEntry>, RequestWithProcessor> globals, @NotNull List<Computable<Boolean>> customs, @NotNull Map<RequestWithProcessor, Processor<? super PsiElement>> localProcessors, @NotNull ProgressIndicator progress) {
        if (collectors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(103);
        }
        if (locals == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(104);
        }
        if (globals == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(105);
        }
        if (customs == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(106);
        }
        if (localProcessors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(107);
        }
        if (progress == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(108);
        }
        for (Map.Entry<SearchRequestCollector, Processor<? super PsiReference>> entry : collectors.entrySet()) {
            ProgressManager.checkCanceled();
            Processor<? super PsiReference> processor2 = entry.getValue();
            SearchRequestCollector collector = entry.getKey();
            for (PsiSearchRequest primitive : collector.takeSearchRequests()) {
                ProgressManager.checkCanceled();
                SearchScope scope = primitive.searchScope;
                if (scope instanceof LocalSearchScope) {
                    PsiSearchHelperImpl.registerRequest(locals, primitive, processor2);
                    continue;
                }
                HashSet<IdIndexEntry> key = new HashSet<IdIndexEntry>(PsiSearchHelperImpl.getWordEntries(primitive.word, primitive.caseSensitive));
                PsiSearchHelperImpl.registerRequest(globals.getModifiable(key), primitive, processor2);
            }
            for (Processor customAction : collector.takeCustomSearchActions()) {
                ProgressManager.checkCanceled();
                customs.add((Computable<Boolean>)((Computable)() -> customAction.process((Object)processor2)));
            }
        }
        for (Map.Entry<Object, Object> entry : globals.entrySet()) {
            ProgressManager.checkCanceled();
            for (RequestWithProcessor singleRequest : (Collection)entry.getValue()) {
                ProgressManager.checkCanceled();
                PsiSearchRequest primitive = singleRequest.request;
                StringSearcher searcher = new StringSearcher(primitive.word, primitive.caseSensitive, true, false);
                BulkOccurrenceProcessor adapted = PsiSearchHelperImpl.adaptProcessor(primitive, (Processor<? super PsiReference>)singleRequest.refProcessor);
                Processor<PsiElement> localProcessor = PsiSearchHelperImpl.localProcessor(progress, searcher, adapted);
                assert (!localProcessors.containsKey(singleRequest) || localProcessors.get(singleRequest) == localProcessor);
                localProcessors.put(singleRequest, localProcessor);
            }
        }
    }

    private static void registerRequest(@NotNull Collection<RequestWithProcessor> collection, @NotNull PsiSearchRequest primitive, @NotNull Processor<? super PsiReference> processor2) {
        if (collection == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(109);
        }
        if (primitive == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(110);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(111);
        }
        RequestWithProcessor singleRequest = new RequestWithProcessor(primitive, processor2);
        for (RequestWithProcessor existing : collection) {
            ProgressManager.checkCanceled();
            if (!existing.uniteWith(singleRequest)) continue;
            return;
        }
        collection.add(singleRequest);
    }

    private boolean processSingleRequest(@NotNull PsiSearchRequest single, @NotNull Processor<? super PsiReference> consumer) {
        if (single == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(112);
        }
        if (consumer == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(113);
        }
        EnumSet<Options> options = EnumSet.of(Options.PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE);
        if (single.caseSensitive) {
            options.add(Options.CASE_SENSITIVE_SEARCH);
        }
        if (PsiSearchHelperImpl.shouldProcessInjectedPsi(single.searchScope)) {
            options.add(Options.PROCESS_INJECTED_PSI);
        }
        return this.bulkProcessElementsWithWord(single.searchScope, single.word, single.searchContext, options, single.containerName, PsiSearchHelperImpl.adaptProcessor(single, consumer));
    }

    @NotNull
    public PsiSearchHelper.SearchCostResult isCheapEnoughToSearch(@NotNull String name, @NotNull GlobalSearchScope scope, final @Nullable PsiFile fileToIgnoreOccurrencesIn, @Nullable ProgressIndicator progress) {
        boolean cheap;
        if (name == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(114);
        }
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(115);
        }
        if (!((Boolean)ReadAction.compute(() -> {
            if (scope == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(140);
            }
            return scope.getUnloadedModulesBelongingToScope().isEmpty();
        })).booleanValue()) {
            PsiSearchHelper.SearchCostResult searchCostResult = PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
            if (searchCostResult == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(116);
            }
            return searchCostResult;
        }
        final AtomicInteger filesCount = new AtomicInteger();
        final AtomicLong filesSizeToProcess = new AtomicLong();
        Processor<VirtualFile> processor2 = new Processor<VirtualFile>(){
            private final VirtualFile virtualFileToIgnoreOccurrencesIn;
            private final int maxFilesToProcess;
            private final int maxFilesSizeToProcess;
            {
                this.virtualFileToIgnoreOccurrencesIn = fileToIgnoreOccurrencesIn == null ? null : fileToIgnoreOccurrencesIn.getVirtualFile();
                this.maxFilesToProcess = Registry.intValue((String)"ide.unused.symbol.calculation.maxFilesToSearchUsagesIn", (int)10);
                this.maxFilesSizeToProcess = Registry.intValue((String)"ide.unused.symbol.calculation.maxFilesSizeToSearchUsagesIn", (int)524288);
            }

            public boolean process(VirtualFile file2) {
                ProgressManager.checkCanceled();
                if (Comparing.equal((Object)file2, (Object)this.virtualFileToIgnoreOccurrencesIn)) {
                    return true;
                }
                int currentFilesCount = filesCount.incrementAndGet();
                long accumulatedFileSizeToProcess = filesSizeToProcess.addAndGet(file2.isDirectory() ? 0L : file2.getLength());
                return currentFilesCount < this.maxFilesToProcess && accumulatedFileSizeToProcess < (long)this.maxFilesSizeToProcess;
            }
        };
        List<IdIndexEntry> keys = PsiSearchHelperImpl.getWordEntries(name, true);
        boolean bl = cheap = keys.isEmpty() || PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), scope, null, keys, (Processor<? super VirtualFile>)processor2);
        if (!cheap) {
            PsiSearchHelper.SearchCostResult searchCostResult = PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
            if (searchCostResult == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(117);
            }
            return searchCostResult;
        }
        PsiSearchHelper.SearchCostResult searchCostResult = filesCount.get() == 0 ? PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES : PsiSearchHelper.SearchCostResult.FEW_OCCURRENCES;
        if (searchCostResult == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(118);
        }
        return searchCostResult;
    }

    private static boolean processFilesContainingAllKeys(@NotNull Project project, @NotNull GlobalSearchScope scope, @Nullable Condition<Integer> checker, @NotNull Collection<IdIndexEntry> keys, @NotNull Processor<? super VirtualFile> processor2) {
        if (project == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(119);
        }
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(120);
        }
        if (keys == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(121);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(122);
        }
        FileIndexFacade index = FileIndexFacade.getInstance((Project)project);
        return (Boolean)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
            if (keys == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(135);
            }
            if (scope == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(136);
            }
            if (processor2 == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(137);
            }
            return FileBasedIndex.getInstance().processFilesContainingAllKeys(IdIndex.NAME, keys, scope, checker, file2 -> {
                if (scope == null) {
                    PsiSearchHelperImpl.$$$reportNull$$$0(138);
                }
                if (processor2 == null) {
                    PsiSearchHelperImpl.$$$reportNull$$$0(139);
                }
                return !index.shouldBeFound(scope, file2) || processor2.process(file2);
            });
        });
    }

    @NotNull
    private static List<IdIndexEntry> getWordEntries(@NotNull String name, boolean caseSensitively) {
        String trimmed;
        List<String> words;
        if (name == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(123);
        }
        if ((words = StringUtil.getWordsInStringLongestFirst((String)name)).isEmpty() && StringUtil.isNotEmpty((String)(trimmed = name.trim()))) {
            words = Collections.singletonList(trimmed);
        }
        if (words.isEmpty()) {
            List<IdIndexEntry> list2 = Collections.emptyList();
            if (list2 == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(124);
            }
            return list2;
        }
        List list3 = ContainerUtil.map2List((Collection)words, word -> new IdIndexEntry((String)word, caseSensitively));
        if (list3 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(125);
        }
        return list3;
    }

    public static boolean processTextOccurrences(@NotNull PsiElement element, @NotNull String stringToSearch, @NotNull GlobalSearchScope searchScope, @NotNull Processor<? super UsageInfo> processor2, @NotNull UsageInfoFactory factory) {
        if (element == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(126);
        }
        if (stringToSearch == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(127);
        }
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(128);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(129);
        }
        if (factory == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(130);
        }
        PsiSearchHelper helper = (PsiSearchHelper)ReadAction.compute(() -> {
            if (element == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(134);
            }
            return PsiSearchHelper.getInstance((Project)element.getProject());
        });
        return helper.processUsagesInNonJavaFiles(element, stringToSearch, (psiFile, startOffset, endOffset) -> {
            if (factory == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(131);
            }
            if (processor2 == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(132);
            }
            try {
                UsageInfo usageInfo = (UsageInfo)ReadAction.compute(() -> {
                    if (factory == null) {
                        PsiSearchHelperImpl.$$$reportNull$$$0(133);
                    }
                    return factory.createUsageInfo((PsiElement)psiFile, startOffset, endOffset);
                });
                return usageInfo == null || processor2.process((Object)usageInfo);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                return true;
            }
        }, searchScope);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 18: 
            case 27: 
            case 32: 
            case 55: 
            case 78: 
            case 81: 
            case 82: 
            case 90: 
            case 93: 
            case 100: 
            case 102: 
            case 116: 
            case 117: 
            case 118: 
            case 124: 
            case 125: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 18: 
            case 27: 
            case 32: 
            case 55: 
            case 78: 
            case 81: 
            case 82: 
            case 90: 
            case 93: 
            case 100: 
            case 102: 
            case 116: 
            case 117: 
            case 118: 
            case 124: 
            case 125: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 5: 
            case 18: 
            case 27: 
            case 32: 
            case 55: 
            case 78: 
            case 81: 
            case 82: 
            case 90: 
            case 93: 
            case 100: 
            case 102: 
            case 116: 
            case 117: 
            case 118: 
            case 124: 
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/search/PsiSearchHelperImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 20: 
            case 23: 
            case 58: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 19: 
            case 26: 
            case 31: 
            case 36: 
            case 53: 
            case 57: 
            case 60: 
            case 64: 
            case 67: 
            case 70: 
            case 73: 
            case 75: 
            case 77: 
            case 111: 
            case 122: 
            case 129: 
            case 132: 
            case 137: 
            case 139: 
            case 148: 
            case 161: 
            case 162: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 11: 
            case 14: 
            case 17: 
            case 21: 
            case 24: 
            case 49: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 22: 
            case 25: 
            case 160: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 28: 
            case 33: 
            case 48: 
            case 51: 
            case 63: 
            case 66: 
            case 69: 
            case 72: 
            case 115: 
            case 120: 
            case 136: 
            case 138: 
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 29: 
            case 35: 
            case 38: 
            case 42: 
            case 79: 
            case 84: 
            case 88: 
            case 108: 
            case 158: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searcher";
                break;
            }
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 39: 
            case 44: 
            case 46: 
            case 151: 
            case 154: 
            case 156: 
            case 159: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localProcessor";
                break;
            }
            case 40: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 43: 
            case 47: 
            case 152: 
            case 155: 
            case 157: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopped";
                break;
            }
            case 45: 
            case 153: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vfile";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 54: 
            case 62: 
            case 65: 
            case 68: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 61: 
            case 147: 
            case 149: 
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialScope";
                break;
            }
            case 74: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 80: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectors";
                break;
            }
            case 83: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "singles";
                break;
            }
            case 85: 
            case 86: 
            case 107: 
            case 146: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localProcessors";
                break;
            }
            case 87: 
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateFiles";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allWords";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "singleRequest";
                break;
            }
            case 92: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 95: 
            case 142: 
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intersectionResult";
                break;
            }
            case 96: 
            case 141: 
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restResult";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonScope";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 99: 
            case 121: 
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locals";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globals";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customs";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primitive";
                break;
            }
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "single";
                break;
            }
            case 114: 
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringToSearch";
                break;
            }
            case 130: 
            case 131: 
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/search/PsiSearchHelperImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findCommentsContainingIdentifier";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "processElementsWithWordAsync";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateIndicator";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "localProcessor";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "findFilesWithPlainTextWords";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "processRequestsAsync";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "appendCollectorsFromQueryRequests";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableWordsDescription";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "adaptProcessor";
                break;
            }
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "createMultiMap";
                break;
            }
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "uniteScopes";
                break;
            }
            case 116: 
            case 117: 
            case 118: {
                objectArray = objectArray2;
                objectArray2[1] = "isCheapEnoughToSearch";
                break;
            }
            case 124: 
            case 125: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordEntries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUseScope";
                break;
            }
            case 1: 
            case 5: 
            case 18: 
            case 27: 
            case 32: 
            case 55: 
            case 78: 
            case 81: 
            case 82: 
            case 90: 
            case 93: 
            case 100: 
            case 102: 
            case 116: 
            case 117: 
            case 118: 
            case 124: 
            case 125: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findCommentsContainingIdentifier";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processCommentsContainingIdentifier";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "processElementsWithWord";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processElementsWithWordAsync";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "bulkProcessElementsWithWord";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "shouldProcessInjectedPsi";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "localProcessor";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "processElementsWithTextInGlobalScope";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "processPsiFileRoots";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "processFilesConcurrentlyDespiteWriteActions";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "processVirtualFile";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getFilesWithText";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "processFilesWithText";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "findFilesWithPlainTextWords";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "processUsagesInNonJavaFiles";
                break;
            }
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "processAllFilesWithWord";
                break;
            }
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "processAllFilesWithWordInText";
                break;
            }
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "processAllFilesWithWordInComments";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "processAllFilesWithWordInLiterals";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "processRequests";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "processRequestsAsync";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "appendCollectorsFromQueryRequests";
                break;
            }
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "processGlobalRequestsOptimized";
                break;
            }
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "processCandidates";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableWordsDescription";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "adaptProcessor";
                break;
            }
            case 94: 
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "collectFiles";
                break;
            }
            case 97: 
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "intersectionWithContainerNameFiles";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "uniteScopes";
                break;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "distributePrimitives";
                break;
            }
            case 109: 
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "registerRequest";
                break;
            }
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "processSingleRequest";
                break;
            }
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "isCheapEnoughToSearch";
                break;
            }
            case 119: 
            case 120: 
            case 121: 
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "processFilesContainingAllKeys";
                break;
            }
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "getWordEntries";
                break;
            }
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "processTextOccurrences";
                break;
            }
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processTextOccurrences$26";
                break;
            }
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$25";
                break;
            }
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processTextOccurrences$24";
                break;
            }
            case 135: 
            case 136: 
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processFilesContainingAllKeys$22";
                break;
            }
            case 138: 
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$21";
                break;
            }
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isCheapEnoughToSearch$20";
                break;
            }
            case 141: 
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "lambda$collectFiles$16";
                break;
            }
            case 143: 
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$15";
                break;
            }
            case 145: 
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processCandidates$14";
                break;
            }
            case 147: 
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processUsagesInNonJavaFiles$13";
                break;
            }
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$12";
                break;
            }
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processUsagesInNonJavaFiles$8";
                break;
            }
            case 151: 
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processVirtualFile$6";
                break;
            }
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processVirtualFile$5";
                break;
            }
            case 154: 
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processFilesConcurrentlyDespiteWriteActions$4";
                break;
            }
            case 156: 
            case 157: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$3";
                break;
            }
            case 158: 
            case 159: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processPsiFileRoots$2";
                break;
            }
            case 160: 
            case 161: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processElementsWithWord$1";
                break;
            }
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processCommentsContainingIdentifier$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 18: 
            case 27: 
            case 32: 
            case 55: 
            case 78: 
            case 81: 
            case 82: 
            case 90: 
            case 93: 
            case 100: 
            case 102: 
            case 116: 
            case 117: 
            case 118: 
            case 124: 
            case 125: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum QueryRequestsRunResult {
        STOPPED,
        UNCHANGED,
        CHANGED;

    }

    private static class RequestWithProcessor {
        @NotNull
        private final PsiSearchRequest request;
        @NotNull
        private Processor<? super PsiReference> refProcessor;

        private RequestWithProcessor(@NotNull PsiSearchRequest request, @NotNull Processor<? super PsiReference> processor2) {
            if (request == null) {
                RequestWithProcessor.$$$reportNull$$$0(0);
            }
            if (processor2 == null) {
                RequestWithProcessor.$$$reportNull$$$0(1);
            }
            this.request = request;
            this.refProcessor = processor2;
        }

        private boolean uniteWith(@NotNull RequestWithProcessor another) {
            if (another == null) {
                RequestWithProcessor.$$$reportNull$$$0(2);
            }
            if (this.request.equals((Object)another.request)) {
                Processor<? super PsiReference> myProcessor = this.refProcessor;
                if (myProcessor != another.refProcessor) {
                    this.refProcessor = psiReference -> {
                        if (another == null) {
                            RequestWithProcessor.$$$reportNull$$$0(3);
                        }
                        return myProcessor.process(psiReference) && another.refProcessor.process(psiReference);
                    };
                }
                return true;
            }
            return false;
        }

        public String toString() {
            return this.request.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "another";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/search/PsiSearchHelperImpl$RequestWithProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "uniteWith";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$uniteWith$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum Options {
        PROCESS_INJECTED_PSI,
        CASE_SENSITIVE_SEARCH,
        PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE;

    }
}

