/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.dtd.DTDLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModel;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.PomTransaction;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.impl.PomTransactionBase;
import com.intellij.pom.xml.XmlAspect;
import com.intellij.pom.xml.impl.events.XmlDocumentChangedImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.PsiCachedValueImpl;
import com.intellij.psi.impl.meta.MetaRegistry;
import com.intellij.psi.impl.source.html.dtd.HtmlNSDescriptorImpl;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.xml.XmlElementImpl;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.Html5SchemaProvider;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.index.XmlNamespaceIndex;
import com.intellij.xml.util.XmlNSDescriptorSequence;
import com.intellij.xml.util.XmlUtil;
import gnu.trove.TObjectIntHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlDocumentImpl
extends XmlElementImpl
implements XmlDocument {
    private static final Key<Boolean> AUTO_GENERATED = Key.create((String)"auto-generated xml schema");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.xml.XmlDocumentImpl");
    private static final AtomicFieldUpdater<XmlDocumentImpl, XmlProlog> MY_PROLOG_UPDATER = AtomicFieldUpdater.forFieldOfType(XmlDocumentImpl.class, XmlProlog.class);
    private static final AtomicFieldUpdater<XmlDocumentImpl, XmlTag> MY_ROOT_TAG_UPDATER = AtomicFieldUpdater.forFieldOfType(XmlDocumentImpl.class, XmlTag.class);
    private volatile XmlProlog myProlog;
    private volatile XmlTag myRootTag;
    private volatile long myExtResourcesModCount = -1L;
    private ConcurrentMap<String, CachedValue<XmlNSDescriptor>> myDefaultDescriptorsCacheStrict = ContainerUtil.newConcurrentMap();
    private ConcurrentMap<String, CachedValue<XmlNSDescriptor>> myDefaultDescriptorsCacheNotStrict = ContainerUtil.newConcurrentMap();

    public static boolean isAutoGeneratedSchema(XmlFile file2) {
        return file2.getUserData(AUTO_GENERATED) != null;
    }

    public XmlDocumentImpl() {
        this(XmlElementType.XML_DOCUMENT);
    }

    protected XmlDocumentImpl(IElementType type) {
        super(type);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            XmlDocumentImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof XmlElementVisitor) {
            ((XmlElementVisitor)visitor).visitXmlDocument((XmlDocument)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public int getChildRole(@NotNull ASTNode child2) {
        if (child2 == null) {
            XmlDocumentImpl.$$$reportNull$$$0(1);
        }
        LOG.assertTrue(child2.getTreeParent() == this);
        IElementType i = child2.getElementType();
        if (i == XmlElementType.XML_PROLOG) {
            return 225;
        }
        if (i == XmlElementType.XML_TAG) {
            return 241;
        }
        return 0;
    }

    public XmlProlog getProlog() {
        XmlProlog prolog = this.myProlog;
        if (prolog == null && !MY_PROLOG_UPDATER.compareAndSet((Object)this, null, (Object)(prolog = (XmlProlog)this.findElementByTokenType(XmlElementType.XML_PROLOG)))) {
            prolog = (XmlProlog)MY_PROLOG_UPDATER.get((Object)this);
        }
        return prolog;
    }

    public XmlTag getRootTag() {
        XmlTag rootTag = this.myRootTag;
        if (rootTag == null && !MY_ROOT_TAG_UPDATER.compareAndSet((Object)this, null, (Object)(rootTag = (XmlTag)this.findElementByTokenType(XmlElementType.XML_TAG)))) {
            rootTag = (XmlTag)MY_ROOT_TAG_UPDATER.get((Object)this);
        }
        return rootTag;
    }

    public XmlNSDescriptor getRootTagNSDescriptor() {
        XmlTag rootTag = this.getRootTag();
        return rootTag != null ? rootTag.getNSDescriptor(rootTag.getNamespace(), false) : null;
    }

    @Override
    public void clearCaches() {
        this.myDefaultDescriptorsCacheStrict.clear();
        this.myDefaultDescriptorsCacheNotStrict.clear();
        this.myRootTag = null;
        this.myProlog = null;
        super.clearCaches();
    }

    @Nullable
    public XmlNSDescriptor getDefaultNSDescriptor(String namespace, boolean strict) {
        ConcurrentMap<String, CachedValue<XmlNSDescriptor>> defaultDescriptorsCache;
        PsiCachedValueImpl cachedValue;
        long curExtResourcesModCount = ExternalResourceManagerEx.getInstanceEx().getModificationCount(this.getProject());
        if (this.myExtResourcesModCount != curExtResourcesModCount) {
            this.myDefaultDescriptorsCacheNotStrict.clear();
            this.myDefaultDescriptorsCacheStrict.clear();
            this.myExtResourcesModCount = curExtResourcesModCount;
        }
        if ((cachedValue = (PsiCachedValueImpl)(defaultDescriptorsCache = strict ? this.myDefaultDescriptorsCacheStrict : this.myDefaultDescriptorsCacheNotStrict).get(namespace)) == null) {
            cachedValue = new PsiCachedValueImpl(this.getManager(), () -> {
                XmlNSDescriptor defaultNSDescriptorInner = this.getDefaultNSDescriptorInner(namespace, strict);
                if (this.isGeneratedFromDtd(defaultNSDescriptorInner)) {
                    return new CachedValueProvider.Result((Object)defaultNSDescriptorInner, new Object[]{this, ExternalResourceManager.getInstance()});
                }
                return new CachedValueProvider.Result((Object)defaultNSDescriptorInner, new Object[]{defaultNSDescriptorInner != null ? defaultNSDescriptorInner.getDependencies() : ExternalResourceManager.getInstance()});
            });
            defaultDescriptorsCache.put(namespace, cachedValue);
        }
        return (XmlNSDescriptor)cachedValue.getValue();
    }

    private boolean isGeneratedFromDtd(XmlNSDescriptor defaultNSDescriptorInner) {
        if (defaultNSDescriptorInner == null) {
            return false;
        }
        XmlFile descriptorFile = defaultNSDescriptorInner.getDescriptorFile();
        if (descriptorFile == null) {
            return false;
        }
        String otherName = XmlUtil.getContainingFile(this).getName() + ".dtd";
        return descriptorFile.getName().equals(otherName);
    }

    private XmlNSDescriptor getDefaultNSDescriptorInner(String namespace, boolean strict) {
        XmlFile xmlFile;
        XmlNSDescriptor descr;
        XmlFile containingFile = XmlUtil.getContainingFile(this);
        if (containingFile == null) {
            return null;
        }
        XmlProlog prolog = this.getProlog();
        XmlDoctype doctype = prolog != null ? prolog.getDoctype() : null;
        boolean dtdUriFromDocTypeIsNamespace = false;
        if ("http://www.w3.org/1999/html".equals(namespace)) {
            XmlFile descriptorFile;
            XmlNSDescriptor nsDescriptor;
            XmlNSDescriptor xmlNSDescriptor = nsDescriptor = doctype != null ? this.getNsDescriptorFormDocType(doctype, containingFile, true) : null;
            if (doctype != null) {
                LOG.debug("Descriptor from doctype " + doctype + " is " + (nsDescriptor != null ? nsDescriptor.getClass().getCanonicalName() : "NULL"));
            }
            if (nsDescriptor == null) {
                String htmlns = ExternalResourceManagerEx.getInstanceEx().getDefaultHtmlDoctype(this.getProject());
                if (htmlns.isEmpty()) {
                    htmlns = Html5SchemaProvider.getHtml5SchemaLocation();
                }
                nsDescriptor = this.getDefaultNSDescriptor(htmlns, false);
            }
            if (nsDescriptor != null && (descriptorFile = nsDescriptor.getDescriptorFile()) != null) {
                return XmlDocumentImpl.getCachedHtmlNsDescriptor(descriptorFile);
            }
            return new HtmlNSDescriptorImpl(nsDescriptor);
        }
        if ("http://www.w3.org/1999/xhtml".equals(namespace)) {
            String xhtmlNamespace = XmlUtil.getDefaultXhtmlNamespace(this.getProject());
            if (xhtmlNamespace == null || xhtmlNamespace.isEmpty()) {
                xhtmlNamespace = Html5SchemaProvider.getXhtml5SchemaLocation();
            }
            return this.getDefaultNSDescriptor(xhtmlNamespace, false);
        }
        if (namespace != null && namespace != "") {
            if (doctype == null || !namespace.equals(XmlUtil.getDtdUri(doctype))) {
                XmlDocument document;
                XmlFile xmlFile2;
                boolean documentIsSchemaThatDefinesNs = namespace.equals(XmlUtil.getTargetSchemaNsFromTag(this.getRootTag()));
                XmlFile xmlFile3 = xmlFile2 = documentIsSchemaThatDefinesNs ? containingFile : XmlUtil.findNamespace((PsiFile)containingFile, namespace);
                if (xmlFile2 != null && (document = xmlFile2.getDocument()) != null) {
                    return (XmlNSDescriptor)document.getMetaData();
                }
            } else {
                dtdUriFromDocTypeIsNamespace = true;
            }
        }
        if (strict && !dtdUriFromDocTypeIsNamespace) {
            return null;
        }
        if (doctype != null && (descr = this.getNsDescriptorFormDocType(doctype, containingFile, false)) != null) {
            return XmlExtension.getExtension((PsiFile)containingFile).getDescriptorFromDoctype(containingFile, descr);
        }
        if (strict) {
            return null;
        }
        if (namespace == "" && (xmlFile = XmlUtil.findNamespace((PsiFile)containingFile, namespace)) != null) {
            return (XmlNSDescriptor)xmlFile.getDocument().getMetaData();
        }
        try {
            PsiFile fileFromText = PsiFileFactory.getInstance((Project)this.getProject()).createFileFromText(containingFile.getName() + ".dtd", (Language)DTDLanguage.INSTANCE, (CharSequence)XmlUtil.generateDocumentDTD(this, false), false, false);
            if (fileFromText instanceof XmlFile) {
                fileFromText.putUserData(AUTO_GENERATED, (Object)Boolean.TRUE);
                return (XmlNSDescriptor)((XmlFile)fileFromText).getDocument().getMetaData();
            }
        }
        catch (ProcessCanceledException ex) {
            throw ex;
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return null;
    }

    private static XmlNSDescriptor getCachedHtmlNsDescriptor(XmlFile descriptorFile) {
        return (XmlNSDescriptor)CachedValuesManager.getCachedValue((PsiElement)descriptorFile, () -> {
            XmlDocument document = descriptorFile.getDocument();
            if (document == null) {
                return CachedValueProvider.Result.create(null, (Object[])new Object[]{descriptorFile});
            }
            return CachedValueProvider.Result.create((Object)new HtmlNSDescriptorImpl((XmlNSDescriptor)document.getMetaData()), (Object[])new Object[]{descriptorFile});
        });
    }

    @NotNull
    private static String getFilePathForLogging(@Nullable PsiFile file2) {
        if (file2 == null) {
            if ("NULL" == null) {
                XmlDocumentImpl.$$$reportNull$$$0(2);
            }
            return "NULL";
        }
        VirtualFile vFile = file2.getVirtualFile();
        String string = vFile != null ? vFile.getPath() : "NULL_VFILE";
        if (string == null) {
            XmlDocumentImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    private XmlNSDescriptor getNsDescriptorFormDocType(XmlDoctype doctype, XmlFile containingFile, boolean forHtml) {
        XmlNSDescriptor descriptor = this.getNSDescriptorFromMetaData((PsiMetaOwner)doctype.getMarkupDecl(), true);
        String filePath = XmlDocumentImpl.getFilePathForLogging((PsiFile)containingFile);
        String dtdUri = XmlUtil.getDtdUri(doctype);
        LOG.debug("DTD url for doctype " + doctype.getText() + " in file " + filePath + " is " + dtdUri);
        if (dtdUri != null && !dtdUri.isEmpty()) {
            XmlFile xmlFile = XmlUtil.findNamespace((PsiFile)containingFile, dtdUri);
            if (xmlFile == null) {
                xmlFile = XmlNamespaceIndex.guessDtd(dtdUri, (PsiFile)containingFile);
            }
            String schemaFilePath = XmlDocumentImpl.getFilePathForLogging((PsiFile)xmlFile);
            LOG.debug("Schema file for " + filePath + " is " + schemaFilePath);
            XmlNSDescriptor descriptorFromDtd = this.getNSDescriptorFromMetaData((PsiMetaOwner)(xmlFile == null ? null : xmlFile.getDocument()), forHtml);
            LOG.debug("Descriptor from meta data for schema file " + schemaFilePath + " is " + (descriptorFromDtd != null ? descriptorFromDtd.getClass().getCanonicalName() : "NULL"));
            if (descriptor != null && descriptorFromDtd != null) {
                descriptor = new XmlNSDescriptorSequence(new XmlNSDescriptor[]{descriptor, descriptorFromDtd});
            } else if (descriptorFromDtd != null) {
                descriptor = descriptorFromDtd;
            }
        }
        return descriptor;
    }

    @Nullable
    private XmlNSDescriptor getNSDescriptorFromMetaData(@Nullable PsiMetaOwner metaOwner, boolean nonEmpty) {
        if (metaOwner == null) {
            return null;
        }
        XmlNSDescriptor descriptor = (XmlNSDescriptor)metaOwner.getMetaData();
        if (descriptor == null) {
            return null;
        }
        if (nonEmpty && descriptor.getRootElementsDescriptors((XmlDocument)this).length == 0) {
            return null;
        }
        return descriptor;
    }

    @Override
    @NotNull
    public CompositePsiElement clone() {
        HashMap<String, CachedValue<XmlNSDescriptor>> cacheStrict = new HashMap<String, CachedValue<XmlNSDescriptor>>(this.myDefaultDescriptorsCacheStrict);
        HashMap<String, CachedValue<XmlNSDescriptor>> cacheNotStrict = new HashMap<String, CachedValue<XmlNSDescriptor>>(this.myDefaultDescriptorsCacheNotStrict);
        XmlDocumentImpl copy = (XmlDocumentImpl)super.clone();
        this.updateSelfDependentDtdDescriptors(copy, cacheStrict, cacheNotStrict);
        XmlDocumentImpl xmlDocumentImpl = copy;
        if (xmlDocumentImpl == null) {
            XmlDocumentImpl.$$$reportNull$$$0(4);
        }
        return xmlDocumentImpl;
    }

    @Override
    public PsiElement copy() {
        HashMap<String, CachedValue<XmlNSDescriptor>> cacheStrict = new HashMap<String, CachedValue<XmlNSDescriptor>>(this.myDefaultDescriptorsCacheStrict);
        HashMap<String, CachedValue<XmlNSDescriptor>> cacheNotStrict = new HashMap<String, CachedValue<XmlNSDescriptor>>(this.myDefaultDescriptorsCacheNotStrict);
        XmlDocumentImpl copy = (XmlDocumentImpl)super.copy();
        this.updateSelfDependentDtdDescriptors(copy, cacheStrict, cacheNotStrict);
        return copy;
    }

    private void updateSelfDependentDtdDescriptors(XmlDocumentImpl copy, HashMap<String, CachedValue<XmlNSDescriptor>> cacheStrict, HashMap<String, CachedValue<XmlNSDescriptor>> cacheNotStrict) {
        XmlNSDescriptor nsDescriptor;
        copy.myDefaultDescriptorsCacheNotStrict = ContainerUtil.newConcurrentMap();
        copy.myDefaultDescriptorsCacheStrict = ContainerUtil.newConcurrentMap();
        for (Map.Entry<String, CachedValue<XmlNSDescriptor>> e : cacheStrict.entrySet()) {
            if (!e.getValue().hasUpToDateValue() || this.isGeneratedFromDtd(nsDescriptor = (XmlNSDescriptor)e.getValue().getValue())) continue;
            copy.myDefaultDescriptorsCacheStrict.put(e.getKey(), e.getValue());
        }
        for (Map.Entry<String, CachedValue<XmlNSDescriptor>> e : cacheNotStrict.entrySet()) {
            if (!e.getValue().hasUpToDateValue() || this.isGeneratedFromDtd(nsDescriptor = (XmlNSDescriptor)e.getValue().getValue())) continue;
            copy.myDefaultDescriptorsCacheNotStrict.put(e.getKey(), e.getValue());
        }
    }

    public PsiMetaData getMetaData() {
        return MetaRegistry.getMeta(this);
    }

    public void dumpStatistics() {
        Object[] keys;
        System.out.println("Statistics:");
        final TObjectIntHashMap map = new TObjectIntHashMap();
        XmlRecursiveElementVisitor psiRecursiveElementVisitor = new XmlRecursiveElementVisitor(){
            @NonNls
            private static final String TOKENS_KEY = "Tokens";
            @NonNls
            private static final String ELEMENTS_KEY = "Elements";

            public void visitXmlToken(XmlToken token) {
                this.inc(TOKENS_KEY);
            }

            public void visitElement(PsiElement element) {
                this.inc(ELEMENTS_KEY);
                super.visitElement(element);
            }

            private void inc(String key) {
                map.put((Object)key, map.get((Object)key) + 1);
            }
        };
        this.accept((PsiElementVisitor)psiRecursiveElementVisitor);
        for (Object key : keys = map.keys()) {
            System.out.println(key + ": " + map.get(key));
        }
    }

    @Override
    public TreeElement addInternal(final TreeElement first, final ASTNode last, final ASTNode anchor2, final Boolean before) {
        final PomModel model = PomManager.getModel((Project)this.getProject());
        XmlAspect aspect = (XmlAspect)model.getModelAspect(XmlAspect.class);
        final TreeElement[] holder = new TreeElement[1];
        try {
            model.runTransaction((PomTransaction)new PomTransactionBase(this, (PomModelAspect)aspect){

                public PomModelEvent runInner() {
                    holder[0] = XmlDocumentImpl.super.addInternal(first, last, anchor2, before);
                    return XmlDocumentChangedImpl.createXmlDocumentChanged(model, XmlDocumentImpl.this);
                }
            });
        }
        catch (IncorrectOperationException incorrectOperationException) {
            // empty catch block
        }
        return holder[0];
    }

    @Override
    public void deleteChildInternal(final @NotNull ASTNode child2) {
        if (child2 == null) {
            XmlDocumentImpl.$$$reportNull$$$0(5);
        }
        final PomModel model = PomManager.getModel((Project)this.getProject());
        XmlAspect aspect = (XmlAspect)model.getModelAspect(XmlAspect.class);
        try {
            model.runTransaction((PomTransaction)new PomTransactionBase(this, (PomModelAspect)aspect){

                public PomModelEvent runInner() {
                    XmlDocumentImpl.super.deleteChildInternal(child2);
                    return XmlDocumentChangedImpl.createXmlDocumentChanged(model, XmlDocumentImpl.this);
                }
            });
        }
        catch (IncorrectOperationException incorrectOperationException) {
            // empty catch block
        }
    }

    @Override
    public void replaceChildInternal(final @NotNull ASTNode child2, final @NotNull TreeElement newElement) {
        if (child2 == null) {
            XmlDocumentImpl.$$$reportNull$$$0(6);
        }
        if (newElement == null) {
            XmlDocumentImpl.$$$reportNull$$$0(7);
        }
        final PomModel model = PomManager.getModel((Project)this.getProject());
        XmlAspect aspect = (XmlAspect)model.getModelAspect(XmlAspect.class);
        try {
            model.runTransaction((PomTransaction)new PomTransactionBase(this, (PomModelAspect)aspect){

                public PomModelEvent runInner() {
                    XmlDocumentImpl.super.replaceChildInternal(child2, newElement);
                    return XmlDocumentChangedImpl.createXmlDocumentChanged(model, XmlDocumentImpl.this);
                }
            });
        }
        catch (IncorrectOperationException incorrectOperationException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/xml/XmlDocumentImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/xml/XmlDocumentImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePathForLogging";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getChildRole";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "replaceChildInternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

