/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.scss.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.inspections.CssInspectionsUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.sass.SASSBundle;
import org.jetbrains.plugins.sass.SASSLanguage;
import org.jetbrains.plugins.scss.SCSSLanguage;
import org.jetbrains.plugins.scss.inspections.SassScssBaseInspection;
import org.jetbrains.plugins.scss.psi.SASSSCSSElementVisitor;
import org.jetbrains.plugins.scss.psi.SassScssInclude;
import org.jetbrains.plugins.scss.psi.SassScssPlaceholderSelectorImpl;
import org.jetbrains.plugins.scss.psi.SassScssVariableImpl;
import org.jetbrains.plugins.scss.references.SassScssFunctionReference;

public class SassScssResolvedByNameOnlyInspection
extends SassScssBaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = SASSBundle.message("inspections.resolved.without.imports.name");
        if (string == null) {
            SassScssResolvedByNameOnlyInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            SassScssResolvedByNameOnlyInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            SassScssResolvedByNameOnlyInspection.$$$reportNull$$$0(2);
        }
        SASSSCSSElementVisitor sASSSCSSElementVisitor = new SASSSCSSElementVisitor(){

            @Override
            public void visitSassScssVariable(SassScssVariableImpl sassScssVariable) {
                CssInspectionsUtil.checkForProperlyResolving((PsiElement)sassScssVariable, (ProblemsHolder)holder, (String)SASSBundle.message("inspections.resolved.without.imports.message", sassScssVariable.getName()));
            }

            @Override
            public void visitInclude(SassScssInclude scssInclude) {
                PsiElement namedElement = scssInclude.getNameIdentifier();
                CssInspectionsUtil.checkForProperlyResolving((PsiElement)scssInclude, (PsiElement)(namedElement != null ? namedElement : scssInclude), (ProblemsHolder)holder, (String)SASSBundle.message("inspections.resolved.without.imports.message", scssInclude.getName()));
            }

            @Override
            public void visitPlaceholderSelector(SassScssPlaceholderSelectorImpl selector) {
                if (selector.isInsideExtendStatement()) {
                    CssInspectionsUtil.checkForProperlyResolving((PsiElement)selector, (ProblemsHolder)holder, (String)SASSBundle.message("inspections.resolved.without.imports.message", selector.getName()));
                }
            }

            public void visitElement(PsiElement element) {
                Language stylesheetLanguage = CssPsiUtil.getStylesheetLanguage((PsiElement)element);
                if (stylesheetLanguage != SASSLanguage.INSTANCE && stylesheetLanguage != SCSSLanguage.INSTANCE) {
                    return;
                }
                if (element instanceof CssFunction) {
                    PsiElement nameIdentifier = ((CssFunction)element).getNameIdentifier();
                    boolean hasProblem = false;
                    for (PsiReference reference : element.getReferences()) {
                        if (reference instanceof SassScssFunctionReference) {
                            ResolveResult[] results = ((SassScssFunctionReference)reference).multiResolve(false);
                            hasProblem = hasProblem || results.length > 0;
                            for (ResolveResult result : results) {
                                if (!result.isValidResult()) continue;
                                hasProblem = false;
                            }
                            continue;
                        }
                        if (!(reference instanceof PsiPolyVariantReference ? ((PsiPolyVariantReference)reference).multiResolve(false).length > 0 : reference.resolve() != null)) continue;
                        return;
                    }
                    if (hasProblem) {
                        holder.registerProblem(nameIdentifier != null ? nameIdentifier : element, SASSBundle.message("inspections.resolved.without.imports.message", ((CssFunction)element).getName()), new LocalQuickFix[0]);
                    }
                }
                super.visitElement(element);
            }
        };
        if (sASSSCSSElementVisitor == null) {
            SassScssResolvedByNameOnlyInspection.$$$reportNull$$$0(3);
        }
        return sASSSCSSElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/scss/inspections/SassScssResolvedByNameOnlyInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/scss/inspections/SassScssResolvedByNameOnlyInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

