/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson;

import com.intellij.execution.ExecutionException;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.packageJson.InstalledPackageVersion;
import com.intellij.javascript.nodejs.packageJson.NodeInstalledPackageFinder;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependencies;
import com.intellij.javascript.nodejs.packageJson.PackageVersionRangeMatchRequest;
import com.intellij.javascript.nodejs.packageJson.PackageVersionRangeMatcher;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.SemVer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PackageJsonDependenciesVerifier {
    private static final Logger LOG = Logger.getInstance(PackageJsonDependenciesVerifier.class);
    private final Project myProject;
    private final VirtualFile myPackageJson;

    public PackageJsonDependenciesVerifier(@NotNull Project project, @NotNull VirtualFile packageJson) {
        if (project == null) {
            PackageJsonDependenciesVerifier.$$$reportNull$$$0(0);
        }
        if (packageJson == null) {
            PackageJsonDependenciesVerifier.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myPackageJson = packageJson;
    }

    public boolean verify() {
        PackageJsonDependencies deps = PackageJsonDependencies.getOrCreate(this.myProject, this.myPackageJson);
        if (deps == null) {
            return true;
        }
        HashMap<String, String> ranges = new HashMap<String, String>(deps.getDevDependencies());
        ranges.putAll(deps.getDependencies());
        ArrayList<PackageVersionRangeMatchRequest> requests = new ArrayList<PackageVersionRangeMatchRequest>();
        NodeInstalledPackageFinder finder = new NodeInstalledPackageFinder(this.myProject, this.myPackageJson);
        for (Map.Entry entry : ranges.entrySet()) {
            String packageName = (String)entry.getKey();
            String versionRange = (String)entry.getValue();
            InstalledPackageVersion installed = finder.findInstalledPackage(packageName);
            if (installed == null) {
                LOG.info("Missing '" + packageName + "' dependency for " + this.myPackageJson.getPath());
                return false;
            }
            SemVer version = installed.getVersion();
            if (version == null) continue;
            requests.add(new PackageVersionRangeMatchRequest(packageName, versionRange, version.getRawVersion()));
        }
        try {
            NodeJsInterpreter interpreter = NodeJsInterpreterManager.getInstance(this.myProject).getInterpreter();
            return PackageVersionRangeMatcher.isMatched(NodeJsLocalInterpreter.castAndValidate(interpreter), requests);
        }
        catch (ExecutionException e) {
            return true;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "packageJson";
                break;
            }
        }
        objectArray[1] = "com/intellij/javascript/nodejs/packageJson/PackageJsonDependenciesVerifier";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

