/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.javascript.nodejs.PackageJsonField;
import com.intellij.json.JsonFileType;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.modules.InstallNodeLocalDependenciesAction;
import com.intellij.lang.javascript.modules.InstallNodeModuleQuickFix;
import com.intellij.lang.javascript.modules.JSModulesQuickFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RecordModuleIntoPackageJsonQuickFix
implements LocalQuickFix,
HintAction,
HighPriorityAction,
JSModulesQuickFix {
    @NotNull
    private final InstallNodeModuleQuickFix.ModuleElement myModuleElement;
    private final List<VirtualFile> myPackageJsonFiles;
    private final boolean myAsDevDependency;
    @Nullable
    private final VirtualFile myNodeModules;

    protected RecordModuleIntoPackageJsonQuickFix(@NotNull InstallNodeModuleQuickFix.ModuleElement module, @NotNull Collection<VirtualFile> virtualFiles, boolean asDevDependency, @Nullable VirtualFile modules) {
        if (module == null) {
            RecordModuleIntoPackageJsonQuickFix.$$$reportNull$$$0(0);
        }
        if (virtualFiles == null) {
            RecordModuleIntoPackageJsonQuickFix.$$$reportNull$$$0(1);
        }
        this.myModuleElement = module;
        this.myPackageJsonFiles = new ArrayList<VirtualFile>(virtualFiles);
        this.myAsDevDependency = asDevDependency;
        this.myNodeModules = modules;
    }

    public boolean showHint(@NotNull Editor editor) {
        if (editor == null) {
            RecordModuleIntoPackageJsonQuickFix.$$$reportNull$$$0(2);
        }
        return false;
    }

    @Nls
    @NotNull
    public String getText() {
        String string = JSBundle.message((String)"node.js.quickfix.record.into.package.json.text", (Object[])new Object[]{this.myModuleElement.getModuleName(), this.myAsDevDependency ? PackageJsonField.devDependencies.getName() : PackageJsonField.dependencies.getName()});
        if (string == null) {
            RecordModuleIntoPackageJsonQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            RecordModuleIntoPackageJsonQuickFix.$$$reportNull$$$0(4);
        }
        return !StringUtil.isEmptyOrSpaces((String)this.myModuleElement.getModuleName());
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            RecordModuleIntoPackageJsonQuickFix.$$$reportNull$$$0(5);
        }
        this.selectPackageJsonAndInvoke(project, file2);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            RecordModuleIntoPackageJsonQuickFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"node.js.quickfix.record.into.package.json.dependencies.family.name", (Object[])new Object[0]);
        if (string == null) {
            RecordModuleIntoPackageJsonQuickFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            RecordModuleIntoPackageJsonQuickFix.$$$reportNull$$$0(8);
        }
        if (descriptor2 == null) {
            RecordModuleIntoPackageJsonQuickFix.$$$reportNull$$$0(9);
        }
        this.selectPackageJsonAndInvoke(project, descriptor2.getPsiElement().getContainingFile());
    }

    private void selectPackageJsonAndInvoke(@NotNull Project project, @NotNull PsiFile file2) {
        if (project == null) {
            RecordModuleIntoPackageJsonQuickFix.$$$reportNull$$$0(10);
        }
        if (file2 == null) {
            RecordModuleIntoPackageJsonQuickFix.$$$reportNull$$$0(11);
        }
        InstallNodeModuleQuickFix.showSelectPackagePopupIfRequired(project, this.myPackageJsonFiles, (Consumer<? super VirtualFile>)((Consumer)packageJson -> {
            if (project == null) {
                RecordModuleIntoPackageJsonQuickFix.$$$reportNull$$$0(17);
            }
            if (file2 == null) {
                RecordModuleIntoPackageJsonQuickFix.$$$reportNull$$$0(18);
            }
            CommandProcessor.getInstance().executeCommand(project, () -> {
                if (project == null) {
                    RecordModuleIntoPackageJsonQuickFix.$$$reportNull$$$0(19);
                }
                if (file2 == null) {
                    RecordModuleIntoPackageJsonQuickFix.$$$reportNull$$$0(20);
                }
                ApplicationManager.getApplication().runWriteAction(() -> {
                    if (project == null) {
                        RecordModuleIntoPackageJsonQuickFix.$$$reportNull$$$0(21);
                    }
                    if (file2 == null) {
                        RecordModuleIntoPackageJsonQuickFix.$$$reportNull$$$0(22);
                    }
                    this.invokeAction(project, file2, (VirtualFile)packageJson);
                });
            }, this.getText(), null);
        }));
    }

    private void invokeAction(@NotNull Project project, PsiFile source, @Nullable VirtualFile packageJson) {
        VirtualFile candidateDir;
        PsiFile psiFile;
        if (project == null) {
            RecordModuleIntoPackageJsonQuickFix.$$$reportNull$$$0(12);
        }
        if ((psiFile = RecordModuleIntoPackageJsonQuickFix.ensurePackageJsonExist(project, packageJson, candidateDir = packageJson != null ? null : (this.myNodeModules == null ? null : this.myNodeModules.getParent()))) == null) {
            return;
        }
        JsonFile file2 = (JsonFile)ObjectUtils.tryCast((Object)psiFile, JsonFile.class);
        if (file2 == null) {
            return;
        }
        PsiElement[] children = file2.getChildren();
        if (children.length == 0) {
            return;
        }
        JsonObject topObject = (JsonObject)ObjectUtils.tryCast((Object)children[0], JsonObject.class);
        if (topObject == null) {
            return;
        }
        String propertyName = this.myAsDevDependency ? PackageJsonField.devDependencies.getName() : PackageJsonField.dependencies.getName();
        JsonProperty property = topObject.findProperty(propertyName);
        if (property == null ? this.createDependencyObject(project, topObject, propertyName) : this.addDependencyRecord(project, property)) {
            return;
        }
        InstallNodeLocalDependenciesAction.saveFile(psiFile.getViewProvider().getVirtualFile());
        DaemonCodeAnalyzer analyzer = DaemonCodeAnalyzer.getInstance((Project)project);
        analyzer.restart(source);
        analyzer.restart((PsiFile)file2);
    }

    @Nullable
    public static PsiFile ensurePackageJsonExist(@NotNull Project project, @Nullable VirtualFile packageJson, VirtualFile candidateDir) {
        PsiFile psiFile;
        if (project == null) {
            RecordModuleIntoPackageJsonQuickFix.$$$reportNull$$$0(13);
        }
        if (packageJson == null) {
            VirtualFile folder = candidateDir;
            if (folder == null) {
                FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor();
                descriptor2.setTitle("Select Folder To Create package.json");
                folder = FileChooser.chooseFile((FileChooserDescriptor)descriptor2, (Project)project, (VirtualFile)project.getBaseDir());
            }
            if (folder == null) {
                return null;
            }
            PsiDirectory directory = PsiManager.getInstance((Project)project).findDirectory(folder);
            if (directory == null) {
                Messages.showErrorDialog((Project)project, (String)"Error when trying to create package.json.", (String)"Put Node.js Module into package.json");
                return null;
            }
            psiFile = directory.findFile("package.json");
            if (psiFile == null) {
                psiFile = PackageJsonUtil.createPackageJson(directory, false);
            }
        } else {
            psiFile = PsiManager.getInstance((Project)project).findFile(packageJson);
        }
        return psiFile;
    }

    private boolean createDependencyObject(@NotNull Project project, JsonObject topObject, String propertyName) {
        JsonProperty depProperty;
        if (project == null) {
            RecordModuleIntoPackageJsonQuickFix.$$$reportNull$$$0(14);
        }
        if ((depProperty = this.createDepProperty(project, propertyName)) == null) {
            return true;
        }
        List list = topObject.getPropertyList();
        if (list.isEmpty()) {
            topObject.addAfter((PsiElement)depProperty, topObject.getFirstChild());
        } else {
            JsonProperty last = (JsonProperty)list.get(list.size() - 1);
            PsiElement added = topObject.addAfter(depProperty.getPrevSibling(), (PsiElement)last);
            topObject.addAfter((PsiElement)depProperty, added);
        }
        return false;
    }

    private boolean addDependencyRecord(@NotNull Project project, JsonProperty property) {
        JsonValue value;
        JsonObject object;
        if (project == null) {
            RecordModuleIntoPackageJsonQuickFix.$$$reportNull$$$0(15);
        }
        if ((object = (JsonObject)ObjectUtils.tryCast((Object)(value = property.getValue()), JsonObject.class)) == null) {
            return true;
        }
        String moduleName = this.myModuleElement.getModuleName();
        PsiFile dummyFile = RecordModuleIntoPackageJsonQuickFix.createDummyFile(project, "{\"\":1,\"" + moduleName + "\": \"latest\"}");
        PsiElement topElement = dummyFile.getFirstChild();
        JsonObject newTopObject = (JsonObject)ObjectUtils.tryCast((Object)topElement, JsonObject.class);
        if (newTopObject == null) {
            return true;
        }
        JsonProperty newDepProperty = newTopObject.findProperty(moduleName);
        if (newDepProperty == null) {
            return true;
        }
        List innerProperties = object.getPropertyList();
        if (innerProperties.isEmpty()) {
            object.addAfter((PsiElement)newDepProperty, object.getFirstChild());
        } else {
            PsiElement added = object.addAfter(newDepProperty.getPrevSibling(), (PsiElement)innerProperties.get(innerProperties.size() - 1));
            object.addAfter((PsiElement)newDepProperty, added);
        }
        return false;
    }

    @Nullable
    private JsonProperty createDepProperty(@NotNull Project project, String propertyName) {
        if (project == null) {
            RecordModuleIntoPackageJsonQuickFix.$$$reportNull$$$0(16);
        }
        String moduleName = this.myModuleElement.getModuleName();
        PsiFile dummyFile = RecordModuleIntoPackageJsonQuickFix.createDummyFile(project, "{\"\":1,\"" + propertyName + "\": {\"" + moduleName + "\": \"latest\"}}");
        PsiElement topElement = dummyFile.getFirstChild();
        JsonObject object = (JsonObject)ObjectUtils.tryCast((Object)topElement, JsonObject.class);
        if (object == null) {
            return null;
        }
        JsonProperty depProperty = object.findProperty(propertyName);
        if (depProperty == null) {
            return null;
        }
        return depProperty;
    }

    private static PsiFile createDummyFile(Project project, String text) {
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)project);
        return psiFileFactory.createFileFromText("dummy.json", (FileType)JsonFileType.INSTANCE, (CharSequence)text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFiles";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/RecordModuleIntoPackageJsonQuickFix";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 11: 
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/RecordModuleIntoPackageJsonQuickFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showHint";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "selectPackageJsonAndInvoke";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "invokeAction";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "ensurePackageJsonExist";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createDependencyObject";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addDependencyRecord";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createDepProperty";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$selectPackageJsonAndInvoke$2";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

