/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.guard;

import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.controlflow.JSControlFlowService;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSCaseBlockInstruction;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSConditionInstruction;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSEntryPointInstruction;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSInstructionWithReachability;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSLoopJunctionInstruction;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSModificationInstruction;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSReadWriteInstruction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSDecoratedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardChecker;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverJSTypeImpl;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Predicate;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSControlFlowTypeGuard
extends JSTypeGuardChecker {
    private static final Logger LOGGER = Logger.getInstance(JSControlFlowTypeGuard.class);
    private static final int CF_DEPTH_LIMIT = 300;
    private final boolean myUseAutoVariableType;
    private final boolean myUseAutoArrayType;
    private final boolean myStrictNullCheck;
    private final boolean myResetDecoratorsOnAnyCall;
    private final AtomicInteger myDepth;
    private final ArrayDeque<Instruction> myLoopStack;
    private final Set<JSType> myEvolvingArrays;
    @Nullable
    private final JSElement myStartControlFlowScope;
    private final Map<Instruction, JSType> myCalculatedTypes;

    public JSControlFlowTypeGuard(@NotNull JSReferenceExpression reference, @Nullable JSType startType, @Nullable PsiElement resolveResult, boolean useAutoVariableType) {
        if (reference == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(0);
        }
        this(reference, startType, resolveResult, false, useAutoVariableType, false);
    }

    protected JSControlFlowTypeGuard(@NotNull JSReferenceExpression reference, @Nullable JSType startType, @Nullable PsiElement resolveResult, boolean useAutoArrayType, boolean useAutoVariableType, boolean strictNullCheck) {
        if (reference == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(1);
        }
        super(reference, startType, resolveResult, useAutoVariableType);
        this.myDepth = new AtomicInteger();
        this.myLoopStack = new ArrayDeque();
        this.myEvolvingArrays = ContainerUtil.newTroveSet();
        this.myCalculatedTypes = ContainerUtil.newHashMap();
        this.myUseAutoArrayType = useAutoArrayType;
        this.myUseAutoVariableType = useAutoVariableType;
        this.myStrictNullCheck = strictNullCheck;
        this.myStartControlFlowScope = JSControlFlowTypeGuard.getStartControlFlowScope((PsiElement)reference);
        this.myResetDecoratorsOnAnyCall = JSControlFlowTypeGuard.shouldResetDecoratorsOnAssignments(resolveResult, (PsiElement)this.myStartControlFlowScope, reference, this.myTopReferenceName);
    }

    private static boolean shouldResetDecoratorsOnAssignments(@Nullable PsiElement resolveResult, @Nullable PsiElement startControlFlowScope, @NotNull JSReferenceExpression reference, @NotNull String topName) {
        ASTNode node;
        if (reference == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(2);
        }
        if (topName == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(3);
        }
        if (!(resolveResult instanceof JSVariable)) {
            return true;
        }
        if (((JSVariable)resolveResult).isConst() && !(resolveResult instanceof JSField)) {
            return false;
        }
        if (reference.getQualifier() != null || !JSControlFlowTypeGuard.isLocalSymbol((JSVariable)resolveResult)) {
            return true;
        }
        ASTNode aSTNode = node = startControlFlowScope == null ? null : startControlFlowScope.getNode();
        if (!(node instanceof CompositeElement)) {
            return true;
        }
        JSElement variableDefaultScope = JSControlFlowTypeGuard.getStartControlFlowScope(resolveResult);
        if (variableDefaultScope != startControlFlowScope) {
            return true;
        }
        return JSTreeUtil.hasDeclarationOrAssignmentInNestedScopes((CompositeElement)node, topName);
    }

    private static boolean isLocalSymbol(@NotNull JSVariable resolveResult) {
        JSFile file2;
        JSFile.ModuleStatus status;
        if (resolveResult == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(4);
        }
        if (resolveResult.isLocal()) {
            return true;
        }
        PsiFile containingFile = resolveResult.getContainingFile();
        return containingFile instanceof JSFile && ((status = (file2 = (JSFile)containingFile).getModuleStatus()) == JSFile.ModuleStatus.ES6 || status == JSFile.ModuleStatus.COMMONJS);
    }

    public static boolean isEvolvingArrayOperationTarget(@NotNull JSExpression expression) {
        PsiElement parent;
        if (expression == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(5);
        }
        if ((parent = expression.getParent()) instanceof JSIndexedPropertyAccessExpression && parent instanceof JSDefinitionExpression) {
            return true;
        }
        if (expression instanceof JSReferenceExpression && parent instanceof JSReferenceExpression) {
            JSReferenceExpression parentExpression = (JSReferenceExpression)parent;
            if (parentExpression.getParent() instanceof JSReferenceExpression) {
                return false;
            }
            String name = parentExpression.getName();
            return JSControlFlowTypeGuard.isPushOrUnshiftName(name) || "length".equals(name);
        }
        return false;
    }

    public static boolean isPushOrUnshiftName(@Nullable String name) {
        return "push".equals(name) || "unshift".equals(name);
    }

    public static boolean isEmptyArrayExpression(@Nullable JSExpression expression) {
        return expression instanceof JSArrayLiteralExpression && ((JSArrayLiteralExpression)expression).isEmpty();
    }

    public static boolean useAutoTypes(@NotNull JSReferenceExpression reference, @NotNull PsiElement resolveResult, @Nullable TypeScriptConfig config2) {
        if (reference == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(6);
        }
        if (resolveResult == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(7);
        }
        if (config2 == null || !config2.noImplicitAny() || !reference.getContainingFile().equals(resolveResult.getContainingFile()) || resolveResult.getParent() instanceof JSDestructuringContainer) {
            return false;
        }
        JSVariable result2 = (JSVariable)resolveResult;
        if (result2.getTypeElement() != null) {
            return false;
        }
        JSAttributeList list = result2.getAttributeList();
        if (list != null && list.hasModifier(JSAttributeList.ModifierType.EXPORT)) {
            return false;
        }
        return !TypeScriptPsiUtil.isAmbientDeclaration(resolveResult);
    }

    @Override
    @NotNull
    protected final JSType getNarrowedTypeImpl() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        JSControlFlowService.JSControlFlow flow = this.getStartControlFlow();
        if (flow == null) {
            JSType jSType = this.myDeclaredType;
            if (jSType == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(8);
            }
            return jSType;
        }
        Instruction instruction = this.getControlFlowInstruction(flow, (PsiElement)this.myReference);
        if (instruction == null) {
            JSType jSType = this.myDeclaredType;
            if (jSType == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(9);
            }
            return jSType;
        }
        JSType result2 = this.getTypeAtFlowNode(flow, instruction);
        JSType jSType = this.isEvolvingArrayType(result2) && JSControlFlowTypeGuard.isEvolvingArrayOperationTarget(this.myReference) ? this.myDeclaredType : this.finalizeEvolvingArrayType(result2);
        if (jSType == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(10);
        }
        return jSType;
    }

    @Nullable
    public Instruction getControlFlowInstruction(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull PsiElement context) {
        Instruction[] instructions;
        int indexOfElement;
        if (flow == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(11);
        }
        if (context == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(12);
        }
        if ((indexOfElement = ControlFlowUtil.findInstructionNumberByElement((Instruction[])(instructions = flow.getInstructions()), (PsiElement)context)) == -1) {
            Document document = PsiDocumentManager.getInstance((Project)context.getProject()).getDocument(context.getContainingFile());
            int number = document == null ? -1 : document.getLineNumber(context.getNode().getStartOffset());
            LOGGER.debug("Control flow must contain all semantic elements for correct type inference, line " + number + ", class " + context.getClass());
            return null;
        }
        return instructions[indexOfElement];
    }

    @Nullable
    private JSControlFlowService.JSControlFlow getStartControlFlow() {
        return this.getControlFlowScope(this.myStartControlFlowScope);
    }

    @Nullable
    private static JSElement getStartControlFlowScope(@NotNull PsiElement context) {
        JSElement result2;
        if (context == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(13);
        }
        return (result2 = (JSElement)PsiTreeUtil.getContextOfType((PsiElement)context, (Class[])new Class[]{JSExecutionScope.class, JSClass.class})) instanceof JSClass ? null : result2;
    }

    @Nullable
    public JSControlFlowService.JSControlFlow getControlFlowScope(@Nullable JSElement executionScope) {
        if (executionScope == null || executionScope instanceof JSClass) {
            return null;
        }
        return JSControlFlowService.getService(this.myReference.getProject()).getControlFlow(executionScope);
    }

    @NotNull
    private JSType getTypeAtFlowNode(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull Instruction currentInstruction) {
        if (flow == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(14);
        }
        if (currentInstruction == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(15);
        }
        ProgressManager.checkCanceled();
        if (currentInstruction instanceof JSLoopJunctionInstruction) {
            JSType jSType = this.getTypeAtLoop(flow, (JSLoopJunctionInstruction)currentInstruction);
            if (jSType == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(16);
            }
            return jSType;
        }
        JSType type = this.myCalculatedTypes.get(currentInstruction);
        if (type != null) {
            JSType jSType = type;
            if (jSType == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(17);
            }
            return jSType;
        }
        type = this.getTypeAtFlowNodeImpl(flow, currentInstruction);
        this.myCalculatedTypes.put(currentInstruction, type);
        JSType jSType = type;
        if (jSType == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(18);
        }
        return jSType;
    }

    @NotNull
    private JSType getTypeAtFlowNodeImpl(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull Instruction currentInstruction) {
        if (flow == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(19);
        }
        if (currentInstruction == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(20);
        }
        HashSet visitedInstructions = ContainerUtil.newHashSet();
        while (currentInstruction != null) {
            JSType result2;
            if (!visitedInstructions.add(currentInstruction)) {
                JSType jSType = this.myDeclaredType;
                if (jSType == null) {
                    JSControlFlowTypeGuard.$$$reportNull$$$0(21);
                }
                return jSType;
            }
            if (currentInstruction instanceof JSEntryPointInstruction) {
                boolean isReferenceExpression;
                JSElement scope = ((JSEntryPointInstruction)currentInstruction).getScope();
                if (this.isFinalScope((PsiElement)scope) || (!(isReferenceExpression = this.myReference instanceof JSReferenceExpression) || ((JSReferenceExpression)this.myReference).getQualifier() != null) && (isReferenceExpression || this.myReference instanceof JSThisExpression)) break;
                JSType jSType = TypeScriptTypeRelations.removeInferredDecorators(this.getTypeAtParentScope((PsiElement)scope));
                if (jSType == null) {
                    JSControlFlowTypeGuard.$$$reportNull$$$0(22);
                }
                return jSType;
            }
            if (currentInstruction instanceof JSReadWriteInstruction) {
                if (this.myResetDecoratorsOnAnyCall && ((JSReadWriteInstruction)currentInstruction).isCall()) {
                    JSType jSType = TypeScriptTypeRelations.removeInferredDecorators(this.getPrevFlowType(flow, currentInstruction));
                    if (jSType == null) {
                        JSControlFlowTypeGuard.$$$reportNull$$$0(23);
                    }
                    return jSType;
                }
                JSType assignmentType = this.getTypeAtFlowAssignment(flow, currentInstruction);
                if (assignmentType != null) {
                    JSType jSType = assignmentType;
                    if (jSType == null) {
                        JSControlFlowTypeGuard.$$$reportNull$$$0(24);
                    }
                    return jSType;
                }
            }
            if (currentInstruction instanceof JSModificationInstruction && this.myUseAutoArrayType && (result2 = this.getTypeAtFlowArrayMutation(flow, (JSModificationInstruction)currentInstruction)) != null) {
                JSType jSType = result2;
                if (jSType == null) {
                    JSControlFlowTypeGuard.$$$reportNull$$$0(25);
                }
                return jSType;
            }
            if (currentInstruction instanceof JSCaseBlockInstruction) {
                JSType jSType = this.getTypeAtCaseBlock(flow, (JSCaseBlockInstruction)currentInstruction);
                if (jSType == null) {
                    JSControlFlowTypeGuard.$$$reportNull$$$0(26);
                }
                return jSType;
            }
            if (currentInstruction instanceof JSConditionInstruction) {
                JSType jSType = this.getTypeAtFlowCondition(flow, (JSConditionInstruction)currentInstruction);
                if (jSType == null) {
                    JSControlFlowTypeGuard.$$$reportNull$$$0(27);
                }
                return jSType;
            }
            if (currentInstruction instanceof JSLoopJunctionInstruction) {
                JSType jSType = this.getTypeAtLoop(flow, (JSLoopJunctionInstruction)currentInstruction);
                if (jSType == null) {
                    JSControlFlowTypeGuard.$$$reportNull$$$0(28);
                }
                return jSType;
            }
            Collection prevInstructions = currentInstruction.allPred();
            int size = prevInstructions.size();
            if (size == 0) break;
            if (size > 1) {
                JSType jSType = this.getPrevFlowType(flow, currentInstruction);
                if (jSType == null) {
                    JSControlFlowTypeGuard.$$$reportNull$$$0(29);
                }
                return jSType;
            }
            currentInstruction = (Instruction)ContainerUtil.getFirstItem((Collection)prevInstructions);
        }
        JSType jSType = this.myDeclaredType;
        if (jSType == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(30);
        }
        return jSType;
    }

    protected boolean isFinalScope(@NotNull PsiElement scope) {
        if (scope == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(31);
        }
        return scope instanceof JSFile || scope instanceof TypeScriptModule || ES6PsiUtil.isEmbeddedModule(scope) || scope instanceof JSFunction && !(scope instanceof JSFunctionExpression);
    }

    @NotNull
    private JSType getTypeAtLoop(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull JSLoopJunctionInstruction instruction) {
        if (flow == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(32);
        }
        if (instruction == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(33);
        }
        JSType currentValue = this.myCalculatedTypes.get((Object)instruction);
        if (this.myLoopStack.contains((Object)instruction) || currentValue != null) {
            JSType jSType = currentValue == null ? this.myDeclaredType : currentValue;
            if (jSType == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(34);
            }
            return jSType;
        }
        this.myLoopStack.push((Instruction)instruction);
        JSType resultType = this.getRegularPredTypes(flow, instruction.getRegularPred());
        if (!this.isDeclaredType(resultType)) {
            this.myCalculatedTypes.put((Instruction)instruction, resultType);
            Collection<Instruction> jumps = instruction.getJumpPred();
            if (!jumps.isEmpty()) {
                LinkedHashSet resultTypes = ContainerUtil.newLinkedHashSet();
                resultTypes.add(resultType);
                resultTypes.addAll(this.getPrevFlowTypeForInstructions(flow, jumps));
                resultType = this.getCommonTypeForPred(resultTypes);
            }
        }
        this.myLoopStack.pop();
        this.myCalculatedTypes.put((Instruction)instruction, resultType);
        JSType jSType = resultType;
        if (jSType == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(35);
        }
        return jSType;
    }

    @NotNull
    private JSType getRegularPredTypes(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull Collection<Instruction> regularPreds) {
        if (flow == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(36);
        }
        if (regularPreds == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(37);
        }
        if (regularPreds.size() > 0) {
            JSType jSType = this.getCommonTypeForPred(this.getPrevFlowTypeForInstructions(flow, regularPreds));
            if (jSType == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(38);
            }
            return jSType;
        }
        JSType jSType = this.myDeclaredType;
        if (jSType == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(39);
        }
        return jSType;
    }

    @Nullable
    private JSType getTypeAtFlowAssignment(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull Instruction currentInstruction) {
        JSReadWriteInstruction readWriteInstruction;
        ReadWriteAccessDetector.Access access;
        if (flow == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(40);
        }
        if (currentInstruction == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(41);
        }
        if ((access = (readWriteInstruction = (JSReadWriteInstruction)currentInstruction).getAccess()) != ReadWriteAccessDetector.Access.Write && access != ReadWriteAccessDetector.Access.ReadWrite) {
            return null;
        }
        PsiElement element = currentInstruction.getElement();
        JSElement referenceExpressionCandidate = JSControlFlowTypeGuard.getAssignTarget(element);
        if (referenceExpressionCandidate == null) {
            return null;
        }
        if (this.isMatchingReference((PsiElement)this.myReference, (PsiElement)referenceExpressionCandidate)) {
            if (access == ReadWriteAccessDetector.Access.ReadWrite) {
                JSType prevType = this.getPrevFlowType(flow, currentInstruction);
                return this.getBaseTypeOfLiteralType(prevType);
            }
            if (this.myUseAutoArrayType) {
                JSType initializerType;
                JSExpression initializer = JSControlFlowTypeGuard.getInitializerExpression(element);
                if (element instanceof JSVariable || JSControlFlowTypeGuard.isEmptyArrayExpression(initializer)) {
                    return this.getEvolvingArrayType(new TypeScriptNeverJSTypeImpl(this.mySource));
                }
                if (initializer != null && (initializerType = this.evaluateInitializerType(element)) != null) {
                    JSType typeToUse = this.getBaseTypeOfLiteralType(initializerType);
                    return TypeScriptTypeRelations.isTypeAssignableTo(typeToUse, this.myDeclaredType, this.myProcessingContext) ? typeToUse : JSNamedTypeFactory.createType("Array", this.mySource, JSContext.INSTANCE);
                }
            }
            return this.wrapWithInitializerFacts(this.getAssignmentType(element), element);
        }
        if (this.containsMatchingReference((PsiElement)this.myReference, element)) {
            return this.myDeclaredType;
        }
        return null;
    }

    @Nullable
    private JSType getAssignmentType(@NotNull PsiElement element) {
        JSType initializerType;
        if (element == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(42);
        }
        if (this.isAutoVariableType() && !(element instanceof JSFieldVariable) && (initializerType = this.evaluateInitializerType(element)) != null) {
            return this.getBaseTypeOfLiteralType(initializerType);
        }
        if (this.myDeclaredType instanceof JSUnionType && (initializerType = this.evaluateInitializerType(element)) != null) {
            return this.getAssignmentReducedType((JSUnionType)this.myDeclaredType, initializerType);
        }
        return this.myDeclaredType;
    }

    private JSType wrapWithInitializerFacts(@Nullable JSType resultType, @Nullable PsiElement element) {
        if (resultType == null) {
            return null;
        }
        JSExpression initializer = JSControlFlowTypeGuard.getInitializerExpression(element);
        if (initializer == null) {
            return resultType;
        }
        boolean isUndefined = JSSymbolUtil.isUndefinedExpression(initializer);
        if (isUndefined) {
            return this.wrapWithDecorators(resultType, EnumSet.of(JSDecoratedType.TypeDecoration.INFERRED_UNDEFINED));
        }
        boolean isNull = JSSymbolUtil.isNullLiteral(initializer);
        if (isNull) {
            return this.wrapWithDecorators(resultType, EnumSet.of(JSDecoratedType.TypeDecoration.INFERRED_NULL));
        }
        if (JSControlFlowTypeGuard.isNonEmptyExpression(initializer)) {
            JSType primitiveCandidate;
            if (initializer instanceof JSLiteralExpression && (primitiveCandidate = this.wrapAsPrimitiveGuard(resultType)) != resultType) {
                return primitiveCandidate;
            }
            return this.wrapWithDecorators(resultType, NOTNULL_NOTUNDEFINED);
        }
        return resultType;
    }

    private static boolean isNonEmptyExpression(@Nullable JSExpression initializer) {
        return initializer instanceof JSLiteralExpression || initializer instanceof JSFunctionExpression || initializer instanceof JSObjectLiteralExpression || initializer instanceof JSArrayLiteralExpression || initializer instanceof JSClassExpression;
    }

    @NotNull
    protected JSType getAssignmentReducedType(@NotNull JSUnionType currentType, @NotNull JSType assignmentType) {
        if (currentType == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(43);
        }
        if (assignmentType == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(44);
        }
        if (TypeScriptTypeRelations.getCanonicalType(currentType).isEquivalentTo(TypeScriptTypeRelations.getCanonicalType(assignmentType), this.myProcessingContext, true)) {
            JSUnionType jSUnionType = currentType;
            if (jSUnionType == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(45);
            }
            return jSUnionType;
        }
        if (assignmentType instanceof TypeScriptNeverJSTypeImpl) {
            JSType jSType = assignmentType;
            if (jSType == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(46);
            }
            return jSType;
        }
        if (assignmentType instanceof JSAnyType) {
            JSUnionType jSUnionType = currentType;
            if (jSUnionType == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(47);
            }
            return jSUnionType;
        }
        JSType resultType = TypeScriptTypeRelations.filterType(currentType, (Predicate<? super JSType>)((Predicate)el -> {
            if (assignmentType == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(98);
            }
            return TypeScriptTypeRelations.typeMaybeAssignableTo(assignmentType, el, this.myProcessingContext);
        }), (PsiElement)this.myReference);
        JSUnionType jSUnionType = resultType instanceof TypeScriptNeverJSTypeImpl ? currentType : resultType;
        if (jSUnionType == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(48);
        }
        return jSUnionType;
    }

    @NotNull
    protected JSType getTypeAtParentScope(@NotNull PsiElement scope) {
        if (scope == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(49);
        }
        ArrayList candidateParents = ContainerUtil.newArrayList((Object[])new PsiElement[]{scope});
        JSElement cfScope = null;
        for (PsiElement parent = scope.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof JSClass) {
                JSType jSType = this.myDeclaredType;
                if (jSType == null) {
                    JSControlFlowTypeGuard.$$$reportNull$$$0(50);
                }
                return jSType;
            }
            if (parent instanceof JSElement && JSControlFlowService.isControlFlowScope(parent)) {
                cfScope = (JSElement)parent;
                break;
            }
            candidateParents.add(parent);
        }
        if (cfScope == null) {
            JSType jSType = this.myDeclaredType;
            if (jSType == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(51);
            }
            return jSType;
        }
        JSControlFlowService.JSControlFlow flowScope = this.getControlFlowScope(cfScope);
        if (flowScope == null) {
            JSType jSType = this.myDeclaredType;
            if (jSType == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(52);
            }
            return jSType;
        }
        Instruction[] instructions = flowScope.getInstructions();
        for (PsiElement candidateScope : candidateParents) {
            int numberByElement = ControlFlowUtil.findInstructionNumberByElement((Instruction[])instructions, (PsiElement)candidateScope);
            if (numberByElement == -1) continue;
            JSType jSType = this.getTypeAtFlowNode(flowScope, instructions[numberByElement]);
            if (jSType == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(53);
            }
            return jSType;
        }
        JSType jSType = this.myDeclaredType;
        if (jSType == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(54);
        }
        return jSType;
    }

    @Nullable
    private JSType getTypeAtFlowArrayMutation(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull JSModificationInstruction instruction) {
        JSExpression indexExpression;
        JSExpression elExpression;
        JSDefinitionExpression definitionExpression;
        JSExpression expression;
        JSExpression toProcess;
        if (flow == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(55);
        }
        if (instruction == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(56);
        }
        if (!this.isMatchingReference((PsiElement)this.myReference, (PsiElement)JSControlFlowTypeGuard.getReferenceCandidate(toProcess = JSControlFlowTypeGuard.getExpressionForArrayMutation(expression = instruction.getExpression())))) {
            return null;
        }
        JSType prevType = this.getPrevFlowType(flow, instruction);
        if (!(prevType instanceof JSArrayTypeImpl) || !this.isEvolvingArrayType(prevType)) {
            return prevType;
        }
        JSArrayTypeImpl arrayType = (JSArrayTypeImpl)prevType;
        PsiElement element = instruction.getElement();
        JSType startType = arrayType.getType();
        if (element instanceof JSCallExpression) {
            JSExpression[] arguments = ((JSCallExpression)element).getArguments();
            if (arguments.length > 0) {
                JSType currentType = startType;
                for (JSExpression argument : arguments) {
                    currentType = this.addEvolvingArrayElementType(currentType, argument);
                }
                return currentType == startType ? arrayType : this.getEvolvingArrayType(currentType);
            }
        } else if (element instanceof JSAssignmentExpression && (definitionExpression = ((JSAssignmentExpression)element).getDefinitionExpression()) != null && (elExpression = definitionExpression.getExpression()) instanceof JSIndexedPropertyAccessExpression && this.isIndexExpressionNumberLike(indexExpression = ((JSIndexedPropertyAccessExpression)elExpression).getIndexExpression())) {
            JSExpression initializer = definitionExpression.getInitializer();
            JSType type = this.addEvolvingArrayElementType(startType, initializer);
            return type == startType ? arrayType : this.getEvolvingArrayType(type);
        }
        return prevType;
    }

    @Nullable
    private static JSExpression getExpressionForArrayMutation(@NotNull JSExpression expression) {
        if (expression == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(57);
        }
        if (expression instanceof JSReferenceExpression) {
            return ((JSReferenceExpression)expression).getQualifier();
        }
        return null;
    }

    private boolean isIndexExpressionNumberLike(@Nullable JSExpression indexExpression) {
        if (indexExpression == null) {
            return false;
        }
        JSType type = this.getExpressionTypeForTypeGuard(indexExpression);
        return type instanceof JSNumberType;
    }

    private JSType addEvolvingArrayElementType(@NotNull JSType currentParameter, @Nullable JSExpression newParameterType) {
        if (currentParameter == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(58);
        }
        if (newParameterType == null) {
            return currentParameter;
        }
        JSType type = this.getExpressionTypeForTypeGuard(newParameterType);
        if (type == null) {
            return currentParameter;
        }
        JSType baseType = this.getBaseTypeOfLiteralType(type);
        return this.getUnionTypeWithProcessingDecorators(currentParameter, baseType);
    }

    @NotNull
    private JSType getTypeAtCaseBlock(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull JSCaseBlockInstruction instruction) {
        if (flow == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(59);
        }
        if (instruction == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(60);
        }
        JSType prevType = this.getPrevFlowType(flow, (Instruction)instruction);
        JSCaseBlockInstruction startBlock = instruction.getStartBlock();
        JSSwitchStatement statement = instruction.getSwitchStatement();
        if (statement == null) {
            JSType jSType = prevType;
            if (jSType == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(61);
            }
            return jSType;
        }
        JSType jSType = this.getTypeAtSwitchClause(prevType, statement, startBlock.getIndex(), instruction.getIndex());
        if (jSType == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(62);
        }
        return jSType;
    }

    @NotNull
    private JSType getTypeAtFlowCondition(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull JSConditionInstruction instruction) {
        JSType prevType;
        if (flow == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(63);
        }
        if (instruction == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(64);
        }
        if ((prevType = this.getPrevFlowType(flow, (Instruction)instruction)) instanceof TypeScriptNeverJSTypeImpl) {
            JSType jSType = prevType;
            if (jSType == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(65);
            }
            return jSType;
        }
        boolean assumeTrue = instruction.getValue();
        PsiElement element = instruction.getElement();
        if (element instanceof JSExpression) {
            JSType narrowType = this.narrowType(prevType, (JSExpression)element, assumeTrue);
            if (narrowType == prevType) {
                JSType jSType = prevType;
                if (jSType == null) {
                    JSControlFlowTypeGuard.$$$reportNull$$$0(66);
                }
                return jSType;
            }
            JSType jSType = narrowType;
            if (jSType == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(67);
            }
            return jSType;
        }
        JSType jSType = prevType;
        if (jSType == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(68);
        }
        return jSType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private JSType getPrevFlowType(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull Instruction instruction) {
        if (flow == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(69);
        }
        if (instruction == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(70);
        }
        int depth = this.myDepth.incrementAndGet();
        if (depth > 300) {
            JSType jSType = this.myDeclaredType;
            JSType jSType2 = jSType;
            if (jSType2 == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(71);
            }
            return jSType2;
        }
        Collection instructions = instruction.allPred();
        int size = instructions.size();
        if (size == 1) {
            JSType jSType = this.getTypeAtFlowNode(flow, (Instruction)instructions.iterator().next());
            JSType jSType3 = jSType;
            if (jSType3 == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(72);
            }
            return jSType3;
        }
        Collection<JSType> result2 = this.getPrevFlowTypeForInstructions(flow, instructions);
        JSType jSType = this.getCommonTypeForPred(result2);
        JSType jSType4 = jSType;
        if (jSType4 == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(73);
        }
        return jSType4;
        finally {
            this.myDepth.decrementAndGet();
        }
    }

    @NotNull
    private JSType getCommonTypeForPred(@NotNull Collection<JSType> result2) {
        if (result2 == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(74);
        }
        if (result2.size() == 0 || result2.size() == 1) {
            JSType jSType = (JSType)ContainerUtil.getFirstItem(result2, (Object)this.myDeclaredType);
            if (jSType == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(75);
            }
            return jSType;
        }
        JSType jSType = this.getUnionOrEvolvingArrayType(result2, this.mySource);
        if (jSType == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(76);
        }
        return jSType;
    }

    @NotNull
    private Collection<JSType> getPrevFlowTypeForInstructions(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull Collection<Instruction> instructions) {
        if (flow == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(77);
        }
        if (instructions == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(78);
        }
        LinkedHashSet result2 = ContainerUtil.newLinkedHashSet();
        boolean hasUnreachable = false;
        boolean autoTypeWasSkipped = false;
        for (Instruction prevInstructions : instructions) {
            boolean isUnreachable = JSControlFlowTypeGuard.isUnreachableInstruction(flow, prevInstructions);
            if (isUnreachable) {
                hasUnreachable = true;
                continue;
            }
            JSType currentType = this.getTypeAtFlowNode(flow, prevInstructions);
            if (this.isDeclaredType(currentType)) {
                if (this.isAutoVariableType() && this.myRealType == null) {
                    autoTypeWasSkipped = true;
                    continue;
                }
                Set<JSType> set = Collections.singleton(this.myDeclaredType);
                if (set == null) {
                    JSControlFlowTypeGuard.$$$reportNull$$$0(79);
                }
                return set;
            }
            result2.add(currentType);
        }
        if (result2.isEmpty() && (hasUnreachable || autoTypeWasSkipped)) {
            Set<JSType> set = Collections.singleton(this.myDeclaredType);
            if (set == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(80);
            }
            return set;
        }
        if (autoTypeWasSkipped) {
            Collection collection = result2.stream().map(TypeScriptTypeRelations::removeInferredDecorators).collect(Collectors.toList());
            if (collection == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(81);
            }
            return collection;
        }
        LinkedHashSet linkedHashSet = result2;
        if (linkedHashSet == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(82);
        }
        return linkedHashSet;
    }

    private boolean isDeclaredType(@NotNull JSType type) {
        if (type == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(83);
        }
        if (type instanceof JSDecoratedType) {
            type = ((JSDecoratedType)type).getOriginalType();
        }
        return this.myDeclaredType == type;
    }

    private static boolean isUnreachableInstruction(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull Instruction prevInstructions) {
        if (flow == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(84);
        }
        if (prevInstructions == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(85);
        }
        return flow.isCFUnreachable(prevInstructions) || prevInstructions instanceof JSInstructionWithReachability && !((JSInstructionWithReachability)prevInstructions).isReachable();
    }

    @Contract(value="null -> null")
    private static JSElement getAssignTarget(@Nullable PsiElement element) {
        if (element instanceof JSAssignmentExpression) {
            element = ((JSAssignmentExpression)element).getDefinitionExpression();
        }
        if (element instanceof JSDefinitionExpression) {
            return ((JSDefinitionExpression)element).getExpression();
        }
        if (element instanceof JSParameter) {
            return null;
        }
        if (element instanceof JSVariable) {
            return (JSVariable)element;
        }
        if (element instanceof JSForInStatement) {
            return JSUtils.unparenthesize(((JSForInStatement)element).getVariableExpression());
        }
        return null;
    }

    @Nullable
    protected JSType evaluateInitializerType(@Nullable PsiElement element) {
        JSExpression expression = JSControlFlowTypeGuard.getInitializerExpression(element);
        if (expression == null && element instanceof JSForInStatement) {
            JSExpression collectionExpression = ((JSForInStatement)element).getCollectionExpression();
            return JSTypeUtils.getIndexableComponentType(this.getExpressionTypeForTypeGuard(collectionExpression));
        }
        return expression == null ? null : this.getExpressionTypeForTypeGuard(expression);
    }

    @Nullable
    protected static JSExpression getInitializerExpression(@Nullable PsiElement element) {
        if (element instanceof JSAssignmentExpression) {
            element = ((JSAssignmentExpression)element).getDefinitionExpression();
        }
        if (element instanceof JSInitializerOwner) {
            return ((JSInitializerOwner)element).getInitializer();
        }
        return null;
    }

    @NotNull
    private JSType getUnionOrEvolvingArrayType(@NotNull Collection<JSType> types, @NotNull JSTypeSource source) {
        if (types == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(86);
        }
        if (source == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(87);
        }
        boolean allEvolving = true;
        boolean hasEvolving = false;
        for (JSType type : types) {
            boolean isEvolving = this.isEvolvingArrayType(type);
            allEvolving &= isEvolving;
            hasEvolving |= isEvolving;
        }
        if (allEvolving) {
            JSType jSType = this.mergeEvolvingArrays(types, source);
            if (jSType == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(88);
            }
            return jSType;
        }
        if (hasEvolving) {
            types = types.stream().map(el -> this.finalizeEvolvingArrayType((JSType)el)).collect(Collectors.toList());
        }
        JSType jSType = JSControlFlowTypeGuard.getUnionTypeWithProcessingDecorators(types, source);
        if (jSType == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(89);
        }
        return jSType;
    }

    private JSType mergeEvolvingArrays(@NotNull Collection<JSType> types, @NotNull JSTypeSource source) {
        if (types == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(90);
        }
        if (source == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(91);
        }
        List nestedTypes = types.stream().filter(el -> el instanceof JSArrayTypeImpl).map(el -> ((JSArrayTypeImpl)el).getType()).collect(Collectors.toList());
        JSType unionType = JSControlFlowTypeGuard.getUnionTypeWithProcessingDecorators(nestedTypes, source);
        return this.getEvolvingArrayType(unionType);
    }

    private boolean isEvolvingArrayType(@NotNull JSType arrayType) {
        if (arrayType == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(92);
        }
        return this.myEvolvingArrays.contains(arrayType);
    }

    @NotNull
    private JSType getEvolvingArrayType(@NotNull JSType parameterType) {
        if (parameterType == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(93);
        }
        JSArrayTypeImpl type = new JSArrayTypeImpl(parameterType, this.mySource);
        this.myEvolvingArrays.add(type);
        JSArrayTypeImpl jSArrayTypeImpl = type;
        if (jSArrayTypeImpl == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(94);
        }
        return jSArrayTypeImpl;
    }

    @Override
    protected boolean strictNullChecks() {
        return this.myStrictNullCheck;
    }

    @NotNull
    private JSType finalizeEvolvingArrayType(@NotNull JSType arrayType) {
        if (arrayType == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(95);
        }
        if (arrayType instanceof JSArrayTypeImpl) {
            JSType type = ((JSArrayTypeImpl)arrayType).getType();
            if (type instanceof TypeScriptNeverJSTypeImpl) {
                JSType jSType = this.myDeclaredType;
                if (jSType == null) {
                    JSControlFlowTypeGuard.$$$reportNull$$$0(96);
                }
                return jSType;
            }
            this.myEvolvingArrays.remove(arrayType);
        }
        JSType jSType = arrayType;
        if (jSType == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(97);
        }
        return jSType;
    }

    @Override
    protected boolean isAutoVariableType() {
        return this.myUseAutoVariableType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 61: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 88: 
            case 89: 
            case 94: 
            case 96: 
            case 97: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 61: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 88: 
            case 89: 
            case 94: 
            case 96: 
            case 97: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topName";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 5: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 61: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 88: 
            case 89: 
            case 94: 
            case 96: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/JSControlFlowTypeGuard";
                break;
            }
            case 11: 
            case 14: 
            case 19: 
            case 32: 
            case 36: 
            case 40: 
            case 55: 
            case 59: 
            case 63: 
            case 69: 
            case 77: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 15: 
            case 20: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentInstruction";
                break;
            }
            case 31: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 33: 
            case 56: 
            case 60: 
            case 64: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regularPreds";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentType";
                break;
            }
            case 44: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentType";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentParameter";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructions";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prevInstructions";
                break;
            }
            case 86: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 87: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 92: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayType";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/JSControlFlowTypeGuard";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNarrowedTypeImpl";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeAtFlowNode";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeAtFlowNodeImpl";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeAtLoop";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegularPredTypes";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssignmentReducedType";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeAtParentScope";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeAtCaseBlock";
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeAtFlowCondition";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrevFlowType";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonTypeForPred";
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrevFlowTypeForInstructions";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnionOrEvolvingArrayType";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvolvingArrayType";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "finalizeEvolvingArrayType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "shouldResetDecoratorsOnAssignments";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isLocalSymbol";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isEvolvingArrayOperationTarget";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "useAutoTypes";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 61: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 88: 
            case 89: 
            case 94: 
            case 96: 
            case 97: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getControlFlowInstruction";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getStartControlFlowScope";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAtFlowNode";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAtFlowNodeImpl";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isFinalScope";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAtLoop";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getRegularPredTypes";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAtFlowAssignment";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getAssignmentType";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getAssignmentReducedType";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAtParentScope";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAtFlowArrayMutation";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionForArrayMutation";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "addEvolvingArrayElementType";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAtCaseBlock";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAtFlowCondition";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getPrevFlowType";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getCommonTypeForPred";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getPrevFlowTypeForInstructions";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "isDeclaredType";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "isUnreachableInstruction";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getUnionOrEvolvingArrayType";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "mergeEvolvingArrays";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "isEvolvingArrayType";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "getEvolvingArrayType";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "finalizeEvolvingArrayType";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getAssignmentReducedType$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 61: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 88: 
            case 89: 
            case 94: 
            case 96: 
            case 97: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

