/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.context;

import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class URIFilteredIterator
implements Iterator<XmlFile> {
    private final Iterator<? extends XmlFile> baseIterator;
    private final String uri;
    private XmlFile nextFile = null;
    private boolean advanced = false;
    private boolean completed = false;

    public URIFilteredIterator(Iterator<? extends XmlFile> baseIterator, String uri) {
        this.baseIterator = baseIterator;
        this.uri = uri;
    }

    @Override
    public boolean hasNext() {
        if (this.completed) {
            return false;
        }
        if (!this.advanced) {
            this.advance();
        }
        return !this.completed;
    }

    @Override
    public XmlFile next() {
        if (this.completed) {
            throw new NoSuchElementException();
        }
        if (!this.advanced) {
            this.advance();
        }
        this.advanced = false;
        return this.nextFile;
    }

    private void advance() {
        if (this.completed) {
            return;
        }
        do {
            if (this.baseIterator.hasNext()) {
                this.nextFile = this.baseIterator.next();
                String testURI = URIFilteredIterator.calculateDocTypeURI(this.nextFile);
                if (!this.uri.equals(testURI)) continue;
                this.advanced = true;
                continue;
            }
            this.completed = true;
        } while (!this.completed && !this.advanced);
    }

    public static String calculateDocTypeURI(XmlFile file) {
        XmlDocument document = file.getDocument();
        if (document == null) {
            return null;
        }
        XmlProlog prolog = document.getProlog();
        if (prolog == null) {
            return null;
        }
        XmlDoctype doctype = prolog.getDoctype();
        if (doctype == null) {
            return null;
        }
        return doctype.getDtdUri();
    }

    @Override
    public void remove() {
    }
}

