/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions.fs;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramFileEditor;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class SaveDiagramAction
extends DiagramAction {
    public void perform(@NotNull AnActionEvent e) {
        if (e == null) {
            SaveDiagramAction.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        DiagramBuilder builder = SaveDiagramAction.getBuilder((AnActionEvent)e);
        FileEditor fileEditor = (FileEditor)e.getData(PlatformDataKeys.FILE_EDITOR);
        if (project == null || builder == null || !(fileEditor instanceof DiagramFileEditor)) {
            return;
        }
        String filename = "diagram.uml";
        VirtualFile baseDir = null;
        DiagramFileEditor editor = (DiagramFileEditor)fileEditor;
        VirtualFile vf = editor.getOriginalVirtualFile();
        if (vf != null && vf.getFileSystem() instanceof LocalFileSystem) {
            filename = vf.getName();
            baseDir = vf.getParent();
        } else {
            Object original = builder.getGraph().getDataProvider((Object)"ORIGINAL_ELEMENT").get((Object)"");
            String fqn = null;
            if (original != null) {
                fqn = builder.getProvider().getExtras().suggestDiagramFileName(original);
                if (fqn == null && (fqn = builder.getProvider().getVfsResolver().getQualifiedName(original)) != null && fqn.contains(".") && !fqn.endsWith(".")) {
                    fqn = fqn.substring(fqn.lastIndexOf(46) + 1);
                }
            } else {
                fqn = builder.getProvider().getElementManager().getElementTitle(editor.getOriginalElement());
            }
            if (fqn != null) {
                filename = fqn + ".uml";
            }
        }
        VirtualFileWrapper wrapper = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor("Save File", "Save UML class diagram as .uml", new String[]{"uml"}), project).save(baseDir == null ? project.getBaseDir() : baseDir, filename);
        if (wrapper == null) {
            return;
        }
        Document xml = new Document(new Element("Diagram"));
        DiagramState state = (DiagramState)editor.getState(FileEditorStateLevel.FULL);
        state.write(xml.getRootElement());
        VirtualFile file = wrapper.getVirtualFile(true);
        String path = wrapper.getFile().getPath();
        if (file == null || !state.saveTo(file, project)) {
            String msg = "Can't save diagram to " + path;
            if (file != null && ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(new VirtualFile[]{file}).hasReadonlyFiles()) {
                msg = msg + " File is Read-Only.";
            }
            Messages.showErrorDialog((Project)project, (String)msg, (String)"Error");
        }
    }

    public boolean isEnabled(@NotNull AnActionEvent e, DiagramBuilder b) {
        if (e == null) {
            SaveDiagramAction.$$$reportNull$$$0(1);
        }
        return e.getProject() != null && e.getData(PlatformDataKeys.FILE_EDITOR) instanceof DiagramFileEditor;
    }

    public boolean isUndoable(@NotNull AnActionEvent e) {
        if (e == null) {
            SaveDiagramAction.$$$reportNull$$$0(2);
        }
        return false;
    }

    public String getActionName() {
        return "Save Diagram";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/uml/core/actions/fs/SaveDiagramAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "perform";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isUndoable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

