/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.ui.explorer;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.jetbrains.php.phing.PhingBuildFile;
import com.jetbrains.php.phing.PhingBundle;
import com.jetbrains.php.phing.PhingStateService;
import com.jetbrains.php.phing.ui.explorer.PhingExplorer;
import com.jetbrains.php.phing.ui.explorer.PhingStateListener;
import icons.PhingIcons;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class PhingToolWindowFactory
implements ToolWindowFactory,
Condition<Project> {
    public static final String WINDOW_ID = PhingBundle.message("phing.tool.window.id", new Object[0]);

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            PhingToolWindowFactory.$$$reportNull$$$0(0);
        }
        if (toolWindow == null) {
            PhingToolWindowFactory.$$$reportNull$$$0(1);
        }
        PhingExplorer explorer = new PhingExplorer(project);
        ContentManager contentManager = toolWindow.getContentManager();
        Content content = contentManager.getFactory().createContent((JComponent)((Object)explorer), null, false);
        content.setHelpId("reference.phing.tool.window");
        contentManager.addContent(content);
        Disposer.register((Disposable)project, (Disposable)explorer);
    }

    public void initToolWindowListener(final PhingStateService stateService) {
        stateService.addPhingStateListener(new PhingStateListener(){

            @Override
            public void buildFileChanged(PhingBuildFile buildFile) {
            }

            @Override
            public void buildFileAdded(PhingBuildFile buildFile) {
                if (stateService.getBuildFiles().size() == 1) {
                    PhingToolWindowFactory.this.getOrCreateExplorerToolWindow(buildFile.getProject());
                }
            }

            @Override
            public void buildFileRemoved(PhingBuildFile buildFile) {
                if (stateService.getBuildFiles().size() == 0) {
                    ToolWindowManager.getInstance((Project)buildFile.getProject()).unregisterToolWindow(WINDOW_ID);
                }
            }
        });
    }

    private void getOrCreateExplorerToolWindow(Project project) {
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
        ToolWindow toolWindow = toolWindowManager.getToolWindow(WINDOW_ID);
        if (toolWindow == null) {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                this.createToolWindow(project, toolWindowManager);
            } else {
                ApplicationManager.getApplication().invokeLater(() -> this.createToolWindow(project, toolWindowManager));
            }
        }
    }

    private ToolWindow createToolWindow(Project project, ToolWindowManager toolWindowManager) {
        ToolWindow toolWindow = toolWindowManager.registerToolWindow(WINDOW_ID, false, ToolWindowAnchor.RIGHT);
        toolWindow.setIcon(PhingIcons.PhingToolWindow);
        this.createToolWindowContent(project, toolWindow);
        return toolWindow;
    }

    public boolean value(Project project) {
        return PhingStateService.getInstance(project).getBuildFiles().size() > 0 && ToolWindowManager.getInstance((Project)project).getToolWindow(WINDOW_ID) == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "toolWindow";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/phing/ui/explorer/PhingToolWindowFactory";
        objectArray[2] = "createToolWindowContent";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

