/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.bugs;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.inspections.CssFixFactory;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class CssFloatPxLengthInspection
extends CssBaseInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CssFloatPxLengthInspection.$$$reportNull$$$0(0);
        }
        CssElementVisitor cssElementVisitor = new CssElementVisitor(){

            public void visitCssTerm(CssTerm _term) {
                PsiElement numberTerm;
                super.visitCssTerm(_term);
                PsiElement[] children = _term.getChildren();
                if (children.length == 1 && (numberTerm = children[0]) != null && numberTerm.getNode().getElementType() == CssElementTypes.CSS_NUMBER_TERM) {
                    PsiElement unit;
                    if (CssFloatPxLengthInspection.mayBeColorStopValue(numberTerm)) {
                        return;
                    }
                    PsiElement number = numberTerm.getFirstChild();
                    if (number != null && (unit = numberTerm.getLastChild()) != null && "px".equals(unit.getText())) {
                        try {
                            Integer.parseInt(number.getText());
                        }
                        catch (NumberFormatException e) {
                            holder.registerProblem(number, CssBundle.message((String)"invalid.css.integer.value.message", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{CssFixFactory.getInstance().roundPxValueQuickFix()});
                        }
                    }
                }
            }
        };
        if (cssElementVisitor == null) {
            CssFloatPxLengthInspection.$$$reportNull$$$0(1);
        }
        return cssElementVisitor;
    }

    private static boolean mayBeColorStopValue(PsiElement psiElement) {
        CssFunction function = (CssFunction)PsiTreeUtil.getParentOfType((PsiElement)psiElement, CssFunction.class);
        return function != null && function.getName().contains("gradient");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/inspections/bugs/CssFloatPxLengthInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/inspections/bugs/CssFloatPxLengthInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

