/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.mocha.execution;

import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.javascript.JSRunProfileWithCompileBeforeLaunchOption;
import com.intellij.javascript.nodejs.debug.NodeDebugRunConfiguration;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.testFramework.PreferableRunConfiguration;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.nodejs.mocha.MochaUtil;
import com.jetbrains.nodejs.mocha.execution.MochaRunConfigurationEditor;
import com.jetbrains.nodejs.mocha.execution.MochaRunProfileState;
import com.jetbrains.nodejs.mocha.execution.MochaRunSettings;
import com.jetbrains.nodejs.mocha.execution.MochaRunSettingsSerializationUtil;
import com.jetbrains.nodejs.mocha.execution.MochaTestKind;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.LocalFileFinder;

public class MochaRunConfiguration
extends LocatableConfigurationBase
implements JSRunProfileWithCompileBeforeLaunchOption,
NodeDebugRunConfiguration,
PreferableRunConfiguration {
    private MochaRunSettings myRunSettings = new MochaRunSettings.Builder().build();

    protected MochaRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
    }

    @NotNull
    public SettingsEditor<MochaRunConfiguration> getConfigurationEditor() {
        MochaRunConfigurationEditor mochaRunConfigurationEditor = new MochaRunConfigurationEditor(this.getProject());
        if (mochaRunConfigurationEditor == null) {
            MochaRunConfiguration.$$$reportNull$$$0(0);
        }
        return mochaRunConfigurationEditor;
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            MochaRunConfiguration.$$$reportNull$$$0(1);
        }
        super.readExternal(element);
        MochaRunSettings runSettings = MochaRunSettingsSerializationUtil.readFromXml(element);
        this.setRunSettings(runSettings);
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            MochaRunConfiguration.$$$reportNull$$$0(2);
        }
        super.writeExternal(element);
        MochaRunSettingsSerializationUtil.writeToXml(element, this.myRunSettings);
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        if (executor == null) {
            MochaRunConfiguration.$$$reportNull$$$0(3);
        }
        if (environment == null) {
            MochaRunConfiguration.$$$reportNull$$$0(4);
        }
        return new MochaRunProfileState(this.getProject(), this, environment, this.getMochaPackage(), this.myRunSettings);
    }

    @NotNull
    NodePackage getMochaPackage() {
        if (RunManager.getInstance((Project)this.getProject()).isTemplate((RunConfiguration)this)) {
            NodePackage nodePackage = (NodePackage)ObjectUtils.notNull((Object)this.myRunSettings.getMochaPackage(), (Object)new NodePackage(""));
            if (nodePackage == null) {
                MochaRunConfiguration.$$$reportNull$$$0(5);
            }
            return nodePackage;
        }
        NodePackage pkg = this.myRunSettings.getMochaPackage();
        if (pkg == null) {
            NodeJsInterpreter interpreter;
            Project project = this.getProject();
            pkg = MochaUtil.PACKAGE_DESCRIPTOR.findFirstDirectDependencyPackage(project, interpreter = this.myRunSettings.getInterpreterRef().resolve(project), this.getContextFile());
            if (pkg.isEmptyPath()) {
                pkg = MochaUtil.getMochaPackage(project);
            } else {
                MochaUtil.setMochaPackage(project, pkg);
            }
            this.myRunSettings = this.myRunSettings.builder().setMochaPackage(pkg).build();
        }
        NodePackage nodePackage = pkg;
        if (nodePackage == null) {
            MochaRunConfiguration.$$$reportNull$$$0(6);
        }
        return nodePackage;
    }

    @Nullable
    private VirtualFile getContextFile() {
        VirtualFile f = MochaRunConfiguration.findFile(this.myRunSettings.getTestFilePath());
        if (f == null) {
            f = MochaRunConfiguration.findFile(this.myRunSettings.getTestDirPath());
        }
        if (f == null) {
            f = MochaRunConfiguration.findFile(this.myRunSettings.getWorkingDir());
        }
        return f;
    }

    @Nullable
    private static VirtualFile findFile(@NotNull String path) {
        if (path == null) {
            MochaRunConfiguration.$$$reportNull$$$0(7);
        }
        return FileUtil.isAbsolute((String)path) ? LocalFileSystem.getInstance().findFileByPath(path) : null;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        NodeInterpreterUtil.checkForRunConfiguration((NodeJsInterpreter)this.myRunSettings.getInterpreterRef().resolve(this.getProject()));
        this.getMochaPackage().validateForRunConfiguration("mocha");
        MochaRunConfiguration.validatePath(true, "working directory", this.myRunSettings.getWorkingDir(), true, true);
        if (StringUtil.isEmptyOrSpaces((String)this.myRunSettings.getUi())) {
            throw new RuntimeConfigurationError("Unspecified mocha user interface");
        }
        MochaTestKind testKind = this.myRunSettings.getTestKind();
        if (MochaTestKind.DIRECTORY == testKind) {
            MochaRunConfiguration.validatePath(true, "test directory", this.myRunSettings.getTestDirPath(), false, true);
        } else if (MochaTestKind.PATTERN != testKind && (MochaTestKind.TEST_FILE == testKind || MochaTestKind.SUITE == testKind || MochaTestKind.TEST == testKind)) {
            MochaRunConfiguration.validatePath(false, "test file", this.myRunSettings.getTestFilePath(), true, false);
            if (MochaTestKind.SUITE == testKind && this.myRunSettings.getSuiteNames().isEmpty()) {
                throw new RuntimeConfigurationError("Unspecified suite name");
            }
            if (MochaTestKind.TEST == testKind && this.myRunSettings.getTestNames().isEmpty()) {
                throw new RuntimeConfigurationError("Unspecified test name");
            }
        }
    }

    private static void validatePath(boolean shouldBeDirectory, @NotNull String name, @Nullable String path, boolean shouldBeAbsolute, boolean warnIfNonexistent) throws RuntimeConfigurationException {
        boolean exists;
        if (name == null) {
            MochaRunConfiguration.$$$reportNull$$$0(8);
        }
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            throw new RuntimeConfigurationError("Unspecified " + name);
        }
        File file = new File(path);
        if (shouldBeAbsolute && !file.isAbsolute()) {
            throw new RuntimeConfigurationError("No such " + name);
        }
        boolean bl = exists = shouldBeDirectory ? file.isDirectory() : file.isFile();
        if (!exists) {
            if (warnIfNonexistent) {
                throw new RuntimeConfigurationWarning("No such " + name);
            }
            throw new RuntimeConfigurationError("No such " + name);
        }
    }

    public String suggestedName() {
        MochaRunSettings runSettings = this.myRunSettings;
        MochaTestKind testKind = runSettings.getTestKind();
        if (testKind == MochaTestKind.DIRECTORY) {
            return MochaRunConfiguration.getRelativePath(this.getProject(), runSettings.getTestDirPath());
        }
        if (testKind == MochaTestKind.PATTERN) {
            return runSettings.getTestFilePattern();
        }
        if (testKind == MochaTestKind.TEST_FILE) {
            return MochaRunConfiguration.getRelativePath(this.getProject(), runSettings.getTestFilePath());
        }
        if (runSettings.getTestKind() == MochaTestKind.SUITE) {
            return StringUtil.join(runSettings.getSuiteNames(), (String)".");
        }
        if (runSettings.getTestKind() == MochaTestKind.TEST) {
            return StringUtil.join(runSettings.getTestNames(), (String)".");
        }
        return "All Tests";
    }

    @Nullable
    public String getActionName() {
        MochaRunSettings runSettings = this.myRunSettings;
        MochaTestKind testKind = runSettings.getTestKind();
        if (testKind == MochaTestKind.DIRECTORY) {
            return MochaRunConfiguration.getLastPathComponent(runSettings.getTestDirPath());
        }
        if (testKind == MochaTestKind.PATTERN) {
            return runSettings.getTestFilePattern();
        }
        if (testKind == MochaTestKind.TEST_FILE) {
            return MochaRunConfiguration.getLastPathComponent(runSettings.getTestFilePath());
        }
        if (runSettings.getTestKind() == MochaTestKind.SUITE) {
            return StringUtil.notNullize((String)((String)ContainerUtil.getLastItem(runSettings.getSuiteNames())));
        }
        if (runSettings.getTestKind() == MochaTestKind.TEST) {
            return StringUtil.notNullize((String)((String)ContainerUtil.getLastItem(runSettings.getTestNames())));
        }
        return "All Tests";
    }

    @NotNull
    private static String getRelativePath(@NotNull Project project, @NotNull String path) {
        String relativePath;
        VirtualFile root;
        VirtualFile file;
        if (project == null) {
            MochaRunConfiguration.$$$reportNull$$$0(9);
        }
        if (path == null) {
            MochaRunConfiguration.$$$reportNull$$$0(10);
        }
        if ((file = LocalFileFinder.findFile((String)path)) != null && file.isValid() && (root = ProjectFileIndex.getInstance((Project)project).getContentRootForFile(file)) != null && root.isValid() && StringUtil.isNotEmpty((String)(relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)File.separatorChar)))) {
            String string = relativePath;
            if (string == null) {
                MochaRunConfiguration.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = MochaRunConfiguration.getLastPathComponent(path);
        if (string == null) {
            MochaRunConfiguration.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    private static String getLastPathComponent(@NotNull String path) {
        int lastIndex;
        if (path == null) {
            MochaRunConfiguration.$$$reportNull$$$0(13);
        }
        String string = (lastIndex = path.lastIndexOf(47)) >= 0 ? path.substring(lastIndex + 1) : path;
        if (string == null) {
            MochaRunConfiguration.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public MochaRunSettings getRunSettings() {
        MochaRunSettings mochaRunSettings = this.myRunSettings;
        if (mochaRunSettings == null) {
            MochaRunConfiguration.$$$reportNull$$$0(15);
        }
        return mochaRunSettings;
    }

    public void setRunSettings(@NotNull MochaRunSettings runSettings) {
        NodePackage pkg;
        if (runSettings == null) {
            MochaRunConfiguration.$$$reportNull$$$0(16);
        }
        if ((pkg = runSettings.getMochaPackage()) != null && pkg.isEmptyPath() && RunManager.getInstance((Project)this.getProject()).isTemplate((RunConfiguration)this)) {
            runSettings = runSettings.builder().setMochaPackage(null).build();
        }
        this.myRunSettings = runSettings;
        if (pkg != null) {
            MochaUtil.setMochaPackage(this.getProject(), pkg);
        }
    }

    public boolean isPreferredOver(@NotNull RunConfiguration otherRc, @NotNull PsiElement sourceElement) {
        if (otherRc == null) {
            MochaRunConfiguration.$$$reportNull$$$0(17);
        }
        if (sourceElement == null) {
            MochaRunConfiguration.$$$reportNull$$$0(18);
        }
        return true;
    }

    public void onNewConfigurationCreated() {
        VirtualFile dir;
        MochaRunSettings.Builder builder = this.myRunSettings.builder();
        if (this.myRunSettings.getUi().isEmpty()) {
            builder.setUi("bdd");
        }
        if (this.myRunSettings.getWorkingDir().trim().isEmpty() && (dir = this.getProject().getBaseDir()) != null) {
            builder.setWorkingDir(dir.getPath()).build();
        }
        if (this.myRunSettings.getTestKind() == MochaTestKind.DIRECTORY && this.myRunSettings.getTestDirPath().trim().isEmpty()) {
            String workingDirPath = FileUtil.toSystemIndependentName((String)this.myRunSettings.getWorkingDir());
            VirtualFile workingDir = LocalFileSystem.getInstance().findFileByPath(workingDirPath);
            if (workingDir != null && workingDir.isValid() && workingDir.isDirectory()) {
                String testDirName;
                String[] testDirNames = new String[]{"test", "spec", "tests", "specs"};
                VirtualFile testDir = null;
                String[] stringArray = testDirNames;
                int n = stringArray.length;
                for (int i = 0; !(i >= n || (testDir = workingDir.findChild(testDirName = stringArray[i])) != null && testDir.isValid() && testDir.isDirectory()); ++i) {
                }
                if (testDir != null) {
                    builder.setTestDirPath(testDir.getPath()).build();
                }
            }
        }
        this.myRunSettings = builder.build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/mocha/execution/MochaRunConfiguration";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runSettings";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherRc";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/mocha/execution/MochaRunConfiguration";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMochaPackage";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePath";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastPathComponent";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "validatePath";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getLastPathComponent";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setRunSettings";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isPreferredOver";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

