/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.behat.version;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.jetbrains.php.PhpTestFrameworkVersionDetector;
import com.jetbrains.php.behat.BehatBundle;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BehatVersionDetector
extends PhpTestFrameworkVersionDetector<String> {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.php.behat.version.BehatVersionDetector");
    private static final String[] VERSION_OPTIONS = new String[]{"--no-colors", "--version"};
    private static final String VERSION_PREFIX = "behat";
    private static final String BEHAT = "Behat";
    private static BehatVersionDetector myInstance;

    public static BehatVersionDetector getInstance() {
        if (myInstance == null) {
            myInstance = new BehatVersionDetector();
        }
        return myInstance;
    }

    @NotNull
    protected String getPresentableName() {
        if (BEHAT == null) {
            BehatVersionDetector.$$$reportNull$$$0(0);
        }
        return BEHAT;
    }

    @NotNull
    protected String[] getVersionOptions() {
        if (VERSION_OPTIONS == null) {
            BehatVersionDetector.$$$reportNull$$$0(1);
        }
        return VERSION_OPTIONS;
    }

    @NotNull
    protected String getTitle() {
        String string = BehatBundle.message("php.behat.getting.behat.version", new Object[0]);
        if (string == null) {
            BehatVersionDetector.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String parse(@Nullable String output) throws ExecutionException {
        List split = StringUtil.split((String)StringUtil.notNullize((String)output).trim(), (String)" ");
        if (split.size() < 2) {
            String message = BehatBundle.message("php.behat.configuration.ui.can.not.parse.version", output);
            LOG.debug(message);
            throw new ExecutionException(message);
        }
        if (!StringUtil.equalsIgnoreCase((CharSequence)((CharSequence)split.get(0)), (CharSequence)VERSION_PREFIX)) {
            String message = BehatBundle.message("php.behat.configuration.ui.can.not.parse.version", output);
            LOG.debug(message);
            throw new ExecutionException(message);
        }
        String fullVersion = ((String)split.get(split.size() - 1)).trim();
        String shortVersion = ((String)StringUtil.split((String)fullVersion, (String)"-").get(0)).trim();
        if (shortVersion.isEmpty() || !StringUtil.isDecimalDigit((char)shortVersion.charAt(0))) {
            String message = BehatBundle.message("php.behat.configuration.ui.can.not.parse.version", output);
            LOG.debug(message);
            throw new ExecutionException(message);
        }
        String string = shortVersion;
        if (string == null) {
            BehatVersionDetector.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static boolean isVendorDir(@NotNull String parent) {
        if (parent == null) {
            BehatVersionDetector.$$$reportNull$$$0(4);
        }
        return FileUtil.namesEqual((String)PathUtil.getFileName((String)parent), (String)"vendor");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/behat/version/BehatVersionDetector";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionOptions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/behat/version/BehatVersionDetector";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isVendorDir";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

