/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.client;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.JdomKt;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.ws.rest.client.RestClientRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;

public class RestClientSerializer {
    public static final String REST_CLIENT_REQUEST_TAG = "RestClientRequest";

    private RestClientSerializer() {
    }

    public static void saveToFile(@NotNull RestClientRequest request, @NotNull File file) throws RestClientSerializationException {
        if (request == null) {
            RestClientSerializer.$$$reportNull$$$0(0);
        }
        if (file == null) {
            RestClientSerializer.$$$reportNull$$$0(1);
        }
        Element requestXml = XmlSerializer.serialize((Object)request);
        try {
            JdomKt.write((Parent)requestXml, (Path)file.toPath());
        }
        catch (IOException e1) {
            throw new RestClientSerializationException(e1.getMessage());
        }
    }

    @NotNull
    public static RestClientRequest loadFromFile(@NotNull VirtualFile file) throws RestClientSerializationException {
        Element element;
        if (file == null) {
            RestClientSerializer.$$$reportNull$$$0(2);
        }
        try {
            element = JdomKt.loadElement((InputStream)file.getInputStream());
        }
        catch (JDOMException e) {
            throw new RestClientSerializationException("The selected file is not a valid .xml file: " + e.getMessage());
        }
        catch (IOException e) {
            throw new RestClientSerializationException("Error loading " + file.getPath() + ": " + e.getMessage());
        }
        if (!element.getName().equals(REST_CLIENT_REQUEST_TAG)) {
            throw new RestClientSerializationException("The selected file is not a REST Client request");
        }
        RestClientRequest restClientRequest = (RestClientRequest)XmlSerializer.deserialize((Element)element, RestClientRequest.class);
        if (restClientRequest == null) {
            RestClientSerializer.$$$reportNull$$$0(3);
        }
        return restClientRequest;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/rest/client/RestClientSerializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/rest/client/RestClientSerializer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFromFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "saveToFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadFromFile";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class RestClientSerializationException
    extends Exception {
        public RestClientSerializationException(@NotNull String s) {
            if (s == null) {
                RestClientSerializationException.$$$reportNull$$$0(0);
            }
            super(s);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/ws/rest/client/RestClientSerializer$RestClientSerializationException", "<init>"));
        }
    }
}

