/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import git4idea.commands.GitLineHandlerListener;

public class GitRebaseProblemDetector
implements GitLineHandlerListener {
    private static final String[] REBASE_CONFLICT_INDICATORS = new String[]{"Merge conflict in", "hint: after resolving the conflicts, mark the corrected paths", "You must edit all merge conflicts", "Failed to merge in the changes", "could not apply"};
    private static final String REBASE_NO_CHANGE_INDICATOR = "No changes - did you forget to use 'git add'?";
    private static final String[] DIRTY_TREE_INDICATORS = new String[]{"you have unstaged changes", "your index contains uncommitted changes"};
    private static final String STOPPED_FOR_EDITING = "You can amend the commit now";
    private volatile boolean myMergeConflict;
    private volatile boolean myNoChangeError;
    private volatile boolean myDirtyTree;
    private volatile boolean myStoppedForEditing;

    public boolean isNoChangeError() {
        return this.myNoChangeError;
    }

    public boolean isMergeConflict() {
        return this.myMergeConflict;
    }

    public boolean isDirtyTree() {
        return this.myDirtyTree;
    }

    public boolean hasStoppedForEditing() {
        return this.myStoppedForEditing;
    }

    @Override
    public void onLineAvailable(String line, Key outputType) {
        for (String conflictIndicator : REBASE_CONFLICT_INDICATORS) {
            if (!StringUtil.containsIgnoreCase((String)line, (String)conflictIndicator)) continue;
            this.myMergeConflict = true;
            return;
        }
        if (StringUtil.containsIgnoreCase((String)line, (String)REBASE_NO_CHANGE_INDICATOR)) {
            this.myNoChangeError = true;
            return;
        }
        for (String indicator : DIRTY_TREE_INDICATORS) {
            if (!StringUtil.containsIgnoreCase((String)line, (String)indicator)) continue;
            this.myDirtyTree = true;
            return;
        }
        if (StringUtil.containsIgnoreCase((String)line, (String)STOPPED_FOR_EDITING)) {
            this.myStoppedForEditing = true;
        }
    }
}

