/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFileBase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.LocalTimeCounter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class BinaryLightVirtualFile
extends LightVirtualFileBase {
    private byte[] myContent;

    public BinaryLightVirtualFile() {
        this("");
    }

    public BinaryLightVirtualFile(@NonNls String name) {
        this(name, ArrayUtil.EMPTY_BYTE_ARRAY);
    }

    public BinaryLightVirtualFile(@NonNls String name, @NotNull byte[] content) {
        if (content == null) {
            BinaryLightVirtualFile.$$$reportNull$$$0(0);
        }
        this(name, null, content, LocalTimeCounter.currentTime());
    }

    public BinaryLightVirtualFile(String name, FileType fileType, @NotNull byte[] content) {
        if (content == null) {
            BinaryLightVirtualFile.$$$reportNull$$$0(1);
        }
        this(name, fileType, content, LocalTimeCounter.currentTime());
    }

    public BinaryLightVirtualFile(VirtualFile original, @NotNull byte[] content, long modificationStamp) {
        if (content == null) {
            BinaryLightVirtualFile.$$$reportNull$$$0(2);
        }
        this(original.getName(), original.getFileType(), content, modificationStamp);
    }

    public BinaryLightVirtualFile(String name, FileType fileType, @NotNull byte[] content, long modificationStamp) {
        if (content == null) {
            BinaryLightVirtualFile.$$$reportNull$$$0(3);
        }
        super(name, fileType, modificationStamp);
        this.myContent = ArrayUtil.EMPTY_BYTE_ARRAY;
        this.setContent(content);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return VfsUtilCore.byteStreamSkippingBOM(this.myContent, this);
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(Object requestor, final long newModificationStamp, long newTimeStamp) throws IOException {
        OutputStream outputStream = VfsUtilCore.outputStreamAddingBOM(new ByteArrayOutputStream(){

            @Override
            public void close() {
                BinaryLightVirtualFile.this.setModificationStamp(newModificationStamp);
                byte[] content = this.toByteArray();
                BinaryLightVirtualFile.this.setContent(content);
            }
        }, this);
        if (outputStream == null) {
            BinaryLightVirtualFile.$$$reportNull$$$0(4);
        }
        return outputStream;
    }

    @Override
    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        if (this.myContent == null) {
            BinaryLightVirtualFile.$$$reportNull$$$0(5);
        }
        return this.myContent;
    }

    public void setContent(Object requestor, @NotNull byte[] content, boolean fireEvent) {
        if (content == null) {
            BinaryLightVirtualFile.$$$reportNull$$$0(6);
        }
        this.setContent(content);
        this.setModificationStamp(LocalTimeCounter.currentTime());
    }

    private void setContent(@NotNull byte[] content) {
        if (content == null) {
            BinaryLightVirtualFile.$$$reportNull$$$0(7);
        }
        this.myContent = content;
    }

    @NotNull
    public byte[] getContent() {
        if (this.myContent == null) {
            BinaryLightVirtualFile.$$$reportNull$$$0(8);
        }
        return this.myContent;
    }

    @Override
    public String toString() {
        return "BinaryLightVirtualFile: " + this.getPresentableUrl();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/BinaryLightVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/BinaryLightVirtualFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputStream";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

