/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.intermediate;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Properties;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.intermediate.AdaptIntermediateFacade;
import org.jetbrains.dekaf.intermediate.DBExceptionRecognizer;
import org.jetbrains.dekaf.intermediate.IntegralIntermediateFacade;
import org.jetbrains.dekaf.intermediate.IntegralIntermediateRdbmsProvider;
import org.jetbrains.dekaf.intermediate.PrimeIntermediateFacade;
import org.jetbrains.dekaf.intermediate.PrimeIntermediateRdbmsProvider;

public class AdaptIntermediateRdbmsProvider
implements IntegralIntermediateRdbmsProvider {
    @NotNull
    private final Rdbms myRdbms;
    @NotNull
    private final PrimeIntermediateRdbmsProvider myRemoteProvider;

    public AdaptIntermediateRdbmsProvider(@NotNull PrimeIntermediateRdbmsProvider remoteProvider) {
        this.myRemoteProvider = remoteProvider;
        this.myRdbms = remoteProvider.rdbms();
    }

    @Override
    @NotNull
    public Rdbms rdbms() {
        return this.myRdbms;
    }

    @Override
    @NotNull
    public Pattern connectionStringPattern() {
        return this.myRemoteProvider.connectionStringPattern();
    }

    @Override
    public byte specificity() {
        return this.myRemoteProvider.specificity();
    }

    @Override
    @NotNull
    public IntegralIntermediateFacade openFacade(@NotNull String connectionString, @Nullable Properties connectionProperties, int connectionsLimit) {
        PrimeIntermediateFacade remoteFacade = this.myRemoteProvider.openFacade(connectionString, connectionProperties, connectionsLimit);
        return new AdaptIntermediateFacade(remoteFacade);
    }

    @Override
    @NotNull
    public Class<? extends DBExceptionRecognizer> getExceptionRecognizerClass() {
        return this.myRemoteProvider.getExceptionRecognizerClass();
    }

    @Override
    @NotNull
    public DBExceptionRecognizer getExceptionRecognizer() {
        Class<? extends DBExceptionRecognizer> erClass = this.myRemoteProvider.getExceptionRecognizerClass();
        try {
            Field instanceField = erClass.getDeclaredField("INSTANCE");
            if (instanceField != null && Modifier.isStatic(instanceField.getModifiers())) {
                return (DBExceptionRecognizer)instanceField.get(null);
            }
            return erClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException("Unknown how to get an instance of class " + erClass.getName());
        }
    }

    @Override
    @Nullable
    public <I> I getSpecificService(@NotNull Class<I> serviceClass, @NotNull String serviceName) throws ClassCastException {
        return this.myRemoteProvider.getSpecificService(serviceClass, serviceName);
    }
}

