/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rest.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.rest.psi.RestElement;
import com.jetbrains.rest.psi.RestReference;
import com.jetbrains.rest.validation.RestElementVisitor;
import org.jetbrains.annotations.NotNull;

public class RestReferenceTarget
extends RestElement {
    public RestReferenceTarget(@NotNull ASTNode node) {
        if (node == null) {
            RestReferenceTarget.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    public String toString() {
        return "RestReferenceTarget:" + this.getNode().getElementType().toString();
    }

    public String getReferenceName(boolean quoted) {
        String text = this.getNode().getText();
        if ("__".equals(text)) {
            return text;
        }
        if ((text = text.replaceAll("\\\\([^\\\\]+)", "$1")).startsWith("_`") && !quoted) {
            return text.substring(2, text.length() - 2);
        }
        if (text.startsWith("_")) {
            return text.substring(1, text.length() - 1);
        }
        if (text.startsWith("[#") && !quoted && text.length() > 3) {
            return text.substring(2, text.length() - 1);
        }
        if (text.startsWith("[") && !quoted) {
            return text.substring(1, text.length() - 1);
        }
        return text;
    }

    public String getReferenceName() {
        return this.getReferenceName(true);
    }

    public boolean hasReference() {
        String text = this.getNode().getText();
        PsiFile file = this.getContainingFile();
        if ("__".equals(text)) {
            RestReference[] references = (RestReference[])PsiTreeUtil.getChildrenOfType((PsiElement)file, RestReference.class);
            if (references != null) {
                for (RestReference ref : references) {
                    if (ref.resolve() != this) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    protected void acceptRestVisitor(RestElementVisitor visitor) {
        visitor.visitReferenceTarget(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/rest/psi/RestReferenceTarget", "<init>"));
    }
}

