/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.introspector;

import com.google.common.collect.ImmutableList;
import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseSingleDatabaseIntrospector;
import com.intellij.database.dialects.base.introspector.IntrospectorSqlHelper;
import com.intellij.database.dialects.oracle.introspector.OraIntroQueries;
import com.intellij.database.dialects.oracle.introspector.OraIntrospector;
import com.intellij.database.dialects.oracle.introspector.OraIntrospector$OraDatabaseRetriever$WhenMappings;
import com.intellij.database.dialects.oracle.introspector.OraIntrospector$OraSchemaRetriever$retrieveSources$;
import com.intellij.database.dialects.oracle.introspector.OraIntrospectorFunctions;
import com.intellij.database.dialects.oracle.introspector.OraObjectCodes;
import com.intellij.database.dialects.oracle.introspector.PortionType;
import com.intellij.database.dialects.oracle.model.OraBody;
import com.intellij.database.dialects.oracle.model.OraCatalogObject;
import com.intellij.database.dialects.oracle.model.OraCluster;
import com.intellij.database.dialects.oracle.model.OraCollectionType;
import com.intellij.database.dialects.oracle.model.OraLikeTable;
import com.intellij.database.dialects.oracle.model.OraMatView;
import com.intellij.database.dialects.oracle.model.OraModCheck;
import com.intellij.database.dialects.oracle.model.OraModCluster;
import com.intellij.database.dialects.oracle.model.OraModClusterColumn;
import com.intellij.database.dialects.oracle.model.OraModClusterIndex;
import com.intellij.database.dialects.oracle.model.OraModCollectionType;
import com.intellij.database.dialects.oracle.model.OraModConstraint;
import com.intellij.database.dialects.oracle.model.OraModForeignKey;
import com.intellij.database.dialects.oracle.model.OraModIndex;
import com.intellij.database.dialects.oracle.model.OraModInfraColumn;
import com.intellij.database.dialects.oracle.model.OraModInnerRoutine;
import com.intellij.database.dialects.oracle.model.OraModKey;
import com.intellij.database.dialects.oracle.model.OraModLikeColumn;
import com.intellij.database.dialects.oracle.model.OraModLikeTable;
import com.intellij.database.dialects.oracle.model.OraModMajorObject;
import com.intellij.database.dialects.oracle.model.OraModMatLog;
import com.intellij.database.dialects.oracle.model.OraModMatView;
import com.intellij.database.dialects.oracle.model.OraModModel;
import com.intellij.database.dialects.oracle.model.OraModModule;
import com.intellij.database.dialects.oracle.model.OraModObjectType;
import com.intellij.database.dialects.oracle.model.OraModObjectTypeAttribute;
import com.intellij.database.dialects.oracle.model.OraModObjectTypeBody;
import com.intellij.database.dialects.oracle.model.OraModPackage;
import com.intellij.database.dialects.oracle.model.OraModPackageBody;
import com.intellij.database.dialects.oracle.model.OraModRoot;
import com.intellij.database.dialects.oracle.model.OraModRoutine;
import com.intellij.database.dialects.oracle.model.OraModSchema;
import com.intellij.database.dialects.oracle.model.OraModSchemaObject;
import com.intellij.database.dialects.oracle.model.OraModSequence;
import com.intellij.database.dialects.oracle.model.OraModSingleRoutine;
import com.intellij.database.dialects.oracle.model.OraModSourceAware;
import com.intellij.database.dialects.oracle.model.OraModTable;
import com.intellij.database.dialects.oracle.model.OraModTableColumn;
import com.intellij.database.dialects.oracle.model.OraModTableTrigger;
import com.intellij.database.dialects.oracle.model.OraModTrigger;
import com.intellij.database.dialects.oracle.model.OraModVariable;
import com.intellij.database.dialects.oracle.model.OraModView;
import com.intellij.database.dialects.oracle.model.OraModule;
import com.intellij.database.dialects.oracle.model.OraObjectType;
import com.intellij.database.dialects.oracle.model.OraPackage;
import com.intellij.database.dialects.oracle.model.OraRoot;
import com.intellij.database.dialects.oracle.model.OraSchema;
import com.intellij.database.dialects.oracle.model.OraSchemaObject;
import com.intellij.database.dialects.oracle.model.OraSequence;
import com.intellij.database.dialects.oracle.model.OraSingleRoutine;
import com.intellij.database.dialects.oracle.model.OraTable;
import com.intellij.database.dialects.oracle.model.OraView;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.introspection.IntrospectionMode;
import com.intellij.database.introspection.LongIdName;
import com.intellij.database.introspection.StringListAggregator;
import com.intellij.database.model.ClusterType;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicModDatabase;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSchemaObject;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.families.SingletonFamily;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.OraCollectionTypeKind;
import com.intellij.database.model.properties.OraMatViewRefreshMethod;
import com.intellij.database.model.properties.OraMatViewRefreshMode;
import com.intellij.database.model.properties.OraTableType;
import com.intellij.database.model.properties.SourceError;
import com.intellij.database.model.properties.TableOrganization;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.database.util.StringFun;
import com.intellij.database.util.Version;
import com.intellij.icons.AllIcons;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.StringKt;
import gnu.trove.TLongHashSet;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.DBTransaction;
import org.jetbrains.dekaf.exceptions.DBException;
import org.jetbrains.dekaf.exceptions.NoTableOrViewException;
import org.jetbrains.dekaf.sql.SqlQuery;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0006\u0018\u00002 \u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0001:\u0005<=>?@B\u0015\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u001c\u0010\u0017\u001a\u00060\u0018R\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0003H\u0014J\u001c\u0010\u001c\u001a\u00060\u001dR\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u0005H\u0014J\b\u0010\u001f\u001a\u00020\u0013H\u0014J9\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020%2\u0012\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020(0'\"\u00020(H\u0016\u00a2\u0006\u0002\u0010)J\u0010\u0010*\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u001aH\u0014J\u001e\u0010,\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u001a2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015H\u0014J\u0010\u0010.\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u001aH\u0014J3\u0010/\u001a\u00020\u00132\f\u00100\u001a\b\u0012\u0004\u0012\u00020(0'2\u000e\u00101\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u0006022\u0006\u00103\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u00104J3\u00105\u001a\u00020\u00132\f\u00100\u001a\b\u0012\u0004\u0012\u00020(0'2\u000e\u00101\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u0006022\u0006\u00103\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u00104J\b\u00106\u001a\u00020\u0013H\u0016J\"\u00107\u001a\u000e\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u00020\r082\f\u0010:\u001a\b\u0012\u0004\u0012\u0002090;H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector;", "Lcom/intellij/database/dialects/oracle/model/OraModModel;", "Lcom/intellij/database/dialects/oracle/model/OraRoot;", "Lcom/intellij/database/dialects/oracle/model/OraModRoot;", "Lcom/intellij/database/dialects/oracle/model/OraSchema;", "Lcom/intellij/database/dialects/oracle/model/OraModSchema;", "project", "Lcom/intellij/openapi/project/Project;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/model/ModelFactory;)V", "fast", "", "queries", "Lcom/intellij/database/dialects/oracle/introspector/OraIntroQueries;", "sessionInfo", "Lcom/intellij/database/dialects/oracle/introspector/OraIntroQueries$OneSessionInfo;", "applySchemas", "", "scs", "", "Lcom/intellij/database/introspection/LongIdName;", "createDatabaseRetriever", "Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector$OraDatabaseRetriever;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "database", "createSchemaRetriever", "Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector$OraSchemaRetriever;", "schema", "initConnectionRelatedState", "introspectFragment", "namespace", "Lcom/intellij/database/model/basic/BasicNamespace;", "withSources", "objectKind", "Lcom/intellij/database/model/ObjectKind;", "objectNames", "", "", "(Lcom/intellij/database/model/basic/BasicNamespace;ZLcom/intellij/database/model/ObjectKind;[Ljava/lang/String;)V", "introspectNamespacesInTran", "tran", "introspectSchemasAuto", "schemas", "introspectSessionState", "processNames", "items", "modelSchemas", "Lcom/intellij/database/model/families/ModNamingIdentifyingFamily;", "renew", "([Ljava/lang/String;Lcom/intellij/database/model/families/ModNamingIdentifyingFamily;Z)V", "processTheNames", "retrieveAndApplySchemas", "retrieveInvalid", "", "Lcom/intellij/database/model/basic/BasicElement;", "elements", "", "Factory", "OraDatabaseFirstRetriever", "OraDatabaseIncRetriever", "OraDatabaseRetriever", "OraSchemaRetriever", "intellij.database.dialects"})
public final class OraIntrospector
extends BaseSingleDatabaseIntrospector<OraModModel, OraRoot, OraModRoot, OraSchema, OraModSchema> {
    private final OraIntroQueries queries;
    private OraIntroQueries.OneSessionInfo sessionInfo;
    private boolean fast;

    @Override
    protected void initConnectionRelatedState() {
        super.initConnectionRelatedState();
        if (!this.getServerVersion().isOrGreater(new int[]{10}) && this.getDriverVersion().isOrGreater(new int[]{12})) {
            String message2 = String.format("Unsupported combination of server/driver versions: found Oracle server version %s with JDBC driver version %s that is not compatible. Oracle server version 9.x must be connected by JDBC driver versions 9.x to 11.x.", this.getServerVersion(), this.getDriverVersion());
            throw (Throwable)new IllegalStateException(message2);
        }
        this.fast = (Boolean)this.inTransaction((Function1)new Function1<DBTransaction, Boolean>(this){
            final /* synthetic */ OraIntrospector this$0;

            public final Boolean invoke(@NotNull DBTransaction tran) {
                Boolean bl;
                Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
                try {
                    Object object = tran.query(OraIntrospector.access$getQueries$p((OraIntrospector)this.this$0).checkBaseDictionariesAccess).run();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"tran.query(queries.check\u2026DictionariesAccess).run()");
                    bl = (Boolean)object;
                }
                catch (NoTableOrViewException ntv) {
                    bl = false;
                }
                return bl;
            }
            {
                this.this$0 = oraIntrospector;
                super(1);
            }
        });
        BaseIntrospectionFunctions.setMajorVersionParameters(this.getServerVersion(), 10, this.queryParameters);
        BaseIntrospectionFunctions.setOracleFastSlowModeParameters(this.fast, this.queryParameters);
        this.getLog().info(String.format("Oracle Introspector: initialized for Oracle version %s driver version %s using %s mode", this.getServerVersion(), this.getDriverVersion(), this.fast ? "FAST" : "SLOW"));
    }

    @Override
    protected void introspectNamespacesInTran(@NotNull DBTransaction tran) {
        List schemas2;
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        List list = schemas2 = (List)tran.query(this.queries.retrieveAllSchemas).run();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"schemas");
        this.applySchemas(list);
    }

    @Override
    public void retrieveAndApplySchemas() {
        List schemas2 = (List)this.inTransaction((Function1)new Function1<DBTransaction, List<LongIdName>>(this){
            final /* synthetic */ OraIntrospector this$0;

            public final List<LongIdName> invoke(@NotNull DBTransaction tran) {
                Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
                Object object = tran.query(OraIntrospector.access$getQueries$p((OraIntrospector)this.this$0).retrieveAllSchemas).run();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"tran.query(queries.retrieveAllSchemas).run()");
                return (List)object;
            }
            {
                this.this$0 = oraIntrospector;
                super(1);
            }
        });
        this.applySchemas(schemas2);
    }

    private final void applySchemas(List<LongIdName> scs) {
        ((OraModModel)this.getModel()).modify(OraModRoot.class, new ModelModifier<OraModRoot>(this, scs){
            final /* synthetic */ OraIntrospector this$0;
            final /* synthetic */ List $scs;

            /*
             * WARNING - void declaration
             */
            public final void perform(OraModRoot root2) {
                OraModRoot oraModRoot = root2;
                Intrinsics.checkExpressionValueIsNotNull((Object)oraModRoot, (String)"root");
                NamingIdentifyingFamily namingIdentifyingFamily = oraModRoot.getSchemas();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"root.schemas");
                NamingIdentifyingFamily schemas2 = namingIdentifyingFamily;
                boolean wasEmpty = schemas2.isEmpty();
                schemas2.markChildrenAsSyncPending();
                OraIntroQueries.OneSessionInfo info = OraIntrospector.access$getSessionInfo$p(this.this$0);
                String[] $receiver$iv = (String[])this.$scs;
                int index$iv = 0;
                for (T t : $receiver$iv) {
                    void sc;
                    OraModSchema schema;
                    int n;
                    if ((n = index$iv++) < 0) {
                        throw (Throwable)new ArithmeticException("Index overflow has happened.");
                    }
                    int n2 = n;
                    LongIdName longIdName = (LongIdName)t;
                    int idx = n2;
                    OraModSchema oraModSchema = schema = (OraModSchema)schemas2.renew(sc.id, sc.name);
                    Intrinsics.checkExpressionValueIsNotNull((Object)oraModSchema, (String)"schema");
                    oraModSchema.setCurrent(info != null ? Intrinsics.areEqual((Object)schema.getName(), (Object)info.current_schema) : idx == 0);
                }
                schemas2.removeSyncPendingChildren();
                schemas2.sort();
                if (wasEmpty) {
                    void var8_12;
                    String string;
                    String[] stringArray = new String[3];
                    if (info != null) {
                        string = info.current_schema;
                    } else {
                        LongIdName longIdName = (LongIdName)CollectionsKt.firstOrNull((List)this.$scs);
                        string = longIdName != null ? longIdName.name : null;
                    }
                    stringArray[0] = string;
                    OraIntroQueries.OneSessionInfo oneSessionInfo = info;
                    stringArray[1] = oneSessionInfo != null ? oneSessionInfo.current_user : null;
                    stringArray[2] = "PUBLIC";
                    String[] stringArray2 = $receiver$iv = stringArray;
                    int n = stringArray2.length;
                    boolean bl = false;
                    while (var8_12 < n) {
                        String element$iv = stringArray2[var8_12];
                        String it = element$iv;
                        if (it != null) {
                            OraModSchema oraModSchema = (OraModSchema)schemas2.get(it);
                            if (oraModSchema != null) {
                                oraModSchema.setVisible(true);
                            }
                        }
                        ++var8_12;
                    }
                }
            }
            {
                this.this$0 = oraIntrospector;
                this.$scs = list;
            }
        });
    }

    @Override
    protected void introspectSessionState(@NotNull DBTransaction tran) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        Object object = tran.query(this.queries.retrieveSessionInfo).run();
        if (object == null) {
            Intrinsics.throwNpe();
        }
        this.sessionInfo = (OraIntroQueries.OneSessionInfo)object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void introspectSchemasAuto(@NotNull DBTransaction tran, @NotNull List<? extends OraSchema> schemas2) {
        Object retriever2;
        OraIntrospector this_$iv;
        String message$iv;
        String operationName$iv;
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        Intrinsics.checkParameterIsNotNull(schemas2, (String)"schemas");
        ArrayList schemasToProcess = new ArrayList(schemas2);
        Iterator iterator = schemasToProcess.iterator();
        Intrinsics.checkExpressionValueIsNotNull(iterator, (String)"schemasToProcess.iterator()");
        Iterator it = iterator;
        while (it.hasNext()) {
            OraSchema s;
            OraSchema oraSchema = s = (OraSchema)it.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)oraSchema, (String)"s");
            if (oraSchema.getObjectId() != Long.MIN_VALUE || !(Intrinsics.areEqual((Object)s.getName(), (Object)"SYS") ^ true)) continue;
            this.getLog().warn("Oracle schema " + s.getRealName() + " has no object Id");
            it.remove();
        }
        ArrayList<Object> schemas1 = new ArrayList<Object>(schemasToProcess.size());
        ArrayList schemas22 = new ArrayList(schemasToProcess.size());
        for (Object schema : schemasToProcess) {
            OraSchema oraSchema = schema;
            Intrinsics.checkExpressionValueIsNotNull((Object)oraSchema, (String)"schema");
            (oraSchema.getIntrospectionTimestamp() == null ? schemas1 : schemas22).add(schema);
        }
        if (!schemas1.isEmpty()) {
            Object schema;
            schema = this;
            operationName$iv = "Introspect database stuff completely";
            try {
                OraDatabaseFirstRetriever retriever1 = new OraDatabaseFirstRetriever(tran, (List<? extends OraSchema>)schemas1, false);
                retriever1.process();
            }
            catch (InterruptedException ie$iv) {
                throw (Throwable)ie$iv;
            }
            catch (DBException d$iv) {
                message$iv = "Error encountered when performing " + operationName$iv + ": " + d$iv.getMessage();
                this_$iv.getErrorSink().consume((Object)message$iv, (Object)d$iv);
            }
            catch (NullPointerException npe$iv) {
                message$iv = "NPE encountered when performing " + operationName$iv;
                this_$iv.getErrorSink().consume((Object)message$iv, (Object)npe$iv);
                BaseIntrospector.access$getLog$p(this_$iv).error(message$iv, (Throwable)npe$iv);
            }
            catch (Exception e$iv) {
                message$iv = "Unexpected error (" + e$iv.getClass().getSimpleName() + ") encountered when performing " + operationName$iv + ": " + e$iv.getMessage();
                this_$iv.getErrorSink().consume((Object)message$iv, (Object)e$iv);
            }
        }
        if (!schemas22.isEmpty()) {
            this_$iv = this;
            operationName$iv = "Introspect database stuff incrementally";
            try {
                retriever2 = new OraDatabaseIncRetriever(tran, schemas22, false);
                ((OraDatabaseIncRetriever)retriever2).process();
            }
            catch (InterruptedException ie$iv) {
                throw (Throwable)ie$iv;
            }
            catch (DBException d$iv) {
                message$iv = "Error encountered when performing " + operationName$iv + ": " + d$iv.getMessage();
                this_$iv.getErrorSink().consume((Object)message$iv, (Object)d$iv);
            }
            catch (NullPointerException npe$iv) {
                message$iv = "NPE encountered when performing " + operationName$iv;
                this_$iv.getErrorSink().consume((Object)message$iv, (Object)npe$iv);
                BaseIntrospector.access$getLog$p(this_$iv).error(message$iv, (Throwable)npe$iv);
            }
            catch (Exception e$iv) {
                message$iv = "Unexpected error (" + e$iv.getClass().getSimpleName() + ") encountered when performing " + operationName$iv + ": " + e$iv.getMessage();
                this_$iv.getErrorSink().consume((Object)message$iv, (Object)e$iv);
            }
        }
        for (Object schema : schemasToProcess) {
            void this_$iv2;
            String message$iv2;
            retriever2 = this;
            StringBuilder stringBuilder = new StringBuilder().append("Introspect the schema ");
            Object object = schema;
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"schema");
            String operationName$iv2 = stringBuilder.append(object.getName()).append(" stuff completely").toString();
            try {
                OraSchemaRetriever oraSchemaRetriever;
                OraSchemaRetriever $receiver = oraSchemaRetriever = new OraSchemaRetriever(tran, (OraSchema)schema);
                Date lastIntrospectionTimestamp = schema.getIntrospectionTimestamp();
                $receiver.setMyFromTimestamp$intellij_database_dialects($receiver.getMode$intellij_database_dialects().increment && lastIntrospectionTimestamp != null ? new Timestamp(lastIntrospectionTimestamp.getTime()) : BaseIntrospectionFunctions.AGES_AGO);
                Long srcExistentVersion = ((OraModModel)this.getModel()).getSchemaSourcesVersion((BasicSchema)schema);
                $receiver.setSrcFromTimestamp$intellij_database_dialects(srcExistentVersion != null && srcExistentVersion > 0L ? new Timestamp(srcExistentVersion) : BaseIntrospectionFunctions.AGES_AGO);
                OraSchemaRetriever retriever = oraSchemaRetriever;
                retriever.retrieveMain$intellij_database_dialects();
            }
            catch (InterruptedException ie$iv) {
                throw (Throwable)ie$iv;
            }
            catch (DBException d$iv) {
                message$iv2 = "Error encountered when performing " + operationName$iv2 + ": " + d$iv.getMessage();
                this_$iv2.getErrorSink().consume((Object)message$iv2, (Object)d$iv);
            }
            catch (NullPointerException npe$iv) {
                message$iv2 = "NPE encountered when performing " + operationName$iv2;
                this_$iv2.getErrorSink().consume((Object)message$iv2, (Object)npe$iv);
                BaseIntrospector.access$getLog$p((BaseIntrospector)this_$iv2).error(message$iv2, (Throwable)npe$iv);
            }
            catch (Exception e$iv) {
                message$iv2 = "Unexpected error (" + e$iv.getClass().getSimpleName() + ") encountered when performing " + operationName$iv2 + ": " + e$iv.getMessage();
                this_$iv2.getErrorSink().consume((Object)message$iv2, (Object)e$iv);
            }
        }
    }

    @Override
    @NotNull
    public Map<BasicElement, Boolean> retrieveInvalid(@NotNull Iterable<? extends BasicElement> elements) {
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        LinkedHashMap linkedHashMap = ContainerUtil.newLinkedHashMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)linkedHashMap, (String)"ContainerUtil.newLinkedH\u2026Long, OraCatalogObject>()");
        LinkedHashMap ids = linkedHashMap;
        Iterable<? extends BasicElement> $receiver$iv = elements;
        for (BasicElement basicElement : $receiver$iv) {
            BasicElement it = basicElement;
            if (!OraIntrospectorFunctions.access$canCheckOutdated(it)) continue;
            BasicElement basicElement2 = it;
            if (basicElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.dialects.oracle.model.OraCatalogObject");
            }
            OraCatalogObject cfr_ignored_0 = (OraCatalogObject)basicElement2;
            Map map = ids;
            Long l = ((OraCatalogObject)it).getObjectId();
            BasicElement basicElement3 = it;
            map.put(l, basicElement3);
        }
        if (ids.isEmpty()) {
            return MapsKt.emptyMap();
        }
        Set set = ids.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"ids.keys");
        this.setQueryParameter("OBJECT_IDS", CollectionsKt.toLongArray((Collection)set));
        SqlQuery<List<OraIntroQueries.OneState>> sqlQuery = this.fast ? this.queries.retrieveStatesFast : this.queries.retrieveStatesSlow;
        Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"if (fast) queries.retrie\u2026ueries.retrieveStatesSlow");
        List<OraIntroQueries.OneState> states2 = this.performQuery(sqlQuery);
        LinkedHashMap linkedHashMap2 = ContainerUtil.newLinkedHashMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)linkedHashMap2, (String)"ContainerUtil.newLinkedH\u2026<BasicElement, Boolean>()");
        LinkedHashMap res2 = linkedHashMap2;
        ids.forEach((BiConsumer)new BiConsumer<Long, OraCatalogObject>(res2){
            final /* synthetic */ LinkedHashMap $res;

            public final void accept(Long $noName_0, OraCatalogObject v) {
                Map map = this.$res;
                Boolean bl = false;
                map.put(v, bl);
            }
            {
                this.$res = linkedHashMap;
            }
        });
        List<OraIntroQueries.OneState> list = states2;
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"states");
        Iterable iterable = list;
        for (Object element$iv : iterable) {
            OraCatalogObject obj;
            OraIntroQueries.OneState s = (OraIntroQueries.OneState)element$iv;
            if ((OraCatalogObject)ids.get(s.object_id) == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)obj, (String)"ids[s.object_id] ?: return@forEach");
            Map map = res2;
            Boolean bl = Intrinsics.areEqual((Object)obj.getModifiedTimestamp(), (Object)s.modified_timestamp);
            map.put(obj, bl);
        }
        ((OraModModel)this.getModel()).modify((ModelModifier<? super OraModRoot>)new ModelModifier<OraModRoot>(res2){
            final /* synthetic */ LinkedHashMap $res;

            public final void perform(OraModRoot it) {
                Set<Map.Entry<K, V>> set = this.$res.entrySet();
                Intrinsics.checkExpressionValueIsNotNull(set, (String)"res.entries");
                Iterable $receiver$iv = set;
                for (T element$iv : $receiver$iv) {
                    Map.Entry $obj_ok;
                    Map.Entry entry = $obj_ok = (Map.Entry)element$iv;
                    BasicElement obj = (BasicElement)entry.getKey();
                    entry = $obj_ok;
                    Boolean ok = (Boolean)entry.getValue();
                    BasicElement basicElement = obj;
                    if (basicElement == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.basic.BasicModElement");
                    }
                    ((BasicModElement)basicElement).setOutdated(ok == false);
                }
            }
            {
                this.$res = linkedHashMap;
            }
        });
        return res2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void introspectFragment(@NotNull BasicNamespace namespace, boolean withSources, @NotNull ObjectKind objectKind, String ... objectNames) {
        void this_$iv;
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        Intrinsics.checkParameterIsNotNull((Object)objectKind, (String)"objectKind");
        Intrinsics.checkParameterIsNotNull((Object)objectNames, (String)"objectNames");
        boolean bl2 = bl = namespace.getModel() == (OraModModel)this.getModel();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        bl = namespace instanceof OraSchema;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        OraSchema schema = (OraSchema)namespace;
        OraIntrospector oraIntrospector = this;
        String operationName$iv = "Introspect fragments " + ArraysKt.joinToString$default((Object[])objectNames, null, null, null, (int)0, null, null, (int)63, null);
        try {
            this.inTransactionUnit((Function1<DBTransaction, Unit>)((Function1)new Function1<DBTransaction, Unit>(this, schema, objectKind, objectNames, withSources){
                final /* synthetic */ OraIntrospector this$0;
                final /* synthetic */ OraSchema $schema$inlined;
                final /* synthetic */ ObjectKind $objectKind$inlined;
                final /* synthetic */ String[] $objectNames$inlined;
                final /* synthetic */ boolean $withSources$inlined;
                {
                    this.this$0 = oraIntrospector;
                    this.$schema$inlined = oraSchema;
                    this.$objectKind$inlined = objectKind;
                    this.$objectNames$inlined = stringArray;
                    this.$withSources$inlined = bl;
                    super(1);
                }

                public final void invoke(@NotNull DBTransaction tran) {
                    Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
                    OraSchemaRetriever retriever = this.this$0.new OraSchemaRetriever(tran, this.$schema$inlined);
                    retriever.setMode$intellij_database_dialects(IntrospectionMode.FRAGMENT);
                    retriever.setFragmentKind$intellij_database_dialects(this.$objectKind$inlined);
                    retriever.setFragmentNames$intellij_database_dialects(this.$objectNames$inlined);
                    retriever.setWithSources$intellij_database_dialects(this.$withSources$inlined);
                    retriever.setMyFromTimestamp$intellij_database_dialects(BaseIntrospectionFunctions.AGES_AGO);
                    retriever.setSrcFromTimestamp$intellij_database_dialects(BaseIntrospectionFunctions.AGES_AGO);
                    retriever.retrieveMain$intellij_database_dialects();
                }
            }));
        }
        catch (InterruptedException ie$iv) {
            throw (Throwable)ie$iv;
        }
        catch (DBException d$iv) {
            String message$iv = "Error encountered when performing " + operationName$iv + ": " + d$iv.getMessage();
            this_$iv.getErrorSink().consume((Object)message$iv, (Object)d$iv);
        }
        catch (NullPointerException npe$iv) {
            String message$iv = "NPE encountered when performing " + operationName$iv;
            this_$iv.getErrorSink().consume((Object)message$iv, (Object)npe$iv);
            BaseIntrospector.access$getLog$p((BaseIntrospector)this_$iv).error(message$iv, (Throwable)npe$iv);
        }
        catch (Exception e$iv) {
            String message$iv = "Unexpected error (" + e$iv.getClass().getSimpleName() + ") encountered when performing " + operationName$iv + ": " + e$iv.getMessage();
            this_$iv.getErrorSink().consume((Object)message$iv, (Object)e$iv);
        }
    }

    private final void processNames(String[] items, ModNamingIdentifyingFamily<? extends OraModSchema> modelSchemas, boolean renew) {
        long time1 = System.currentTimeMillis();
        this.processTheNames(items, modelSchemas, renew);
        long time2 = System.currentTimeMillis();
        double delta = (double)(time2 - time1) / 1000.0;
        this.getLog().debug("Major names processing took " + delta + " s.");
    }

    /*
     * WARNING - void declaration
     */
    private final void processTheNames(String[] items, ModNamingIdentifyingFamily<? extends OraModSchema> modelSchemas, boolean renew) {
        HashSet<ModNamingIdentifyingFamily> affectedFamilies = new HashSet<ModNamingIdentifyingFamily>();
        int n = 0;
        int n2 = items.length;
        while (n < n2) {
            void i2;
            String item = items[i2];
            try {
                String objectName;
                String kindCode;
                OraModSchema schema;
                String objectIdStr;
                String schemaIdStr;
                String string;
                boolean bl;
                boolean bl2 = bl = item.length() >= 23;
                if (_Assertions.ENABLED && !bl) {
                    string = "The item should be at least 23 characters length";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                String $i$a$1$assert = item;
                int n3 = 0;
                int n4 = 2;
                String string2 = $i$a$1$assert;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(n3, n4), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                string = item;
                n4 = 2;
                int n5 = 12;
                String string3 = string;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string3.substring(n4, n5), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String string4 = item;
                n5 = 12;
                int n6 = 22;
                String string5 = string4;
                if (string5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string5.substring(n5, n6), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String string6 = item;
                n6 = 22;
                String string7 = string6;
                if (string7 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string7.substring(n6), (String)"(this as java.lang.String).substring(startIndex)");
                int schemaId = Integer.parseInt(schemaIdStr);
                int objectId = Integer.parseInt(objectIdStr);
                if ((OraModSchema)modelSchemas.getByObjectId((long)schemaId) == null) {
                    String string8 = "Schema should exist, id:" + schemaId;
                    throw (Throwable)new IllegalStateException(string8.toString());
                }
                ModNamingIdentifyingFamily family = OraIntrospectorFunctions.access$majorFamilyOf(schema, kindCode);
                if (renew) {
                    family.renew(objectId, objectName);
                } else {
                    OraModSchemaObject majorObject;
                    OraModSchemaObject oraModSchemaObject = majorObject = (OraModSchemaObject)family.createOrGet(objectName);
                    Intrinsics.checkExpressionValueIsNotNull((Object)oraModSchemaObject, (String)"majorObject");
                    oraModSchemaObject.setObjectId(objectId);
                }
                affectedFamilies.add(family);
            }
            catch (NumberFormatException e) {
                this.getLog().warn(String.format("Failed to handle item '%s': %s: %s", item, e.getClass().getSimpleName(), e.getMessage()));
            }
            ++i2;
        }
        for (ModNamingIdentifyingFamily family : affectedFamilies) {
            family.sort();
        }
    }

    @NotNull
    protected OraDatabaseRetriever createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull OraRoot database) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        return new OraDatabaseFirstRetriever(transaction, CollectionsKt.emptyList(), false);
    }

    @NotNull
    protected OraSchemaRetriever createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull OraSchema schema) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        return new OraSchemaRetriever(transaction, schema);
    }

    public OraIntrospector(@NotNull Project project, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)modelFactory, (String)"modelFactory");
        Dbms dbms = Dbms.ORACLE;
        Intrinsics.checkExpressionValueIsNotNull((Object)dbms, (String)"Dbms.ORACLE");
        super(dbms, project, modelFactory, OraModModel.class, OraModRoot.class, OraModSchema.class);
        OraIntroQueries oraIntroQueries = OraIntroQueries.QUERIES;
        Intrinsics.checkExpressionValueIsNotNull((Object)oraIntroQueries, (String)"QUERIES");
        this.queries = oraIntroQueries;
    }

    public static final /* synthetic */ void access$setFast$p(OraIntrospector $this, boolean bl) {
        $this.fast = bl;
    }

    @NotNull
    public static final /* synthetic */ Version access$getServerVersion$p(OraIntrospector $this) {
        return $this.getServerVersion();
    }

    public static final /* synthetic */ void access$setServerVersion$p(OraIntrospector $this, @NotNull Version version) {
        $this.setServerVersion(version);
    }

    public static final /* synthetic */ void access$writeSources(OraIntrospector $this, @NotNull Function0 r) {
        $this.writeSources((Function0<Unit>)r);
    }

    @Nullable
    public static final /* synthetic */ OraIntroQueries.OneSessionInfo access$getSessionInfo$p(OraIntrospector $this) {
        return $this.sessionInfo;
    }

    public static final /* synthetic */ void access$setSessionInfo$p(OraIntrospector $this, @Nullable OraIntroQueries.OneSessionInfo oneSessionInfo) {
        $this.sessionInfo = oneSessionInfo;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "()V", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "dbms", "Lcom/intellij/database/Dbms;", "project", "Lcom/intellij/openapi/project/Project;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isOutdatedCheckSupported", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "isSupported", "version", "Lcom/intellij/database/util/Version;", "VERSION", "intellij.database.dialects"})
    public static final class Factory
    implements DBIntrospector.Factory {
        @Override
        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
            return version.isOrGreater(new int[]{9});
        }

        @Override
        @NotNull
        public DBIntrospector createIntrospector(@NotNull Dbms dbms, @NotNull Project project, @NotNull ModelFactory modelFactory) {
            Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)modelFactory, (String)"modelFactory");
            return new OraIntrospector(project, modelFactory);
        }

        @Override
        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        @Override
        public boolean isOutdatedCheckSupported(@NotNull BasicElement e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            return OraIntrospectorFunctions.access$canCheckOutdated(e);
        }

        @Override
        public boolean isNative() {
            return DBIntrospector.Factory.DefaultImpls.isNative(this);
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "intellij.database.dialects"})
        public static final class VERSION
        extends PerObjectVersion {
            public static final VERSION INSTANCE;

            private VERSION() {
            }

            static {
                VERSION vERSION;
                INSTANCE = vERSION = new VERSION();
                Map map = vERSION.getMyVersions();
                ObjectKind objectKind = ObjectKind.PACKAGE;
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"PACKAGE");
                ObjectKind objectKind2 = objectKind;
                ObjectKind objectKind3 = ObjectKind.PACKAGE;
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind3, (String)"PACKAGE");
                Integer n = vERSION.get(objectKind3) + 1;
                map.put(objectKind2, n);
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0003\b\u00a4\u0004\u0018\u00002$0\u0001R \u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0002B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\rH\u0002J8\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00190\u0017H\u0002J0\u0010\u001a\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00180\u001b2\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00190\u0017H\u0014J0\u0010\u001c\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00190\u0017H\u0002J8\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00190\u0017H\u0002\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector$OraDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector$BaseDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector;", "Lcom/intellij/database/dialects/oracle/model/OraModModel;", "Lcom/intellij/database/dialects/oracle/model/OraRoot;", "Lcom/intellij/database/dialects/oracle/model/OraModRoot;", "Lcom/intellij/database/dialects/oracle/model/OraSchema;", "Lcom/intellij/database/dialects/oracle/model/OraModSchema;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "(Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;)V", "adjustNativeStatements", "", "", "text", "chopListAndRetrieveNativeDefinitions", "", "portionType", "Lcom/intellij/database/dialects/oracle/introspector/PortionType;", "elements", "", "Lcom/intellij/database/dialects/oracle/model/OraSchemaObject;", "result", "", "Lcom/intellij/database/model/basic/BasicElement;", "", "retrieveNativeDefinitions", "", "retrieveNativeDefinitionsPortion", "retrieveNativeDefinitionsPortionSafe", "intellij.database.dialects"})
    protected abstract class OraDatabaseRetriever
    extends BaseSingleDatabaseIntrospector.BaseDatabaseRetriever {
        /*
         * WARNING - void declaration
         */
        @Override
        protected void retrieveNativeDefinitions(@NotNull Iterable<? extends BasicElement> elements, @NotNull Map<BasicElement, String[]> result2) {
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            Intrinsics.checkParameterIsNotNull(result2, (String)"result");
            List filteredElements = CollectionsKt.filterIsInstance(elements, OraSchemaObject.class);
            int n = filteredElements.size();
            if (n == 0) {
                return;
            }
            PortionType portionType = OraIntrospectorFunctions.access$applicablePortionTypeFor(n);
            if (portionType == PortionType.ALL) {
                int stepSize = PortionType.NORMAL.getSize();
                IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)n)), (int)stepSize);
                int n2 = intProgression.getFirst();
                int n3 = intProgression.getLast();
                int n4 = intProgression.getStep();
                int n5 = n2;
                int n6 = n3;
                if (n4 > 0 ? n5 <= n6 : n5 >= n6) {
                    while (true) {
                        void offset;
                        List portion = filteredElements.subList((int)offset, Math.min((int)(offset + stepSize), n));
                        PortionType pt = OraIntrospectorFunctions.access$applicablePortionTypeFor(portion.size());
                        this.retrieveNativeDefinitionsPortionSafe(pt, portion, result2);
                        if (offset != n3) {
                            offset += n4;
                            continue;
                        }
                        break;
                    }
                }
            } else {
                this.retrieveNativeDefinitionsPortionSafe(portionType, filteredElements, result2);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void chopListAndRetrieveNativeDefinitions(PortionType portionType, List<? extends OraSchemaObject> elements, Map<BasicElement, String[]> result2) {
            PortionType portionType2;
            switch (OraIntrospector$OraDatabaseRetriever$WhenMappings.$EnumSwitchMapping$0[portionType.ordinal()]) {
                case 1: {
                    portionType2 = PortionType.NORMAL;
                    break;
                }
                case 2: {
                    portionType2 = PortionType.SMALL;
                    break;
                }
                case 3: {
                    portionType2 = PortionType.ONE;
                    break;
                }
                case 4: {
                    throw (Throwable)new IllegalArgumentException("A portion of one element cannot be split into several portions");
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            PortionType nextPortion = portionType2;
            int stepSize = nextPortion.getSize();
            int n = elements.size();
            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)n)), (int)stepSize);
            int n2 = intProgression.getFirst();
            int n3 = intProgression.getLast();
            int n4 = intProgression.getStep();
            int n5 = n2;
            int n6 = n3;
            if (n4 > 0 ? n5 <= n6 : n5 >= n6) {
                while (true) {
                    void offset;
                    List<? extends OraSchemaObject> portion = elements.subList((int)offset, Math.min((int)(offset + stepSize), n));
                    PortionType pt = OraIntrospectorFunctions.access$applicablePortionTypeFor(portion.size());
                    this.retrieveNativeDefinitionsPortionSafe(pt, portion, result2);
                    if (offset == n3) break;
                    offset += n4;
                }
            }
        }

        private final void retrieveNativeDefinitionsPortionSafe(PortionType portionType, List<? extends OraSchemaObject> elements, Map<BasicElement, String[]> result2) {
            try {
                this.retrieveNativeDefinitionsPortion(elements, result2);
            }
            catch (DBException e) {
                if (portionType.compareTo((Enum)PortionType.ONE) > 0) {
                    this.chopListAndRetrieveNativeDefinitions(portionType, elements, result2);
                }
                OraSchemaObject element2 = (OraSchemaObject)CollectionsKt.first(elements);
                String comment = "-- failed to obtain definition for " + element2 + ":\n--\t" + e.getMessage();
                result2.put(element2, new String[]{comment});
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveNativeDefinitionsPortion(List<? extends OraSchemaObject> elements, Map<BasicElement, String[]> result2) {
            String[] stringArray;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)elements;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                stringArray = (String[])item$iv$iv;
                Collection collection2 = collection;
                Long l = it.getObjectId();
                collection2.add(l);
            }
            long[] identifiers = CollectionsKt.toLongArray((Collection)((List)collection));
            this.setQueryParameter$intellij_database_dialects("identifiers", identifiers);
            SqlQuery<List<OraIntroQueries.OneNativeDefinition>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveNativeDefinitions;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveNativeDefinitions");
            List<OraIntroQueries.OneNativeDefinition> entries = this.performQuery(sqlQuery);
            MultiMap map = new MultiMap();
            for (OraIntroQueries.OneNativeDefinition oneNativeDefinition : entries) {
                Long l = oneNativeDefinition.object_id;
                String string = oneNativeDefinition.text;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entry.text");
                map.putValues((Object)l, this.adjustNativeStatements(string));
            }
            for (OraSchemaObject oraSchemaObject : elements) {
                Collection thisCollection$iv;
                Collection $receiver$iv2;
                Map<BasicElement, String[]> map2 = result2;
                Intrinsics.checkExpressionValueIsNotNull((Object)map.get((Object)oraSchemaObject.getObjectId()), (String)"map[element.objectId]");
                if ($receiver$iv2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                if (thisCollection$iv.toArray(new String[0]) == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                map2.put(oraSchemaObject, stringArray);
            }
        }

        private final Collection<String> adjustNativeStatements(String text2) {
            CharSequence charSequence = text2;
            String string = charSequence;
            if (string == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String txt = ((Object)StringsKt.trim((CharSequence)string)).toString();
            charSequence = txt;
            if (charSequence.length() == 0) {
                return SetsKt.emptySet();
            }
            charSequence = txt;
            Regex regex = OraIntrospectorFunctions.access$getNATIVE_TRIGGER_DEFINITION_PATTERN$p();
            if (regex.matches(charSequence)) {
                int p2 = StringsKt.indexOf$default((CharSequence)txt, (String)"ALTER TRIGGER \"", (int)0, (boolean)false, (int)6, null);
                if (p2 > 0) {
                    String string2;
                    String string3 = txt;
                    int n = 0;
                    String string4 = string3;
                    if (string4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string5 = string4.substring(n, p2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    String string6 = string3 = string5;
                    if (string6 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    String stmt1 = ((Object)StringsKt.trim((CharSequence)string6)).toString();
                    String string7 = string2 = txt;
                    if (string7 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string8 = string7.substring(p2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.String).substring(startIndex)");
                    String string9 = string2 = string8;
                    if (string9 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    String stmt2 = ((Object)StringsKt.trim((CharSequence)string9)).toString();
                    return CollectionsKt.listOf((Object[])new String[]{stmt1, stmt2});
                }
                Set<String> set = Collections.singleton(txt);
                Intrinsics.checkExpressionValueIsNotNull(set, (String)"singleton(txt)");
                return set;
            }
            Set<String> set = Collections.singleton(txt);
            Intrinsics.checkExpressionValueIsNotNull(set, (String)"singleton(txt)");
            return set;
        }

        public OraDatabaseRetriever(DBTransaction transaction) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            super(OraIntrospector.this, transaction);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B%\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\fH\u0002J\b\u0010\u000f\u001a\u00020\fH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector$OraDatabaseFirstRetriever;", "Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector$OraDatabaseRetriever;", "Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "schemas", "", "Lcom/intellij/database/dialects/oracle/model/OraSchema;", "glutton", "", "(Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Ljava/util/List;Z)V", "prepareParameters", "", "process", "retrieveAllOrdinaryNames", "retrieveAllSynonyms", "intellij.database.dialects"})
    private final class OraDatabaseFirstRetriever
    extends OraDatabaseRetriever {
        private final List<OraSchema> schemas;
        private final boolean glutton;

        protected void prepareParameters() {
            this.setQueryParameter$intellij_database_dialects(this.glutton ? "GLUTTON" : "ASCETIC", Boolean.TRUE);
            this.setQueryParameter$intellij_database_dialects("ALL_SCHEMA_IDS", this.schemas.stream().map(prepareParameters.1.INSTANCE).toArray());
            this.setQueryParameter$intellij_database_dialects("ALL_SCHEMA_NAMES", this.schemas.stream().map(prepareParameters.2.INSTANCE).toArray());
        }

        @Override
        public void process() {
            this.prepareParameters();
            this.retrieveAllOrdinaryNames();
            this.retrieveAllSynonyms();
        }

        private final void retrieveAllOrdinaryNames() {
            SqlQuery<String[]> query;
            this.reportRetrieving("Major Object Names");
            SqlQuery<String[]> sqlQuery = query = OraIntrospector.this.fast ? ((OraIntrospector)OraIntrospector.this).queries.retrieveAllMajorNamesFast : ((OraIntrospector)OraIntrospector.this).queries.retrieveAllMajorNamesSlow;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"query");
            String[] items = this.performQuery(sqlQuery);
            this.inModel((Function1)new Function1<OraModRoot, Unit>(this, items){
                final /* synthetic */ OraDatabaseFirstRetriever this$0;
                final /* synthetic */ String[] $items;

                public final void invoke(@NotNull OraModRoot root2) {
                    Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                    for (OraSchema schema : OraDatabaseFirstRetriever.access$getSchemas$p(this.this$0)) {
                        BasicModSchema basicModSchema = root2.mod(schema);
                        if (basicModSchema == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.dialects.oracle.model.OraModSchema");
                        }
                        OraModSchema ms = (OraModSchema)basicModSchema;
                        ms.getSequences().clear();
                        ms.getObjectTypes().clear();
                        ms.getCollectionTypes().clear();
                        ms.getTables().clear();
                        ms.getMatViews().clear();
                        ms.getViews().clear();
                        ms.getPackages().clear();
                        ms.getRoutines().clear();
                    }
                    OraIntrospector oraIntrospector = this.this$0.OraIntrospector.this;
                    NamingIdentifyingFamily namingIdentifyingFamily = root2.getSchemas();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"root.schemas");
                    OraIntrospector.access$processNames(oraIntrospector, this.$items, (ModNamingIdentifyingFamily)namingIdentifyingFamily, false);
                }
                {
                    this.this$0 = oraDatabaseFirstRetriever;
                    this.$items = stringArray;
                    super(1);
                }
            });
        }

        private final void retrieveAllSynonyms() {
            this.reportRetrieving("Synonyms");
            SqlQuery<List<OraIntroQueries.OneSynonym>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveAllSynonyms;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveAllSynonyms");
            List<OraIntroQueries.OneSynonym> ss = this.performQuery(sqlQuery);
            this.inModel((Function1)new Function1<OraModRoot, Unit>(ss){
                final /* synthetic */ List $ss;

                public final void invoke(@NotNull OraModRoot root2) {
                    Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                    OraIntrospectorFunctions.access$processSynonyms(this.$ss, root2);
                }
                {
                    this.$ss = list;
                    super(1);
                }
            });
        }

        public OraDatabaseFirstRetriever(@NotNull DBTransaction transaction, List<? extends OraSchema> schemas2, boolean glutton) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull(schemas2, (String)"schemas");
            super(transaction);
            this.schemas = schemas2;
            this.glutton = glutton;
        }

        @NotNull
        public static final /* synthetic */ List access$getSchemas$p(OraDatabaseFirstRetriever $this) {
            return $this.schemas;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B%\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector$OraDatabaseIncRetriever;", "Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector$OraDatabaseRetriever;", "Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "schemas", "", "Lcom/intellij/database/dialects/oracle/model/OraSchema;", "glutton", "", "(Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Ljava/util/List;Z)V", "since", "Ljava/util/Date;", "determineAndRemoveAllDroppedStuff", "", "prepareParameters", "process", "retrieveAllOrdinaryNames", "root", "Lcom/intellij/database/dialects/oracle/model/OraModRoot;", "retrieveAllSynonyms", "intellij.database.dialects"})
    private final class OraDatabaseIncRetriever
    extends OraDatabaseRetriever {
        private Date since;
        private final List<OraSchema> schemas;
        private final boolean glutton;

        /*
         * WARNING - void declaration
         */
        @Override
        public void process() {
            Iterable $receiver$iv$iv;
            this.prepareParameters();
            this.determineAndRemoveAllDroppedStuff();
            Iterable $receiver$iv = this.schemas;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                Date date;
                Object element$iv$iv = element$iv$iv$iv;
                OraSchema it = (OraSchema)element$iv$iv;
                if (it.getIntrospectionTimestamp() == null) continue;
                Date it$iv$iv = date;
                destination$iv$iv.add(it$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                Object element$iv$iv$iv;
                element$iv$iv$iv = (Date)item$iv$iv;
                Collection collection = destination$iv$iv;
                void v0 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"it");
                Long l = v0.getTime();
                collection.add(l);
            }
            Long l = (Long)CollectionsKt.min((Iterable)((List)destination$iv$iv));
            long sinceTime = l != null ? l : System.currentTimeMillis();
            this.since = new Timestamp(sinceTime);
            this.setQueryParameter$intellij_database_dialects("INC", Boolean.TRUE);
            this.setQueryParameter$intellij_database_dialects("SINCE", this.since);
            this.inModel((Function1)new Function1<OraModRoot, Unit>(this){
                final /* synthetic */ OraDatabaseIncRetriever this$0;

                public final void invoke(@NotNull OraModRoot root2) {
                    Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                    OraDatabaseIncRetriever.access$retrieveAllOrdinaryNames(this.this$0, root2);
                }
                {
                    this.this$0 = oraDatabaseIncRetriever;
                    super(1);
                }
            });
            this.inModel((Function1)new Function1<OraModRoot, Unit>(this){
                final /* synthetic */ OraDatabaseIncRetriever this$0;

                public final void invoke(@NotNull OraModRoot root2) {
                    Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                    OraDatabaseIncRetriever.access$retrieveAllSynonyms(this.this$0, root2);
                }
                {
                    this.this$0 = oraDatabaseIncRetriever;
                    super(1);
                }
            });
        }

        private final void prepareParameters() {
            this.setQueryParameter$intellij_database_dialects(this.glutton ? "GLUTTON" : "ASCETIC", Boolean.TRUE);
            this.setQueryParameter$intellij_database_dialects("ALL_SCHEMA_IDS", this.schemas.stream().map(prepareParameters.1.INSTANCE).toArray());
            this.setQueryParameter$intellij_database_dialects("ALL_SCHEMA_NAMES", this.schemas.stream().map(prepareParameters.2.INSTANCE).toArray());
        }

        private final void determineAndRemoveAllDroppedStuff() {
            SqlQuery<long[]> query;
            this.reportRetrieving("detect dropped objects");
            SqlQuery<long[]> sqlQuery = query = OraIntrospector.this.fast ? ((OraIntrospector)OraIntrospector.this).queries.retrieveAllObjectIdentifiersFast : ((OraIntrospector)OraIntrospector.this).queries.retrieveAllObjectIdentifiersSlow;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"query");
            long[] idsArray = this.performQuery(sqlQuery);
            TLongHashSet identifiers = new TLongHashSet(idsArray);
            this.inModel((Function1)new Function1<OraModRoot, Unit>(this, identifiers){
                final /* synthetic */ OraDatabaseIncRetriever this$0;
                final /* synthetic */ TLongHashSet $identifiers;

                public final void invoke(@NotNull OraModRoot root2) {
                    Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                    for (OraSchema schema : OraDatabaseIncRetriever.access$getSchemas$p(this.this$0)) {
                        BasicModSchema basicModSchema = root2.mod(schema);
                        if (basicModSchema == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.dialects.oracle.model.OraModSchema");
                        }
                        OraModSchema s = (OraModSchema)basicModSchema;
                        OraIntrospectorFunctions.access$dropUnexistentObjectsInSchema(s, this.$identifiers);
                    }
                }
                {
                    this.this$0 = oraDatabaseIncRetriever;
                    this.$identifiers = tLongHashSet;
                    super(1);
                }
            });
        }

        private final void retrieveAllOrdinaryNames(OraModRoot root2) {
            SqlQuery<String[]> query;
            this.reportRetrieving("Major Object Names");
            NamingIdentifyingFamily namingIdentifyingFamily = root2.getSchemas();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"root.schemas");
            NamingIdentifyingFamily modelSchemas = namingIdentifyingFamily;
            SqlQuery<String[]> sqlQuery = query = OraIntrospector.this.fast ? ((OraIntrospector)OraIntrospector.this).queries.retrieveAllMajorNamesFast : ((OraIntrospector)OraIntrospector.this).queries.retrieveAllMajorNamesSlow;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"query");
            String[] items = this.performQuery(sqlQuery);
            OraIntrospector.this.processNames(items, (ModNamingIdentifyingFamily)modelSchemas, true);
        }

        private final void retrieveAllSynonyms(OraModRoot root2) {
            this.reportRetrieving("Synonyms");
            SqlQuery<List<OraIntroQueries.OneSynonym>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveAllSynonyms;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveAllSynonyms");
            List<OraIntroQueries.OneSynonym> ss = this.performQuery(sqlQuery);
            OraIntrospectorFunctions.access$processSynonyms(ss, root2);
        }

        public OraDatabaseIncRetriever(@NotNull DBTransaction transaction, List<? extends OraSchema> schemas2, boolean glutton) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull(schemas2, (String)"schemas");
            super(transaction);
            this.since = BaseIntrospectionFunctions.AGES_AGO;
            this.schemas = schemas2;
            this.glutton = glutton;
        }

        public static final /* synthetic */ void access$retrieveAllOrdinaryNames(OraDatabaseIncRetriever $this, @NotNull OraModRoot root2) {
            $this.retrieveAllOrdinaryNames(root2);
        }

        public static final /* synthetic */ void access$retrieveAllSynonyms(OraDatabaseIncRetriever $this, @NotNull OraModRoot root2) {
            $this.retrieveAllSynonyms(root2);
        }

        @NotNull
        public static final /* synthetic */ List access$getSchemas$p(OraDatabaseIncRetriever $this) {
            return $this.schemas;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\"\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0084\u0004\u0018\u00002<\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001R,\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0004B\u0017\b\u0010\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010F\u001a\u0004\u0018\u00010G2\b\u0010H\u001a\u0004\u0018\u00010IH\u0002J\b\u0010J\u001a\u00020KH\u0002J\u0018\u0010L\u001a\u00020K2\u0006\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020PH\u0002J&\u0010Q\u001a\u00020K2\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020U2\f\u0010V\u001a\b\u0012\u0004\u0012\u00020X0WH\u0002J\b\u0010Y\u001a\u00020KH\u0014J\b\u0010Z\u001a\u00020KH\u0002J\u0018\u0010[\u001a\u00020K2\u0006\u0010M\u001a\u00020N2\u0006\u0010\\\u001a\u00020XH\u0002J\u0018\u0010]\u001a\u00020K2\u0006\u0010^\u001a\u00020_2\u0006\u0010\\\u001a\u00020XH\u0002J\b\u0010`\u001a\u00020aH\u0002J$\u0010b\u001a\u0004\u0018\u0001Hc\"\n\b\u0000\u0010c\u0018\u0001*\u00020d2\u0006\u0010e\u001a\u00020XH\u0082\b\u00a2\u0006\u0002\u0010fJ\b\u0010g\u001a\u00020KH\u0014J\b\u0010h\u001a\u00020KH\u0016J\b\u0010i\u001a\u00020KH\u0002J\u0010\u0010j\u001a\u00020K2\u0006\u0010k\u001a\u00020XH\u0014J\b\u0010l\u001a\u00020KH\u0002J\b\u0010m\u001a\u00020KH\u0002J\b\u0010n\u001a\u00020KH\u0002J\b\u0010o\u001a\u00020KH\u0002J\b\u0010p\u001a\u00020KH\u0002J\b\u0010q\u001a\u00020KH\u0002J\b\u0010r\u001a\u00020KH\u0002J\b\u0010s\u001a\u00020KH\u0002J\b\u0010t\u001a\u00020KH\u0002J\b\u0010u\u001a\u00020KH\u0002J\b\u0010v\u001a\u00020KH\u0002J\b\u0010w\u001a\u00020KH\u0002J\b\u0010x\u001a\u00020KH\u0002J\b\u0010y\u001a\u00020KH\u0002J\b\u0010z\u001a\u00020KH\u0002J\b\u0010{\u001a\u00020KH\u0002J\b\u0010|\u001a\u00020KH\u0002J\b\u0010}\u001a\u00020KH\u0002J\b\u0010~\u001a\u00020KH\u0002J\b\u0010\u007f\u001a\u00020KH\u0002J\t\u0010\u0080\u0001\u001a\u00020KH\u0002J\u000f\u0010\u0081\u0001\u001a\u00020KH\u0000\u00a2\u0006\u0003\b\u0082\u0001J\t\u0010\u0083\u0001\u001a\u00020KH\u0014J\t\u0010\u0084\u0001\u001a\u00020KH\u0002J\t\u0010\u0085\u0001\u001a\u00020KH\u0002J\u0011\u0010\u0086\u0001\u001a\n\u0012\u0005\u0012\u00030\u0088\u00010\u0087\u0001H\u0002J\t\u0010\u0089\u0001\u001a\u00020KH\u0002J\t\u0010\u008a\u0001\u001a\u00020KH\u0002J\t\u0010\u008b\u0001\u001a\u00020KH\u0002J\u0011\u0010\u008c\u0001\u001a\n\u0012\u0005\u0012\u00030\u008d\u00010\u0087\u0001H\u0002J\t\u0010\u008e\u0001\u001a\u00020KH\u0002J\t\u0010\u008f\u0001\u001a\u00020KH\u0002J\t\u0010\u0090\u0001\u001a\u00020KH\u0002J\t\u0010\u0091\u0001\u001a\u00020KH\u0002J\t\u0010\u0092\u0001\u001a\u00020KH\u0002J\t\u0010\u0093\u0001\u001a\u00020KH\u0002J\t\u0010\u0094\u0001\u001a\u00020KH\u0002J\t\u0010\u0095\u0001\u001a\u00020KH\u0002J\u0011\u0010\u0096\u0001\u001a\n\u0012\u0005\u0012\u00030\u0097\u00010\u0087\u0001H\u0002J\t\u0010\u0098\u0001\u001a\u00020KH\u0002J\u0011\u0010\u0099\u0001\u001a\n\u0012\u0005\u0012\u00030\u009a\u00010\u0087\u0001H\u0002J\t\u0010\u009b\u0001\u001a\u00020KH\u0002J\u0019\u0010\u009c\u0001\u001a\n\u0012\u0005\u0012\u00030\u009e\u00010\u009d\u00012\u0006\u0010\n\u001a\u00020\u0003H\u0002J\t\u0010\u009f\u0001\u001a\u00020KH\u0002J\u0016\u0010\u00a0\u0001\u001a\u0005\u0018\u00010\u00a1\u00012\b\u0010\u00a2\u0001\u001a\u00030\u00a3\u0001H\u0002J$\u0010\u00a4\u0001\u001a\u00020K2\u000f\u0010\u00a5\u0001\u001a\n\u0012\u0005\u0012\u00030\u00a6\u00010\u009d\u00012\b\u0010\u00a7\u0001\u001a\u00030\u00a8\u0001H\u0002J(\u0010\u00a9\u0001\u001a\u00020K*\u00020\u00032\u0007\u0010\u00aa\u0001\u001a\u00020X2\u0007\u0010\u00ab\u0001\u001a\u00020X2\u0007\u0010\u00ac\u0001\u001a\u00020XH\u0002R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u00020\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001d\"\u0004\b\"\u0010\u001fR\u001a\u0010#\u001a\u00020\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u001d\"\u0004\b%\u0010\u001fR\u001a\u0010&\u001a\u00020\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u001d\"\u0004\b(\u0010\u001fR\u001a\u0010)\u001a\u00020\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u001d\"\u0004\b+\u0010\u001fR\u001a\u0010,\u001a\u00020\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u001d\"\u0004\b.\u0010\u001fR\u001a\u0010/\u001a\u00020\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u001d\"\u0004\b1\u0010\u001fR\u001a\u00102\u001a\u00020\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u001d\"\u0004\b4\u0010\u001fR\u001c\u00105\u001a\u0004\u0018\u000106X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u001a\u0010;\u001a\u000206X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u00108\"\u0004\b=\u0010:R\u001c\u0010>\u001a\u0004\u0018\u000106X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u00108\"\u0004\b@\u0010:R\u0014\u0010A\u001a\b\u0012\u0004\u0012\u00020B0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010C\u001a\u00020\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010\u001d\"\u0004\bE\u0010\u001f\u00a8\u0006\u00ad\u0001"}, d2={"Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector$OraSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/oracle/model/OraSchema;", "Lcom/intellij/database/dialects/oracle/model/OraModSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector;", "Lcom/intellij/database/dialects/oracle/model/OraModModel;", "Lcom/intellij/database/dialects/oracle/model/OraRoot;", "Lcom/intellij/database/dialects/oracle/model/OraModRoot;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "schema", "(Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/dialects/oracle/model/OraSchema;)V", "affectedClusters", "Ljava/util/HashSet;", "Lcom/intellij/database/dialects/oracle/model/OraCluster;", "affectedDepObjects", "Lcom/intellij/database/model/basic/BasicSchemaObject;", "affectedInnerRoutines", "Lcom/intellij/database/model/basic/BasicRoutine;", "affectedModuleBodies", "Lcom/intellij/database/dialects/oracle/model/OraBody;", "affectedModuleSpecs", "Lcom/intellij/database/dialects/oracle/model/OraModule;", "affectedSingleRoutines", "affectedTables", "Lcom/intellij/database/dialects/oracle/model/OraTable;", "affectsClusters", "", "getAffectsClusters$intellij_database_dialects", "()Z", "setAffectsClusters$intellij_database_dialects", "(Z)V", "affectsMatLogs", "getAffectsMatLogs$intellij_database_dialects", "setAffectsMatLogs$intellij_database_dialects", "affectsMatViews", "getAffectsMatViews$intellij_database_dialects", "setAffectsMatViews$intellij_database_dialects", "affectsModulesOrBodies", "getAffectsModulesOrBodies$intellij_database_dialects", "setAffectsModulesOrBodies$intellij_database_dialects", "affectsTables", "getAffectsTables$intellij_database_dialects", "setAffectsTables$intellij_database_dialects", "affectsTriggers", "getAffectsTriggers$intellij_database_dialects", "setAffectsTriggers$intellij_database_dialects", "affectsViews", "getAffectsViews$intellij_database_dialects", "setAffectsViews$intellij_database_dialects", "haveDefaults", "getHaveDefaults$intellij_database_dialects", "setHaveDefaults$intellij_database_dialects", "myBeginTimestamp", "Ljava/sql/Timestamp;", "getMyBeginTimestamp$intellij_database_dialects", "()Ljava/sql/Timestamp;", "setMyBeginTimestamp$intellij_database_dialects", "(Ljava/sql/Timestamp;)V", "myFromTimestamp", "getMyFromTimestamp$intellij_database_dialects", "setMyFromTimestamp$intellij_database_dialects", "srcFromTimestamp", "getSrcFromTimestamp$intellij_database_dialects", "setSrcFromTimestamp$intellij_database_dialects", "tablesToReorderDetails", "Lcom/intellij/database/dialects/oracle/model/OraLikeTable;", "toStop", "getToStop$intellij_database_dialects", "setToStop$intellij_database_dialects", "adjustBigIntegerForSequence", "Ljava/math/BigInteger;", "bigDecimalValue", "Ljava/math/BigDecimal;", "adjustInnerRoutines", "", "applyClusterInfo", "cluster", "Lcom/intellij/database/dialects/oracle/model/OraModCluster;", "c", "Lcom/intellij/database/dialects/oracle/introspector/OraIntroQueries$OneCluster;", "applyIndexingItems", "table", "Lcom/intellij/database/model/basic/BasicTable;", "index", "Lcom/intellij/database/dialects/oracle/model/OraModIndex;", "items", "", "", "clearSchema", "determineAndRemoveDroppedStuff", "extractClusterColumns", "text", "extractPackageChildren", "pkg", "Lcom/intellij/database/dialects/oracle/model/OraModPackage;", "getSourceLineWidthLimit", "", "parseStatement", "T", "Lcom/intellij/sql/psi/SqlStatement;", "src", "(Ljava/lang/String;)Lcom/intellij/sql/psi/SqlStatement;", "prepareParameters", "process", "reorderTableDetails", "reportRetrieving", "what", "retrieveChecks", "retrieveClusterIndices", "retrieveClusters", "retrieveCollectionTypes", "retrieveColumnDefaults", "retrieveColumns", "retrieveComments", "retrieveConstraintColumns", "retrieveDependencies", "retrieveDependenciesLowServerHighTraffic", "retrieveDependenciesNormally", "retrieveEntireSchema", "retrieveErrors", "retrieveForeignKeys", "retrieveFragment", "retrieveFragmentNewObjectNames", "retrieveIndices", "retrieveIndicesColumns", "retrieveInnerRoutines", "retrieveInnerRoutinesArguments", "retrieveKeys", "retrieveMain", "retrieveMain$intellij_database_dialects", "retrieveMainContent", "retrieveMatLogs", "retrieveMatViews", "retrieveObfuscatedSources", "", "Lcom/intellij/database/dialects/oracle/introspector/OraIntroQueries$OneObfuscatedSrc;", "retrieveObjectTypeAttributes", "retrieveObjectTypes", "retrievePackages", "retrieveProgramSources", "Lcom/intellij/database/dialects/oracle/introspector/OraIntroQueries$OneSrcLine;", "retrieveSchemaInfo", "retrieveSequences", "retrieveSingleRoutines", "retrieveSingleRoutinesArguments", "retrieveSources", "retrieveSynonyms", "retrieveTableClusterColumns", "retrieveTables", "retrieveTriggerSources", "Lcom/intellij/database/dialects/oracle/introspector/OraIntroQueries$OneTriggerSource;", "retrieveTriggers", "retrieveViewSources", "Lcom/intellij/database/dialects/oracle/introspector/OraIntroQueries$OneViewSource;", "retrieveViews", "seanceRelatedTablesAndViews", "", "Lcom/intellij/database/dialects/oracle/model/OraModLikeTable;", "skipDependencies", "trigTurnOf", "Lcom/intellij/database/model/TrigTurn;", "turn", "", "updateInvalidStatus", "family", "Lcom/intellij/database/model/basic/BasicModElement;", "invalids", "Lgnu/trove/TLongHashSet;", "applySources", "type", "name", "sourceText", "intellij.database.dialects"})
    protected final class OraSchemaRetriever
    extends BaseIntrospector.AbstractSchemaRetriever<OraSchema, OraModSchema> {
        @NotNull
        private Timestamp myFromTimestamp;
        @Nullable
        private Timestamp myBeginTimestamp;
        @Nullable
        private Timestamp srcFromTimestamp;
        private boolean affectsClusters;
        private boolean affectsTables;
        private boolean affectsMatLogs;
        private boolean affectsMatViews;
        private boolean affectsViews;
        private boolean affectsTriggers;
        private boolean affectsModulesOrBodies;
        private boolean haveDefaults;
        private boolean toStop;
        private final HashSet<OraLikeTable> tablesToReorderDetails;
        private final HashSet<OraCluster> affectedClusters;
        private final HashSet<OraModule> affectedModuleSpecs;
        private final HashSet<OraBody> affectedModuleBodies;
        private final HashSet<BasicRoutine> affectedInnerRoutines;
        private final HashSet<BasicRoutine> affectedSingleRoutines;
        private final HashSet<BasicSchemaObject> affectedDepObjects;
        private final HashSet<OraTable> affectedTables;

        @NotNull
        public final Timestamp getMyFromTimestamp$intellij_database_dialects() {
            return this.myFromTimestamp;
        }

        public final void setMyFromTimestamp$intellij_database_dialects(@NotNull Timestamp timestamp) {
            Intrinsics.checkParameterIsNotNull((Object)timestamp, (String)"<set-?>");
            this.myFromTimestamp = timestamp;
        }

        @Nullable
        public final Timestamp getMyBeginTimestamp$intellij_database_dialects() {
            return this.myBeginTimestamp;
        }

        public final void setMyBeginTimestamp$intellij_database_dialects(@Nullable Timestamp timestamp) {
            this.myBeginTimestamp = timestamp;
        }

        @Nullable
        public final Timestamp getSrcFromTimestamp$intellij_database_dialects() {
            return this.srcFromTimestamp;
        }

        public final void setSrcFromTimestamp$intellij_database_dialects(@Nullable Timestamp timestamp) {
            this.srcFromTimestamp = timestamp;
        }

        public final boolean getAffectsClusters$intellij_database_dialects() {
            return this.affectsClusters;
        }

        public final void setAffectsClusters$intellij_database_dialects(boolean bl) {
            this.affectsClusters = bl;
        }

        public final boolean getAffectsTables$intellij_database_dialects() {
            return this.affectsTables;
        }

        public final void setAffectsTables$intellij_database_dialects(boolean bl) {
            this.affectsTables = bl;
        }

        public final boolean getAffectsMatLogs$intellij_database_dialects() {
            return this.affectsMatLogs;
        }

        public final void setAffectsMatLogs$intellij_database_dialects(boolean bl) {
            this.affectsMatLogs = bl;
        }

        public final boolean getAffectsMatViews$intellij_database_dialects() {
            return this.affectsMatViews;
        }

        public final void setAffectsMatViews$intellij_database_dialects(boolean bl) {
            this.affectsMatViews = bl;
        }

        public final boolean getAffectsViews$intellij_database_dialects() {
            return this.affectsViews;
        }

        public final void setAffectsViews$intellij_database_dialects(boolean bl) {
            this.affectsViews = bl;
        }

        public final boolean getAffectsTriggers$intellij_database_dialects() {
            return this.affectsTriggers;
        }

        public final void setAffectsTriggers$intellij_database_dialects(boolean bl) {
            this.affectsTriggers = bl;
        }

        public final boolean getAffectsModulesOrBodies$intellij_database_dialects() {
            return this.affectsModulesOrBodies;
        }

        public final void setAffectsModulesOrBodies$intellij_database_dialects(boolean bl) {
            this.affectsModulesOrBodies = bl;
        }

        public final boolean getHaveDefaults$intellij_database_dialects() {
            return this.haveDefaults;
        }

        public final void setHaveDefaults$intellij_database_dialects(boolean bl) {
            this.haveDefaults = bl;
        }

        public final boolean getToStop$intellij_database_dialects() {
            return this.toStop;
        }

        public final void setToStop$intellij_database_dialects(boolean bl) {
            this.toStop = bl;
        }

        @Override
        protected void prepareParameters() {
            super.prepareParameters();
            String[] fragmentKindTypeNames = OraObjectCodes.KIND_ORACLE_NAMES.get(this.getFragmentKind$intellij_database_dialects());
            this.setQueryParameter$intellij_database_dialects("major_object_type_names", fragmentKindTypeNames);
            this.setQueryParameter$intellij_database_dialects("major_object_names", this.getFragmentNames$intellij_database_dialects());
            this.setQueryParameter$intellij_database_dialects("src_since", this.srcFromTimestamp);
        }

        @Override
        public void process() {
            this.retrieveMain$intellij_database_dialects();
        }

        @Override
        protected void retrieveMainContent() {
            this.retrieveMain$intellij_database_dialects();
        }

        public final void retrieveMain$intellij_database_dialects() {
            this.prepareParameters();
            if (this.getMode$intellij_database_dialects().fragment) {
                this.retrieveFragment();
            } else {
                this.retrieveEntireSchema();
            }
        }

        private final void retrieveEntireSchema() {
            boolean bl;
            boolean skipSystemSchema;
            boolean bl2 = skipSystemSchema = this.getMode$intellij_database_dialects().increment && OraIntrospectorFunctions.access$getSYSTEM_SCHEMAS$p().contains(((OraSchema)this.getSchema()).getName()) && !OraIntrospector.this.getConsiderSystemSchemasReinstrospection() && !((OraSchema)this.getSchema()).isCurrent();
            if (skipSystemSchema) {
                return;
            }
            Timestamp beginTimestamp = (Timestamp)this.getTransaction().query(((OraIntrospector)OraIntrospector.this).queries.askForTimeNow).run();
            boolean bl3 = bl = beginTimestamp != null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Failed to obtain the current timestamp from the database";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this.myBeginTimestamp = beginTimestamp;
            this.reportRetrieving("schema information");
            this.retrieveSchemaInfo();
            if (this.toStop) {
                return;
            }
            Date modifiedTimestamp = ((OraSchema)this.getSchema()).getModifiedTimestamp();
            Timestamp srcFromTimestamp1 = this.srcFromTimestamp;
            boolean bl4 = this.toStop = modifiedTimestamp != null && modifiedTimestamp.before(this.myFromTimestamp) && (!this.getWithSources$intellij_database_dialects() || srcFromTimestamp1 != null && !srcFromTimestamp1.before(modifiedTimestamp));
            if (this.toStop) {
                this.retrieveComments();
                return;
            }
            this.retrieveSequences();
            this.retrieveObjectTypes();
            this.retrieveCollectionTypes();
            this.retrieveObjectTypeAttributes();
            this.retrieveClusters();
            this.retrieveTables();
            this.retrieveMatLogs();
            this.retrieveMatViews();
            this.retrieveViews();
            this.retrieveColumns();
            this.retrieveColumnDefaults();
            this.retrieveClusterIndices();
            this.retrieveTableClusterColumns();
            this.retrieveIndices();
            this.retrieveIndicesColumns();
            this.retrieveKeys();
            this.retrieveForeignKeys();
            this.retrieveChecks();
            this.retrieveConstraintColumns();
            this.reorderTableDetails();
            this.retrieveTriggers();
            this.retrievePackages();
            this.retrieveInnerRoutines();
            this.retrieveInnerRoutinesArguments();
            this.adjustInnerRoutines();
            this.retrieveSingleRoutines();
            this.retrieveSingleRoutinesArguments();
            this.retrieveComments();
            this.retrieveDependencies();
            this.retrieveSources();
            this.retrieveErrors();
            this.reportRetrieving("finishing the schema...");
            this.inSchema((Function1)new Function1<OraModSchema, Unit>(beginTimestamp){
                final /* synthetic */ Timestamp $beginTimestamp;

                public final void invoke(@NotNull OraModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    schema.setIntrospectionTimestamp(this.$beginTimestamp);
                }
                {
                    this.$beginTimestamp = timestamp;
                    super(1);
                }
            });
            if (this.getWithSources$intellij_database_dialects()) {
                OraModModel oraModModel = (OraModModel)this.getModel();
                Object s = this.getSchema();
                Timestamp timestamp = beginTimestamp;
                Intrinsics.checkExpressionValueIsNotNull((Object)timestamp, (String)"beginTimestamp");
                oraModModel.setSchemaSourcesVersion((BasicSchema)s, timestamp.getTime());
            }
        }

        private final void retrieveFragment() {
            this.retrieveFragmentNewObjectNames();
            this.determineAndRemoveDroppedStuff();
            ObjectKind objectKind = this.getFragmentKind$intellij_database_dialects();
            if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SEQUENCE)) {
                this.retrieveSequences();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.CLUSTER)) {
                this.retrieveClusters();
                this.retrieveColumns();
                this.retrieveClusterIndices();
                this.retrieveTableClusterColumns();
                this.retrieveIndicesColumns();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TABLE)) {
                this.retrieveTables();
                this.retrieveMatLogs();
                this.retrieveColumns();
                this.retrieveColumnDefaults();
                this.retrieveComments();
                this.retrieveIndices();
                this.retrieveIndicesColumns();
                this.retrieveKeys();
                this.retrieveForeignKeys();
                this.retrieveChecks();
                this.retrieveConstraintColumns();
                this.retrieveTriggers();
                this.reorderTableDetails();
                this.retrieveDependencies();
                this.retrieveSources();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.MAT_LOG)) {
                this.retrieveTables();
                this.retrieveMatLogs();
                this.retrieveColumns();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.MAT_VIEW)) {
                this.retrieveTables();
                this.retrieveMatLogs();
                this.retrieveMatViews();
                this.retrieveColumns();
                this.retrieveIndices();
                this.retrieveIndicesColumns();
                this.retrieveKeys();
                this.retrieveConstraintColumns();
                this.retrieveComments();
                this.retrieveTriggers();
                this.reorderTableDetails();
                this.retrieveDependencies();
                this.retrieveSources();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.VIEW)) {
                this.retrieveViews();
                this.retrieveColumns();
                this.retrieveComments();
                this.retrieveTriggers();
                this.reorderTableDetails();
                this.retrieveDependencies();
                this.retrieveSources();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ROUTINE)) {
                this.retrieveSingleRoutines();
                this.retrieveSingleRoutinesArguments();
                this.retrieveDependencies();
                this.retrieveSources();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.PACKAGE)) {
                this.retrievePackages();
                this.retrieveInnerRoutines();
                this.retrieveInnerRoutinesArguments();
                this.adjustInnerRoutines();
                this.retrieveDependencies();
                this.retrieveSources();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.OBJECT_TYPE)) {
                this.retrieveObjectTypes();
                this.retrieveObjectTypeAttributes();
                this.retrieveInnerRoutines();
                this.retrieveInnerRoutinesArguments();
                this.adjustInnerRoutines();
                this.retrieveDependencies();
                this.retrieveSources();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.COLLECTION_TYPE)) {
                this.retrieveCollectionTypes();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SYNONYM)) {
                this.retrieveSynonyms();
            }
        }

        private final void retrieveFragmentNewObjectNames() {
            SqlQuery<String[]> listIdsQuery;
            ObjectKind fragmentKind = this.getFragmentKind$intellij_database_dialects();
            SqlQuery<String[]> sqlQuery = listIdsQuery = fragmentKind == ObjectKind.OBJECT_TYPE || fragmentKind == ObjectKind.COLLECTION_TYPE ? ((OraIntrospector)OraIntrospector.this).queries.listFragmentTypeIds : ((OraIntrospector)OraIntrospector.this).queries.listFragmentRegularIds;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"listIdsQuery");
            String[] items = this.performQuery(sqlQuery);
            ((OraModModel)this.getModel()).modify(OraModRoot.class, new ModelModifier<OraModRoot>(this, items){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ String[] $items;

                public final void perform(OraModRoot root2) {
                    OraIntrospector oraIntrospector = this.this$0.OraIntrospector.this;
                    OraModRoot oraModRoot = root2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)oraModRoot, (String)"root");
                    NamingIdentifyingFamily namingIdentifyingFamily = oraModRoot.getSchemas();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"root.schemas");
                    OraIntrospector.access$processNames(oraIntrospector, this.$items, (ModNamingIdentifyingFamily)namingIdentifyingFamily, true);
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$items = stringArray;
                }
            });
        }

        private final void determineAndRemoveDroppedStuff() {
            SqlQuery<long[]> query;
            this.reportRetrieving("detect dropped objects");
            SqlQuery<long[]> sqlQuery = query = OraIntrospector.this.fast ? ((OraIntrospector)OraIntrospector.this).queries.retrieveAllObjectIdentifiersFast : ((OraIntrospector)OraIntrospector.this).queries.retrieveAllObjectIdentifiersSlow;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"query");
            long[] idsArray = this.performQuery(sqlQuery);
            TLongHashSet identifiers = new TLongHashSet(idsArray);
            this.inSchema((Function1)new Function1<OraModSchema, Unit>(identifiers){
                final /* synthetic */ TLongHashSet $identifiers;

                public final void invoke(@NotNull OraModSchema s) {
                    Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
                    OraIntrospectorFunctions.access$dropUnexistentObjectsInSchema(s, this.$identifiers);
                }
                {
                    this.$identifiers = tLongHashSet;
                    super(1);
                }
            });
        }

        @Override
        protected void clearSchema() {
            this.inSchema((Function1)new Function1<OraModSchema, Unit>(this){
                final /* synthetic */ OraSchemaRetriever this$0;

                public final void invoke(@NotNull OraModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    schema.dropChildren();
                    schema.setCreatedTimestamp(null);
                    schema.setModifiedTimestamp(null);
                    schema.setIntrospectionTimestamp(null);
                    OraSchemaRetriever.access$getModel$p(this.this$0).setSchemaSourcesVersion(schema, null);
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    super(1);
                }
            });
        }

        private final void retrieveSchemaInfo() {
            boolean schemaIsPublic = Intrinsics.areEqual((Object)((OraSchema)this.getSchema()).getName(), (Object)"PUBLIC");
            SqlQuery<OraIntroQueries.OneSchemaInfo> sqlQuery = schemaIsPublic ? ((OraIntrospector)OraIntrospector.this).queries.retrievePublicSchemaInfo : ((OraIntrospector)OraIntrospector.this).queries.retrieveSchemaInfo;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"if (schemaIsPublic) quer\u2026ueries.retrieveSchemaInfo");
            OraIntroQueries.OneSchemaInfo info = this.performQuery(sqlQuery);
            this.inSchema((Function1)new Function1<OraModSchema, Unit>(info){
                final /* synthetic */ OraIntroQueries.OneSchemaInfo $info;

                public final void invoke(@NotNull OraModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    schema.setObjectId(this.$info.user_id);
                    schema.setCreatedTimestamp(this.$info.created_timestamp);
                    schema.setModifiedTimestamp(this.$info.modified_timestamp);
                }
                {
                    this.$info = oneSchemaInfo;
                    super(1);
                }
            });
            this.setQueryParameter$intellij_database_dialects("SCHEMA_ID", info.user_id);
        }

        private final void retrieveSequences() {
            NamingIdentifyingFamily<? extends OraSequence> namingIdentifyingFamily = ((OraSchema)this.getSchema()).getSequences();
            Intrinsics.checkExpressionValueIsNotNull(namingIdentifyingFamily, (String)"schema.sequences");
            if (namingIdentifyingFamily.isEmpty()) {
                return;
            }
            this.reportRetrieving("Sequences");
            SqlQuery<List<OraIntroQueries.OneSequence>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveSequences;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveSequences");
            List<OraIntroQueries.OneSequence> ss = this.performQuery(sqlQuery);
            if (ss.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraModSchema, Unit>(this, ss){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $ss;

                /*
                 * Unable to fully structure code
                 */
                public final void invoke(@NotNull OraModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneSequence s : this.$ss) {
                        v0 = sequence = (OraModSequence)schema.getSequences().renew(s.object_id, s.sequence_name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"sequence");
                        v0.setSequenceIdentity(SequenceIdentity.of(OraSchemaRetriever.access$adjustBigIntegerForSequence(this.this$0, s.min_value), OraSchemaRetriever.access$adjustBigIntegerForSequence(this.this$0, s.last_number), BigInteger.valueOf(s.increment_by), OraSchemaRetriever.access$adjustBigIntegerForSequence(this.this$0, s.max_value)));
                        sequence.setOrdered(s.order_flag);
                        sequence.setCycled(s.cycle_flag);
                        v1 = s.cache_size;
                        sequence.setCacheSize(v1 != null ? v1 : 0);
                        sequence.setBelongsToColumn(s.generated);
                        v2 = sequence;
                        if (!s.generated) ** GOTO lbl-1000
                        v3 = s.sequence_name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"s.sequence_name");
                        var5_5 = v3;
                        var6_6 = OraIntrospectorFunctions.access$getSEQUENCE_SURROGATE_NAME_PATTERN$p();
                        var7_7 = v2;
                        var8_8 = var6_6.matches(var5_5);
                        v2 = var7_7;
                        if (var8_8) {
                            v4 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v4 = false;
                        }
                        v2.setNameSurrogate(v4);
                        sequence.setCreatedTimestamp(s.created_timestamp);
                        sequence.setModifiedTimestamp(s.modified_timestamp);
                    }
                    schema.getSequences().sort();
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$ss = list;
                    super(1);
                }
            });
        }

        private final BigInteger adjustBigIntegerForSequence(BigDecimal bigDecimalValue) {
            BigInteger bigInteger;
            String str;
            if (bigDecimalValue == null) {
                return null;
            }
            BigInteger bi = bigDecimalValue.toBigInteger();
            String string = bi.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"bi.toString()");
            switch (str = string) {
                case "99999999999999999999999999": {
                    bigInteger = null;
                    break;
                }
                case "999999999999999999999999999": {
                    bigInteger = null;
                    break;
                }
                case "9999999999999999999999999999": {
                    bigInteger = null;
                    break;
                }
                case "-99999999999999999999999999": {
                    bigInteger = null;
                    break;
                }
                case "-999999999999999999999999999": {
                    bigInteger = null;
                    break;
                }
                case "-9999999999999999999999999999": {
                    bigInteger = null;
                    break;
                }
                case "1000000000000000000000000000": {
                    bigInteger = null;
                    break;
                }
                case "-1000000000000000000000000000": {
                    bigInteger = null;
                    break;
                }
                default: {
                    bigInteger = bi;
                }
            }
            return bigInteger;
        }

        private final void retrieveObjectTypes() {
            NamingIdentifyingFamily<? extends OraObjectType> namingIdentifyingFamily = ((OraSchema)this.getSchema()).getObjectTypes();
            Intrinsics.checkExpressionValueIsNotNull(namingIdentifyingFamily, (String)"schema.objectTypes");
            if (namingIdentifyingFamily.isEmpty()) {
                return;
            }
            this.reportRetrieving("Object Types");
            SqlQuery<List<OraIntroQueries.OneObjectType>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveObjectTypes;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveObjectTypes");
            List<OraIntroQueries.OneObjectType> ots = this.performQuery(sqlQuery);
            if (ots.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraModSchema, Unit>(this, ots){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $ots;

                public final void invoke(@NotNull OraModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneObjectType ot : this.$ots) {
                        OraModObjectType oType;
                        OraModObjectType oraModObjectType = oType = (OraModObjectType)schema.getObjectTypes().renew(ot.object_id, ot.type_name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraModObjectType, (String)"oType");
                        oraModObjectType.setSuperSchemaName(ot.supertype_schema_name);
                        oType.setSuperObjectName(ot.supertype_name);
                        oType.setCreatedTimestamp(ot.created_timestamp);
                        oType.setModifiedTimestamp(ot.modified_timestamp);
                        oType.setIncomplete(ot.is_incomplete);
                        oType.setFinal(ot.is_final);
                        oType.setInstantiable(ot.is_instantiable);
                        if (ot.body_object_id != 0L) {
                            OraModObjectTypeBody body2;
                            OraModObjectTypeBody oraModObjectTypeBody = body2 = (OraModObjectTypeBody)oType.getBodies().createOrGet();
                            Intrinsics.checkExpressionValueIsNotNull((Object)oraModObjectTypeBody, (String)"body");
                            oraModObjectTypeBody.setObjectId(ot.body_object_id);
                            body2.setName(ot.type_name);
                            OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(body2, ot.body_created_timestamp, ot.body_modified_timestamp);
                            OraSchemaRetriever.access$getAffectedModuleBodies$p(this.this$0).add(body2);
                            OraSchemaRetriever.access$getAffectedDepObjects$p(this.this$0).add(body2);
                        } else {
                            oType.getBodies().clear();
                            OraSchemaRetriever.access$getAffectedDepObjects$p(this.this$0).add(oType);
                        }
                        OraSchemaRetriever.access$getAffectedModuleSpecs$p(this.this$0).add(oType);
                    }
                    schema.getObjectTypes().sort();
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$ots = list;
                    super(1);
                }
            });
            this.affectsModulesOrBodies = true;
        }

        private final void retrieveCollectionTypes() {
            NamingIdentifyingFamily<? extends OraCollectionType> namingIdentifyingFamily = ((OraSchema)this.getSchema()).getCollectionTypes();
            Intrinsics.checkExpressionValueIsNotNull(namingIdentifyingFamily, (String)"schema.collectionTypes");
            if (namingIdentifyingFamily.isEmpty()) {
                return;
            }
            this.reportRetrieving("Collection Types");
            SqlQuery<List<OraIntroQueries.OneCollectionType>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveCollectionTypes;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveCollectionTypes");
            List<OraIntroQueries.OneCollectionType> cts = this.performQuery(sqlQuery);
            if (cts.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraModSchema, Unit>(cts){
                final /* synthetic */ List $cts;

                public final void invoke(@NotNull OraModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneCollectionType ct : this.$cts) {
                        OraModCollectionType cType;
                        OraModCollectionType oraModCollectionType = cType = (OraModCollectionType)schema.getCollectionTypes().renew(ct.object_id, ct.type_name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraModCollectionType, (String)"cType");
                        oraModCollectionType.setTypeKind(ct.collection_kind == 'A' ? OraCollectionTypeKind.VARIABLE_SIZE_ARRAY : OraCollectionTypeKind.NESTED_TABLE);
                        cType.setUpperBound(ct.upper_bound);
                        DataType type = OraIntrospectorFunctions.access$makeDataType(schema, ct.data_type_schema_name, null, ct.data_type, ct.data_size, ct.data_scale, ct.data_size_units);
                        cType.setElementType(type);
                        OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(cType, ct.created_timestamp, ct.modified_timestamp);
                    }
                    schema.getCollectionTypes().sort();
                }
                {
                    this.$cts = list;
                    super(1);
                }
            });
        }

        private final void retrieveObjectTypeAttributes() {
            NamingIdentifyingFamily<? extends OraObjectType> namingIdentifyingFamily = ((OraSchema)this.getSchema()).getObjectTypes();
            Intrinsics.checkExpressionValueIsNotNull(namingIdentifyingFamily, (String)"schema.objectTypes");
            if (namingIdentifyingFamily.isEmpty()) {
                return;
            }
            this.reportRetrieving("Object Type Attributes");
            SqlQuery<List<OraIntroQueries.OneObjectTypeAttribute>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveObjectTypeAttributes;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveObjectTypeAttributes");
            List<OraIntroQueries.OneObjectTypeAttribute> attrs = this.performQuery(sqlQuery);
            if (attrs.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraModSchema, Unit>(attrs){
                final /* synthetic */ List $attrs;

                public final void invoke(@NotNull OraModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    HashSet<OraModObjectType> affectedObjectTypes = new HashSet<OraModObjectType>(schema.getObjectTypes().size());
                    for (OraIntroQueries.OneObjectTypeAttribute ota : this.$attrs) {
                        OraModObjectTypeAttribute attr;
                        OraModObjectType ot;
                        OraModObjectType oraModObjectType = ot = (OraModObjectType)schema.getObjectTypes().createOrGet(ota.type_name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraModObjectType, (String)"ot");
                        OraModObjectTypeAttribute oraModObjectTypeAttribute = attr = (OraModObjectTypeAttribute)oraModObjectType.getAttributes().createOrGet(ota.attr_name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraModObjectTypeAttribute, (String)"attr");
                        oraModObjectTypeAttribute.setPosition(ota.position);
                        DataType type = OraIntrospectorFunctions.access$makeDataType(schema, ota.data_type_schema, null, ota.data_type, ota.data_size, ota.data_scale, ota.data_size_units);
                        attr.setDataType(type);
                        affectedObjectTypes.add(ot);
                    }
                    Iterator<E> iterator = affectedObjectTypes.iterator();
                    while (iterator.hasNext()) {
                        OraModObjectType objectType;
                        OraModObjectType oraModObjectType = objectType = (OraModObjectType)iterator.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraModObjectType, (String)"objectType");
                        oraModObjectType.getAttributes().sort();
                    }
                }
                {
                    this.$attrs = list;
                    super(1);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveClusters() {
            void cs;
            NamingIdentifyingFamily<? extends OraCluster> namingIdentifyingFamily = ((OraSchema)this.getSchema()).getClusters();
            Intrinsics.checkExpressionValueIsNotNull(namingIdentifyingFamily, (String)"schema.clusters");
            if (namingIdentifyingFamily.isEmpty()) {
                return;
            }
            this.reportRetrieving("Clusters");
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = CollectionsKt.emptyList();
            boolean ora31603 = false;
            try {
                SqlQuery<List<OraIntroQueries.OneCluster>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveClusters;
                Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveClusters");
                cs.element = this.performQuery(sqlQuery);
            }
            catch (DBException e) {
                if (e.vendorErrorCode == 31603) {
                    ora31603 = true;
                    String string = ((OraSchema)this.getSchema()).getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"schema.name");
                    String schemaName = string;
                    OraIntrospector.this.getLog().warn("Oracle schema " + schemaName + ": Unable to retrieve CLUSTER details because the user has no SELECT_CATALOG_ROLE.");
                    Notification notification = new Notification("Oracle Introspector Unable To Retrieve Cluster Details", AllIcons.Ide.Notification.WarningEvents, "Cluster details not retrieved", null, "Oracle Introspector is unable to retrieve details of clusters in schema " + schemaName + ".\n" + "In order to retrieve these details, grant the user the SELECT_CATALOG_ROLE, " + "then re-sync the data source again (use the 'Forget Cached Schemas' action).", NotificationType.WARNING, null);
                    Notifications.Bus.notify((Notification)notification);
                }
                throw (Throwable)e;
            }
            if (ora31603) {
                SqlQuery<List<OraIntroQueries.OneCluster>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveClustersWhenNoPermissions;
                Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveClustersWhenNoPermissions");
                cs.element = this.performQuery(sqlQuery);
            }
            if (((List)cs.element).isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraModSchema, Unit>(this, (Ref.ObjectRef)cs){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ Ref.ObjectRef $cs;

                public final void invoke(@NotNull OraModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneCluster c2 : (List)this.$cs.element) {
                        OraModCluster cluster;
                        OraModCluster oraModCluster = cluster = (OraModCluster)schema.getClusters().createOrGet(c2.id);
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraModCluster, (String)"cluster");
                        OraSchemaRetriever.access$applyClusterInfo(this.this$0, oraModCluster, c2);
                        OraSchemaRetriever.access$getAffectedClusters$p(this.this$0).add(cluster);
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$cs = objectRef;
                    super(1);
                }
            });
            this.affectsClusters = true;
        }

        private final void applyClusterInfo(OraModCluster cluster, OraIntroQueries.OneCluster c2) {
            String string;
            cluster.setClusterType(ClusterType.of((char)c2.type_code));
            cluster.setSingleTable(c2.single_table);
            cluster.setBlockSize(c2.block_size);
            OraModCluster oraModCluster = cluster;
            String string2 = c2.hash_expression;
            if (string2 != null) {
                String string3 = string2;
                OraModCluster oraModCluster2 = oraModCluster;
                String string4 = string3;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String string5 = ((Object)StringsKt.trim((CharSequence)string4)).toString();
                oraModCluster = oraModCluster2;
                string = string5;
            } else {
                string = null;
            }
            oraModCluster.setHashExpression(string);
            cluster.setHashCardinality(c2.hash_cardinality);
            cluster.setTablespaceName(c2.tablespace_name);
            String decompiled_text = c2.decompiled_text;
            if (decompiled_text != null) {
                String string6 = c2.decompiled_text;
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"c.decompiled_text");
                this.extractClusterColumns(cluster, string6);
            }
        }

        private final void extractClusterColumns(OraModCluster cluster, String text2) {
            SqlStatement sqlStatement;
            PositioningNamingFamily positioningNamingFamily = cluster.getColumns();
            Intrinsics.checkExpressionValueIsNotNull((Object)positioningNamingFamily, (String)"cluster.columns");
            PositioningNamingFamily columns = positioningNamingFamily;
            OraSchemaRetriever this_$iv = this;
            try {
                IntrospectorSqlHelper this_$iv$iv = this_$iv.OraIntrospector.this.getSqlHelper();
                sqlStatement = (SqlStatement)this_$iv$iv.statements(text2, SqlCreateStatement.class).first();
            }
            catch (Exception e$iv) {
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                if (application.isUnitTestMode()) {
                    this_$iv.OraIntrospector.this.getLog().error((Throwable)e$iv);
                }
                this_$iv.OraIntrospector.this.getLog().warn("Failed to parse sources", (Throwable)e$iv);
                sqlStatement = null;
            }
            SqlCreateStatement statement = (SqlCreateStatement)sqlStatement;
            if (statement == null || Intrinsics.areEqual((Object)statement.getKind(), (Object)ObjectKind.CLUSTER) ^ true) {
                columns.clear();
                return;
            }
            columns.markChildrenAsSyncPending();
            JBIterable jBIterable = statement.getDasChildren(ObjectKind.COLUMN);
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"statement.getDasChildren(COLUMN)");
            JBIterable parsedColumns = jBIterable;
            Iterator iterator = parsedColumns.iterator();
            while (iterator.hasNext()) {
                DasObject c2;
                DasObject dasObject = c2 = (DasObject)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)dasObject, (String)"c");
                OraModClusterColumn column2 = (OraModClusterColumn)columns.createOrGet(dasObject.getName());
                OraIntrospector.this.getSqlHelper().getBuilder().partialBuild((DasObject)column2, c2);
            }
            columns.removeSyncPendingChildren();
            columns.sort();
        }

        private final void retrieveTables() {
            NamingIdentifyingFamily<? extends OraTable> namingIdentifyingFamily = ((OraSchema)this.getSchema()).getTables();
            Intrinsics.checkExpressionValueIsNotNull(namingIdentifyingFamily, (String)"schema.tables");
            if (namingIdentifyingFamily.isEmpty()) {
                return;
            }
            this.reportRetrieving("Tables");
            SqlQuery<List<OraIntroQueries.OneTable>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveTables;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveTables");
            List<OraIntroQueries.OneTable> tabs = this.performQuery(sqlQuery);
            if (tabs.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraModSchema, Unit>(this, tabs){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $tabs;

                public final void invoke(@NotNull OraModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneTable tab : this.$tabs) {
                        TableOrganization tableOrganization;
                        OraModTable table;
                        String tableName = tab.table_name;
                        OraModTable oraModTable = table = (OraModTable)schema.getTables().renew(tab.object_id, tableName);
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraModTable, (String)"table");
                        oraModTable.setMasterTableName(tab.master_table_name);
                        table.setClusterName(tab.cluster_name);
                        table.setTemporary(tab.is_temp);
                        table.setTemporaryPreserve(tab.is_temp_preserved);
                        OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(table, tab.created_timestamp, tab.modified_timestamp);
                        OraModCluster cluster = tab.cluster_name != null ? (OraModCluster)schema.getClusters().get(tab.cluster_name) : null;
                        boolean clusterIsIndexed = cluster != null && cluster.getHashCardinality() == 0;
                        switch (tab.organization_kind) {
                            case 'I': {
                                tableOrganization = TableOrganization.INDEX;
                                break;
                            }
                            case 'C': {
                                if (clusterIsIndexed) {
                                    tableOrganization = TableOrganization.ORA_CLUSTERED_BY_INDEX;
                                    break;
                                }
                                tableOrganization = TableOrganization.ORA_CLUSTERED_BY_HASH;
                                break;
                            }
                            default: {
                                tableOrganization = TableOrganization.DEFAULT;
                            }
                        }
                        table.setOrganization(tableOrganization);
                        table.setRowTypeSchemaName(tab.row_type_schema_name);
                        table.setRowTypeObjectName(tab.row_type_name);
                        table.setTableType(tab.is_mat_log ? OraTableType.MAT_LOG : (tab.is_mat_view ? OraTableType.MAT_VIEW : OraTableType.BASIC));
                        table.setNameSurrogate(tab.is_mat_log);
                        if (tab.has_mat_log) {
                            table.getMatLogs().createOrGet();
                        } else {
                            table.getMatLogs().clear();
                        }
                        table.getChecks().clear();
                        table.getForeignKeys().clear();
                        table.getKeys().clear();
                        OraSchemaRetriever.access$getAffectedTables$p(this.this$0).add(table);
                        this.this$0.setAffectsMatLogs$intellij_database_dialects(this.this$0.getAffectsMatLogs$intellij_database_dialects() || tab.is_mat_log || tab.has_mat_log);
                        this.this$0.setAffectsMatViews$intellij_database_dialects(this.this$0.getAffectsMatViews$intellij_database_dialects() || tab.is_mat_view);
                    }
                    schema.getTables().sort();
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$tabs = list;
                    super(1);
                }
            });
            this.affectsTables = true;
        }

        private final void retrieveMatLogs() {
            if (!this.affectsMatLogs) {
                return;
            }
            this.reportRetrieving("Materialized Logs");
            SqlQuery<List<OraIntroQueries.OneMatLog>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveMatLogs;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveMatLogs");
            List<OraIntroQueries.OneMatLog> mls = this.performQuery(sqlQuery);
            if (mls.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraModSchema, Unit>(mls){
                final /* synthetic */ List $mls;

                public final void invoke(@NotNull OraModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneMatLog m : this.$mls) {
                        OraModTable table;
                        OraModMatLog ml;
                        if ((OraModTable)schema.getTables().get(m.table_name) == null) {
                            continue;
                        }
                        OraModMatLog oraModMatLog = ml = (OraModMatLog)table.getMatLogs().createOrGet();
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraModMatLog, (String)"ml");
                        oraModMatLog.setName(m.log_name);
                        ml.setNameSurrogate(true);
                        ml.setWithRowId(m.with_rowid);
                        ml.setWithObjectId(m.with_object_id);
                        ml.setWithPrimaryKey(m.with_primary_key);
                        ml.setWithSequence(m.with_sequence);
                        ml.setWithNewValues(m.with_new_values);
                    }
                }
                {
                    this.$mls = list;
                    super(1);
                }
            });
        }

        private final void retrieveMatViews() {
            NamingIdentifyingFamily<? extends OraMatView> namingIdentifyingFamily = ((OraSchema)this.getSchema()).getMatViews();
            Intrinsics.checkExpressionValueIsNotNull(namingIdentifyingFamily, (String)"schema.matViews");
            if (namingIdentifyingFamily.isEmpty() && !this.affectsMatViews) {
                return;
            }
            this.reportRetrieving("Materialized Views");
            SqlQuery<List<OraIntroQueries.OneMatView>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveMatViews;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveMatViews");
            List<OraIntroQueries.OneMatView> vs = this.performQuery(sqlQuery);
            if (vs.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraModSchema, Unit>(this, vs){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $vs;

                public final void invoke(@NotNull OraModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneMatView v : this.$vs) {
                        OraModMatView view;
                        OraModMatView oraModMatView = view = (OraModMatView)schema.getMatViews().renew(v.object_id, v.view_name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraModMatView, (String)"view");
                        oraModMatView.setPrebuilt(v.prebuilt);
                        view.setModifiable(v.modifiable);
                        view.setRefreshMode(OraMatViewRefreshMode.byCode(v.refresh_mode));
                        view.setRefreshMethod(OraMatViewRefreshMethod.byCode(v.refresh_method));
                        view.setInvalid(v.is_invalid);
                        OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(view, v.created_timestamp, v.modified_timestamp);
                        if (this.this$0.getMode$intellij_database_dialects() == IntrospectionMode.INCREMENT) {
                            OraModTable oraModTable = (OraModTable)schema.getTables().get(v.view_name);
                            if (oraModTable != null) {
                                oraModTable.setTableType(OraTableType.MAT_VIEW);
                            }
                        }
                        OraSchemaRetriever.access$getAffectedDepObjects$p(this.this$0).add(view);
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$vs = list;
                    super(1);
                }
            });
            this.affectsMatViews = true;
        }

        private final void retrieveViews() {
            NamingIdentifyingFamily<? extends OraView> namingIdentifyingFamily = ((OraSchema)this.getSchema()).getViews();
            Intrinsics.checkExpressionValueIsNotNull(namingIdentifyingFamily, (String)"schema.views");
            if (namingIdentifyingFamily.isEmpty()) {
                return;
            }
            this.reportRetrieving("Views");
            SqlQuery<List<OraIntroQueries.OneView>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveViews;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveViews");
            List<OraIntroQueries.OneView> vs = this.performQuery(sqlQuery);
            if (vs.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraModSchema, Unit>(this, vs){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $vs;

                public final void invoke(@NotNull OraModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneView v : this.$vs) {
                        OraModView view;
                        OraModView oraModView = view = (OraModView)schema.getViews().renew(v.object_id, v.view_name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraModView, (String)"view");
                        oraModView.setModifiable(v.modifiable);
                        view.setInvalid(v.is_invalid);
                        OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(view, v.created_timestamp, v.modified_timestamp);
                        OraSchemaRetriever.access$getAffectedDepObjects$p(this.this$0).add(view);
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$vs = list;
                    super(1);
                }
            });
            this.affectsViews = true;
        }

        private final void retrieveColumns() {
            this.haveDefaults = false;
            if (!(this.affectsClusters || this.affectsTables || this.affectsMatViews || this.affectsViews)) {
                return;
            }
            this.reportRetrieving("Table and View Columns");
            SqlQuery<List<OraIntroQueries.OneColumn>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveColumns;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveColumns");
            List<OraIntroQueries.OneColumn> cols = this.performQuery(sqlQuery);
            if (cols.isEmpty()) {
                return;
            }
            HashSet affectedTables = new HashSet();
            this.inSchema((Function1)new Function1<OraModSchema, Unit>(this, cols, affectedTables){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $cols;
                final /* synthetic */ HashSet $affectedTables;

                /*
                 * Unable to fully structure code
                 * Could not resolve type clashes
                 */
                public final void invoke(@NotNull OraModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    major = null;
                    major_id = -9223372036854775808L;
                    for (OraIntroQueries.OneColumn col : this.$cols) {
                        block10: {
                            if (col.major_id == major_id) break block10;
                            var7_6 = schema;
                            objectId$iv = col.major_id;
                            v0 /* !! */  = $receiver$iv.getDatabase();
                            if (v0 /* !! */  == null) ** GOTO lbl-1000
                            $receiver$iv$iv = v0 /* !! */ ;
                            v1 = $receiver$iv$iv.findIdentifiedElement(objectId$iv);
                            if (!(v1 instanceof OraModMajorObject)) {
                                v1 = null;
                            }
                            if ((v0 /* !! */  = (OraModMajorObject)v1) != null) {
                                $receiver$iv$iv = v0 /* !! */ ;
                                v2 /* !! */  = $receiver$iv$iv != null && Intrinsics.areEqual((Object)(it$iv = $receiver$iv$iv).getSchema(), (Object)$receiver$iv) ? $receiver$iv$iv : null;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v2 /* !! */  = major = null;
                            }
                            if (major == null) continue;
                            major_id = col.major_id;
                            $receiver$iv = major;
                            if (!($receiver$iv instanceof OraModLikeTable)) continue;
                            ((OraModLikeTable)major).getColumns().markChildrenAsSyncPending();
                            this.$affectedTables.add(major);
                        }
                        v3 = $receiver$iv = major != null;
                        if (_Assertions.ENABLED && !$receiver$iv) {
                            objectId$iv = "Assertion failed";
                            throw (Throwable)new AssertionError((Object)objectId$iv);
                        }
                        objectId$iv = major;
                        if (!(objectId$iv instanceof OraModLikeTable)) continue;
                        Intrinsics.checkExpressionValueIsNotNull((Object)((OraModLikeTable)major).getColumns(), (String)"when (major) {\n         \u2026e@columns\n              }");
                        v4 = tableColumns.createOrGet(col.column_name);
                        Intrinsics.checkExpressionValueIsNotNull(v4, (String)"tableColumns.createOrGet(col.column_name)");
                        column = (OraModInfraColumn)v4;
                        column.resetSyncPending();
                        column.setPosition(col.column_position);
                        type = OraIntrospectorFunctions.access$makeDataType(schema, col.data_type_schema_name, null, col.data_type, col.data_size, col.data_scale, col.data_size_units);
                        column.setDataType(type);
                        if (column instanceof OraModLikeColumn) {
                            ((OraModLikeColumn)column).setNotNull(col.mandatory);
                        }
                        if (!(column instanceof OraModTableColumn)) continue;
                        ((OraModTableColumn)column).setAutoInc(col.identity_column);
                        ((OraModTableColumn)column).setDefaultOnNull(col.default_on_null);
                        if (col.has_default_expression && !col.identity_column) {
                            this.this$0.setHaveDefaults$intellij_database_dialects(true);
                            continue;
                        }
                        ((OraModTableColumn)column).setDefaultExpression(null);
                    }
                    if (this.this$0.getMode$intellij_database_dialects().increment || this.this$0.getMode$intellij_database_dialects().fragment) {
                        var6_4 = this.$affectedTables.iterator();
                        while (var6_4.hasNext()) {
                            v5 = affectedTable = (OraLikeTable)var6_4.next();
                            if (v5 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.dialects.oracle.model.OraModLikeTable");
                            }
                            ((OraModLikeTable)v5).getColumns().removeSyncPendingChildren();
                        }
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$cols = list;
                    this.$affectedTables = hashSet;
                    super(1);
                }
            });
            this.tablesToReorderDetails.addAll(affectedTables);
        }

        private final void retrieveColumnDefaults() {
            if (!this.haveDefaults) {
                return;
            }
            this.reportRetrieving("Table and View Column Defaults");
            SqlQuery<List<OraIntroQueries.OneColumnDefault>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveColumnDefaults;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveColumnDefaults");
            List<OraIntroQueries.OneColumnDefault> rows = this.performQuery(sqlQuery);
            if (rows.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraModSchema, Unit>(rows){
                final /* synthetic */ List $rows;

                public final void invoke(@NotNull OraModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneColumnDefault col : this.$rows) {
                        String string;
                        OraModTableColumn column2;
                        OraModTable table;
                        if ((OraModTable)schema.getTables().get(col.table_name) == null) {
                            continue;
                        }
                        if ((OraModTableColumn)table.getColumns().get(col.column_name) == null) {
                            continue;
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)col.default_expression, (String)"col.default_expression");
                        OraModTableColumn oraModTableColumn = column2;
                        String string2 = string;
                        if (string2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                        }
                        String string3 = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                        oraModTableColumn.setDefaultExpression(string3);
                    }
                }
                {
                    this.$rows = list;
                    super(1);
                }
            });
        }

        private final void retrieveClusterIndices() {
            SqlQuery<List<OraIntroQueries.OneClusterIndex>> sqlQuery;
            NamingIdentifyingFamily<? extends OraCluster> namingIdentifyingFamily = ((OraSchema)this.getSchema()).getClusters();
            Intrinsics.checkExpressionValueIsNotNull(namingIdentifyingFamily, (String)"schema.clusters");
            if (namingIdentifyingFamily.isEmpty()) {
                return;
            }
            if (OraIntrospector.this.fast) {
                sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveClusterIndicesFast;
            } else if (((OraSchema)this.getSchema()).isCurrent()) {
                sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveClusterIndicesUser;
            } else {
                return;
            }
            SqlQuery<List<OraIntroQueries.OneClusterIndex>> query = sqlQuery;
            this.reportRetrieving("Cluster Indices");
            SqlQuery<List<OraIntroQueries.OneClusterIndex>> sqlQuery2 = query;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery2, (String)"query");
            List<OraIntroQueries.OneClusterIndex> inds = this.performQuery(sqlQuery2);
            if (inds.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraModSchema, Unit>(this, inds){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $inds;

                public final void invoke(@NotNull OraModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneClusterIndex ind : this.$inds) {
                        OraModCluster cluster;
                        OraModClusterIndex index2;
                        if ((OraModCluster)schema.getClusters().get(ind.cluster_name) == null) {
                            continue;
                        }
                        OraModClusterIndex oraModClusterIndex = index2 = (OraModClusterIndex)cluster.getIndices().createOrGet();
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraModClusterIndex, (String)"index");
                        oraModClusterIndex.setObjectId(ind.index_id);
                        index2.setName(ind.index_name);
                        String string = ind.index_name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ind.index_name");
                        CharSequence charSequence = string;
                        Regex regex = OraIntrospectorFunctions.access$getSURROGATE_NAME_PATTERN$p();
                        OraModClusterIndex oraModClusterIndex2 = index2;
                        boolean bl = regex.matches(charSequence);
                        oraModClusterIndex2.setNameSurrogate(bl);
                        index2.setTablespaceName(ind.tablespace_name);
                        OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(index2, ind.created_timestamp, ind.modified_timestamp);
                        if (!this.this$0.getMode$intellij_database_dialects().fragment) continue;
                        index2.setColNames(CollectionsKt.emptyList());
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$inds = list;
                    super(1);
                }
            });
        }

        private final void retrieveTableClusterColumns() {
            SqlQuery<List<OraIntroQueries.OneTableClusterColumn>> query;
            SqlQuery<List<OraIntroQueries.OneTableClusterColumn>> sqlQuery;
            NamingIdentifyingFamily<? extends OraCluster> namingIdentifyingFamily = ((OraSchema)this.getSchema()).getClusters();
            Intrinsics.checkExpressionValueIsNotNull(namingIdentifyingFamily, (String)"schema.clusters");
            if (namingIdentifyingFamily.isEmpty() || this.affectedTables.isEmpty()) {
                return;
            }
            this.reportRetrieving("Tables' clustered columns");
            if (OraIntrospector.this.fast) {
                sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveTableClusterColumnsAdmin;
            } else if (((OraSchema)this.getSchema()).isCurrent()) {
                sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveTableClusterColumnsUser;
            } else {
                return;
            }
            SqlQuery<List<OraIntroQueries.OneTableClusterColumn>> sqlQuery2 = query = sqlQuery;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery2, (String)"query");
            List<OraIntroQueries.OneTableClusterColumn> cols = this.performQuery(sqlQuery2);
            if (cols.isEmpty()) {
                return;
            }
            StringListAggregator g = new StringListAggregator();
            for (OraIntroQueries.OneTableClusterColumn col : cols) {
                String string = col.table_name;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"col.table_name");
                String string2 = col.column_name;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"col.column_name");
                g.add(string, string2);
            }
            this.inSchema((Function1)new Function1<OraModSchema, Unit>(g){
                final /* synthetic */ StringListAggregator $g;

                public final void invoke(@NotNull OraModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    Map<K, CV> map = this.$g.getResult();
                    Iterator<Map.Entry<K, CV>> iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<K, CV> entry;
                        Map.Entry<K, CV> entry2 = entry = iterator.next();
                        String tableName = (String)entry2.getKey();
                        entry2 = entry;
                        List colNames = (List)entry2.getValue();
                        OraModTable oraModTable = (OraModTable)schema.getTables().get(tableName);
                        if (oraModTable == null) continue;
                        oraModTable.setClusterColNames(colNames);
                    }
                }
                {
                    this.$g = stringListAggregator;
                    super(1);
                }
            });
        }

        private final void retrieveIndices() {
            if (!this.affectsTables && !this.affectsMatViews) {
                return;
            }
            this.reportRetrieving("Indices");
            SqlQuery<List<OraIntroQueries.OneIndex>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveIndices;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveIndices");
            List<OraIntroQueries.OneIndex> indices = this.performQuery(sqlQuery);
            if (indices.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraModSchema, Unit>(this, indices){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $indices;

                public final void invoke(@NotNull OraModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneIndex ind : this.$indices) {
                        OraModIndex oraModIndex;
                        OraModTable table;
                        if ((OraModTable)schema.getTables().get(ind.table_name) == null) {
                            continue;
                        }
                        OraModIndex index2 = (OraModIndex)table.getIndices().renew(ind.object_id, ind.index_name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)index2, (String)"index");
                        String string = ind.index_name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ind.index_name");
                        CharSequence charSequence = string;
                        Regex regex = OraIntrospectorFunctions.access$getSURROGATE_NAME_PATTERN$p();
                        boolean bl = regex.matches(charSequence);
                        oraModIndex.setNameSurrogate(bl || table.getTableType() == OraTableType.MAT_VIEW);
                        index2.setUnique(ind.uniqueness);
                        index2.setClustering(ind.clustering);
                        index2.setFunctionBased(ind.function_based);
                        index2.setBitmap(ind.bitmap);
                        index2.setTablespaceName(ind.tablespace_name);
                        OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(index2, ind.created_timestamp, ind.modified_timestamp);
                        if (this.this$0.getMode$intellij_database_dialects().fragment) {
                            index2.setColNames(CollectionsKt.emptyList());
                        }
                        OraSchemaRetriever.access$getTablesToReorderDetails$p(this.this$0).add(table);
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$indices = list;
                    super(1);
                }
            });
        }

        private final void retrieveIndicesColumns() {
            Object object;
            StringListAggregator stringListAggregator;
            String string;
            if (!this.affectsTables && !this.affectsMatViews) {
                return;
            }
            SqlQuery<List<OraIntroQueries.OneIndexItem>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveIndicesColumns;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveIndicesColumns");
            List<OraIntroQueries.OneIndexItem> ics = this.performQuery(sqlQuery);
            if (ics.isEmpty()) {
                return;
            }
            StringListAggregator columns = new StringListAggregator();
            boolean hasExpressions = false;
            for (OraIntroQueries.OneIndexItem ic : ics) {
                String key2 = ic.table_name + '\uffff' + ic.index_name;
                String string2 = ic.item;
                if (string2 == null) {
                    string2 = "???[" + ic.column_position + ']';
                }
                String item = string2;
                char c2 = ic.direction;
                string = key2;
                stringListAggregator = columns;
                String string3 = String.valueOf(c2) + item;
                stringListAggregator.add(string, string3);
                CharSequence charSequence = item;
                object = OraIntrospectorFunctions.access$getINDEX_EXPRESSION_STUB_PATTERN$p();
                boolean isExpression = object.matches(charSequence);
                hasExpressions = hasExpressions || isExpression;
            }
            if (hasExpressions) {
                SqlQuery<List<OraIntroQueries.OneIndexItem>> sqlQuery2 = ((OraIntrospector)OraIntrospector.this).queries.retrieveIndicesExpressions;
                Intrinsics.checkExpressionValueIsNotNull(sqlQuery2, (String)"queries.retrieveIndicesExpressions");
                List<OraIntroQueries.OneIndexItem> ies = this.performQuery(sqlQuery2);
                for (OraIntroQueries.OneIndexItem ie : ies) {
                    String key3 = ie.table_name + '\uffff' + ie.index_name;
                    short position = ie.column_position;
                    char c3 = ie.direction;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ie.item, (String)"ie.item");
                    int n = position - 1;
                    string = key3;
                    stringListAggregator = columns;
                    String string4 = String.valueOf(c3) + (String)object;
                    stringListAggregator.set(string, n, string4);
                }
            }
            this.inSchema((Function1)new Function1<OraModSchema, Unit>(this, columns){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ StringListAggregator $columns;

                public final void invoke(@NotNull OraModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    Map<K, CV> map = this.$columns.getResult();
                    Iterator<Map.Entry<K, CV>> iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        OraModIndex index2;
                        String indexName;
                        OraModTable table;
                        String tableName;
                        Map.Entry<K, CV> entry;
                        Map.Entry<K, CV> entry2 = entry = iterator.next();
                        String key2 = (String)entry2.getKey();
                        entry2 = entry;
                        List items = (List)entry2.getValue();
                        int d_pos = StringsKt.indexOf$default((CharSequence)key2, (char)'\uffff', (int)0, (boolean)false, (int)6, null);
                        if (d_pos < 0) continue;
                        String string = key2;
                        int n = 0;
                        String string2 = string;
                        if (string2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(n, d_pos), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        String string3 = key2;
                        int n2 = d_pos + 1;
                        String string4 = string3;
                        if (string4 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4.substring(n2), (String)"(this as java.lang.String).substring(startIndex)");
                        if ((OraModTable)schema.getTables().get(tableName) == null) {
                            continue;
                        }
                        if ((OraModIndex)table.getIndices().get(indexName) == null) {
                            continue;
                        }
                        OraSchemaRetriever.access$applyIndexingItems(this.this$0, table, index2, items);
                        OraSchemaRetriever.access$getTablesToReorderDetails$p(this.this$0).add(table);
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$columns = stringListAggregator;
                    super(1);
                }
            });
        }

        private final void applyIndexingItems(BasicTable table, OraModIndex index2, List<String> items) {
            int n = items.size();
            if (n == 0) {
                index2.setColNames(CollectionsKt.emptyList());
                index2.setReverseColNames(SetsKt.emptySet());
                return;
            }
            if (index2.isFunctionBased()) {
                ArrayList<String> expressions = new ArrayList<String>(n);
                TreeSet<String> reverse = new TreeSet<String>();
                PositioningNamingFamily positioningNamingFamily = table.getColumns();
                Intrinsics.checkExpressionValueIsNotNull((Object)positioningNamingFamily, (String)"table.columns");
                TreeSet tableColumnNames = new TreeSet(positioningNamingFamily.getNames());
                for (String item : items) {
                    String string;
                    if (item.length() < 2) continue;
                    String string2 = item;
                    int n2 = 1;
                    String string3 = string2;
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = string3.substring(n2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                    String c2 = OraIntrospectorFunctions.access$unquoteNameIfPossible(string4);
                    boolean isColumn = tableColumnNames.contains(c2);
                    if (isColumn) {
                        string = c2;
                    } else {
                        char c3 = '\u001b';
                        string = String.valueOf(c3) + c2;
                    }
                    String x = string;
                    expressions.add(x);
                    if (item.charAt(0) != '-') continue;
                    reverse.add(x);
                }
                index2.setColNames((List<String>)expressions);
                Collection collection = reverse;
                OraModIndex oraModIndex = index2;
                boolean bl = !collection.isEmpty();
                oraModIndex.setReverseColNames(bl ? (Set)reverse : SetsKt.emptySet());
            } else {
                ArrayList<String> columns = new ArrayList<String>(n);
                TreeSet<String> reverse = new TreeSet<String>();
                for (String item : items) {
                    String c4;
                    if (item.length() < 2) continue;
                    String string = item;
                    int n3 = 1;
                    String string5 = string;
                    if (string5 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5.substring(n3), (String)"(this as java.lang.String).substring(startIndex)");
                    columns.add(c4);
                    if (item.charAt(0) != '-') continue;
                    reverse.add(c4);
                }
                index2.setColNames((List<String>)columns);
                Collection collection = reverse;
                OraModIndex oraModIndex = index2;
                boolean bl = !collection.isEmpty();
                oraModIndex.setReverseColNames(bl ? (Set)reverse : SetsKt.emptySet());
            }
        }

        private final void retrieveKeys() {
            if (!this.affectsTables && !this.affectsMatViews) {
                return;
            }
            this.reportRetrieving("Keys");
            SqlQuery<List<OraIntroQueries.OneKey>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveKeys;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveKeys");
            List<OraIntroQueries.OneKey> keys = this.performQuery(sqlQuery);
            if (keys.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraModSchema, Unit>(keys){
                final /* synthetic */ List $keys;

                public final void invoke(@NotNull OraModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneKey k : this.$keys) {
                        OraModKey key2;
                        OraModTable table;
                        if (k.table_name == null || k.constraint_name == null) continue;
                        OraModTable oraModTable = table = (OraModTable)schema.getTables().createOrGet(k.table_name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraModTable, (String)"table");
                        OraModKey oraModKey = key2 = (OraModKey)oraModTable.getKeys().createOrGet(k.constraint_name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraModKey, (String)"key");
                        oraModKey.setColNames(CollectionsKt.emptyList());
                        key2.setNameSurrogate(k.is_surrogate_name);
                        key2.setPrimary(k.is_pk);
                        key2.setDeferrable(k.is_deferrable);
                        key2.setInitiallyDeferred(k.is_initially_deferred);
                        key2.setModifiedTimestamp(k.modified_timestamp);
                        key2.setUnderlyingIndexName(k.index_name);
                    }
                }
                {
                    this.$keys = list;
                    super(1);
                }
            });
        }

        private final void retrieveForeignKeys() {
            SqlQuery<List<OraIntroQueries.OneForeignKey>> query;
            if (!this.affectsTables) {
                return;
            }
            this.reportRetrieving("Foreign Keys");
            SqlQuery<List<OraIntroQueries.OneForeignKey>> sqlQuery = query = OraIntrospector.this.fast ? ((OraIntrospector)OraIntrospector.this).queries.retrieveForeignKeysFast : ((OraIntrospector)OraIntrospector.this).queries.retrieveForeignKeysSlow;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"query");
            List<OraIntroQueries.OneForeignKey> fks = this.performQuery(sqlQuery);
            if (fks.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraModSchema, Unit>(fks){
                final /* synthetic */ List $fks;

                public final void invoke(@NotNull OraModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    OraModRoot oraModRoot = schema.getParent();
                    Intrinsics.checkExpressionValueIsNotNull((Object)oraModRoot, (String)"schema.parent");
                    OraModRoot database = oraModRoot;
                    for (OraIntroQueries.OneForeignKey fk : this.$fks) {
                        CascadeRule cascadeRule;
                        OraModForeignKey fkey;
                        OraModTable table;
                        if ((fk.table_id > 0L ? (OraModTable)schema.getTables().getByObjectId(fk.table_id) : (OraModTable)schema.getTables().get(fk.table_name)) == null) {
                            continue;
                        }
                        table = table;
                        OraModForeignKey oraModForeignKey = fkey = (OraModForeignKey)table.getForeignKeys().createOrGet(fk.constraint_name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraModForeignKey, (String)"fkey");
                        oraModForeignKey.setColNames(CollectionsKt.emptyList());
                        String string = fk.ref_schema_name;
                        if (string == null) {
                            OraModSchema oraModSchema = (OraModSchema)database.getSchemas().getByObjectId(fk.ref_schema_id);
                            string = oraModSchema != null ? oraModSchema.getName() : null;
                        }
                        fkey.setRefSchemaName(string);
                        fkey.setRefTableName(fk.ref_table_name);
                        fkey.setRefKeyName(fk.ref_key_name);
                        fkey.setNameSurrogate(fk.is_surrogate_name);
                        fkey.setDeferrable(fk.is_deferrable);
                        fkey.setInitiallyDeferred(fk.is_initially_deferred);
                        switch (fk.cascade_rule) {
                            case 'C': {
                                cascadeRule = CascadeRule.cascade;
                                break;
                            }
                            case 'N': {
                                cascadeRule = CascadeRule.set_null;
                                break;
                            }
                            default: {
                                cascadeRule = CascadeRule.restrict;
                            }
                        }
                        fkey.setOnDelete(cascadeRule);
                        fkey.setModifiedTimestamp(fk.modified_timestamp);
                    }
                }
                {
                    this.$fks = list;
                    super(1);
                }
            });
        }

        private final void retrieveChecks() {
            if (!this.affectsTables) {
                return;
            }
            this.reportRetrieving("Check Constraints");
            SqlQuery<List<OraIntroQueries.OneCheck>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveChecks;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveChecks");
            List<OraIntroQueries.OneCheck> cks = this.performQuery(sqlQuery);
            if (cks.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraModSchema, Unit>(cks){
                final /* synthetic */ List $cks;

                public final void invoke(@NotNull OraModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneCheck ck : this.$cks) {
                        OraModCheck check;
                        OraModTable table;
                        if (ck.predicate == null) continue;
                        if (ck.is_surrogate_name) {
                            String string = ck.predicate;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ck.predicate");
                            CharSequence charSequence = string;
                            Regex regex = OraIntrospectorFunctions.access$getAUTO_NOT_NULL_CHECK_PATTERN$p();
                            if (regex.matches(charSequence)) continue;
                        }
                        OraModTable oraModTable = table = (OraModTable)schema.getTables().createOrGet(ck.table_name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraModTable, (String)"table");
                        OraModCheck oraModCheck = check = (OraModCheck)oraModTable.getChecks().createOrGet(ck.constraint_name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraModCheck, (String)"check");
                        oraModCheck.setColNames(CollectionsKt.emptyList());
                        check.setNameSurrogate(ck.is_surrogate_name);
                        check.setPredicate(ck.predicate);
                        check.setModifiedTimestamp(ck.modified_timestamp);
                    }
                }
                {
                    this.$cks = list;
                    super(1);
                }
            });
        }

        private final void retrieveConstraintColumns() {
            if (!this.affectsTables) {
                return;
            }
            SqlQuery<List<OraIntroQueries.OneConstraintColumn>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveConstraintColumns;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveConstraintColumns");
            List<OraIntroQueries.OneConstraintColumn> ccs = this.performQuery(sqlQuery);
            if (ccs.isEmpty()) {
                return;
            }
            StringListAggregator agg = new StringListAggregator();
            for (OraIntroQueries.OneConstraintColumn cc : ccs) {
                String key2 = cc.table_name + '\uffff' + cc.constraint_name;
                String string = cc.column_name;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"cc.column_name");
                agg.add(key2, string);
            }
            this.inSchema((Function1)new Function1<OraModSchema, Unit>(this, agg){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ StringListAggregator $agg;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull OraModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    Map<K, CV> map = this.$agg.getResult();
                    for (Map.Entry<K, CV> entry : map.entrySet()) {
                        OraModConstraint constraint;
                        OraModTable table;
                        void tableName;
                        Object object = entry;
                        String key2 = (String)object.getKey();
                        object = entry;
                        List colNames = (List)object.getValue();
                        Object object2 = StringFun.unPair(key2, '\uffff');
                        object = (String)object2.component1();
                        String constraintName = (String)object2.component2();
                        object2 = (CharSequence)tableName;
                        if (object2.length() == 0 || (object2 = (CharSequence)constraintName).length() == 0) continue;
                        if ((OraModTable)schema.getTables().get((String)tableName) == null) {
                            continue;
                        }
                        if (OraIntrospectorFunctions.access$findModConstraint(table, constraintName) == null) {
                            continue;
                        }
                        constraint.setColNames(colNames);
                        OraSchemaRetriever.access$getTablesToReorderDetails$p(this.this$0).add(table);
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$agg = stringListAggregator;
                    super(1);
                }
            });
        }

        private final void reorderTableDetails() {
            this.inSchema((Function1)new Function1<OraModSchema, Unit>(this){
                final /* synthetic */ OraSchemaRetriever this$0;

                public final void invoke(@NotNull OraModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (OraLikeTable table : OraSchemaRetriever.access$getTablesToReorderDetails$p(this.this$0)) {
                        OraLikeTable oraLikeTable = table;
                        if (oraLikeTable instanceof OraModTable) {
                            OraLikeTable oraLikeTable2 = table;
                            Intrinsics.checkExpressionValueIsNotNull((Object)oraLikeTable2, (String)"table");
                            ((OraModTable)oraLikeTable2).getColumns().sort();
                            ((OraModTable)table).getIndices().sort();
                            ((OraModTable)table).getKeys().sort();
                            ((OraModTable)table).getForeignKeys().sort();
                            ((OraModTable)table).getChecks().sort();
                            continue;
                        }
                        if (!(oraLikeTable instanceof OraModLikeTable)) continue;
                        OraLikeTable oraLikeTable3 = table;
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraLikeTable3, (String)"table");
                        ((OraModLikeTable)oraLikeTable3).getColumns().sort();
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    super(1);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveTriggers() {
            void also_retrieve_update_columns;
            if (!(this.affectsTables || this.affectsMatViews || this.affectsViews)) {
                return;
            }
            this.reportRetrieving("Triggers");
            SqlQuery<List<OraIntroQueries.OneTrigger>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveTriggers;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveTriggers");
            List<OraIntroQueries.OneTrigger> ts2 = this.performQuery(sqlQuery);
            if (ts2.isEmpty()) {
                return;
            }
            HashSet tables = new HashSet(ts2.size());
            Ref.BooleanRef booleanRef = new Ref.BooleanRef();
            booleanRef.element = false;
            this.inSchema((Function1)new Function1<OraModSchema, Unit>(this, ts2, (Ref.BooleanRef)also_retrieve_update_columns, tables){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $ts;
                final /* synthetic */ Ref.BooleanRef $also_retrieve_update_columns;
                final /* synthetic */ HashSet $tables;

                public final void invoke(@NotNull OraModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneTrigger trig : this.$ts) {
                        OraModLikeTable table;
                        OraModTrigger trigger;
                        String string = trig.table_name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"trig.table_name");
                        if (OraIntrospectorFunctions.access$findTableOrViewByName(schema, string) == null) {
                            continue;
                        }
                        OraModTrigger oraModTrigger = trigger = (OraModTrigger)table.getTriggers().renew(trig.trigger_id, trig.trigger_name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraModTrigger, (String)"trigger");
                        oraModTrigger.setEvents(TrigEvent.of((String)trig.events));
                        trigger.setTurn(OraSchemaRetriever.access$trigTurnOf(this.this$0, trig.turn));
                        OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(trigger, trig.created_timestamp, trig.modified_timestamp);
                        if (trigger instanceof OraModTableTrigger) {
                            ((OraModTableTrigger)trigger).setCondition(StringKt.nullize((String)trig.condition, (boolean)true));
                        }
                        this.$also_retrieve_update_columns.element |= trig.has_on_update_columns;
                        this.$tables.add(table);
                        OraSchemaRetriever.access$getAffectedDepObjects$p(this.this$0).add(trigger);
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$ts = list;
                    this.$also_retrieve_update_columns = booleanRef;
                    this.$tables = hashSet;
                    super(1);
                }
            });
            if (also_retrieve_update_columns.element) {
                SqlQuery<List<String[]>> sqlQuery2 = ((OraIntrospector)OraIntrospector.this).queries.retrieveTriggerUpdateColumns;
                Intrinsics.checkExpressionValueIsNotNull(sqlQuery2, (String)"queries.retrieveTriggerUpdateColumns");
                List<String[]> cols = this.performQuery(sqlQuery2);
                StringListAggregator columns = new StringListAggregator();
                for (String[] col : cols) {
                    String tableName = col[0];
                    String triggerName = col[1];
                    String columnName = col[2];
                    if (tableName == null || triggerName == null || columnName == null) continue;
                    String key2 = tableName + '\uffff' + triggerName;
                    columns.add(key2, columnName);
                }
                this.inSchema((Function1)new Function1<OraModSchema, Unit>(columns){
                    final /* synthetic */ StringListAggregator $columns;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull OraModSchema schema) {
                        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                        Map<K, CV> map = this.$columns.getResult();
                        for (Map.Entry<K, CV> entry : map.entrySet()) {
                            OraModTrigger trigger;
                            OraModLikeTable table;
                            void tableName;
                            Object object = entry;
                            String key2 = (String)object.getKey();
                            object = entry;
                            List names = (List)object.getValue();
                            Object object2 = StringFun.unPair(key2, '\uffff');
                            object = (String)object2.component1();
                            String triggerName = (String)object2.component2();
                            object2 = (CharSequence)tableName;
                            if (object2.length() == 0 || (object2 = (CharSequence)triggerName).length() == 0) continue;
                            if (OraIntrospectorFunctions.access$findTableOrViewByName(schema, (String)tableName) == null) {
                                continue;
                            }
                            if ((OraModTrigger)table.getTriggers().get(triggerName) == null) {
                                continue;
                            }
                            trigger.setColNames(names);
                        }
                    }
                    {
                        this.$columns = stringListAggregator;
                        super(1);
                    }
                });
            }
            this.inSchema((Function1)new Function1<OraModSchema, Unit>(tables){
                final /* synthetic */ HashSet $tables;

                public final void invoke(@NotNull OraModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    Iterator<E> iterator = this.$tables.iterator();
                    while (iterator.hasNext()) {
                        OraModLikeTable table;
                        OraModLikeTable oraModLikeTable = table = (OraModLikeTable)iterator.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraModLikeTable, (String)"table");
                        oraModLikeTable.getTriggers().sort();
                    }
                }
                {
                    this.$tables = hashSet;
                    super(1);
                }
            });
            this.affectsTriggers = true;
        }

        private final TrigTurn trigTurnOf(short turn) {
            TrigTurn trigTurn;
            switch (turn) {
                case -2: {
                    trigTurn = TrigTurn.BEFORE_STMT;
                    break;
                }
                case -1: {
                    trigTurn = TrigTurn.BEFORE_ROW;
                    break;
                }
                case 1: {
                    trigTurn = TrigTurn.AFTER_ROW;
                    break;
                }
                case 2: {
                    trigTurn = TrigTurn.AFTER_STMT;
                    break;
                }
                case 0: {
                    trigTurn = TrigTurn.INSTEAD_OF;
                    break;
                }
                default: {
                    trigTurn = null;
                }
            }
            return trigTurn;
        }

        private final void retrievePackages() {
            NamingIdentifyingFamily<? extends OraPackage> namingIdentifyingFamily = ((OraSchema)this.getSchema()).getPackages();
            Intrinsics.checkExpressionValueIsNotNull(namingIdentifyingFamily, (String)"schema.packages");
            if (namingIdentifyingFamily.isEmpty()) {
                return;
            }
            this.reportRetrieving("Packages");
            SqlQuery<List<OraIntroQueries.OnePackage>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrievePackages;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrievePackages");
            List<OraIntroQueries.OnePackage> packages = this.performQuery(sqlQuery);
            if (packages.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraModSchema, Unit>(this, packages){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $packages;

                public final void invoke(@NotNull OraModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (OraIntroQueries.OnePackage p2 : this.$packages) {
                        OraModPackageBody body2;
                        OraModPackage pack2;
                        if (!p2.is_body) {
                            OraModPackage oraModPackage = pack2 = (OraModPackage)schema.getPackages().renew(p2.object_id, p2.package_name);
                            Intrinsics.checkExpressionValueIsNotNull((Object)oraModPackage, (String)"pack");
                            oraModPackage.setInvalid(p2.is_invalid);
                            OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(pack2, p2.created_timestamp, p2.modified_timestamp);
                            OraSchemaRetriever.access$getAffectedModuleSpecs$p(this.this$0).add(pack2);
                            OraSchemaRetriever.access$getAffectedDepObjects$p(this.this$0).add(pack2);
                            continue;
                        }
                        OraModPackage oraModPackage = pack2 = (OraModPackage)schema.getPackages().createOrGet(p2.package_name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraModPackage, (String)"pack");
                        OraModPackageBody oraModPackageBody = body2 = (OraModPackageBody)oraModPackage.getBodies().createOrGet();
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraModPackageBody, (String)"body");
                        oraModPackageBody.setObjectId(p2.object_id);
                        body2.setInvalid(p2.is_invalid);
                        OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(body2, p2.created_timestamp, p2.modified_timestamp);
                        OraSchemaRetriever.access$getAffectedModuleBodies$p(this.this$0).add(body2);
                        OraSchemaRetriever.access$getAffectedDepObjects$p(this.this$0).add(body2);
                    }
                    schema.getPackages().sort();
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$packages = list;
                    super(1);
                }
            });
            this.affectsModulesOrBodies = true;
        }

        private final void retrieveInnerRoutines() {
            if (this.affectedModuleSpecs.isEmpty()) {
                return;
            }
            this.reportRetrieving("Inner procedures and functions");
            SqlQuery<List<OraIntroQueries.OneInnerRoutine>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveInnerRoutines;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveInnerRoutines");
            List<OraIntroQueries.OneInnerRoutine> routines = this.performQuery(sqlQuery);
            this.inSchema((Function1)new Function1<OraModSchema, Unit>(this, routines){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $routines;

                public final void invoke(@NotNull OraModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    Iterator<E> iterator = OraSchemaRetriever.access$getAffectedModuleSpecs$p(this.this$0).iterator();
                    while (iterator.hasNext()) {
                        OraModule module;
                        OraModule oraModule = module = (OraModule)iterator.next();
                        if (oraModule == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.dialects.oracle.model.OraModModule");
                        }
                        ((OraModModule)oraModule).getRoutines().markChildrenAsSyncPending();
                    }
                    for (OraIntroQueries.OneInnerRoutine r : this.$routines) {
                        OraModInnerRoutine routine;
                        OraModModule module = null;
                        if (r.module_kind == 'T' || r.module_kind == 'Z') {
                            module = (OraModModule)schema.getObjectTypes().get(r.module_name);
                        }
                        if (module == null && (r.module_kind == 'P' || r.module_kind == 'Z')) {
                            module = (OraModModule)schema.getPackages().get(r.module_name);
                        }
                        if (module == null) continue;
                        OraModInnerRoutine oraModInnerRoutine = routine = (OraModInnerRoutine)module.getRoutines().createOrGet(r.routine_name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraModInnerRoutine, (String)"routine");
                        oraModInnerRoutine.setDeterministic(r.is_deterministic);
                        OraSchemaRetriever.access$getAffectedInnerRoutines$p(this.this$0).add(routine);
                    }
                    boolean toReorder = OraIntrospector.access$getServerVersion$p(this.this$0.OraIntrospector.this).get(0) < 11;
                    Iterator<E> iterator2 = OraSchemaRetriever.access$getAffectedModuleSpecs$p(this.this$0).iterator();
                    while (iterator2.hasNext()) {
                        NamingFamily moduleRoutines;
                        OraModule module;
                        OraModule oraModule = module = (OraModule)iterator2.next();
                        if (oraModule == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.dialects.oracle.model.OraModModule");
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)((OraModModule)oraModule).getRoutines(), (String)"(module as OraModModule).routines");
                        moduleRoutines.removeSyncPendingChildren();
                        if (!toReorder) continue;
                        moduleRoutines.sort();
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$routines = list;
                    super(1);
                }
            });
        }

        private final void retrieveInnerRoutinesArguments() {
            if (this.affectedModuleSpecs.isEmpty()) {
                return;
            }
            this.reportRetrieving("Inner procedures and functions (arguments and result types)");
            List list = this.affectedModuleSpecs.stream().flatMap(retrieveInnerRoutinesArguments.oldAffectedRoutines.1.INSTANCE).map(retrieveInnerRoutinesArguments.oldAffectedRoutines.2.INSTANCE).collect(Collectors.toList());
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"affectedModuleSpecs.stre\u2026lect(Collectors.toList())");
            Iterable oldAffectedRoutines2 = list;
            SqlQuery<List<OraIntroQueries.OneInnerRoutineArgument>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveInnerRoutineArguments;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveInnerRoutineArguments");
            List<OraIntroQueries.OneInnerRoutineArgument> args2 = this.performQuery(sqlQuery);
            this.inSchema((Function1)new Function1<OraModSchema, Unit>(oldAffectedRoutines2, args2){
                final /* synthetic */ Iterable $oldAffectedRoutines;
                final /* synthetic */ List $args;

                public final void invoke(@NotNull OraModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (OraModRoutine r : this.$oldAffectedRoutines) {
                        r.getArguments().markChildrenAsSyncPending();
                    }
                    for (OraIntroQueries.OneInnerRoutineArgument a : this.$args) {
                        OraModInnerRoutine routine;
                        OraModModule m;
                        if (a.package_name == null || a.routine_name == null) continue;
                        String string = a.package_name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"a.package_name");
                        if (OraIntrospectorFunctions.access$findModuleByName(schema, string) == null) {
                            continue;
                        }
                        if ((OraModInnerRoutine)m.getRoutines().get(a.routine_name) == null) {
                            continue;
                        }
                        BasicSchema basicSchema = schema;
                        OraModRoutine oraModRoutine = routine;
                        short s = a.position;
                        String string2 = a.arg_name;
                        char c2 = a.arg_direction;
                        String string3 = a.data_type_schema_name;
                        String string4 = a.data_type_package_name;
                        String string5 = a.data_type;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"a.data_type");
                        OraIntrospectorFunctions.access$makeArgument(basicSchema, oraModRoutine, s, string2, c2, string3, string4, string5);
                    }
                    for (OraModRoutine r : this.$oldAffectedRoutines) {
                        r.getArguments().removeSyncPendingChildren();
                    }
                }
                {
                    this.$oldAffectedRoutines = iterable;
                    this.$args = list;
                    super(1);
                }
            });
        }

        private final void adjustInnerRoutines() {
            if (this.affectedInnerRoutines.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraModSchema, Unit>(this){
                final /* synthetic */ OraSchemaRetriever this$0;

                public final void invoke(@NotNull OraModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (BasicRoutine routine : OraSchemaRetriever.access$getAffectedInnerRoutines$p(this.this$0)) {
                        if (!(routine instanceof BasicModRoutine)) continue;
                        ((BasicModRoutine)routine).setRoutineKind(((BasicModRoutine)routine).getReturnArgument() == null ? DasRoutine.Kind.PROCEDURE : DasRoutine.Kind.FUNCTION);
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    super(1);
                }
            });
        }

        private final void retrieveSingleRoutines() {
            NamingIdentifyingFamily<? extends OraSingleRoutine> namingIdentifyingFamily = ((OraSchema)this.getSchema()).getRoutines();
            Intrinsics.checkExpressionValueIsNotNull(namingIdentifyingFamily, (String)"schema.routines");
            if (namingIdentifyingFamily.isEmpty()) {
                return;
            }
            this.reportRetrieving("Procedures and functions");
            SqlQuery<List<OraIntroQueries.OneSingleRoutine>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveSingleRoutines;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveSingleRoutines");
            List<OraIntroQueries.OneSingleRoutine> routines = this.performQuery(sqlQuery);
            if (routines.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraModSchema, Unit>(this, routines){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $routines;

                public final void invoke(@NotNull OraModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneSingleRoutine r : this.$routines) {
                        OraModSingleRoutine routine;
                        OraModSingleRoutine oraModSingleRoutine = routine = (OraModSingleRoutine)schema.getRoutines().renew(r.object_id, r.name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraModSingleRoutine, (String)"routine");
                        oraModSingleRoutine.setRoutineKind(DasRoutine.Kind.byChar((char)r.kind));
                        routine.setInvalid(r.is_invalid);
                        routine.setDeterministic(r.is_deterministic);
                        OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(routine, r.created_timestamp, r.modified_timestamp);
                        OraSchemaRetriever.access$getAffectedSingleRoutines$p(this.this$0).add(routine);
                        OraSchemaRetriever.access$getAffectedDepObjects$p(this.this$0).add(routine);
                    }
                    schema.getRoutines().sort();
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$routines = list;
                    super(1);
                }
            });
        }

        private final void retrieveSingleRoutinesArguments() {
            if (this.affectedSingleRoutines.isEmpty()) {
                return;
            }
            this.reportRetrieving("Procedures and functions (arguments and result types)");
            SqlQuery<List<OraIntroQueries.OneSingleRoutineArgument>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveSingleRoutineArguments;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveSingleRoutineArguments");
            List<OraIntroQueries.OneSingleRoutineArgument> args2 = this.performQuery(sqlQuery);
            this.inSchema((Function1)new Function1<OraModSchema, Unit>(this, args2){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $args;

                public final void invoke(@NotNull OraModSchema schema) {
                    BasicRoutine r;
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    Iterator<E> iterator = OraSchemaRetriever.access$getAffectedSingleRoutines$p(this.this$0).iterator();
                    while (iterator.hasNext()) {
                        BasicRoutine basicRoutine = r = (BasicRoutine)iterator.next();
                        if (basicRoutine == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.dialects.oracle.model.OraModRoutine");
                        }
                        ((OraModRoutine)basicRoutine).getArguments().markChildrenAsSyncPending();
                    }
                    for (OraIntroQueries.OneSingleRoutineArgument a : this.$args) {
                        OraModSingleRoutine routine;
                        if (a.routine_name == null) continue;
                        if ((OraModSingleRoutine)schema.getRoutines().get(a.routine_name) == null) {
                            continue;
                        }
                        BasicSchema basicSchema = schema;
                        OraModRoutine oraModRoutine = routine;
                        short s = a.position;
                        String string = a.arg_name;
                        char c2 = a.arg_direction;
                        String string2 = a.data_type_schema_name;
                        String string3 = a.data_type_package_name;
                        String string4 = a.data_type;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"a.data_type");
                        OraIntrospectorFunctions.access$makeArgument(basicSchema, oraModRoutine, s, string, c2, string2, string3, string4);
                    }
                    iterator = OraSchemaRetriever.access$getAffectedSingleRoutines$p(this.this$0).iterator();
                    while (iterator.hasNext()) {
                        BasicRoutine basicRoutine = r = (BasicRoutine)iterator.next();
                        if (basicRoutine == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.dialects.oracle.model.OraModRoutine");
                        }
                        ((OraModRoutine)basicRoutine).getArguments().removeSyncPendingChildren();
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$args = list;
                    super(1);
                }
            });
        }

        private final void retrieveComments() {
            long hash;
            NamingIdentifyingFamily<? extends OraTable> namingIdentifyingFamily = ((OraSchema)this.getSchema()).getTables();
            Intrinsics.checkExpressionValueIsNotNull(namingIdentifyingFamily, (String)"schema.tables");
            if (namingIdentifyingFamily.isEmpty()) {
                NamingIdentifyingFamily<? extends OraMatView> namingIdentifyingFamily2 = ((OraSchema)this.getSchema()).getMatViews();
                Intrinsics.checkExpressionValueIsNotNull(namingIdentifyingFamily2, (String)"schema.matViews");
                if (namingIdentifyingFamily2.isEmpty()) {
                    NamingIdentifyingFamily<? extends OraView> namingIdentifyingFamily3 = ((OraSchema)this.getSchema()).getViews();
                    Intrinsics.checkExpressionValueIsNotNull(namingIdentifyingFamily3, (String)"schema.views");
                    if (namingIdentifyingFamily3.isEmpty()) {
                        if (((OraSchema)this.getSchema()).getCommentsHash() != 0L) {
                            this.inSchema(retrieveComments.1.INSTANCE);
                        }
                        return;
                    }
                }
            }
            this.reportRetrieving("Comments");
            SqlQuery<Long> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.calculateCommentsHash;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.calculateCommentsHash");
            Long l = this.performQuery(sqlQuery);
            long l2 = hash = l != null ? l : 0L;
            if (hash == ((OraSchema)this.getSchema()).getCommentsHash()) {
                return;
            }
            SqlQuery<List<OraIntroQueries.OneComment>> sqlQuery2 = ((OraIntrospector)OraIntrospector.this).queries.retrieveComments;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery2, (String)"queries.retrieveComments");
            List<OraIntroQueries.OneComment> comments = this.performQuery(sqlQuery2);
            this.inSchema((Function1)new Function1<OraModSchema, Unit>(this, hash, comments){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ long $hash;
                final /* synthetic */ List $comments;

                public final void invoke(@NotNull OraModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    schema.setCommentsHash(this.this$0.getMode$intellij_database_dialects() == IntrospectionMode.FRAGMENT ? -1L : this.$hash);
                    HashSet<BasicModNamedElement> touched = new HashSet<BasicModNamedElement>();
                    for (OraIntroQueries.OneComment c2 : this.$comments) {
                        OraModLikeColumn column2;
                        OraModLikeTable table;
                        String string = c2.table_name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"c.table_name");
                        if (OraIntrospectorFunctions.access$findTableOrViewByName(schema, string) == null) {
                            continue;
                        }
                        if (c2.column_name == null) {
                            table.setComment(c2.comments);
                            touched.add(table);
                            continue;
                        }
                        if ((OraModLikeColumn)table.getColumns().get(c2.column_name) == null) {
                            continue;
                        }
                        column2.setComment(c2.comments);
                        touched.add(column2);
                    }
                    for (OraModLikeTable t : OraSchemaRetriever.access$seanceRelatedTablesAndViews(this.this$0, schema)) {
                        if (!touched.contains(t)) {
                            t.setComment(null);
                        }
                        for (OraModLikeColumn column3 : t.getColumns()) {
                            if (touched.contains(column3)) continue;
                            OraModLikeColumn oraModLikeColumn = column3;
                            Intrinsics.checkExpressionValueIsNotNull((Object)oraModLikeColumn, (String)"column");
                            oraModLikeColumn.setComment(null);
                        }
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$hash = l;
                    this.$comments = list;
                    super(1);
                }
            });
        }

        private final Iterable<OraModLikeTable> seanceRelatedTablesAndViews(OraModSchema schema) {
            if (this.getMode$intellij_database_dialects() == IntrospectionMode.FRAGMENT) {
                JBIterable jBIterable = JBIterable.empty().append((Iterable)JBIterable.from((Iterable)schema.getTables()).filter((Condition)new Condition<OraModTable>(this){
                    final /* synthetic */ OraSchemaRetriever this$0;

                    public final boolean value(OraModTable it) {
                        Object[] objectArray = this.this$0.getFragmentNames$intellij_database_dialects();
                        OraModTable oraModTable = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraModTable, (String)"it");
                        return ArraysKt.contains((Object[])objectArray, (Object)oraModTable.getName());
                    }
                    {
                        this.this$0 = oraSchemaRetriever;
                    }
                })).append((Iterable)JBIterable.from((Iterable)schema.getMatViews()).filter((Condition)new Condition<OraModMatView>(this){
                    final /* synthetic */ OraSchemaRetriever this$0;

                    public final boolean value(OraModMatView it) {
                        Object[] objectArray = this.this$0.getFragmentNames$intellij_database_dialects();
                        OraModMatView oraModMatView = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraModMatView, (String)"it");
                        return ArraysKt.contains((Object[])objectArray, (Object)oraModMatView.getName());
                    }
                    {
                        this.this$0 = oraSchemaRetriever;
                    }
                })).append((Iterable)JBIterable.from((Iterable)schema.getViews()).filter((Condition)new Condition<OraModView>(this){
                    final /* synthetic */ OraSchemaRetriever this$0;

                    public final boolean value(OraModView it) {
                        Object[] objectArray = this.this$0.getFragmentNames$intellij_database_dialects();
                        OraModView oraModView = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraModView, (String)"it");
                        return ArraysKt.contains((Object[])objectArray, (Object)oraModView.getName());
                    }
                    {
                        this.this$0 = oraSchemaRetriever;
                    }
                }));
                Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.empty<OraModL\u2026.name in fragmentNames })");
                return (Iterable)jBIterable;
            }
            JBIterable jBIterable = JBIterable.empty().append((Iterable)JBIterable.from((Iterable)schema.getTables())).append((Iterable)JBIterable.from((Iterable)schema.getMatViews())).append((Iterable)JBIterable.from((Iterable)schema.getViews()));
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.empty<OraModL\u2026rable.from(schema.views))");
            return (Iterable)jBIterable;
        }

        private final void retrieveDependencies() {
            if (this.affectedDepObjects.isEmpty()) {
                return;
            }
            if (Intrinsics.areEqual((Object)((OraSchema)this.getSchema()).getName(), (Object)"SYS") || Intrinsics.areEqual((Object)((OraSchema)this.getSchema()).getName(), (Object)"PUBLIC")) {
                return;
            }
            int methodCode = Registry.get((String)"database.introspection.oracle.dependencies.method").asInteger();
            switch (methodCode) {
                case 0: {
                    this.retrieveDependenciesNormally();
                    break;
                }
                case 1: {
                    this.retrieveDependenciesLowServerHighTraffic();
                    break;
                }
                default: {
                    this.skipDependencies();
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveDependenciesNormally() {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            SqlQuery<List<OraIntroQueries.OneDependency>> query;
            this.reportRetrieving("Dependencies");
            SqlQuery<List<OraIntroQueries.OneDependency>> sqlQuery = query = OraIntrospector.this.fast ? ((OraIntrospector)OraIntrospector.this).queries.retrieveDependenciesFast : ((OraIntrospector)OraIntrospector.this).queries.retrieveDependenciesSlow;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"query");
            List<OraIntroQueries.OneDependency> deps = this.performQuery(sqlQuery);
            if (deps.isEmpty()) {
                return;
            }
            List<OraIntroQueries.OneDependency> list = deps;
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"deps");
            Iterable iterable = $receiver$iv = (Iterable)list;
            Map destination$iv$iv = new LinkedHashMap();
            for (Object element$iv$iv : $receiver$iv$iv) {
                Object object;
                OraIntroQueries.OneDependency it = (OraIntroQueries.OneDependency)element$iv$iv;
                Map $receiver$iv$iv$iv = destination$iv$iv;
                Long key$iv$iv = it.object_id;
                Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    ArrayList answer$iv$iv$iv = new ArrayList();
                    $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                it = (OraIntroQueries.OneDependency)element$iv$iv;
                List list2 = list$iv$iv;
                Long l = it.referenced_id;
                list2.add(l);
            }
            Map g = destination$iv$iv;
            this.inSchema((Function1)new Function1<OraModSchema, Unit>(g){
                final /* synthetic */ Map $g;

                public final void invoke(@NotNull OraModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    BasicDatabase basicDatabase = schema.getDatabase();
                    if (basicDatabase == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.basic.BasicModDatabase");
                    }
                    BasicModDatabase db = (BasicModDatabase)basicDatabase;
                    Map map = this.$g;
                    for (Map.Entry<K, V> d2 : map.entrySet()) {
                        BasicIdentifiedElement o = db.findIdentifiedElement(((Number)d2.getKey()).longValue());
                        if (!(o instanceof OraModSourceAware) || ((OraModSourceAware)o).getSchema() != schema) continue;
                        BasicElement parent2 = ((OraModSourceAware)o).getDasParent();
                        BasicElement basicElement = parent2;
                        if (!(basicElement instanceof BasicIdentifiedElement)) {
                            basicElement = null;
                        }
                        BasicIdentifiedElement basicIdentifiedElement = (BasicIdentifiedElement)basicElement;
                        long parentId = basicIdentifiedElement != null ? basicIdentifiedElement.getObjectId() : Long.MIN_VALUE;
                        ((OraModSourceAware)o).setDependsOnIds(SetsKt.minus((Set)CollectionsKt.toSortedSet((Iterable)((Iterable)d2.getValue())), (Object)parentId));
                    }
                }
                {
                    this.$g = map;
                    super(1);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveDependenciesLowServerHighTraffic() {
            List list;
            Collection collection;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            SqlQuery<String[]> query;
            this.reportRetrieving("Dependencies (experimental method)");
            SqlQuery<String[]> sqlQuery = query = ((OraIntrospector)OraIntrospector.this).queries.retrieveDependenciesSlow2;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"query");
            String[] deps = this.performQuery(sqlQuery);
            Intrinsics.checkExpressionValueIsNotNull((Object)deps, (String)"deps");
            String[] stringArray = deps;
            if (stringArray.length == 0) {
                return;
            }
            String[] stringArray2 = deps;
            void var5_5 = $receiver$iv;
            Object destination$iv$iv = new ArrayList(((void)$receiver$iv).length);
            Iterator iterator = $receiver$iv$iv;
            int n = ((void)iterator).length;
            for (int j = 0; j < n; ++j) {
                void s;
                void item$iv$iv;
                void var11_13 = item$iv$iv = iterator[j];
                collection = destination$iv$iv;
                char[] cArray = new char[]{'\f'};
                boolean bl = false;
                int n2 = 4;
                list = StringsKt.split$default((CharSequence)((CharSequence)s), (char[])cArray, (boolean)bl, (int)n2, (int)2, null);
                collection.add(list);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new LinkedHashMap();
            iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object object;
                Object $receiver$iv$iv$iv = destination$iv$iv;
                Object element$iv$iv = iterator.next();
                List it = (List)element$iv$iv;
                String key$iv$iv = (String)it.get(0);
                Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    ArrayList answer$iv$iv$iv = new ArrayList();
                    $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                it = (List)element$iv$iv;
                collection = list$iv$iv;
                list = new Pair(it.get(1), it.get(2));
                collection.add(list);
            }
            Object g = destination$iv$iv;
            this.inSchema((Function1)new Function1<OraModSchema, Unit>((Map)g){
                final /* synthetic */ Map $g;

                public final void invoke(@NotNull OraModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    BasicDatabase basicDatabase = schema.getDatabase();
                    if (basicDatabase == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.basic.BasicModDatabase");
                    }
                    BasicModDatabase db = (BasicModDatabase)basicDatabase;
                    Map map = this.$g;
                    for (Map.Entry<K, V> d2 : map.entrySet()) {
                        BasicElement o = OraIntrospectorFunctions.access$findOracleObjectByStringTypeAndName(schema, (String)d2.getKey());
                        if (o == null || !(o instanceof OraModSourceAware)) continue;
                        List refIds = new ArrayList<E>(((List)d2.getValue()).size());
                        for (Pair pair : (List)d2.getValue()) {
                            BasicElement refObject;
                            BasicModSchema basicModSchema;
                            String refSchemaName = (String)pair.component1();
                            String refObjectKey = (String)pair.component2();
                            if (Intrinsics.areEqual((Object)refSchemaName, (Object)"@")) {
                                basicModSchema = schema;
                            } else {
                                basicModSchema = (BasicModSchema)db.getSchemas().get(refSchemaName);
                                if (basicModSchema == null) {
                                    continue;
                                }
                            }
                            BasicModSchema refSchema = basicModSchema;
                            if (OraIntrospectorFunctions.access$findOracleObjectByStringTypeAndName(refSchema, refObjectKey) == null) {
                                continue;
                            }
                            if (!(refObject instanceof BasicIdentifiedElement)) continue;
                            refIds.add(((BasicIdentifiedElement)refObject).getObjectId());
                        }
                        BasicElement parent2 = ((OraModSourceAware)o).getDasParent();
                        BasicElement basicElement = parent2;
                        if (!(basicElement instanceof BasicIdentifiedElement)) {
                            basicElement = null;
                        }
                        BasicIdentifiedElement basicIdentifiedElement = (BasicIdentifiedElement)basicElement;
                        long parentId = basicIdentifiedElement != null ? basicIdentifiedElement.getObjectId() : Long.MIN_VALUE;
                        ((OraModSourceAware)o).setDependsOnIds(SetsKt.minus((Set)CollectionsKt.toSet((Iterable)refIds), (Object)parentId));
                    }
                }
                {
                    this.$g = map;
                    super(1);
                }
            });
        }

        private final void skipDependencies() {
            this.reportRetrieving("Dependencies are skipped");
        }

        /*
         * Unable to fully structure code
         */
        private final void retrieveSources() {
            if (!this.getWithSources$intellij_database_dialects()) {
                return;
            }
            hV = ((OraSchema)this.getSchema()).getViews().hasChildren() != false || ((OraSchema)this.getSchema()).getMatViews().hasChildren() != false;
            hT = ModelFun.hasTriggers(this.getSchema());
            if (((OraSchema)this.getSchema()).getPackages().hasChildren() || ((OraSchema)this.getSchema()).getRoutines().hasChildren()) ** GOTO lbl-1000
            var4_3 = (BasicElement)this.getSchema();
            v0 = ObjectKind.OBJECT_TYPE;
            Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"OBJECT_TYPE");
            var5_4 = v0;
            v1 = ObjectKind.BODY;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"BODY");
            kindOfLevel2$iv = v1;
            v2 = $receiver$iv;
            if (v2 == null || (v2 = v2.familyOf((ObjectKind)kindOfLevel1$iv)) == null || (v2 = v2.jbi()) == null || (v2 = v2.flatten((Function)new Function<BasicElement, Iterable<? extends T>>(kindOfLevel2$iv){
                final /* synthetic */ ObjectKind $kindOfLevel2;
                {
                    this.$kindOfLevel2 = objectKind;
                }

                @NotNull
                public final JBIterable<? extends BasicElement> fun(BasicElement it) {
                    JBIterable jBIterable = it.familyOf(this.$kindOfLevel2);
                    if (jBIterable == null || (jBIterable = jBIterable.jbi()) == null) {
                        jBIterable = JBIterable.empty();
                    }
                    return jBIterable;
                }
            })) == null || (v2 = v2.filter(BasicElement.class)) == null) {
                v3 = JBIterable.empty();
                v2 = v3;
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"JBIterable.empty()");
            }
            if (v2.isNotEmpty()) lbl-1000:
            // 2 sources

            {
                v4 = true;
            } else {
                v4 = hP = false;
            }
            if (!(hV || hT || hP)) {
                return;
            }
            viewBodies = this.retrieveViewSources();
            triggerBodies = this.retrieveTriggerSources();
            programLines = this.retrieveProgramSources();
            obfuscations = this.retrieveObfuscatedSources();
            if (viewBodies.isEmpty() && triggerBodies.isEmpty() && programLines.isEmpty() && obfuscations.isEmpty()) {
                return;
            }
            this.reportRetrieving("applying sources");
            this_$iv = OraIntrospector.this;
            this_$iv.getModel().writeSources(new Runnable(this, viewBodies, triggerBodies, programLines, obfuscations){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ Collection $viewBodies$inlined;
                final /* synthetic */ Collection $triggerBodies$inlined;
                final /* synthetic */ Collection $programLines$inlined;
                final /* synthetic */ Collection $obfuscations$inlined;
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$viewBodies$inlined = collection;
                    this.$triggerBodies$inlined = collection2;
                    this.$programLines$inlined = collection3;
                    this.$obfuscations$inlined = collection4;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void run() {
                    Collection collection = this.$viewBodies$inlined;
                    if (!collection.isEmpty()) {
                        OraSchemaRetriever.access$inSchema(this.this$0, (Function1)new Function1<OraModSchema, Unit>(this){
                            final /* synthetic */ OraSchemaRetriever$retrieveSources$$inlined$writeSources$1 this$0;
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }

                            public final void invoke(@NotNull OraModSchema schema) {
                                Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                                for (OraIntroQueries.OneViewSource v : this.this$0.$viewBodies$inlined) {
                                    OraModView oraModView = (OraModView)schema.getViews().get(v.view_name);
                                    BasicModSourceAware view = oraModView != null ? (BasicModSourceAware)oraModView : (BasicModSourceAware)schema.getMatViews().get(v.view_name);
                                    if (view == null) continue;
                                    OraIntrospectorFunctions.access$applyViewSources(view, v.text);
                                }
                            }
                        });
                    }
                    if (!(collection = this.$triggerBodies$inlined).isEmpty()) {
                        OraSchemaRetriever.access$inSchema(this.this$0, (Function1)new Function1<OraModSchema, Unit>(this){
                            final /* synthetic */ OraSchemaRetriever$retrieveSources$$inlined$writeSources$1 this$0;
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }

                            public final void invoke(@NotNull OraModSchema schema) {
                                Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                                for (OraIntroQueries.OneTriggerSource trig : this.this$0.$triggerBodies$inlined) {
                                    OraModTrigger trigger;
                                    OraModLikeTable table;
                                    String string = trig.table_name;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"trig.table_name");
                                    if (OraIntrospectorFunctions.access$findTableOrViewByName(schema, string) == null) {
                                        continue;
                                    }
                                    if ((OraModTrigger)table.getTriggers().get(trig.trigger_name) == null) {
                                        continue;
                                    }
                                    String text2 = trig.trigger_body;
                                    trigger.setSourceText(text2 != null ? (CompositeText)new SimpleCompositeText(text2, CompositeText.Kind.ORIGINAL_TEXT) : null);
                                }
                            }
                        });
                    }
                    if (!(collection = this.$programLines$inlined).isEmpty()) {
                        void theName;
                        void theType;
                        collection = new Ref.ObjectRef();
                        ((Ref.ObjectRef)collection).element = "";
                        Ref.ObjectRef objectRef = new Ref.ObjectRef();
                        objectRef.element = "";
                        StringBuilder buf = new StringBuilder();
                        OraSchemaRetriever.access$inSchema(this.this$0, (Function1)new Function1<OraModSchema, Unit>((Ref.ObjectRef)theType, (Ref.ObjectRef)theName, buf, this){
                            final /* synthetic */ Ref.ObjectRef $theType;
                            final /* synthetic */ Ref.ObjectRef $theName;
                            final /* synthetic */ StringBuilder $buf;
                            final /* synthetic */ OraSchemaRetriever$retrieveSources$$inlined$writeSources$1 this$0;
                            {
                                this.$theType = objectRef;
                                this.$theName = objectRef2;
                                this.$buf = stringBuilder;
                                this.this$0 = var4_4;
                                super(1);
                            }

                            public final void invoke(@NotNull OraModSchema schema) {
                                Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                                for (OraIntroQueries.OneSrcLine line : this.this$0.$programLines$inlined) {
                                    boolean theSame;
                                    boolean bl = theSame = Intrinsics.areEqual((Object)((String)this.$theType.element), (Object)line.type) && Intrinsics.areEqual((Object)((String)this.$theName.element), (Object)line.name);
                                    if (!theSame) {
                                        OraSchemaRetriever oraSchemaRetriever = this.this$0.this$0;
                                        String string = (String)this.$theType.element;
                                        String string2 = (String)this.$theName.element;
                                        String string3 = this.$buf.toString();
                                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"buf.toString()");
                                        OraSchemaRetriever.access$applySources(oraSchemaRetriever, schema, string, string2, string3);
                                        Intrinsics.checkExpressionValueIsNotNull((Object)line.type, (String)"line.type");
                                        this.$theType.element = this.$theType.element;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)line.name, (String)"line.name");
                                        this.$theName.element = this.$theName.element;
                                        this.$buf.delete(0, this.$buf.length());
                                    }
                                    this.$buf.append(line.text);
                                }
                                OraSchemaRetriever oraSchemaRetriever = this.this$0.this$0;
                                String string = (String)this.$theType.element;
                                String string4 = (String)this.$theName.element;
                                String string5 = this.$buf.toString();
                                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"buf.toString()");
                                OraSchemaRetriever.access$applySources(oraSchemaRetriever, schema, string, string4, string5);
                            }
                        });
                    }
                    if (!(collection = this.$obfuscations$inlined).isEmpty()) {
                        OraSchemaRetriever.access$inSchema(this.this$0, (Function1)new Function1<OraModSchema, Unit>(this){
                            final /* synthetic */ OraSchemaRetriever$retrieveSources$$inlined$writeSources$1 this$0;
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final void invoke(@NotNull OraModSchema schema) {
                                Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                                for (OraIntroQueries.OneObfuscatedSrc o : this.this$0.$obfuscations$inlined) {
                                    if (o.type == null) ** GOTO lbl-1000
                                    tmp = -1;
                                    switch (var4_4.hashCode()) {
                                        case 1691390643: {
                                            if (!var4_4.equals("PROCEDURE")) break;
                                            tmp = 1;
                                            break;
                                        }
                                        case -89079770: {
                                            if (!var4_4.equals("PACKAGE")) break;
                                            tmp = 2;
                                            break;
                                        }
                                        case -1018163512: {
                                            if (!var4_4.equals("TYPE BODY")) break;
                                            tmp = 3;
                                            break;
                                        }
                                        case 2590522: {
                                            if (!var4_4.equals("TYPE")) break;
                                            tmp = 4;
                                            break;
                                        }
                                        case 411142492: {
                                            if (!var4_4.equals("PACKAGE BODY")) break;
                                            tmp = 5;
                                            break;
                                        }
                                        case -2131401768: {
                                            if (!var4_4.equals("FUNCTION")) break;
                                            tmp = 1;
                                            break;
                                        }
                                    }
                                    switch (tmp) {
                                        case 4: {
                                            v0 = (OraModSourceAware)schema.getObjectTypes().get(o.name);
                                            break;
                                        }
                                        case 3: {
                                            v1 = (OraModObjectType)schema.getObjectTypes().get(o.name);
                                            v0 = v1 != null && (v1 = v1.getBodies()) != null ? (OraModObjectTypeBody)v1.get() : null;
                                            break;
                                        }
                                        case 2: {
                                            v0 = (OraModSourceAware)schema.getPackages().get(o.name);
                                            break;
                                        }
                                        case 5: {
                                            v2 = (OraModPackage)schema.getPackages().get(o.name);
                                            v0 = v2 != null && (v2 = v2.getBodies()) != null ? (OraModPackageBody)v2.get() : null;
                                            break;
                                        }
                                        case 1: {
                                            v0 = (OraModSourceAware)schema.getRoutines().get(o.name);
                                            break;
                                        }
                                        default: lbl-1000:
                                        // 2 sources

                                        {
                                            v0 = null;
                                        }
                                    }
                                    if ((sourceAware = v0) == null) continue;
                                    sourceAware.setSourceText(null);
                                    sourceAware.setObfuscated(true);
                                }
                            }
                        });
                    }
                }
            });
        }

        private final void applySources(@NotNull OraModSchema $receiver, String type, String name, String sourceText) {
            OraModSourceAware oraModSourceAware;
            CharSequence charSequence = sourceText;
            if (charSequence.length() == 0) {
                return;
            }
            switch (type) {
                case "TYPE": {
                    Object e = $receiver.getObjectTypes().createOrGet(name);
                    Intrinsics.checkExpressionValueIsNotNull(e, (String)"this.objectTypes.createOrGet(name)");
                    oraModSourceAware = (OraModSourceAware)e;
                    break;
                }
                case "TYPE BODY": {
                    Object e = $receiver.getObjectTypes().createOrGet(name);
                    Intrinsics.checkExpressionValueIsNotNull(e, (String)"this.objectTypes.createOrGet(name)");
                    Object e2 = ((OraModObjectType)e).getBodies().createOrGet();
                    Intrinsics.checkExpressionValueIsNotNull(e2, (String)"this.objectTypes.createO\u2026ame).bodies.createOrGet()");
                    oraModSourceAware = (OraModSourceAware)e2;
                    break;
                }
                case "PACKAGE": {
                    Object e = $receiver.getPackages().createOrGet(name);
                    Intrinsics.checkExpressionValueIsNotNull(e, (String)"this.packages.createOrGet(name)");
                    oraModSourceAware = (OraModSourceAware)e;
                    break;
                }
                case "PACKAGE BODY": {
                    Object e = $receiver.getPackages().createOrGet(name);
                    Intrinsics.checkExpressionValueIsNotNull(e, (String)"this.packages.createOrGet(name)");
                    Object e3 = ((OraModPackage)e).getBodies().createOrGet();
                    Intrinsics.checkExpressionValueIsNotNull(e3, (String)"this.packages.createOrGe\u2026ame).bodies.createOrGet()");
                    oraModSourceAware = (OraModSourceAware)e3;
                    break;
                }
                case "PROCEDURE": 
                case "FUNCTION": {
                    Object e = $receiver.getRoutines().createOrGet(name);
                    Intrinsics.checkExpressionValueIsNotNull(e, (String)"this.routines.createOrGet(name)");
                    oraModSourceAware = (OraModSourceAware)e;
                    break;
                }
                default: {
                    return;
                }
            }
            OraModSourceAware sourceAware = oraModSourceAware;
            OraIntrospectorFunctions.access$applyStoredProgramSources(sourceAware, sourceText);
            if (sourceAware instanceof OraModPackage) {
                this.extractPackageChildren((OraModPackage)sourceAware, "CREATE " + sourceText);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void extractPackageChildren(OraModPackage pkg, String text2) {
            SqlStatement sqlStatement;
            void this_$iv;
            Object it = BaseIntrospectionFunctions.cleanupFamilies.1.INSTANCE;
            NamingFamily namingFamily = pkg.getAliasTypes();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily, (String)"pkg.aliasTypes");
            it.invoke((Object)namingFamily);
            NamingFamily namingFamily2 = pkg.getCollectionTypes();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily2, (String)"pkg.collectionTypes");
            it.invoke((Object)namingFamily2);
            PositioningNamingFamily positioningNamingFamily = pkg.getVariables();
            Intrinsics.checkExpressionValueIsNotNull((Object)positioningNamingFamily, (String)"pkg.variables");
            it.invoke((Object)positioningNamingFamily);
            NamingFamily namingFamily3 = pkg.getExceptions();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily3, (String)"pkg.exceptions");
            it.invoke((Object)namingFamily3);
            it = this;
            String src$iv = text2;
            try {
                IntrospectorSqlHelper this_$iv$iv = this_$iv.OraIntrospector.this.getSqlHelper();
                sqlStatement = (SqlStatement)this_$iv$iv.statements(src$iv, SqlCreateStatement.class).first();
            }
            catch (Exception e$iv) {
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                if (application.isUnitTestMode()) {
                    this_$iv.OraIntrospector.this.getLog().error((Throwable)e$iv);
                }
                this_$iv.OraIntrospector.this.getLog().warn("Failed to parse sources", (Throwable)e$iv);
                sqlStatement = null;
            }
            SqlCreateStatement statement = (SqlCreateStatement)sqlStatement;
            if (statement == null || Intrinsics.areEqual((Object)statement.getKind(), (Object)ObjectKind.PACKAGE) ^ true) {
                return;
            }
            short vc = (short)0;
            Iterator iterator = statement.getDasChildren(null).iterator();
            while (iterator.hasNext()) {
                ModNamingFamily family;
                DasObject child;
                DasObject dasObject = child = (DasObject)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)dasObject, (String)"child");
                ObjectKind $i$f$parseStatement = dasObject.getKind();
                if ((Intrinsics.areEqual((Object)$i$f$parseStatement, (Object)ObjectKind.VARIABLE) ? (ModNamingFamily)((Object)pkg.getVariables()) : (Intrinsics.areEqual((Object)$i$f$parseStatement, (Object)ObjectKind.EXCEPTION) ? pkg.getExceptions() : (Intrinsics.areEqual((Object)$i$f$parseStatement, (Object)ObjectKind.OBJECT_TYPE) ? pkg.getAliasTypes() : (Intrinsics.areEqual((Object)$i$f$parseStatement, (Object)ObjectKind.COLLECTION_TYPE) ? pkg.getCollectionTypes() : null)))) == null) {
                    continue;
                }
                family = family;
                Object obj = family.createOrGet(child.getName());
                OraIntrospector.this.getSqlHelper().getBuilder().build((DasObject)obj, child);
                if (!(obj instanceof OraModVariable)) continue;
                vc = (short)(vc + 1);
                ((OraModVariable)obj).setPosition(vc);
            }
            Function1 it2 = BaseIntrospectionFunctions.cleanupFamilies.2.INSTANCE;
            NamingFamily namingFamily4 = pkg.getAliasTypes();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily4, (String)"pkg.aliasTypes");
            it2.invoke((Object)namingFamily4);
            NamingFamily namingFamily5 = pkg.getCollectionTypes();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily5, (String)"pkg.collectionTypes");
            it2.invoke((Object)namingFamily5);
            PositioningNamingFamily positioningNamingFamily2 = pkg.getVariables();
            Intrinsics.checkExpressionValueIsNotNull((Object)positioningNamingFamily2, (String)"pkg.variables");
            it2.invoke((Object)positioningNamingFamily2);
            NamingFamily namingFamily6 = pkg.getExceptions();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily6, (String)"pkg.exceptions");
            it2.invoke((Object)namingFamily6);
        }

        private final Collection<OraIntroQueries.OneViewSource> retrieveViewSources() {
            Collection views;
            if (this.affectsMatViews || this.affectsViews) {
                this.reportRetrieving("View Sources");
                SqlQuery<List<OraIntroQueries.OneViewSource>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveViewSources;
                Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveViewSources");
                views = this.performQuery(sqlQuery);
            } else {
                views = SetsKt.emptySet();
            }
            return views;
        }

        private final Collection<OraIntroQueries.OneTriggerSource> retrieveTriggerSources() {
            Collection triggers;
            if (this.affectsTables || this.affectsMatViews || this.affectsViews) {
                this.reportRetrieving("Trigger Sources");
                SqlQuery<List<OraIntroQueries.OneTriggerSource>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveTriggerSources;
                Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveTriggerSources");
                triggers = this.performQuery(sqlQuery);
            } else {
                triggers = SetsKt.emptySet();
            }
            return triggers;
        }

        private final Collection<OraIntroQueries.OneSrcLine> retrieveProgramSources() {
            Collection lines;
            Collection collection;
            if (this.affectsModulesOrBodies || !(collection = (Collection)this.affectedSingleRoutines).isEmpty() || this.affectsTriggers) {
                this.reportRetrieving("Procedures and Functions Sources");
                this.setQueryParameter$intellij_database_dialects("source_line_width_limit", this.getSourceLineWidthLimit());
                SqlQuery<List<OraIntroQueries.OneSrcLine>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveSources;
                Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveSources");
                lines = this.performQuery(sqlQuery);
            } else {
                lines = SetsKt.emptySet();
            }
            return lines;
        }

        private final int getSourceLineWidthLimit() {
            RegistryValue registryValue = Registry.get((String)"database.introspection.oracle.source.line.limit");
            Intrinsics.checkExpressionValueIsNotNull((Object)registryValue, (String)"Registry.get(\"database.i\u2026racle.source.line.limit\")");
            RegistryValue limitRegVal = registryValue;
            int limit = limitRegVal.asInteger();
            if (limit == 0) {
                limit = 4000;
            }
            if (limit > 4000) {
                limit = 4000;
            }
            if (limit < 80) {
                limit = 80;
            }
            return limit;
        }

        private final Collection<OraIntroQueries.OneObfuscatedSrc> retrieveObfuscatedSources() {
            Collection collection;
            if (this.affectsModulesOrBodies || !(collection = (Collection)this.affectedSingleRoutines).isEmpty() || this.affectsTriggers) {
                this.reportRetrieving("Obfuscated Procedures and Functions");
                SqlQuery<List<OraIntroQueries.OneObfuscatedSrc>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.listObfuscatedSources;
                Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.listObfuscatedSources");
                List<OraIntroQueries.OneObfuscatedSrc> list = this.performQuery(sqlQuery);
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"performQuery(queries.listObfuscatedSources)");
                return list;
            }
            return CollectionsKt.emptyList();
        }

        private final void retrieveSynonyms() {
            this.reportRetrieving("Synonyms");
            SqlQuery<List<OraIntroQueries.OneSynonym>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveFragmentSynonyms;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveFragmentSynonyms");
            List<OraIntroQueries.OneSynonym> ss = this.performQuery(sqlQuery);
            if (ss.isEmpty()) {
                return;
            }
            this.inModel((Function1)new Function1<OraModRoot, Unit>(ss){
                final /* synthetic */ List $ss;

                public final void invoke(@NotNull OraModRoot root2) {
                    Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                    List list = this.$ss;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"ss");
                    OraIntrospectorFunctions.access$processSynonyms(list, root2);
                }
                {
                    this.$ss = list;
                    super(1);
                }
            });
        }

        private final void retrieveErrors() {
            SqlQuery<long[]> invalidObjectsQuery;
            this.reportRetrieving("Statuses and Errors");
            SqlQuery<long[]> sqlQuery = invalidObjectsQuery = OraIntrospector.this.fast ? ((OraIntrospector)OraIntrospector.this).queries.listInvalidObjectsFast : ((OraIntrospector)OraIntrospector.this).queries.listInvalidObjectsSlow;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"invalidObjectsQuery");
            long[] invalidObjectsAr = this.performQuery(sqlQuery);
            TLongHashSet invalids = new TLongHashSet(invalidObjectsAr);
            this.inSchema((Function1)new Function1<OraModSchema, Unit>(this, invalids){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ TLongHashSet $invalids;

                public final void invoke(@NotNull OraModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    NamingIdentifyingFamily namingIdentifyingFamily = schema.getObjectTypes();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.objectTypes");
                    OraSchemaRetriever.access$updateInvalidStatus(this.this$0, namingIdentifyingFamily, this.$invalids);
                    NamingIdentifyingFamily namingIdentifyingFamily2 = schema.getPackages();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily2, (String)"schema.packages");
                    OraSchemaRetriever.access$updateInvalidStatus(this.this$0, namingIdentifyingFamily2, this.$invalids);
                    NamingIdentifyingFamily namingIdentifyingFamily3 = schema.getRoutines();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily3, (String)"schema.routines");
                    OraSchemaRetriever.access$updateInvalidStatus(this.this$0, namingIdentifyingFamily3, this.$invalids);
                    NamingIdentifyingFamily namingIdentifyingFamily4 = schema.getTables();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily4, (String)"schema.tables");
                    OraSchemaRetriever.access$updateInvalidStatus(this.this$0, namingIdentifyingFamily4, this.$invalids);
                    NamingIdentifyingFamily namingIdentifyingFamily5 = schema.getViews();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily5, (String)"schema.views");
                    OraSchemaRetriever.access$updateInvalidStatus(this.this$0, namingIdentifyingFamily5, this.$invalids);
                    NamingIdentifyingFamily namingIdentifyingFamily6 = schema.getSynonyms();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily6, (String)"schema.synonyms");
                    OraSchemaRetriever.access$updateInvalidStatus(this.this$0, namingIdentifyingFamily6, this.$invalids);
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$invalids = tLongHashSet;
                    super(1);
                }
            });
            if (invalids.isEmpty()) {
                return;
            }
            SqlQuery<List<OraIntroQueries.OneError>> sqlQuery2 = ((OraIntrospector)OraIntrospector.this).queries.retrieveErrors;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery2, (String)"queries.retrieveErrors");
            List<OraIntroQueries.OneError> errs = this.performQuery(sqlQuery2);
            if (errs.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraModSchema, Unit>(errs){
                final /* synthetic */ List $errs;

                public final void invoke(@NotNull OraModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    MultiMap map = new MultiMap();
                    for (OraIntroQueries.OneError err : this.$errs) {
                        BasicModSourceAware src = null;
                        switch (err.type_code) {
                            case 'R': {
                                src = (BasicModSourceAware)schema.getRoutines().get(err.name);
                                break;
                            }
                            case 'V': {
                                src = (BasicModSourceAware)schema.getViews().get(err.name);
                                break;
                            }
                            case 'T': {
                                OraModObjectType m = (OraModObjectType)schema.getObjectTypes().get(err.name);
                                if (m == null) break;
                                src = err.is_body ? (BasicModSourceAware)m.getBodies().get() : (BasicModSourceAware)m;
                                break;
                            }
                            case 'P': {
                                OraModPackage p2 = (OraModPackage)schema.getPackages().get(err.name);
                                if (p2 == null) break;
                                src = err.is_body ? (BasicModSourceAware)p2.getBodies().get() : (BasicModSourceAware)p2;
                                break;
                            }
                            case 'G': {
                                String string = err.name;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"err.name");
                                src = OraIntrospectorFunctions.access$findTrigger(schema, string);
                            }
                        }
                        if (src == null) continue;
                        SourceError error2 = SourceError.of(err.line, err.position, err.message);
                        map.putValue((Object)src, (Object)error2);
                    }
                    Iterator<E> iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry;
                        Map.Entry entry2 = entry = (Map.Entry)iterator.next();
                        BasicModSourceAware key2 = (BasicModSourceAware)entry2.getKey();
                        entry2 = entry;
                        Collection value = (Collection)entry2.getValue();
                        BasicModSourceAware basicModSourceAware = key2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)basicModSourceAware, (String)"key");
                        basicModSourceAware.setErrors((List)ImmutableList.copyOf((Collection)value));
                    }
                }
                {
                    this.$errs = list;
                    super(1);
                }
            });
        }

        private final void updateInvalidStatus(Iterable<? extends BasicModElement> family, TLongHashSet invalids) {
            for (BasicModElement basicModElement : family) {
                BasicModElement basicModElement2;
                if (basicModElement instanceof BasicModSourceAware && basicModElement instanceof BasicIdentifiedElement) {
                    boolean invalid = invalids.contains(((BasicIdentifiedElement)((Object)basicModElement)).getObjectId());
                    ((BasicModSourceAware)basicModElement).setInvalid(invalid);
                    if (!invalid) {
                        ((BasicModSourceAware)basicModElement).setErrors(ModelConsts.NO_ERRORS);
                    }
                }
                if ((basicModElement2 = basicModElement) instanceof OraModLikeTable) {
                    NamingIdentifyingFamily namingIdentifyingFamily = ((OraModLikeTable)basicModElement).getTriggers();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"e.triggers");
                    this.updateInvalidStatus(namingIdentifyingFamily, invalids);
                    continue;
                }
                if (basicModElement2 instanceof OraModObjectType) {
                    SingletonFamily singletonFamily = ((OraModObjectType)basicModElement).getBodies();
                    Intrinsics.checkExpressionValueIsNotNull((Object)singletonFamily, (String)"e.bodies");
                    this.updateInvalidStatus(singletonFamily, invalids);
                    continue;
                }
                if (!(basicModElement2 instanceof OraModPackage)) continue;
                SingletonFamily singletonFamily = ((OraModPackage)basicModElement).getBodies();
                Intrinsics.checkExpressionValueIsNotNull((Object)singletonFamily, (String)"e.bodies");
                this.updateInvalidStatus(singletonFamily, invalids);
            }
        }

        private final <T extends SqlStatement> T parseStatement(String src) {
            try {
                IntrospectorSqlHelper this_$iv = OraIntrospector.this.getSqlHelper();
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return (T)((SqlStatement)this_$iv.statements(src, Object.class).first());
            }
            catch (Exception e) {
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                if (application.isUnitTestMode()) {
                    OraIntrospector.this.getLog().error((Throwable)e);
                }
                OraIntrospector.this.getLog().warn("Failed to parse sources", (Throwable)e);
                return null;
            }
        }

        @Override
        protected void reportRetrieving(@NotNull String what) {
            Intrinsics.checkParameterIsNotNull((Object)what, (String)"what");
            String modeStr = this.getMode$intellij_database_dialects().increment ? "incrementally" : "completely";
            String string = String.format("Introspecting schema %s (%s)", ((OraSchema)this.getSchema()).getName(), modeStr);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"format(\"Introspecting sc\u2026)\", schema.name, modeStr)");
            OraIntrospector.this.updateStatus(string, what);
        }

        public OraSchemaRetriever(@NotNull DBTransaction transaction, OraSchema schema) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            super((BaseIntrospector)OraIntrospector.this, transaction, (BasicSchema)schema);
            this.myFromTimestamp = BaseIntrospectionFunctions.AGES_AGO;
            this.tablesToReorderDetails = new HashSet();
            this.affectedClusters = new HashSet();
            this.affectedModuleSpecs = new HashSet();
            this.affectedModuleBodies = new HashSet();
            this.affectedInnerRoutines = new HashSet();
            this.affectedSingleRoutines = new HashSet();
            this.affectedDepObjects = new HashSet();
            this.affectedTables = new HashSet();
        }

        @NotNull
        public static final /* synthetic */ OraModModel access$getModel$p(OraSchemaRetriever $this) {
            return (OraModModel)$this.getModel();
        }

        @Nullable
        public static final /* synthetic */ BigInteger access$adjustBigIntegerForSequence(OraSchemaRetriever $this, @Nullable BigDecimal bigDecimalValue) {
            return $this.adjustBigIntegerForSequence(bigDecimalValue);
        }

        @NotNull
        public static final /* synthetic */ HashSet access$getAffectedModuleBodies$p(OraSchemaRetriever $this) {
            return $this.affectedModuleBodies;
        }

        @NotNull
        public static final /* synthetic */ HashSet access$getAffectedDepObjects$p(OraSchemaRetriever $this) {
            return $this.affectedDepObjects;
        }

        @NotNull
        public static final /* synthetic */ HashSet access$getAffectedModuleSpecs$p(OraSchemaRetriever $this) {
            return $this.affectedModuleSpecs;
        }

        public static final /* synthetic */ void access$applyClusterInfo(OraSchemaRetriever $this, @NotNull OraModCluster cluster, @NotNull OraIntroQueries.OneCluster c2) {
            $this.applyClusterInfo(cluster, c2);
        }

        @NotNull
        public static final /* synthetic */ HashSet access$getAffectedClusters$p(OraSchemaRetriever $this) {
            return $this.affectedClusters;
        }

        @NotNull
        public static final /* synthetic */ HashSet access$getAffectedTables$p(OraSchemaRetriever $this) {
            return $this.affectedTables;
        }

        @NotNull
        public static final /* synthetic */ HashSet access$getTablesToReorderDetails$p(OraSchemaRetriever $this) {
            return $this.tablesToReorderDetails;
        }

        public static final /* synthetic */ void access$applyIndexingItems(OraSchemaRetriever $this, @NotNull BasicTable table, @NotNull OraModIndex index2, @NotNull List items) {
            $this.applyIndexingItems(table, index2, items);
        }

        @Nullable
        public static final /* synthetic */ TrigTurn access$trigTurnOf(OraSchemaRetriever $this, short turn) {
            return $this.trigTurnOf(turn);
        }

        @NotNull
        public static final /* synthetic */ HashSet access$getAffectedInnerRoutines$p(OraSchemaRetriever $this) {
            return $this.affectedInnerRoutines;
        }

        @NotNull
        public static final /* synthetic */ HashSet access$getAffectedSingleRoutines$p(OraSchemaRetriever $this) {
            return $this.affectedSingleRoutines;
        }

        @NotNull
        public static final /* synthetic */ Iterable access$seanceRelatedTablesAndViews(OraSchemaRetriever $this, @NotNull OraModSchema schema) {
            return $this.seanceRelatedTablesAndViews(schema);
        }

        public static final /* synthetic */ void access$inSchema(OraSchemaRetriever $this, @NotNull Function1 modifier) {
            $this.inSchema(modifier);
        }

        public static final /* synthetic */ void access$applySources(OraSchemaRetriever $this, @NotNull OraModSchema $receiver, @NotNull String type, @NotNull String name, @NotNull String sourceText) {
            $this.applySources($receiver, type, name, sourceText);
        }

        public static final /* synthetic */ void access$updateInvalidStatus(OraSchemaRetriever $this, @NotNull Iterable family, @NotNull TLongHashSet invalids) {
            $this.updateInvalidStatus(family, invalids);
        }
    }
}

