/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.schemaEditor.model.DeForeignKey;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorUtil;
import com.intellij.database.view.editors.DatabaseForeignKeyEditor;
import com.intellij.database.view.editors.DatabaseTableEditor;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.models.ForeignKeyEditorModel;
import com.intellij.database.view.models.ObjectEditorModel;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.database.view.ui.TableEditorToolbarsDecorator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import javax.swing.JComponent;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseTableForeignKeysEditor
extends DatabaseTableEditor.TabProvider {
    private final DatabaseEditorUtil.DbListTableWithEditor myTable;
    private final DatabaseTableEditor myTableEditor;
    private final DatabaseEditorCapabilities.TableEditorCaps myCaps;
    private final ListTableModel<DatabaseForeignKeyEditor> myForeignKeysModel;
    private final JComponent myTablePanel;

    public DatabaseTableForeignKeysEditor(@NotNull DatabaseTableEditor tableEditor, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps, @NotNull TableEditorToolbarsDecorator toolbarsDecorator) {
        if (tableEditor == null) {
            DatabaseTableForeignKeysEditor.$$$reportNull$$$0(0);
        }
        if (caps == null) {
            DatabaseTableForeignKeysEditor.$$$reportNull$$$0(1);
        }
        if (toolbarsDecorator == null) {
            DatabaseTableForeignKeysEditor.$$$reportNull$$$0(2);
        }
        this.myTableEditor = tableEditor;
        this.myCaps = caps;
        this.myForeignKeysModel = DatabaseEditorUtil.createTableModel(this.getTableModel(), new DatabaseEditorUtil.EditorModelHelper<DatabaseForeignKeyEditor>(){

            @Override
            @Nullable
            public DatabaseForeignKeyEditor createRow() {
                if (!DatabaseTableForeignKeysEditor.this.myCaps.getForeignKeys().canAdd()) {
                    return null;
                }
                DeForeignKey fk = DatabaseTableForeignKeysEditor.this.getTableModel().createForeignKey(new DeForeignKey.Ref[0]);
                DatabaseTableForeignKeysEditor.this.getTableModel().addForeignKey(fk);
                return DatabaseTableForeignKeysEditor.this.createForeignKeyEditor(fk);
            }

            @Override
            public boolean removeRow(DatabaseForeignKeyEditor item, int idx) {
                if (!DatabaseTableForeignKeysEditor.this.myCaps.getForeignKeys().canRemove()) {
                    return false;
                }
                DeForeignKey fk = (DeForeignKey)((ObjectEditorModel)item.getModel()).getObject();
                DatabaseTableForeignKeysEditor.this.getTableModel().removeForeignKey(fk);
                Disposer.dispose((Disposable)item);
                return true;
            }
        }, false);
        this.myTable = DatabaseEditorUtil.createTableWithEditor(this.myForeignKeysModel, this.myTableEditor, 15, JBUI.scale((int)500), null);
        this.myTable.getTable().getEmptyText().setText("No foreign keys");
        ToolbarDecorator decorator = toolbarsDecorator.decorateForeignKeys(caps, tableEditor, (JTable)this.myTable.getTable());
        this.myTablePanel = decorator.createPanel();
        DatabaseEditorUtil.setTableDecoratorMinSize(this.myTablePanel, (JTable)this.myTable.getTable());
        this.myTablePanel.setBorder(this.myTableEditor.getTabComponentBorder());
    }

    @Override
    public void configure(@NotNull DatabaseEditorCapabilities.TableEditorCaps caps) {
        if (caps == null) {
            DatabaseTableForeignKeysEditor.$$$reportNull$$$0(3);
        }
        this.setTabEnabled(caps.getForeignKeys().isSupported());
    }

    @Override
    @Nullable
    public DatabaseForeignKeyEditor startItemEditing(@NotNull DeObject fk) {
        if (fk == null) {
            DatabaseTableForeignKeysEditor.$$$reportNull$$$0(4);
        }
        return DatabaseEditorUtil.startItemEditing(fk, this.myTable, this.myForeignKeysModel);
    }

    @Override
    public boolean isMyObject(@NotNull DeObject object) {
        if (object == null) {
            DatabaseTableForeignKeysEditor.$$$reportNull$$$0(5);
        }
        return object instanceof DeForeignKey;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myTablePanel;
        if (jComponent == null) {
            DatabaseTableForeignKeysEditor.$$$reportNull$$$0(6);
        }
        return jComponent;
    }

    @NotNull
    public TableEditorModel getTableModel() {
        TableEditorModel tableEditorModel = this.myTableEditor.getTableModel();
        if (tableEditorModel == null) {
            DatabaseTableForeignKeysEditor.$$$reportNull$$$0(7);
        }
        return tableEditorModel;
    }

    @NotNull
    private DatabaseForeignKeyEditor createForeignKeyEditor(@NotNull DeForeignKey fk) {
        if (fk == null) {
            DatabaseTableForeignKeysEditor.$$$reportNull$$$0(8);
        }
        DatabaseForeignKeyEditor editor = new DatabaseForeignKeyEditor(this.myTableEditor.getState(), this.getTableModel().modelsCache.get(fk, ForeignKeyEditorModel.class), this.myCaps.getForeignKeyCaps(fk.getEditedObject() != null));
        Disposer.register((Disposable)this.myTableEditor, (Disposable)editor);
        editor.getForeignKeyModel().addListener(new EditorModelBase.Listener(){

            @Override
            public void changed() {
                DatabaseTableForeignKeysEditor.this.myTableEditor.fromModelToUi();
            }
        }, this.myTableEditor);
        DatabaseForeignKeyEditor databaseForeignKeyEditor = editor;
        if (databaseForeignKeyEditor == null) {
            DatabaseTableForeignKeysEditor.$$$reportNull$$$0(9);
        }
        return databaseForeignKeyEditor;
    }

    @Override
    public void updateFromModel() {
        DatabaseEditorUtil.cleanupEditors(this.myForeignKeysModel, this.getTableModel().getForeignKeys(), this::createForeignKeyEditor);
        this.myTable.getTable().repaint();
    }

    @NotNull
    public DeTable getTable() {
        DeTable deTable = (DeTable)this.getTableModel().getObject();
        if (deTable == null) {
            DatabaseTableForeignKeysEditor.$$$reportNull$$$0(10);
        }
        return deTable;
    }

    @Override
    @NotNull
    public String getTabTitle() {
        int count2 = this.getTableModel().getForeignKeysCount();
        String string = "Foreign Keys" + (count2 == 0 ? "" : " (" + count2 + ")");
        if (string == null) {
            DatabaseTableForeignKeysEditor.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public ListTableModel<DatabaseForeignKeyEditor> getForeignKeysListModel() {
        ListTableModel<DatabaseForeignKeyEditor> listTableModel = this.myForeignKeysModel;
        if (listTableModel == null) {
            DatabaseTableForeignKeysEditor.$$$reportNull$$$0(12);
        }
        return listTableModel;
    }

    @Override
    @Nullable
    public DatabaseEditorBaseEx getActiveEditor() {
        return DatabaseEditorUtil.getEditedItem(this.myTable, this.myForeignKeysModel);
    }

    @NotNull
    public DatabaseEditorCapabilities.ListCapability getCaps() {
        DatabaseEditorCapabilities.ListCapability listCapability = this.myCaps.getForeignKeys();
        if (listCapability == null) {
            DatabaseTableForeignKeysEditor.$$$reportNull$$$0(13);
        }
        return listCapability;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableEditor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caps";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolbarsDecorator";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fk";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/editors/DatabaseTableForeignKeysEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/editors/DatabaseTableForeignKeysEditor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableModel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createForeignKeyEditor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTable";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabTitle";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getForeignKeysListModel";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaps";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "configure";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "startItemEditing";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isMyObject";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createForeignKeyEditor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

