/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.dataSource.DatabaseArtifactManager;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverListener;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.validation.DatabaseDriverValidator;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.SimpleColoredRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.table.TableView;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import com.intellij.util.ui.classpath.SimpleClasspathElementFactory;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DriverClasspathPanel
implements Disposable {
    @NotNull
    private final Project myProject;
    @Nullable
    private final LocalDataSource myDataSource;
    private final Configurable myConfigurable;
    @Nullable
    private DatabaseDriver myDriver;
    @NotNull
    private final DatabaseConfigEditor myController;
    private TableView<ClassPathItem> myArtifactList;
    private MyUserActivityPanel myArtifactsPanel;
    private Runnable onUpdate;
    private ListTableModel<ClassPathItem> myArtifactsModel;

    public DriverClasspathPanel(@NotNull Project project, @NotNull Configurable configurable, @Nullable DatabaseDriver driver, @Nullable LocalDataSource dataSource, @NotNull DatabaseConfigEditor controller) {
        if (project == null) {
            DriverClasspathPanel.$$$reportNull$$$0(0);
        }
        if (configurable == null) {
            DriverClasspathPanel.$$$reportNull$$$0(1);
        }
        if (controller == null) {
            DriverClasspathPanel.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myConfigurable = configurable;
        this.myDriver = driver;
        this.myDataSource = dataSource;
        this.myController = controller;
        DatabaseDriverManager.getInstance().addDriverListener(new DatabaseDriverListener.Adapter(){

            @Override
            public void driverUpdated(DatabaseDriver driver) {
                if (driver == DriverClasspathPanel.this.myDriver) {
                    DriverClasspathPanel.this.updateClasspath();
                    DriverClasspathPanel.this.providedChanged();
                    DriverClasspathPanel.this.fireUserActivity();
                }
            }
        }, this);
    }

    private void providedChanged() {
        int i2 = this.myArtifactsModel.indexOf((Object)this.getProvided());
        if (i2 == -1) {
            this.myArtifactsModel.fireTableDataChanged();
        } else {
            this.myArtifactsModel.fireTableRowsUpdated(i2, i2);
        }
    }

    public void dispose() {
    }

    private void fireUserActivity() {
        ((ChangeListener)this.myArtifactsPanel.myDispatcher.getMulticaster()).stateChanged(this.myArtifactsPanel.myEvent);
    }

    public void setDriver(@Nullable DatabaseDriver driver) {
        this.myDriver = driver;
        this.updateClasspath();
        this.providedChanged();
    }

    public void setOnUpdate(Runnable onUpdate) {
        this.onUpdate = onUpdate;
    }

    public JComponent createComponent() {
        this.myArtifactsPanel = new MyUserActivityPanel();
        this.myArtifactsModel = new ListTableModel((ColumnInfo[])ContainerUtil.ar((Object[])new 2[]{new ColumnInfo<ClassPathItem, ClassPathItem>(""){
            MyProvidedEditor myProvidedEditor;
            MyProvidedRenderer myProvidedRenderer;
            TableCellRenderer mySimpleRenderer;
            {
                this.myProvidedEditor = new MyProvidedEditor();
                this.myProvidedRenderer = new MyProvidedRenderer();
                this.mySimpleRenderer = new MySimpleRenderer();
            }

            @Nullable
            public ClassPathItem valueOf(ClassPathItem o) {
                return o;
            }

            public boolean isCellEditable(ClassPathItem item) {
                return this.isProvided(item);
            }

            private boolean isProvided(ClassPathItem item) {
                return item instanceof ProvidedItem;
            }

            @Nullable
            public TableCellRenderer getRenderer(ClassPathItem item) {
                return this.isProvided(item) ? this.myProvidedRenderer : this.mySimpleRenderer;
            }

            @Nullable
            public TableCellEditor getEditor(ClassPathItem item) {
                return this.isProvided(item) ? this.myProvidedEditor : null;
            }
        }}));
        this.myArtifactsModel.addTableModelListener(e -> this.onUpdateClasspath());
        this.myArtifactList = new TableView<ClassPathItem>(this.myArtifactsModel){

            public String getToolTipText(@NotNull MouseEvent event) {
                int row;
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                ProvidedItem item = (row = this.rowAtPoint(event.getPoint())) == -1 ? null : (ProvidedItem)ObjectUtils.tryCast((Object)DriverClasspathPanel.this.myArtifactsModel.getItem(row), ProvidedItem.class);
                return item == null ? null : item.getToolTipText();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/view/ui/DriverClasspathPanel$3", "getToolTipText"));
            }
        };
        this.myArtifactList.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                DriverClasspathPanel.this.myArtifactList.repaint();
            }
        });
        this.myArtifactList.setShowGrid(false);
        this.myArtifactList.getEmptyText().setText("No driver files");
        this.myArtifactList.setPreferredScrollableViewportSize(new Dimension(JBUI.scale((int)100), JBUI.scale((int)100)));
        JPanel artifactsListPanel = ToolbarDecorator.createDecorator(this.myArtifactList).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<Boolean>(null, new Boolean[]{true, false}){

                    @NotNull
                    public String getTextFor(Boolean value) {
                        String string = Boolean.TRUE.equals(value) ? "Custom JARs..." : "Provided Driver";
                        if (string == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    public boolean hasSubstep(Boolean selectedValue) {
                        return Boolean.FALSE.equals(selectedValue);
                    }

                    public Icon getIconFor(Boolean value) {
                        return Boolean.TRUE.equals(value) ? AllIcons.FileTypes.Archive : AllIcons.Modules.Library;
                    }

                    public PopupStep onChosen(Boolean selectedValue, boolean finalChoice) {
                        if (selectedValue == null) {
                            return FINAL_CHOICE;
                        }
                        if (!selectedValue.booleanValue()) {
                            return new ArtifactsPopupStep();
                        }
                        this.doFinalStep(() -> DriverClasspathPanel.this.addCustomDrivers());
                        return FINAL_CHOICE;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DriverClasspathPanel$5$1", "getTextFor"));
                    }
                });
                RelativePoint pref = button.getPreferredPopupPoint();
                if (pref != null) {
                    popup.show(pref);
                } else {
                    popup.showInBestPositionFor(button.getDataContext());
                }
            }
        }).createPanel();
        DatabaseArtifactManager.getInstance().addListener((name, version) -> {
            ProvidedItem provided = this.getProvided();
            if (provided == null || name != null && (!Comparing.equal((String)name, (String)provided.artifact) || !Comparing.equal((String)version, (String)provided.version))) {
                return;
            }
            this.onUpdateClasspath();
            this.providedChanged();
        }, this);
        artifactsListPanel.setAlignmentX(0.0f);
        TitledSeparator providedSep = new TitledSeparator("Driver files");
        providedSep.setAlignmentX(0.0f);
        this.myArtifactsPanel.add((Component)providedSep);
        this.myArtifactsPanel.add(artifactsListPanel);
        this.myArtifactsPanel.add(Box.createVerticalStrut(5));
        return this.myArtifactsPanel;
    }

    private void downloadImpl(final @NotNull String artifactName, final @NotNull String version) {
        if (artifactName == null) {
            DriverClasspathPanel.$$$reportNull$$$0(3);
        }
        if (version == null) {
            DriverClasspathPanel.$$$reportNull$$$0(4);
        }
        new Task.Backgroundable(this.myProject, "Downloading " + artifactName, true, PerformInBackgroundOption.DEAF){

            public void run(@NotNull ProgressIndicator indicator) {
                String realVersion;
                if (indicator == null) {
                    6.$$$reportNull$$$0(0);
                }
                DatabaseArtifactManager.DatabaseArtifactList artifacts = DatabaseArtifactManager.getArtifacts();
                String string = realVersion = version.equals("latest") ? artifacts.getActualVersion(artifactName) : version;
                if (realVersion == null) {
                    return;
                }
                try {
                    Consumer uiUpdate = version -> {
                        ProvidedItem provided = DriverClasspathPanel.this.getProvided();
                        if (provided != null) {
                            provided.update(provided.artifact, (String)version, provided.rolling, provided.legacy);
                        }
                        DriverClasspathPanel.this.providedChanged();
                        DriverClasspathPanel.this.onUpdateClasspath();
                        DriverClasspathPanel.this.fireUserActivity();
                    };
                    if (artifacts.isValid(artifactName, realVersion)) {
                        ApplicationManager.getApplication().invokeLater(() -> uiUpdate.consume((Object)realVersion));
                    } else {
                        DatabaseArtifactManager.getInstance().downloadArtifact(artifactName, version, (Consumer<DownloadableFileSetDescription>)((Consumer)o -> uiUpdate.consume((Object)o.getVersionString())));
                    }
                }
                catch (IOException e) {
                    ApplicationManager.getApplication().invokeLater(() -> DriverClasspathPanel.this.myController.showErrorNotification(DriverClasspathPanel.this.myConfigurable, (Object)this, e));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/view/ui/DriverClasspathPanel$6", "run"));
            }
        }.queue();
    }

    private void doChooseFiles(@NotNull Consumer<List<VirtualFile>> consumer2) {
        if (consumer2 == null) {
            DriverClasspathPanel.$$$reportNull$$$0(5);
        }
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, true, true, false, true){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return super.isFileVisible(file, showHiddenFiles) && file.isDirectory() || file.getFileType() == FileTypes.ARCHIVE;
            }
        };
        descriptor.setTitle("Select Database Driver Files");
        File dir = new File(DatabaseDriverImpl.getDownloadPath());
        try {
            FileUtil.ensureExists((File)dir);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        VirtualFile toSelect = VfsUtil.findFileByIoFile((File)dir, (boolean)true);
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)this.myProject, (Component)this.myArtifactsPanel, (VirtualFile)toSelect, consumer2);
    }

    public void updateClasspath() {
        ArrayList items = ContainerUtil.newArrayList();
        if (this.myDataSource != null) {
            if (this.myArtifactsModel.getRowCount() == 0) {
                for (SimpleClasspathElement cp : this.myDataSource.getOwnClasspath()) {
                    items.add(new SimpleItem(cp));
                }
            } else {
                items.addAll(this.myArtifactsModel.getItems());
            }
        } else if (this.myDriver != null) {
            DatabaseDriver.ArtifactRef artifact = this.myDriver.getArtifact();
            if (artifact != null && artifact.isUsed()) {
                List<SimpleClasspathElement> cp = ((DatabaseDriverImpl)this.myDriver).getArtifactClasspathElements();
                items.add(new ProvidedItem(artifact.getName(), artifact.getVersion(), artifact.isRolling(), cp));
            }
            for (SimpleClasspathElement element2 : this.myDriver.getAdditionalClasspathElements()) {
                items.add(new SimpleItem(element2));
            }
        }
        this.myArtifactsModel.setItems((List)items);
        this.onUpdateClasspath();
    }

    private void onUpdateClasspath() {
        if (this.onUpdate != null) {
            this.onUpdate.run();
        }
    }

    public List<SimpleClasspathElement> getClasspath() {
        TableModel artifactListModel = this.myArtifactList.getModel();
        ArrayList<SimpleClasspathElement> fileList = new ArrayList<SimpleClasspathElement>();
        for (int i2 = 0; i2 < artifactListModel.getRowCount(); ++i2) {
            SimpleItem item = (SimpleItem)ObjectUtils.tryCast((Object)artifactListModel.getValueAt(i2, 0), SimpleItem.class);
            if (item == null) continue;
            fileList.add(item.element);
        }
        return fileList;
    }

    public List<SimpleClasspathElement> getClasspathFull() {
        List<SimpleClasspathElement> classpath = this.getClasspath();
        ProvidedItem provided = this.getProvided();
        if (provided != null) {
            if (provided.version == null) {
                classpath.addAll(provided.legacy);
            } else {
                classpath.addAll(DatabaseArtifactManager.getClasspathElements(provided.artifact, (String)ObjectUtils.chooseNotNull((Object)provided.version, (Object)"latest")));
            }
        }
        return classpath;
    }

    @Nullable
    public String getArtifactName() {
        ProvidedItem provided = this.getProvided();
        if (provided != null) {
            return provided.artifact;
        }
        DatabaseDriver.ArtifactRef artifact = this.myDriver == null ? null : this.myDriver.getArtifact();
        return artifact == null ? null : artifact.getName();
    }

    @Nullable
    public String getArtifactVersion() {
        ProvidedItem provided = this.getProvided();
        if (provided != null) {
            return provided.version;
        }
        DatabaseDriver.ArtifactRef artifact = this.myDriver == null ? null : this.myDriver.getArtifact();
        return artifact == null ? null : artifact.getVersion();
    }

    public boolean isUseArtifact() {
        ProvidedItem provided = this.getProvided();
        return provided != null;
    }

    public boolean isRolling() {
        ProvidedItem provided = this.getProvided();
        if (provided != null) {
            return provided.rolling;
        }
        DatabaseDriver.ArtifactRef artifact = this.myDriver == null ? null : this.myDriver.getArtifact();
        return artifact != null && artifact.isRolling();
    }

    @Nullable
    private ProvidedItem getProvided() {
        return (ProvidedItem)JBIterable.from((Iterable)this.myArtifactList.getItems()).filter(ProvidedItem.class).first();
    }

    private void addCustomDrivers() {
        this.doChooseFiles((Consumer<List<VirtualFile>>)((Consumer)files -> {
            for (VirtualFile file : files) {
                for (SimpleClasspathElement cpe : SimpleClasspathElementFactory.createElements((String[])new String[]{file.getUrl()})) {
                    this.myArtifactsModel.addRow((Object)new SimpleItem(cpe));
                }
            }
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/view/ui/DriverClasspathPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "downloadImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "doChooseFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class VersionsPopupStep
    extends BaseListPopupStep<String> {
        VersionsPopupStep(String artifact) {
            super(null, VersionsPopupStep.getVersions(artifact));
        }

        @NotNull
        private static List<String> getVersions(String artifact) {
            List list = JBIterable.of((Object)"latest").append((Iterable)JBIterable.from(DatabaseArtifactManager.getArtifacts().getArtifacts(artifact)).transform(DownloadableFileSetDescription::getVersionString)).toList();
            if (list == null) {
                VersionsPopupStep.$$$reportNull$$$0(0);
            }
            return list;
        }

        @NotNull
        public String getTextFor(String value) {
            String string = "latest".equals(value) ? "Latest version" : value;
            if (string == null) {
                VersionsPopupStep.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/view/ui/DriverClasspathPanel$VersionsPopupStep";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVersions";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextFor";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private class ArtifactsPopupStep
    extends BaseListPopupStep<String> {
        private final String myPredef;

        ArtifactsPopupStep() {
            super(null, (Object[])new String[0]);
            this.getValues().addAll(DatabaseArtifactManager.getArtifacts().getArtifactNames());
            this.getValues().sort(StringUtil::naturalCompare);
            String string = this.myPredef = DriverClasspathPanel.this.myDriver == null ? null : DatabaseDriverManager.getInstance().getPredefinedArtifact(DriverClasspathPanel.this.myDriver.getId());
            if (this.myPredef != null) {
                this.getValues().remove(this.myPredef);
                this.getValues().add(0, this.myPredef);
            }
        }

        @Nullable
        public ListSeparator getSeparatorAbove(String value) {
            List values2 = this.getValues();
            return this.myPredef != null && values2.size() > 1 && Comparing.equal((String)value, (String)((String)values2.get(1))) ? new ListSeparator() : null;
        }

        public boolean hasSubstep(String selectedValue) {
            return true;
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        public PopupStep onChosen(final String artifact, boolean finalChoice) {
            if (artifact == null) {
                return FINAL_CHOICE;
            }
            return new VersionsPopupStep(artifact){

                public PopupStep onChosen(String v, boolean finalChoice) {
                    if (v == null) {
                        return FINAL_CHOICE;
                    }
                    boolean rolling = "latest".equals(v);
                    String version = rolling ? DatabaseArtifactManager.getArtifacts().getActualVersion(artifact) : v;
                    DriverClasspathPanel.this.fireUserActivity();
                    ProvidedItem provided = DriverClasspathPanel.this.getProvided();
                    if (provided != null) {
                        provided.update(artifact, version, rolling, null);
                    } else {
                        provided = new ProvidedItem(artifact, version, rolling, null);
                        DriverClasspathPanel.this.myArtifactsModel.addRow((Object)provided);
                    }
                    DriverClasspathPanel.this.downloadImpl(provided.artifact, provided.version);
                    return FINAL_CHOICE;
                }
            };
        }
    }

    private class MyProvidedRenderer
    implements TableCellRenderer {
        private final JComponent myComponent = new Box(0){

            @Override
            public void validate() {
                this.sendMouseMove(MyProvidedRenderer.this.myVersionLink);
                this.sendMouseMove(MyProvidedRenderer.this.myFixLink);
                this.sendMouseMove(MyProvidedRenderer.this.myLicenseLink);
                super.validate();
            }

            private void sendMouseMove(LinkLabel<?> link) {
                Point pos = MouseInfo.getPointerInfo().getLocation();
                SwingUtilities.convertPointFromScreen(pos, link);
                MouseEvent e = new MouseEvent((Component)link, 503, System.currentTimeMillis(), 0, pos.x, pos.y, 0, false);
                link.dispatchEvent((AWTEvent)e);
            }
        };
        private final SimpleColoredRenderer myColored = new SimpleColoredRenderer();
        private final LinkLabel<ProvidedItem> myVersionLink = new MyLinkLabel<ProvidedItem>("ver.");
        private final LinkLabel<ProvidedItem> myFixLink = new MyLinkLabel<ProvidedItem>("");
        private final LinkLabel<ProvidedItem> myLicenseLink = new MyLinkLabel<ProvidedItem>("Show License");
        private boolean mySelected;

        private MyProvidedRenderer() {
            this.myComponent.setOpaque(true);
            this.myComponent.add((Component)this.myColored);
            this.myComponent.add(Box.createHorizontalStrut(10));
            this.myComponent.add((Component)this.myVersionLink);
            this.myComponent.add(Box.createHorizontalGlue());
            this.myComponent.add((Component)this.myFixLink);
            this.myComponent.add(Box.createHorizontalStrut(20));
            this.myComponent.add((Component)this.myLicenseLink);
            this.myComponent.add(Box.createHorizontalStrut(10));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column2) {
            this.mySelected = isSelected;
            this.myColored.clear();
            this.myColored.acquireState(table, isSelected, false, row, column2);
            this.myColored.getCellState().updateRenderer(this.myComponent);
            ProvidedItem item = (ProvidedItem)ObjectUtils.tryCast((Object)value, ProvidedItem.class);
            if (item != null) {
                this.myColored.append(item.artifact, item.invalid ? SimpleTextAttributes.ERROR_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                this.myColored.setIcon(PlatformIcons.LIBRARY_ICON);
                this.myVersionLink.setVisible(item.version != null);
                this.myVersionLink.setText("ver. " + item.version + (item.rolling ? " [latest]" : ""));
                this.myVersionLink.setListener(this::switchVersion, (Object)item);
                String actual = DatabaseArtifactManager.getArtifacts().getActualVersion(item.artifact);
                this.myFixLink.setVisible(item.invalid || item.needUpdate);
                this.myFixLink.setText((item.actualDownloaded ? "Switch to" : "Download") + " ver. " + actual);
                this.myFixLink.setListener(this::fixArtifact, (Object)item);
                this.myLicenseLink.setVisible(item.version != null);
                this.myLicenseLink.setListener(this::showLicense, (Object)item);
            }
            this.myColored.setMaximumSize(this.myColored.getPreferredSize());
            return this.myComponent;
        }

        private void switchVersion(LinkLabel label, final ProvidedItem item) {
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)new VersionsPopupStep(item.artifact){

                public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                    if (selectedValue != null) {
                        boolean rolling = "latest".equals(selectedValue);
                        String version = rolling ? DatabaseArtifactManager.getArtifacts().getActualVersion(item.artifact) : selectedValue;
                        item.update(item.artifact, version, rolling, null);
                        DriverClasspathPanel.this.downloadImpl(item.artifact, item.version);
                        DriverClasspathPanel.this.fireUserActivity();
                    }
                    return FINAL_CHOICE;
                }
            }).show(RelativePoint.getSouthWestOf((JComponent)label));
        }

        private void fixArtifact(LinkLabel label, ProvidedItem item) {
            DriverClasspathPanel.this.downloadImpl(item.artifact, item.rolling || item.version == null ? "latest" : item.version);
        }

        private void showLicense(LinkLabel<ProvidedItem> label, ProvidedItem o) {
            JBIterable.from(o.version == null ? null : DatabaseArtifactManager.getClasspathElements(o.artifact, o.version)).flatMap(SimpleClasspathElement::getClassesRootUrls).filter(e -> StringUtil.endsWithIgnoreCase((String)e, (String)"-license.txt") || StringUtil.endsWithIgnoreCase((String)e, (String)"-agreement.txt") || StringUtil.endsWithIgnoreCase((String)e, (String)"/COPYING") || StringUtil.endsWithIgnoreCase((String)e, (String)"/LICENSE")).forEach(l -> BrowserUtil.browse((String)l, (Project)DriverClasspathPanel.this.myProject));
        }

        private class MyLinkLabel<T>
        extends LinkLabel<T> {
            MyLinkLabel(String text2) {
                super(text2, null);
            }

            protected Color getNormal() {
                return MyProvidedRenderer.this.mySelected ? UIUtil.getListForeground((boolean)true) : super.getNormal();
            }
        }
    }

    private class MyProvidedEditor
    extends AbstractTableCellEditor {
        private final MyProvidedRenderer myDelegate;
        Object v;

        private MyProvidedEditor() {
            this.myDelegate = new MyProvidedRenderer();
            this.v = null;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column2) {
            this.v = value;
            return this.myDelegate.getTableCellRendererComponent(table, value, isSelected, true, row, column2);
        }

        public Object getCellEditorValue() {
            return this.v;
        }

        public void cancelCellEditing() {
            super.cancelCellEditing();
        }
    }

    private static class MySimpleRenderer
    implements TableCellRenderer {
        SimpleColoredRenderer myComponent = new SimpleColoredRenderer();

        private MySimpleRenderer() {
            this.myComponent.setTransparentIconBackground(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column2) {
            this.myComponent.clear();
            this.myComponent.acquireState(table, isSelected, false, row, column2);
            this.myComponent.getCellState().updateRenderer((JComponent)this.myComponent);
            SimpleItem item = (SimpleItem)ObjectUtils.tryCast((Object)value, SimpleItem.class);
            if (item != null) {
                SimpleTextAttributes style = item.file != null && item.file.exists() ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.ERROR_ATTRIBUTES;
                this.myComponent.append(item.file != null ? item.file.getPath() : item.element.getPresentableName(), style);
                if (item.file != null) {
                    this.myComponent.setIcon(!item.file.exists() ? PlatformIcons.FILE_ICON : (item.file.isDirectory() ? PlatformIcons.FOLDER_ICON : FileTypeManager.getInstance().getFileTypeByExtension(FileUtilRt.getExtension((String)item.file.getName())).getIcon()));
                } else {
                    this.myComponent.setIcon(PlatformIcons.LIBRARY_ICON);
                }
            }
            return this.myComponent;
        }
    }

    private static class MyUserActivityPanel
    extends Box
    implements UserActivityProviderComponent {
        private final EventDispatcher<ChangeListener> myDispatcher = EventDispatcher.create(ChangeListener.class);
        private final ChangeEvent myEvent = new ChangeEvent(this);

        MyUserActivityPanel() {
            super(1);
        }

        public void addChangeListener(@NotNull ChangeListener changeListener) {
            if (changeListener == null) {
                MyUserActivityPanel.$$$reportNull$$$0(0);
            }
            this.myDispatcher.addListener((EventListener)changeListener);
        }

        public void removeChangeListener(@NotNull ChangeListener changeListener) {
            if (changeListener == null) {
                MyUserActivityPanel.$$$reportNull$$$0(1);
            }
            this.myDispatcher.removeListener((EventListener)changeListener);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "changeListener";
            objectArray2[1] = "com/intellij/database/view/ui/DriverClasspathPanel$MyUserActivityPanel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addChangeListener";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeChangeListener";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ProvidedItem
    implements ClassPathItem {
        private String artifact;
        private String version;
        private List<SimpleClasspathElement> legacy;
        private boolean rolling;
        boolean actualDownloaded;
        boolean invalid;
        boolean needUpdate;

        ProvidedItem(@NotNull String artifact, @Nullable String version, boolean rolling, @Nullable List<SimpleClasspathElement> legacy) {
            if (artifact == null) {
                ProvidedItem.$$$reportNull$$$0(0);
            }
            this.update(artifact, version, rolling, legacy);
        }

        void update(@NotNull String artifact, @Nullable String version, boolean rolling, @Nullable List<SimpleClasspathElement> legacy) {
            if (artifact == null) {
                ProvidedItem.$$$reportNull$$$0(1);
            }
            this.artifact = artifact;
            this.version = version;
            this.rolling = rolling;
            this.legacy = version == null ? legacy : null;
            String actual = DatabaseArtifactManager.getArtifacts().getActualVersion(artifact);
            this.invalid = !DatabaseDriverValidator.isDriverFilesValid(artifact, version, this.legacy);
            this.needUpdate = this.invalid || !DatabaseDriverValidator.isDriverFilesUpToDate(artifact, version, rolling, this.legacy);
            this.actualDownloaded = !this.needUpdate || DatabaseDriverValidator.isDriverFilesUpToDate(artifact, actual, rolling, this.legacy);
        }

        public String getToolTipText() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.artifact);
            if (this.rolling) {
                builder.append(" [rolling releases]");
            }
            if (this.version == null) {
                if (ContainerUtil.isEmpty(this.legacy)) {
                    builder.append(" with no files");
                } else {
                    builder.append(" with old files:\n");
                    for (SimpleClasspathElement element2 : this.legacy) {
                        for (String url2 : element2.getClassesRootUrls()) {
                            if (builder.length() != 0) {
                                builder.append("\n");
                            }
                            builder.append(VfsUtilCore.urlToPath((String)url2));
                        }
                    }
                }
            } else {
                builder.append(" [ver. ").append(this.version).append("]:\n");
                DatabaseArtifactManager.getClasspathElements(this.artifact, this.version).stream().flatMap(o -> o.getClassesRootUrls().stream()).forEach(url -> {
                    if (builder.length() != 0) {
                        builder.append("\n");
                    }
                    builder.append(FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)url)));
                });
            }
            return builder.toString();
        }

        public String toString() {
            return this.artifact + ":" + this.version + (this.rolling ? "[Latest]" : "");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "artifact";
            objectArray2[1] = "com/intellij/database/view/ui/DriverClasspathPanel$ProvidedItem";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SimpleItem
    implements ClassPathItem {
        @NotNull
        SimpleClasspathElement element;
        @Nullable
        File file;

        SimpleItem(@NotNull SimpleClasspathElement element2) {
            if (element2 == null) {
                SimpleItem.$$$reportNull$$$0(0);
            }
            this.element = element2;
            String url = (String)ContainerUtil.getFirstItem((List)element2.getClassesRootUrls());
            if (url != null) {
                this.file = new File(PathUtil.toPresentableUrl((String)url));
            }
        }

        public String toString() {
            String url = (String)ContainerUtil.getFirstItem((List)this.element.getClassesRootUrls());
            return url == null ? "" : PathUtil.toPresentableUrl((String)url);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/view/ui/DriverClasspathPanel$SimpleItem", "<init>"));
        }
    }

    private static interface ClassPathItem {
    }
}

