/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.DbmsExtension;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.database.SqlModelBuilder;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.xmlb.JDOMXIncluder;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCommonTestUtils {
    @NotNull
    public static JBIterable<DbmsExtension.Bean<SqlLanguageDialect>> loadSqlDialectBeans() {
        JBIterable<DbmsExtension.InstanceBean> objects;
        JBIterable<DbmsExtension.InstanceBean> jBIterable = objects = SqlCommonTestUtils.loadExtensionBeans(SqlLanguageDialect.EP.getName(), DbmsExtension.InstanceBean.class);
        if (jBIterable == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(0);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DbmsExtension.Bean<DatabaseDialect>> loadDatabaseDialectBeans() {
        JBIterable<DbmsExtension.InstanceBean> objects;
        JBIterable<DbmsExtension.InstanceBean> jBIterable = objects = SqlCommonTestUtils.loadExtensionBeans(DatabaseDialect.EP.getName(), DbmsExtension.InstanceBean.class);
        if (jBIterable == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(1);
        }
        return jBIterable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> JBIterable<T> loadExtensionBeans(@NotNull String epName, @NotNull Class<T> clazz) {
        if (epName == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(2);
        }
        if (clazz == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(3);
        }
        String shortName = StringUtil.getShortName((String)epName);
        String descriptorPath = "/META-INF/SqlDialects.xml";
        URL xml = DbmsExtension.class.getClassLoader().getResource(descriptorPath);
        if (xml == null) {
            throw new AssertionError((Object)("descriptor not found: " + descriptorPath));
        }
        try (InputStream stream = xml.openStream();){
            class MyOrderable
            implements LoadingOrder.Orderable {
                final T bean;
                final String orderId;
                final LoadingOrder order;
                final /* synthetic */ Class val$clazz;

                MyOrderable(Element element2) {
                    this.val$clazz = element2;
                    this.bean = XmlSerializer.deserialize((Element)e, (Class)this.val$clazz);
                    this.orderId = e.getAttributeValue("id");
                    this.order = LoadingOrder.readOrder((String)e.getAttributeValue("order"));
                }

                @Nullable
                public String getOrderId() {
                    return this.orderId;
                }

                public LoadingOrder getOrder() {
                    return this.order;
                }
            }
            List contents = JDOMXIncluder.resolve((Element)JDOMUtil.load((InputStream)stream), (String)xml.toExternalForm());
            List list = (List)JBIterable.from((Iterable)contents).filter(Element.class).flatten(e -> e.getChildren("extensions")).flatten(e -> e.getChildren()).filter(e -> e.getName().endsWith(shortName)).filter(e -> {
                if (epName == null) {
                    SqlCommonTestUtils.$$$reportNull$$$0(20);
                }
                return epName.equals(StringUtil.getQualifiedName((String)e.getParentElement().getAttributeValue("defaultExtensionNs"), (String)e.getName()));
            }).map(x$0 -> {
                if (clazz == null) {
                    SqlCommonTestUtils.$$$reportNull$$$0(19);
                }
                return new MyOrderable(x$0, clazz);
            }).addAllTo(new ArrayList());
            LoadingOrder.sort((List)list);
            JBIterable result2 = JBIterable.from((Iterable)list).map(o -> o.bean).collect();
            if (result2.isEmpty()) {
                throw new AssertionError((Object)(epName + " is empty in " + descriptorPath));
            }
            JBIterable jBIterable = result2;
            return jBIterable;
        }
        catch (Exception e2) {
            throw new AssertionError("Failed to load '" + epName + "' list", e2);
        }
    }

    @NotNull
    public static <T> T getDialectClass(@NotNull String dialectClass, @NotNull String suffix) {
        Object object;
        if (dialectClass == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(4);
        }
        if (suffix == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(5);
        }
        try {
            object = ReflectionUtil.newInstance(Class.forName(dialectClass.replace("Dialect", suffix)));
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        if (object == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(6);
        }
        return (T)object;
    }

    public static Map<BasicElement, SmartPsiElementPointer<SqlElement>> fillModelOnPooledThread(@NotNull Project project, DasModel model, boolean saveSources, boolean useReadOnlyPsi, String ... texts) {
        if (project == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(7);
        }
        if (texts == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(8);
        }
        Ref res2 = Ref.create();
        DbUIUtil.invokeOnPooledThreadSync(() -> {
            if (project == null) {
                SqlCommonTestUtils.$$$reportNull$$$0(13);
            }
            if (texts == null) {
                SqlCommonTestUtils.$$$reportNull$$$0(14);
            }
            DbImplUtil.performSrcOperation(model, null, false, () -> {
                if (project == null) {
                    SqlCommonTestUtils.$$$reportNull$$$0(15);
                }
                if (texts == null) {
                    SqlCommonTestUtils.$$$reportNull$$$0(16);
                }
                ReadAction.run(() -> {
                    if (project == null) {
                        SqlCommonTestUtils.$$$reportNull$$$0(17);
                    }
                    if (texts == null) {
                        SqlCommonTestUtils.$$$reportNull$$$0(18);
                    }
                    res2.set(SqlCommonTestUtils.fillModel(project, (BasicModModel)model, saveSources, useReadOnlyPsi, texts));
                });
            });
        });
        return (Map)res2.get();
    }

    private static Map<BasicElement, SmartPsiElementPointer<SqlElement>> fillModel(@NotNull Project project, @NotNull BasicModModel model, boolean saveSources, boolean useReadOnlyPsi, String ... texts) {
        PsiErrorElement error2;
        if (project == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(9);
        }
        if (model == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(10);
        }
        if (texts == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(11);
        }
        SqlLanguageDialect sqlDialect = DbSqlUtil.getSqlDialect(model.getDbms());
        List files = JBIterable.of((Object[])texts).map(text2 -> {
            if (project == null) {
                SqlCommonTestUtils.$$$reportNull$$$0(12);
            }
            return useReadOnlyPsi ? SqlPsiFacade.getInstance((Project)project).createROFile(sqlDialect, (CharSequence)text2) : (SqlFile)PsiFileFactory.getInstance((Project)project).createFileFromText("a.sql", (Language)sqlDialect, (CharSequence)text2);
        }).toList();
        if (!useReadOnlyPsi && (error2 = (PsiErrorElement)((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoots((Iterable)files)).filter(PsiErrorElement.class).first()) != null) {
            throw new AssertionError((Object)(error2.getContainingFile().getName() + ": " + error2.getErrorDescription()));
        }
        SqlModelBuilder builder = new SqlModelBuilder(project, model, ContainerUtil.newHashMap());
        builder.begin(saveSources);
        builder.introspect(files, 0, true, -1L);
        builder.end();
        return builder.getMapping();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/database/SqlCommonTestUtils";
                break;
            }
            case 2: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "epName";
                break;
            }
            case 3: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialectClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "texts";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "loadSqlDialectBeans";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDatabaseDialectBeans";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/database/SqlCommonTestUtils";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialectClass";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadExtensionBeans";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDialectClass";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fillModelOnPooledThread";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fillModel";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fillModel$9";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fillModelOnPooledThread$8";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$7";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$6";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$loadExtensionBeans$4";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$loadExtensionBeans$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

