/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlIntentionUtil {
    @Nullable
    static SqlReferenceExpression getReferenceExpression(PsiElement at) {
        PsiElement element2 = at != null ? at.getParent() : null;
        return (SqlReferenceExpression)ObjectUtils.tryCast((Object)(element2 instanceof SqlIdentifier ? element2.getParent() : element2), SqlReferenceExpression.class);
    }

    @Nullable
    static SqlIdentifier getIdentifier(PsiElement at) {
        PsiElement element2 = at != null ? at.getParent() : null;
        return element2 instanceof SqlIdentifier ? (SqlIdentifier)element2 : null;
    }

    public static void qualifyReference(@NotNull Iterable<ObjectName> names, @NotNull DatabaseDialectEx dialect, @NotNull SqlIdentifier identifier) {
        if (names == null) {
            SqlIntentionUtil.$$$reportNull$$$0(0);
        }
        if (dialect == null) {
            SqlIntentionUtil.$$$reportNull$$$0(1);
        }
        if (identifier == null) {
            SqlIntentionUtil.$$$reportNull$$$0(2);
        }
        String quoted = SqlIntentionUtil.joinNames(names, dialect);
        PsiFile file = identifier.getContainingFile();
        if (file == null) {
            return;
        }
        Document document = PsiDocumentManager.getInstance((Project)identifier.getProject()).getDocument(file);
        if (document == null) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(identifier.getProject(), () -> {
            if (identifier == null) {
                SqlIntentionUtil.$$$reportNull$$$0(19);
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (identifier == null) {
                    SqlIntentionUtil.$$$reportNull$$$0(20);
                }
                document.insertString(identifier.getTextRange().getStartOffset(), (CharSequence)(quoted + "."));
            });
        }, "Qualify identifier", null, document);
    }

    public static void qualifyReference(@NotNull RangeMarker identifier, @NotNull Iterable<ObjectName> names, @NotNull DatabaseDialectEx dialect) {
        if (identifier == null) {
            SqlIntentionUtil.$$$reportNull$$$0(3);
        }
        if (names == null) {
            SqlIntentionUtil.$$$reportNull$$$0(4);
        }
        if (dialect == null) {
            SqlIntentionUtil.$$$reportNull$$$0(5);
        }
        String quoted = SqlIntentionUtil.joinNames(names, dialect);
        identifier.getDocument().insertString(identifier.getStartOffset(), (CharSequence)(quoted + "."));
    }

    @NotNull
    protected static String joinNames(@NotNull Iterable<ObjectName> names, @NotNull DatabaseDialectEx dialect) {
        if (names == null) {
            SqlIntentionUtil.$$$reportNull$$$0(6);
        }
        if (dialect == null) {
            SqlIntentionUtil.$$$reportNull$$$0(7);
        }
        String string = StringUtil.join((Iterable)JBIterable.from(names).transform(n -> {
            if (dialect == null) {
                SqlIntentionUtil.$$$reportNull$$$0(18);
            }
            return dialect.quoteIdentifier(n.name, false, !n.quoted);
        }), (String)".");
        if (string == null) {
            SqlIntentionUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    public static void chooseQualifier(@NotNull Editor editor, @NotNull RangeMarker identifier, @NotNull List<List<ObjectName>> variants, @NotNull DatabaseDialectEx dialect, final @NotNull Consumer<Iterable<ObjectName>> qualifier) {
        if (editor == null) {
            SqlIntentionUtil.$$$reportNull$$$0(9);
        }
        if (identifier == null) {
            SqlIntentionUtil.$$$reportNull$$$0(10);
        }
        if (variants == null) {
            SqlIntentionUtil.$$$reportNull$$$0(11);
        }
        if (dialect == null) {
            SqlIntentionUtil.$$$reportNull$$$0(12);
        }
        if (qualifier == null) {
            SqlIntentionUtil.$$$reportNull$$$0(13);
        }
        if (variants.isEmpty()) {
            return;
        }
        THashSet namesSet = ContainerUtil.newTroveSet(new ListHashingStrategy(new ObjectName.HashingStrategy(dialect.getCasing(ObjectKind.TABLE, null))), variants);
        final ArrayList uniqueNames = ContainerUtil.newArrayList((Iterable)namesSet);
        if (uniqueNames.size() == 1) {
            qualifier.consume(uniqueNames.get(0));
            return;
        }
        final ArrayList qualified = ContainerUtil.newArrayList();
        for (Iterable name : uniqueNames) {
            qualified.add(SqlIntentionUtil.joinNames(name, dialect));
        }
        editor.getCaretModel().moveToOffset(identifier.getStartOffset());
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<Integer>("Qualify With...", JBIterable.generate((Object)0, x -> x + 1).take(qualified.size()).toList()){

            @NotNull
            public String getTextFor(Integer value) {
                String string = (String)qualified.get(value);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            public PopupStep onChosen(Integer selectedValue, boolean finalChoice) {
                qualifier.consume(uniqueNames.get(selectedValue));
                return FINAL_CHOICE;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/intentions/SqlIntentionUtil$1", "getTextFor"));
            }
        }).showInBestPositionFor(editor);
    }

    public static void qualifyReference(@NotNull List<? extends Iterable<ObjectName>> names, final @NotNull DatabaseDialectEx dialect, final @NotNull SqlIdentifier identifier, @NotNull Editor editor) {
        if (names == null) {
            SqlIntentionUtil.$$$reportNull$$$0(14);
        }
        if (dialect == null) {
            SqlIntentionUtil.$$$reportNull$$$0(15);
        }
        if (identifier == null) {
            SqlIntentionUtil.$$$reportNull$$$0(16);
        }
        if (editor == null) {
            SqlIntentionUtil.$$$reportNull$$$0(17);
        }
        if (names.isEmpty()) {
            return;
        }
        LinkedHashSet namesSet = ContainerUtil.newLinkedHashSet(names);
        final ArrayList uniqueNames = ContainerUtil.newArrayList((Iterable)namesSet);
        if (uniqueNames.size() == 1) {
            SqlIntentionUtil.qualifyReference((Iterable)uniqueNames.get(0), dialect, identifier);
            return;
        }
        final ArrayList qualified = ContainerUtil.newArrayList();
        for (Iterable name : uniqueNames) {
            qualified.add(SqlIntentionUtil.joinNames(name, dialect) + "." + identifier.getName());
        }
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<Integer>("Qualify With...", JBIterable.generate((Object)0, x -> x + 1).take(qualified.size()).toList()){

            @NotNull
            public String getTextFor(Integer value) {
                String string = (String)qualified.get(value);
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            public PopupStep onChosen(Integer selectedValue, boolean finalChoice) {
                SqlIntentionUtil.qualifyReference((Iterable)uniqueNames.get(selectedValue), dialect, identifier);
                return FINAL_CHOICE;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/intentions/SqlIntentionUtil$2", "getTextFor"));
            }
        }).showInBestPositionFor(editor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 16: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/intentions/SqlIntentionUtil";
                break;
            }
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/intentions/SqlIntentionUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "joinNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "qualifyReference";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "joinNames";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "chooseQualifier";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$joinNames$2";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$qualifyReference$1";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ListHashingStrategy<T>
    implements TObjectHashingStrategy<List<T>> {
        private final TObjectHashingStrategy<T> myStrategy;

        ListHashingStrategy(@NotNull TObjectHashingStrategy<T> strategy) {
            if (strategy == null) {
                ListHashingStrategy.$$$reportNull$$$0(0);
            }
            this.myStrategy = strategy;
        }

        public int computeHashCode(List<T> object) {
            int hc = 0;
            for (T t : object) {
                hc = hc * 31 + this.myStrategy.computeHashCode(t);
            }
            return hc;
        }

        public boolean equals(List<T> o1, List<T> o2) {
            if (o1.size() != o2.size()) {
                return false;
            }
            for (int i2 = 0; i2 < o1.size(); ++i2) {
                if (this.myStrategy.equals(o1.get(i2), o2.get(i2))) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "com/intellij/sql/intentions/SqlIntentionUtil$ListHashingStrategy", "<init>"));
        }
    }
}

