/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsLog;

import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.connections.CvsRootProvider;
import com.intellij.cvsSupport2.cvsoperations.common.CvsExecutionEnvironment;
import com.intellij.cvsSupport2.cvsoperations.common.LocalPathIndifferentOperation;
import com.intellij.cvsSupport2.cvsoperations.common.LocalPathIndifferentOperationHelper;
import com.intellij.cvsSupport2.cvsoperations.cvsTagOrBranch.BranchesProvider;
import com.intellij.cvsSupport2.cvsoperations.cvsTagOrBranch.TagsHelper;
import com.intellij.cvsSupport2.cvsoperations.javacvsSpecificImpls.DeafAdminWriter;
import com.intellij.cvsSupport2.history.CvsRevisionNumber;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.netbeans.lib.cvsclient.command.AbstractCommand;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.log.LogCommand;
import org.netbeans.lib.cvsclient.command.log.LogInformation;

public class LocalPathIndifferentLogOperation
extends LocalPathIndifferentOperation
implements BranchesProvider {
    private final List<LogInformation> myLogInformationList = new ArrayList<LogInformation>();
    private final LocalPathIndifferentOperationHelper myHelper;

    private LocalPathIndifferentLogOperation(CvsEnvironment environment, LocalPathIndifferentOperationHelper helper) {
        super(helper.getAdminReader(), new DeafAdminWriter(), environment);
        this.myHelper = helper;
    }

    public LocalPathIndifferentLogOperation(CvsEnvironment environment) {
        this(environment, new LocalPathIndifferentOperationHelper());
    }

    public LocalPathIndifferentLogOperation(File file) {
        this(CvsEntriesManager.getInstance().getCvsConnectionSettingsFor(file.getParentFile()));
        this.addIOFile(file);
    }

    public LocalPathIndifferentLogOperation(File[] files) {
        this(CvsEntriesManager.getInstance().getCvsConnectionSettingsFor(files[0].getParentFile()));
        for (File file : files) {
            this.addIOFile(file);
        }
    }

    private void addIOFile(File file) {
        String repository = CvsUtil.getRepositoryFor(file.getParentFile());
        this.addFile(new File(repository, file.getName()));
    }

    @Override
    protected Command createCommand(CvsRootProvider root, CvsExecutionEnvironment cvsExecutionEnvironment) {
        LogCommand command = new LogCommand();
        this.myHelper.addFilesTo((AbstractCommand)command);
        return command;
    }

    @Override
    public void fileInfoGenerated(Object info) {
        super.fileInfoGenerated(info);
        if (info instanceof LogInformation) {
            this.myLogInformationList.add((LogInformation)info);
        }
    }

    @Nullable
    public LogInformation getFirstLogInformation() {
        if (!this.myLogInformationList.isEmpty()) {
            return this.myLogInformationList.get(0);
        }
        return null;
    }

    public List<LogInformation> getLogInformationList() {
        return this.myLogInformationList;
    }

    public void addFile(File file) {
        this.myHelper.addFile(file);
    }

    @Override
    public Collection<String> getAllBranches() {
        return TagsHelper.getAllBranches(this.myLogInformationList);
    }

    @Override
    public Collection<CvsRevisionNumber> getAllRevisions() {
        return TagsHelper.getAllRevisions(this.myLogInformationList);
    }

    @Override
    protected String getOperationName() {
        return "log";
    }

    @Override
    public boolean runInReadThread() {
        return false;
    }
}

