/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.composer.InstalledPackageData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerConfigUtils {
    private static final Logger LOG = Logger.getInstance(ComposerConfigUtils.class);
    @NonNls
    private static final String VENDOR_DIR_ELEMENT_NAME = "vendor-dir";
    @NonNls
    private static final String BIN_DIR_ELEMENT_NAME = "bin-dir";
    @NonNls
    private static final String DEFAULT_BIN_DIR_NAME = "bin";

    private ComposerConfigUtils() {
    }

    public static JsonElement parseJson(@NotNull VirtualFile config) throws IOException, JsonParseException {
        if (config == null) {
            ComposerConfigUtils.$$$reportNull$$$0(0);
        }
        String text = VfsUtilCore.loadText((VirtualFile)config);
        JsonParser parser = new JsonParser();
        return parser.parse(text);
    }

    @Nullable
    private static VirtualFile findLockFile(@Nullable VirtualFile configFile) {
        if (configFile == null) {
            return null;
        }
        return configFile.getParent().findChild("composer.lock");
    }

    @NotNull
    public static List<InstalledPackageData> getInstalledPackagesFromConfig(@NotNull VirtualFile composerJson) {
        List<InstalledPackageData> list;
        if (composerJson == null) {
            ComposerConfigUtils.$$$reportNull$$$0(1);
        }
        VirtualFile lock = ComposerConfigUtils.findLockFile(composerJson);
        try {
            list = ComposerConfigUtils.getInstalledPackagesFromLock(lock);
        }
        catch (JsonParseException e) {
            ArrayList<InstalledPackageData> arrayList = new ArrayList<InstalledPackageData>();
            if (arrayList == null) {
                ComposerConfigUtils.$$$reportNull$$$0(3);
            }
            return arrayList;
        }
        if (list == null) {
            ComposerConfigUtils.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    private static List<InstalledPackageData> getInstalledPackagesFromLock(@Nullable VirtualFile lockFile) throws JsonParseException {
        if (lockFile == null) {
            ArrayList<InstalledPackageData> arrayList = new ArrayList<InstalledPackageData>();
            if (arrayList == null) {
                ComposerConfigUtils.$$$reportNull$$$0(4);
            }
            return arrayList;
        }
        JsonElement element = null;
        try {
            element = ComposerConfigUtils.parseJson(lockFile);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
        if (element instanceof JsonObject) {
            ArrayList<InstalledPackageData> result = new ArrayList<InstalledPackageData>();
            for (JsonElement packagesElement : new JsonElement[]{((JsonObject)element).get("packages"), ((JsonObject)element).get("packages-dev")}) {
                if (!(packagesElement instanceof JsonArray)) continue;
                for (JsonElement next : (JsonArray)packagesElement) {
                    if (!(next instanceof JsonObject)) continue;
                    JsonElement name = ((JsonObject)next).get("name");
                    JsonElement version = ((JsonObject)next).get("version");
                    if (!(name instanceof JsonPrimitive) || !(version instanceof JsonPrimitive)) continue;
                    result.add(new InstalledPackageData(name.getAsString(), version.getAsString()));
                }
            }
            ArrayList<InstalledPackageData> arrayList = result;
            if (arrayList == null) {
                ComposerConfigUtils.$$$reportNull$$$0(5);
            }
            return arrayList;
        }
        ArrayList<InstalledPackageData> arrayList = new ArrayList<InstalledPackageData>();
        if (arrayList == null) {
            ComposerConfigUtils.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Nullable
    public static Pair<String, String> getVendorAndBinDirs(@NotNull VirtualFile config) {
        if (config == null) {
            ComposerConfigUtils.$$$reportNull$$$0(7);
        }
        JsonElement element = null;
        try {
            element = ComposerConfigUtils.parseJson(config);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return null;
        }
        catch (JsonParseException e) {
            // empty catch block
        }
        String vendorDir = "vendor";
        String binDir = null;
        if (element instanceof JsonObject) {
            try {
                JsonElement configElement = ((JsonObject)element).get("config");
                if (configElement instanceof JsonObject) {
                    JsonElement binDirElement;
                    JsonElement vendorDirElement = ((JsonObject)configElement).get(VENDOR_DIR_ELEMENT_NAME);
                    if (vendorDirElement != null) {
                        vendorDir = vendorDirElement.getAsString();
                    }
                    if ((binDirElement = ((JsonObject)configElement).get(BIN_DIR_ELEMENT_NAME)) instanceof JsonPrimitive) {
                        binDir = binDirElement.getAsString();
                    }
                }
            }
            catch (JsonParseException jsonParseException) {
                // empty catch block
            }
        }
        if (binDir == null) {
            binDir = vendorDir + "/" + DEFAULT_BIN_DIR_NAME;
        }
        return Pair.create((Object)vendorDir, binDir);
    }

    @Nullable
    public static Set<String> getExtensions(@NotNull VirtualFile config) {
        if (config == null) {
            ComposerConfigUtils.$$$reportNull$$$0(8);
        }
        return ComposerConfigUtils.getExtensions(config, false);
    }

    @Nullable
    public static Set<String> getExtensions(@NotNull VirtualFile config, boolean dev) {
        JsonElement requireElement;
        JsonElement element;
        if (config == null) {
            ComposerConfigUtils.$$$reportNull$$$0(9);
        }
        try {
            element = ComposerConfigUtils.parseJson(config);
        }
        catch (JsonParseException | IOException e) {
            return null;
        }
        HashSet<String> extensions = new HashSet<String>();
        if (element instanceof JsonObject && (requireElement = ((JsonObject)element).get(dev ? "require-dev" : "require")) instanceof JsonObject) {
            requireElement.getAsJsonObject().entrySet().stream().map(Map.Entry::getKey).filter(s -> s.startsWith("ext-")).map(StringUtil::toLowerCase).forEach(extensions::add);
        }
        return extensions;
    }

    public static boolean requiresPhp(@NotNull VirtualFile config) {
        JsonElement configElement;
        JsonElement element;
        if (config == null) {
            ComposerConfigUtils.$$$reportNull$$$0(10);
        }
        try {
            element = ComposerConfigUtils.parseJson(config);
        }
        catch (JsonParseException | IOException e) {
            LOG.warn(e);
            return false;
        }
        return element instanceof JsonObject && (configElement = ((JsonObject)element).get("require")) instanceof JsonObject && (((JsonObject)configElement).get("php") != null || ((JsonObject)configElement).get("PHP") != null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "composerJson";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/ComposerConfigUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/ComposerConfigUtils";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledPackagesFromConfig";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledPackagesFromLock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseJson";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstalledPackagesFromConfig";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getVendorAndBinDirs";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getExtensions";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "requiresPhp";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

