/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.impl.ClassReferenceImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PhpDeprecationInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpDeprecationInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpMethodReference(MethodReference reference) {
                PhpDeprecationInspection.check((PsiReference)reference, "Method #ref is deprecated", holder);
            }

            public void visitPhpFunctionCall(FunctionReference reference) {
                PhpDeprecationInspection.check((PsiReference)reference, "Function #ref is deprecated", holder);
            }

            public void visitPhpClassReference(ClassReference reference) {
                PhpDeprecationInspection.check((PsiReference)reference, "Class #ref is deprecated", holder);
            }

            public void visitPhpClassConstantReference(ClassConstantReference reference) {
                PhpDeprecationInspection.check((PsiReference)reference, "Constant #ref is deprecated", holder);
            }

            public void visitPhpFieldReference(FieldReference reference) {
                PhpDeprecationInspection.check((PsiReference)reference, "Field #ref is deprecated", holder);
            }

            public void visitPhpConstantReference(ConstantReference reference) {
                PhpDeprecationInspection.check((PsiReference)reference, "Constant #ref is deprecated", holder);
            }
        };
        if (phpElementVisitor == null) {
            PhpDeprecationInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private static void check(PsiReference reference, String desc, ProblemsHolder holder) {
        Collection<? extends PhpNamedElement> element1;
        PsiElement element = reference instanceof ClassReference && ((ClassReference)reference).getParent() instanceof NewExpression ? ((element1 = ClassReferenceImpl.resolveGlobal((PhpReference)reference, ((ClassReference)reference).getName(), ((ClassReference)reference).getNamespaceName(), true)).size() == 1 ? (PsiElement)element1.iterator().next() : null) : reference.resolve();
        if (element instanceof PhpNamedElement) {
            PhpDocTag[] elements;
            if (!((PhpNamedElement)element).isDeprecated()) {
                return;
            }
            PhpDocComment docComment = ((PhpNamedElement)element).getDocComment();
            if (docComment != null && (elements = docComment.getTagElementsByName("@deprecated")).length > 0) {
                holder.registerProblem(reference, desc, ProblemHighlightType.LIKE_DEPRECATED);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpDeprecationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpDeprecationInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

