/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessConstantInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpDFAUtil;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpReachingDefinitionsDFAnalyzer;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpSimpleFunctionDefinedDFAnalyzer;
import com.jetbrains.php.lang.inspections.quickfix.PhpImportConstantQuickFix;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public class PhpUndefinedConstantInspection
extends PhpInspection {
    private static final LocalQuickFix[] FIXES = new LocalQuickFix[]{PhpImportConstantQuickFix.INSTANCE};
    private static final String PROBLEM_1 = PhpBundle.message("inspection.undefined.constant.problem1", new Object[0]);
    private static final String PROBLEM_2 = PhpBundle.message("inspection.undefined.constant.problem2", new Object[0]);
    public static final String DEFINED = "defined";
    public static final PhpReachingDefinitionsDFAnalyzer DF_ANALYZER = new PhpSimpleFunctionDefinedDFAnalyzer("defined");

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUndefinedConstantInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpConstantReference(ConstantReference reference) {
                String name = reference.getName();
                if (StringUtil.isEmptyOrSpaces((String)name)) {
                    return;
                }
                ASTNode nameNode = reference.getNameNode();
                if (nameNode == null) {
                    return;
                }
                if (PhpLangUtil.isBuiltInConstant(name)) {
                    return;
                }
                ResolveResult[] results = ((PsiPolyVariantReference)reference.getReference()).multiResolve(false);
                if (results.length == 0) {
                    PhpAccessConstantInstruction instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)reference, PhpAccessConstantInstruction.class);
                    Ref canBeDefined = Ref.create((Object)false);
                    Ref canBeUndefined = Ref.create((Object)false);
                    if (instruction != null) {
                        PhpDFAUtil.performReachingDefinitions((PhpInstruction)instruction, (Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined, name, DF_ANALYZER);
                    }
                    if (!((Boolean)canBeDefined.get()).booleanValue()) {
                        holder.registerProblem(nameNode.getPsi(), PROBLEM_1, FIXES);
                    } else if (((Boolean)canBeUndefined.get()).booleanValue()) {
                        holder.registerProblem(nameNode.getPsi(), PROBLEM_2, new LocalQuickFix[0]);
                    }
                }
            }
        };
        if (phpElementVisitor == null) {
            PhpUndefinedConstantInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedConstantInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedConstantInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

