/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.codeStyle.PhpLoopCanBeConvertedToArrayMapInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpConvertLoopToArrayMapQuickFix
extends PhpQuickFixBase {
    public static final String NAME = PhpBundle.message("quickfix.convert.loop.to.arraymap", new Object[0]);

    @Nls
    @NotNull
    public String getName() {
        String string = NAME;
        if (string == null) {
            PhpConvertLoopToArrayMapQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = NAME;
        if (string == null) {
            PhpConvertLoopToArrayMapQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        String resultArrayName;
        ForeachStatement foreach;
        if (project == null) {
            PhpConvertLoopToArrayMapQuickFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            PhpConvertLoopToArrayMapQuickFix.$$$reportNull$$$0(3);
        }
        if ((foreach = (ForeachStatement)PhpPsiUtil.getParentByCondition(descriptor.getStartElement(), false, (Condition<? super PsiElement>)ForeachStatement.INSTANCEOF)) == null) {
            return;
        }
        Statement prevStatement = (Statement)PhpPsiUtil.getPrevSiblingByCondition((PsiElement)foreach, (Condition<? super PsiElement>)Statement.INSTANCEOF);
        AssignmentExpression emptyArrayDeclaration = PhpLoopCanBeConvertedToArrayMapInspection.getEmptyArrayDeclaration(prevStatement);
        PhpPsiElement resultArray = emptyArrayDeclaration != null ? emptyArrayDeclaration.getVariable() : null;
        String string = resultArrayName = resultArray != null ? resultArray.getName() : null;
        if (resultArrayName == null) {
            return;
        }
        PsiElement arrayPushValue = PhpConvertLoopToArrayMapQuickFix.getArrayPushValue(foreach.getStatement());
        if (arrayPushValue == null) {
            return;
        }
        Statement arrayMapStatement = PhpConvertLoopToArrayMapQuickFix.createArrayMapStatement(project, foreach, arrayPushValue, resultArrayName);
        if (arrayMapStatement != null) {
            PhpConvertLoopToArrayMapQuickFix.restoreComments((PsiElement)foreach);
            foreach.replace((PsiElement)arrayMapStatement);
            prevStatement.delete();
        }
    }

    @Nullable
    private static Statement createArrayMapStatement(@NotNull Project project, @NotNull ForeachStatement foreach, @NotNull PsiElement arrayPushValue, @NotNull String resultArrayName) {
        String valueName;
        if (project == null) {
            PhpConvertLoopToArrayMapQuickFix.$$$reportNull$$$0(4);
        }
        if (foreach == null) {
            PhpConvertLoopToArrayMapQuickFix.$$$reportNull$$$0(5);
        }
        if (arrayPushValue == null) {
            PhpConvertLoopToArrayMapQuickFix.$$$reportNull$$$0(6);
        }
        if (resultArrayName == null) {
            PhpConvertLoopToArrayMapQuickFix.$$$reportNull$$$0(7);
        }
        PsiElement array = foreach.getArray();
        Variable value = foreach.getValue();
        String string = valueName = value != null ? value.getName() : null;
        if (array == null || valueName == null) {
            return null;
        }
        String arrayName = array instanceof PhpNamedElement ? ((PhpNamedElement)array).getName() : "";
        Set<String> variableNames = PhpLoopCanBeConvertedToArrayMapInspection.collectUsedVariables(arrayPushValue, ContainerUtil.newHashSet((Object[])new String[]{valueName, arrayName, resultArrayName}));
        String useList = PhpConvertLoopToArrayMapQuickFix.createUseListStatement(variableNames);
        return PhpPsiElementFactory.createStatement(project, String.format("$%s = %s;", resultArrayName, PhpConvertLoopToArrayMapQuickFix.createArrayMapText(valueName, useList, arrayPushValue.getText(), array.getText())));
    }

    public static String createUseListStatement(@NotNull Set<String> variableNames) {
        if (variableNames == null) {
            PhpConvertLoopToArrayMapQuickFix.$$$reportNull$$$0(8);
        }
        if (variableNames.isEmpty()) {
            return "";
        }
        return String.format("use (%s)", StreamEx.of(variableNames).map(s -> "$" + s).reduce((s, s2) -> s + "," + s2).orElse(""));
    }

    @Nullable
    public static PsiElement getArrayPushValue(@Nullable Statement statement) {
        if (statement == null) {
            return null;
        }
        if (statement instanceof GroupStatement) {
            GroupStatement unwrappedGroupStatement = PhpConvertLoopToArrayMapQuickFix.unwrapGroupStatement((GroupStatement)statement, 0);
            if (unwrappedGroupStatement == null) {
                return null;
            }
            statement = (Statement)ObjectUtils.tryCast((Object)ContainerUtil.find((Object[])unwrappedGroupStatement.getStatements(), (Condition)Statement.INSTANCEOF), Statement.class);
        }
        if (statement == null) {
            return null;
        }
        AssignmentExpression assignment = (AssignmentExpression)ObjectUtils.tryCast((Object)statement.getFirstPsiChild(), AssignmentExpression.class);
        if (assignment != null) {
            return assignment.getValue();
        }
        return null;
    }

    public static void restoreComments(@NotNull PsiElement element) {
        if (element == null) {
            PhpConvertLoopToArrayMapQuickFix.$$$reportNull$$$0(9);
        }
        PsiElement parent = element.getParent();
        PsiTreeUtil.findChildrenOfType((PsiElement)element, PsiComment.class).forEach(comment -> {
            if (element == null) {
                PhpConvertLoopToArrayMapQuickFix.$$$reportNull$$$0(14);
            }
            parent.addBefore((PsiElement)comment, element);
        });
    }

    private static String createArrayMapText(@NotNull String parameterName, @NotNull String useList, @NotNull String pushValue, @NotNull String arrayText) {
        if (parameterName == null) {
            PhpConvertLoopToArrayMapQuickFix.$$$reportNull$$$0(10);
        }
        if (useList == null) {
            PhpConvertLoopToArrayMapQuickFix.$$$reportNull$$$0(11);
        }
        if (pushValue == null) {
            PhpConvertLoopToArrayMapQuickFix.$$$reportNull$$$0(12);
        }
        if (arrayText == null) {
            PhpConvertLoopToArrayMapQuickFix.$$$reportNull$$$0(13);
        }
        return String.format("array_map(function($%s) %s {return %s;}, %s)", parameterName, useList, pushValue, arrayText);
    }

    @Nullable
    public static GroupStatement unwrapGroupStatement(@Nullable GroupStatement statement, int recursionDepth) {
        if (recursionDepth >= 200 || statement == null) {
            return statement;
        }
        List innerStatements = ContainerUtil.filter((Object[])statement.getStatements(), (Condition)Statement.INSTANCEOF);
        if (innerStatements.size() != 1) {
            return statement;
        }
        GroupStatement onlyInnerStatement = (GroupStatement)ObjectUtils.tryCast(innerStatements.get(0), GroupStatement.class);
        return onlyInnerStatement != null ? PhpConvertLoopToArrayMapQuickFix.unwrapGroupStatement(onlyInnerStatement, recursionDepth + 1) : statement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpConvertLoopToArrayMapQuickFix";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foreach";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayPushValue";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultArrayName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableNames";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "useList";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pushValue";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpConvertLoopToArrayMapQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createArrayMapStatement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createUseListStatement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "restoreComments";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createArrayMapText";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$restoreComments$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

