/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;

public class PhpPBMetaBuilderNew {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.php.meta");
    public static final Map<String, BiConsumer<Map<String, String>, FunctionReference>> PROCESSORS = new THashMap();

    @NotNull
    static Map<String, Map<String, String>> getMap(Collection<PsiFile> files) {
        THashMap map = new THashMap();
        Collection<FunctionReference> overrides = PhpPBMetaBuilderNew.topLevel(files, "override");
        for (FunctionReference override : overrides) {
            FunctionReference instruction;
            PsiElement[] parameters;
            if (!"\\PHPSTORM_META\\".equals(override.getNamespaceName()) || (parameters = override.getParameters()).length != 2) continue;
            PsiElement callable = parameters[0];
            FunctionReference functionReference = instruction = parameters[1] instanceof FunctionReference ? (FunctionReference)parameters[1] : null;
            if (instruction == null) continue;
            PhpReference reference = null;
            if (callable instanceof PhpReference) {
                reference = (PhpReference)callable;
            } else if (callable instanceof NewExpression) {
                reference = ((NewExpression)callable).getClassReference();
            }
            String matchSignature = reference != null ? reference.getSignature() : null;
            BiConsumer<Map<String, String>, FunctionReference> consumer = PROCESSORS.get(instruction.getName());
            if (consumer == null) {
                LOG.warn("no map for " + instruction.getName());
                continue;
            }
            Map types = (Map)map.get(matchSignature);
            if (matchSignature != null && types == null) {
                types = new THashMap();
                map.put(matchSignature, types);
            }
            consumer.accept(types, instruction);
        }
        THashMap tHashMap = map;
        if (tHashMap == null) {
            PhpPBMetaBuilderNew.$$$reportNull$$$0(0);
        }
        return tHashMap;
    }

    private static void collectParameterValueMapping(Map<String, String> types, FunctionReference f) {
        PsiElement[] parameters = f.getParameters();
        if (parameters.length != 1) {
            return;
        }
        PhpPsiElement arr = (PhpPsiElement)parameters[0];
        if (arr instanceof ArrayCreationExpression) {
            for (ArrayHashElement element : ((ArrayCreationExpression)arr).getHashElements()) {
                PhpPsiElement key = element.getKey();
                PhpPsiElement value = element.getValue();
                String className = null;
                if (value instanceof ClassConstantReference) {
                    PhpExpression classReference = ((ClassConstantReference)value).getClassReference();
                    if (classReference == null) continue;
                    className = classReference.getText();
                } else if (value instanceof StringLiteralExpression) {
                    className = ((StringLiteralExpression)value).getContents();
                }
                if (className == null) continue;
                if (key instanceof StringLiteralExpression) {
                    String k = ((StringLiteralExpression)key).getContents().replace('.', '\u2265');
                    if (k.isEmpty()) {
                        k = "\u03c0";
                    }
                    types.put(k, className);
                    continue;
                }
                if (key instanceof ConstantReference) {
                    types.put(((ConstantReference)key).getSignature().replace('.', '\u2265'), className);
                    continue;
                }
                if (!(key instanceof ClassConstantReference)) continue;
                types.put(((ClassConstantReference)key).getSignature().replace('.', '\u2265'), className);
            }
        }
    }

    private static void collectParameterTypeMapping(Map<String, String> types, FunctionReference f) {
        PsiElement[] parameters = f.getParameters();
        if (parameters.length != 1) {
            return;
        }
        PhpPsiElement r = (PhpPsiElement)parameters[0];
        types.put("\u03c0\u2020", r.getText());
    }

    private static void collectParameterElementTypeMapping(Map<String, String> types, FunctionReference f) {
        PsiElement[] parameters = f.getParameters();
        if (parameters.length != 1) {
            return;
        }
        PhpPsiElement r = (PhpPsiElement)parameters[0];
        types.put("\u03c0e\u2020", r.getText());
    }

    private static Collection<FunctionReference> topLevel(Collection<PsiFile> inputs, final String key) {
        SmartList result = new SmartList();
        for (PsiElement psiElement : inputs) {
            if (!(psiElement instanceof PhpPsiElement)) continue;
            psiElement.accept((PsiElementVisitor)new PhpRecursiveElementVisitor((Collection)result){
                final /* synthetic */ Collection val$result;
                {
                    this.val$result = collection;
                }

                public void visitPhpFunctionCall(FunctionReference reference) {
                    if (key.equals(reference.getName())) {
                        this.val$result.add(reference);
                    }
                }
            });
        }
        return result;
    }

    static {
        PROCESSORS.put("map", PhpPBMetaBuilderNew::collectParameterValueMapping);
        PROCESSORS.put("type", PhpPBMetaBuilderNew::collectParameterTypeMapping);
        PROCESSORS.put("elementType", PhpPBMetaBuilderNew::collectParameterElementTypeMapping);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/psi/resolve/types/PhpPBMetaBuilderNew", "getMap"));
    }
}

