/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.actions.AbstractRerunFailedTestsAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.config.commandLine.PhpCommandSettingsBuilder;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.phpunit.PhpUnitConsoleProperties;
import com.jetbrains.php.phpunit.PhpUnitLocalRunConfiguration;
import com.jetbrains.php.phpunit.PhpUnitRunConfigurationSettings;
import com.jetbrains.php.phpunit.PhpUnitSettings;
import com.jetbrains.php.phpunit.PhpUnitTestPattern;
import com.jetbrains.php.phpunit.PhpUnitTestRunnerSettings;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import com.jetbrains.php.run.PhpRunConfiguration;
import com.jetbrains.php.run.PhpRunConfigurationHolder;
import com.jetbrains.php.run.PhpRunUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnitRerunFailedTestsAction
extends AbstractRerunFailedTestsAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.php.phpunit.actions.PhpUnitRerunFailedTestsAction");
    private static final String FAKE_TEST_NAME = "Warning";
    public static final String WITH_DATA_SET = " with data set ";

    public PhpUnitRerunFailedTestsAction(@NotNull ComponentContainer componentContainer, PhpUnitConsoleProperties consoleProperties) {
        if (componentContainer == null) {
            PhpUnitRerunFailedTestsAction.$$$reportNull$$$0(0);
        }
        super(componentContainer);
        this.init((TestConsoleProperties)consoleProperties);
    }

    @Nullable
    protected AbstractRerunFailedTestsAction.MyRunProfile getRunProfile(@NotNull ExecutionEnvironment environment) {
        RunProfile configuration;
        if (environment == null) {
            PhpUnitRerunFailedTestsAction.$$$reportNull$$$0(1);
        }
        if (!((configuration = this.myConsoleProperties.getConfiguration()) instanceof PhpUnitLocalRunConfiguration)) {
            LOG.warn("Expected PHPUnit run-configuration type, got: " + configuration.getClass());
            return null;
        }
        PhpUnitLocalRunConfiguration phpRunConfiguration = (PhpUnitLocalRunConfiguration)configuration;
        return new PhpUnitRerunProfile((RunConfigurationBase)phpRunConfiguration, this.getFailedTestPatterns(phpRunConfiguration.getProject()));
    }

    @NotNull
    private List<PhpUnitTestPattern> getFailedTestPatterns(@NotNull Project project) {
        if (project == null) {
            PhpUnitRerunFailedTestsAction.$$$reportNull$$$0(2);
        }
        List failedTests = this.getFailedTests(project);
        HashMap<String, List> result = new HashMap<String, List>();
        for (AbstractTestProxy testProxy : failedTests) {
            String fullTestName;
            String className;
            String testFilePath;
            Location parentLocation;
            PsiElement element;
            AbstractTestProxy parent;
            if (!testProxy.isLeaf() || (parent = testProxy.getParent()) == null) continue;
            String testName = testProxy.getName();
            boolean isFakeWarningTest = StringUtil.equals((CharSequence)testName, (CharSequence)FAKE_TEST_NAME);
            if (isFakeWarningTest && !result.containsKey(FAKE_TEST_NAME)) {
                result.put(FAKE_TEST_NAME, ContainerUtil.emptyList());
            }
            PsiElement psiElement = element = (parentLocation = parent.getLocation(project, this.myConsoleProperties.getScope())) != null ? parentLocation.getPsiElement() : null;
            if (element == null) {
                LOG.warn("Element is null for test location");
            }
            String string = testFilePath = element != null ? element.getContainingFile().getVirtualFile().getPath() : "";
            if (element instanceof Method) {
                AbstractTestProxy grandParent = parent.getParent();
                className = grandParent.getName();
                fullTestName = isFakeWarningTest ? parent.getName() + "(.*)?" : testName;
            } else if (parent.getChildren().size() == 1 && isFakeWarningTest) {
                className = parent.getName() + "(.*)?";
                fullTestName = "";
            } else {
                className = parent.getName();
                fullTestName = testName;
            }
            String dataSet = null;
            if (fullTestName.contains(WITH_DATA_SET)) {
                List methodNameAndDataSet = StringUtil.split((String)fullTestName, (String)WITH_DATA_SET);
                if (methodNameAndDataSet.size() >= 2) {
                    fullTestName = (String)methodNameAndDataSet.get(0);
                    dataSet = (String)methodNameAndDataSet.get(1);
                } else {
                    LOG.warn("Invalid PHPUnit test name: " + fullTestName);
                }
            }
            fullTestName = StringUtil.escapeBackSlashes((String)fullTestName);
            PhpUnitTestPattern pattern = new PhpUnitTestPattern(className, fullTestName, testFilePath, dataSet);
            if (StringUtil.isEmpty((String)fullTestName)) {
                if (result.containsKey(className)) continue;
                result.put(className, ContainerUtil.emptyList());
                continue;
            }
            if (!result.containsKey(className)) {
                result.put(className, ContainerUtil.newArrayList((Object[])new PhpUnitTestPattern[]{pattern}));
                continue;
            }
            ((List)result.get(className)).add(pattern);
        }
        List list = ContainerUtil.flatten(result.values());
        if (list == null) {
            PhpUnitRerunFailedTestsAction.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentContainer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpunit/actions/PhpUnitRerunFailedTestsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpunit/actions/PhpUnitRerunFailedTestsAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFailedTestPatterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRunProfile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFailedTestPatterns";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PhpUnitRerunProfile
    extends AbstractRerunFailedTestsAction.MyRunProfile
    implements PhpRunConfigurationHolder<PhpUnitRunConfigurationSettings> {
        private final List<PhpUnitTestPattern> myFailedTests;

        public PhpUnitRerunProfile(RunConfigurationBase configuration, @NotNull List<PhpUnitTestPattern> failedTests) {
            if (failedTests == null) {
                PhpUnitRerunProfile.$$$reportNull$$$0(0);
            }
            super(configuration);
            this.myFailedTests = failedTests;
        }

        @Nullable
        public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
            if (executor == null) {
                PhpUnitRerunProfile.$$$reportNull$$$0(1);
            }
            if (environment == null) {
                PhpUnitRerunProfile.$$$reportNull$$$0(2);
            }
            PhpUnitLocalRunConfiguration runConfiguration = (PhpUnitLocalRunConfiguration)this.getPeer();
            PhpInterpreter interpreter = PhpProjectConfigurationFacade.getInstance(this.getProject()).getInterpreter();
            if (interpreter == null) {
                throw new ExecutionException(PhpCommandSettingsBuilder.INTERPRETER_NOT_FOUND_ERROR);
            }
            Map<String, String> envParameters = Collections.emptyMap();
            SmartList arguments = new SmartList();
            PhpCommandSettings command = runConfiguration.createCommand(interpreter, this.getSettings(), envParameters, (List<String>)arguments, false);
            String error = this.validate(runConfiguration, interpreter.getName(), command.isRemote());
            if (StringUtil.isNotEmpty((String)error)) {
                String title = PhpBundle.message("phpunit.can.not.rerun.failed.tests.title", new Object[0]);
                PhpUnitUtil.showRunToolWindowError(this.getProject(), title, error, null);
                return null;
            }
            return runConfiguration.getState(environment, command);
        }

        private String validate(@NotNull PhpUnitLocalRunConfiguration runConfiguration, String interpreterName, boolean isRemote) {
            if (runConfiguration == null) {
                PhpUnitRerunProfile.$$$reportNull$$$0(3);
            }
            PhpUnitRunConfigurationSettings oldSettings = (PhpUnitRunConfigurationSettings)runConfiguration.getSettings();
            PhpUnitTestRunnerSettings testRunnerSettings = oldSettings.getTestRunnerSettings();
            PhpUnitTestRunnerSettings.Scope scope = testRunnerSettings.getScope();
            Project project = this.getProject();
            if (scope == PhpUnitTestRunnerSettings.Scope.Directory) {
                if (PhpRunUtil.findDirectory(testRunnerSettings.getDirectoryPath()) == null) {
                    return PhpBundle.message("validation.value.is.not.specified.or.invalid", "Directory");
                }
            } else if (scope == PhpUnitTestRunnerSettings.Scope.XML) {
                PhpUnitSettings phpUnitSettings;
                VirtualFile file;
                if (testRunnerSettings.isUseAlternativeConfigurationFile() ? (file = PhpRunUtil.findFile(testRunnerSettings.getConfigurationFilePath())) == null : (phpUnitSettings = PhpUnitLocalRunConfiguration.getPhpUnitSettings(project, interpreterName, isRemote)) == null || !phpUnitSettings.isUseConfigurationFile()) {
                    return PhpBundle.message("validation.value.is.not.specified.or.invalid", "Configuration file");
                }
            } else if (scope == PhpUnitTestRunnerSettings.Scope.Pattern) {
                if (PhpRunUtil.findDirectory(testRunnerSettings.getDirectoryPath()) == null && PhpRunUtil.findFile(testRunnerSettings.getFilePath()) == null) {
                    return PhpBundle.message("validation.value.is.not.specified.or.invalid", "File/Directory");
                }
            } else {
                VirtualFile file = PhpRunUtil.findFile(testRunnerSettings.getFilePath());
                if (file == null) {
                    return PhpBundle.message("validation.value.is.not.specified.or.invalid", "File");
                }
            }
            return null;
        }

        @Override
        @NotNull
        public PhpRunConfiguration<PhpUnitRunConfigurationSettings> getRunConfiguration() {
            RunConfigurationBase peer = this.getPeer();
            PhpRunConfiguration phpRunConfiguration = (PhpRunConfiguration)peer;
            if (phpRunConfiguration == null) {
                PhpUnitRerunProfile.$$$reportNull$$$0(4);
            }
            return phpRunConfiguration;
        }

        @Override
        @NotNull
        public PhpUnitRunConfigurationSettings getSettings() {
            PhpUnitLocalRunConfiguration runConfiguration = (PhpUnitLocalRunConfiguration)this.getPeer();
            PhpUnitRunConfigurationSettings settings = ((PhpUnitRunConfigurationSettings)runConfiguration.getSettings()).clone();
            PhpUnitTestRunnerSettings runnerSettings = settings.getTestRunnerSettings();
            PhpUnitTestRunnerSettings.Scope scope = runnerSettings.getScope();
            if (scope == PhpUnitTestRunnerSettings.Scope.XML) {
                runnerSettings.setFilePath(null);
                runnerSettings.setDirectoryPath(null);
            } else if (scope == PhpUnitTestRunnerSettings.Scope.Directory) {
                runnerSettings.setFilePath(null);
            } else if (scope != PhpUnitTestRunnerSettings.Scope.Pattern) {
                runnerSettings.setDirectoryPath(null);
            }
            runnerSettings.setScope(PhpUnitTestRunnerSettings.Scope.Pattern);
            runnerSettings.setTestPatterns(this.myFailedTests);
            PhpUnitRunConfigurationSettings phpUnitRunConfigurationSettings = settings;
            if (phpUnitRunConfigurationSettings == null) {
                PhpUnitRerunProfile.$$$reportNull$$$0(5);
            }
            return phpUnitRunConfigurationSettings;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "failedTests";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environment";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runConfiguration";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/phpunit/actions/PhpUnitRerunFailedTestsAction$PhpUnitRerunProfile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/phpunit/actions/PhpUnitRerunFailedTestsAction$PhpUnitRerunProfile";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRunConfiguration";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSettings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getState";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "validate";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

