/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.restClient;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.ws.rest.client.RESTClient;
import com.intellij.ws.rest.client.RestClientRequest;
import com.intellij.ws.rest.client.RestClientRequestProcessor;
import com.intellij.xdebugger.DefaultDebugProcessHandler;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.PhpDebugExtension;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.common.PhpDebugDriver;
import com.jetbrains.php.debug.common.PhpDebugStrategy;
import com.jetbrains.php.debug.common.PhpLocalDebugStrategy;
import com.jetbrains.php.debug.connection.PhpDebugConnectionManager;
import com.jetbrains.php.debug.connection.PhpDebugPathExtractor;
import com.jetbrains.php.debug.connection.PhpDebugServer;
import com.jetbrains.php.restClient.PhpHttpRequestDebugProcess;
import icons.RestClientIcons;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import org.apache.http.HttpHost;
import org.apache.http.client.CookieStore;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.cookie.Cookie;
import org.jetbrains.annotations.NotNull;

public class PhpSendRequestInDebugMode
extends AnAction {
    private static final Logger LOG = Logger.getInstance(PhpSendRequestInDebugMode.class);
    private final RESTClient myRESTClient;
    private RunContentDescriptor myRunContentDescriptor;

    public PhpSendRequestInDebugMode(@NotNull RESTClient client) {
        if (client == null) {
            PhpSendRequestInDebugMode.$$$reportNull$$$0(0);
        }
        super(PhpBundle.message("debug.rest.client.submit.request.in.debug.mode", new Object[0]), PhpBundle.message("debug.rest.client.runs.request.in.debug.mode", new Object[0]), AllIcons.Toolwindows.ToolWindowDebugger);
        this.myRESTClient = client;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        URI uri;
        Project project;
        if (e == null) {
            PhpSendRequestInDebugMode.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        String url = this.myRESTClient.getRequestURL();
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException ex) {
            LOG.error(PhpBundle.message("debug.rest.client.can.not.resolve.host.name", url));
            return;
        }
        HttpHost host = URIUtils.extractHost((URI)uri);
        if (host == null) {
            String message = PhpBundle.message("debug.rest.client.can.not.resolve.host.name", url);
            LOG.error(message);
            PhpSendRequestInDebugMode.showErrorDialog(project, message);
            return;
        }
        try {
            String hostName = host.getHostName();
            String debuggerId = "php.debugger.XDebug";
            String sessionId = this.createDebugSession(project, "php.debugger.XDebug", hostName);
            final RestClientRequest.Biscuit debugCookie = PhpSendRequestInDebugMode.createCookie("php.debugger.XDebug", sessionId, hostName);
            this.myRESTClient.onGoToUrlAction(new RestClientRequestProcessor[]{new RestClientRequestProcessor(){

                public void preProcessRequest(@NotNull RestClientRequest request) {
                    if (request == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    request.biscuits.add(debugCookie);
                }

                public void postProcessRequest(@NotNull RestClientRequest request, @NotNull CookieStore store) {
                    if (request == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (store == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    request.biscuits.remove(debugCookie);
                    List filtered = ContainerUtil.filter((Collection)store.getCookies(), cookie -> !StringUtil.equals((CharSequence)debugCookie.getName(), (CharSequence)cookie.getName()));
                    store.clear();
                    for (Cookie cookie2 : filtered) {
                        store.addCookie(cookie2);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "request";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "store";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/php/restClient/PhpSendRequestInDebugMode$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "preProcessRequest";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "postProcessRequest";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }});
        }
        catch (ExecutionException e1) {
            LOG.error((Throwable)e1);
            PhpSendRequestInDebugMode.showErrorDialog(project, e1.getMessage());
        }
    }

    private static void showErrorDialog(@NotNull Project project, @NotNull String message) {
        if (project == null) {
            PhpSendRequestInDebugMode.$$$reportNull$$$0(2);
        }
        if (message == null) {
            PhpSendRequestInDebugMode.$$$reportNull$$$0(3);
        }
        Messages.showErrorDialog((Project)project, (String)message, (String)PhpBundle.message("debug.rest.client.can.not.resolve.host.name.title", new Object[0]));
    }

    @NotNull
    private static RestClientRequest.Biscuit createCookie(@NotNull String debuggerId, @NotNull String sessionId, @NotNull String host) throws ExecutionException {
        if (debuggerId == null) {
            PhpSendRequestInDebugMode.$$$reportNull$$$0(4);
        }
        if (sessionId == null) {
            PhpSendRequestInDebugMode.$$$reportNull$$$0(5);
        }
        if (host == null) {
            PhpSendRequestInDebugMode.$$$reportNull$$$0(6);
        }
        if (PhpDebugUtil.isXDebug(debuggerId)) {
            RestClientRequest.Biscuit biscuit = new RestClientRequest.Biscuit();
            biscuit.setName("XDEBUG_SESSION");
            biscuit.setValue(sessionId);
            biscuit.setPath("/");
            biscuit.setDomain(host);
            biscuit.setDate(-1L);
            RestClientRequest.Biscuit biscuit2 = biscuit;
            if (biscuit2 == null) {
                PhpSendRequestInDebugMode.$$$reportNull$$$0(7);
            }
            return biscuit2;
        }
        String debuggerName = PhpDebugUtil.getDebuggerNameById(debuggerId);
        throw new ExecutionException(PhpBundle.message("debug.rest.client.debugger.is.not.supported", debuggerName));
    }

    @NotNull
    private String createDebugSession(@NotNull Project project, String debuggerId, String sessionName) throws ExecutionException {
        if (project == null) {
            PhpSendRequestInDebugMode.$$$reportNull$$$0(8);
        }
        PhpDebugExtension debugExtension = PhpDebugUtil.getDebugExtensionByDebuggerId(debuggerId);
        PhpDebugConnectionManager connectionsManager = debugExtension.createDebugConnectionManager();
        PhpDebugServer debugServer = debugExtension.startDebugServer(project);
        String sessionId = debugServer.registerSessionHandler(false, connectionsManager);
        DefaultDebugProcessHandler processHandler = new DefaultDebugProcessHandler();
        ProcessTerminatedListener.attach((ProcessHandler)processHandler, (Project)project);
        UIUtil.invokeLaterIfNeeded(() -> this.lambda$createDebugSession$0(debugServer, sessionId, (ProcessHandler)processHandler, debugExtension, connectionsManager, debuggerId, project, sessionName));
        String string = sessionId;
        if (string == null) {
            PhpSendRequestInDebugMode.$$$reportNull$$$0(9);
        }
        return string;
    }

    private /* synthetic */ void lambda$createDebugSession$0(final PhpDebugServer debugServer, final String sessionId, final ProcessHandler processHandler, final PhpDebugExtension debugExtension, final PhpDebugConnectionManager connectionsManager, final String debuggerId, @NotNull Project project, String sessionName) {
        if (project == null) {
            PhpSendRequestInDebugMode.$$$reportNull$$$0(10);
        }
        try {
            XDebugProcessStarter processStarter = new XDebugProcessStarter(){

                @NotNull
                public XDebugProcess start(final @NotNull XDebugSession session) throws ExecutionException {
                    if (session == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    session.addSessionListener(new XDebugSessionListener(){

                        public void sessionStopped() {
                            debugServer.unregisterSessionHandler(sessionId);
                        }
                    });
                    processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                        public void processTerminated(@NotNull ProcessEvent event) {
                            if (event == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            session.stop();
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/restClient/PhpSendRequestInDebugMode$2$2", "processTerminated"));
                        }
                    });
                    PhpDebugDriver driver = debugExtension.getDebugDriver();
                    PhpDebugPathExtractor pathExtractor = debugServer.createPathFromUrlExtractor();
                    PhpLocalDebugStrategy debugStrategy = new PhpLocalDebugStrategy(session.getProject());
                    PhpHttpRequestDebugProcess debugProcess = new PhpHttpRequestDebugProcess(session, sessionId, connectionsManager, driver, (PhpDebugStrategy)debugStrategy, pathExtractor, debuggerId);
                    RunContentDescriptor runContentDescriptor = debugProcess.getRunContentDescriptor();
                    if (runContentDescriptor != null) {
                        PhpSendRequestInDebugMode.this.myRunContentDescriptor = runContentDescriptor;
                    }
                    PhpHttpRequestDebugProcess phpHttpRequestDebugProcess = debugProcess;
                    if (phpHttpRequestDebugProcess == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return phpHttpRequestDebugProcess;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "session";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/jetbrains/php/restClient/PhpSendRequestInDebugMode$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/jetbrains/php/restClient/PhpSendRequestInDebugMode$2";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "start";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "start";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            XDebuggerManager.getInstance((Project)project).startSessionAndShowTab(sessionName, RestClientIcons.Rest_client_icon_small, this.myRunContentDescriptor, false, processStarter);
            processHandler.startNotify();
        }
        catch (ExecutionException e) {
            debugServer.unregisterSessionHandler(sessionId);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/restClient/PhpSendRequestInDebugMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/restClient/PhpSendRequestInDebugMode";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createCookie";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createDebugSession";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showErrorDialog";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createCookie";
                break;
            }
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createDebugSession";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createDebugSession$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

