/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.testFramework.statistics;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfiguration;
import com.jetbrains.php.testFramework.PhpTestFrameworkSettingsManager;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpTestFrameworkCollectorHelper {
    private static final PhpTestFrameworkCollectorHelper ourVersionCollector = new PhpTestFrameworkCollectorHelper();

    @NotNull
    public Set<UsageDescriptor> collectUsages(@Nullable Project project) {
        PhpTestFrameworkSettingsManager manager = PhpTestFrameworkSettingsManager.getInstance(project);
        if (manager != null) {
            boolean isProjectLevel = project != null;
            Set frameworks = manager.getAllConfigurations().stream().filter(config -> config.isProjectLevel() == isProjectLevel).map(config -> this.toReportedData(project, (PhpTestFrameworkConfiguration)config)).filter(data -> data != null).collect(Collectors.toSet());
            if (!frameworks.isEmpty()) {
                HashSet usages = ContainerUtil.newHashSet();
                for (String version : frameworks) {
                    usages.add(new UsageDescriptor(version, 1));
                }
                HashSet hashSet = usages;
                if (hashSet == null) {
                    PhpTestFrameworkCollectorHelper.$$$reportNull$$$0(0);
                }
                return hashSet;
            }
        }
        Set<UsageDescriptor> set = Collections.emptySet();
        if (set == null) {
            PhpTestFrameworkCollectorHelper.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Nullable
    protected String toReportedData(@Nullable Project project, @NotNull PhpTestFrameworkConfiguration config) {
        if (config == null) {
            PhpTestFrameworkCollectorHelper.$$$reportNull$$$0(2);
        }
        return StringUtil.toLowerCase((String)config.getFrameworkType().getDisplayName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/testFramework/statistics/PhpTestFrameworkCollectorHelper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "collectUsages";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/testFramework/statistics/PhpTestFrameworkCollectorHelper";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "toReportedData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ApplicationUsageCollector
    extends ApplicationUsagesCollector {
        private static final String GROUP_ID = "statistics.php.test.framework.ide";

        @NotNull
        public Set<UsageDescriptor> getUsages() {
            Set<UsageDescriptor> set = ourVersionCollector.collectUsages(null);
            if (set == null) {
                ApplicationUsageCollector.$$$reportNull$$$0(0);
            }
            return set;
        }

        @NotNull
        public String getGroupId() {
            if (GROUP_ID == null) {
                ApplicationUsageCollector.$$$reportNull$$$0(1);
            }
            return GROUP_ID;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/php/testFramework/statistics/PhpTestFrameworkCollectorHelper$ApplicationUsageCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUsages";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupId";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class ProjectUsageCollector
    extends ProjectUsagesCollector {
        private static final String GROUP_ID = "statistics.php.test.framework.project";

        @NotNull
        public Set<UsageDescriptor> getUsages(@NotNull Project project) {
            if (project == null) {
                ProjectUsageCollector.$$$reportNull$$$0(0);
            }
            Set<UsageDescriptor> set = ourVersionCollector.collectUsages(project);
            if (set == null) {
                ProjectUsageCollector.$$$reportNull$$$0(1);
            }
            return set;
        }

        @NotNull
        public String getGroupId() {
            if (GROUP_ID == null) {
                ProjectUsageCollector.$$$reportNull$$$0(2);
            }
            return GROUP_ID;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/testFramework/statistics/PhpTestFrameworkCollectorHelper$ProjectUsageCollector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/testFramework/statistics/PhpTestFrameworkCollectorHelper$ProjectUsageCollector";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUsages";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getUsages";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

