/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.comment;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.psiutil.JSElementFactory;
import org.jetbrains.annotations.NotNull;

public class JSChangeToCStyleCommentIntention
extends JSIntention {
    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        EndOfLineCommentPredicate endOfLineCommentPredicate = new EndOfLineCommentPredicate();
        if (endOfLineCommentPredicate == null) {
            JSChangeToCStyleCommentIntention.$$$reportNull$$$0(0);
        }
        return endOfLineCommentPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiComment lastElementToDelete;
        PsiElement prevComment;
        if (element == null) {
            JSChangeToCStyleCommentIntention.$$$reportNull$$$0(1);
        }
        PsiComment firstComment = (PsiComment)element;
        while (JSChangeToCStyleCommentIntention.isEndOfLineComment(prevComment = JSElementFactory.getNonWhiteSpaceSibling((PsiElement)firstComment, false))) {
            assert (prevComment != null);
            firstComment = (PsiComment)prevComment;
        }
        StringBuilder buffer = new StringBuilder(JSChangeToCStyleCommentIntention.getCommentContents(firstComment));
        PsiComment nextComment = firstComment;
        while (true) {
            lastElementToDelete = nextComment;
            if (!JSChangeToCStyleCommentIntention.isEndOfLineComment((PsiElement)(nextComment = JSElementFactory.getNonWhiteSpaceSibling((PsiElement)nextComment, true)))) break;
            assert (nextComment != null);
            PsiElement prevSibling = nextComment.getPrevSibling();
            assert (prevSibling != null);
            buffer.append(prevSibling.getText()).append(JSChangeToCStyleCommentIntention.getCommentContents(nextComment));
        }
        String text = StringUtil.replace((String)buffer.toString(), (String)"*/", (String)"* /");
        String newCommentString = text.indexOf(10) >= 0 ? "/*\n" + text + "\n*/" : "/*" + text + "*/";
        JSElementFactory.addElementBefore((PsiElement)firstComment, newCommentString);
        FormatFixer ff = FormatFixer.create((PsiElement)firstComment, (PsiElement)lastElementToDelete, (FormatFixer.Mode)FormatFixer.Mode.FirstLinebreak);
        firstComment.getParent().deleteChildRange((PsiElement)firstComment, (PsiElement)lastElementToDelete);
        ff.fixFormat();
    }

    private static boolean isEndOfLineComment(PsiElement element) {
        if (!(element instanceof PsiComment)) {
            return false;
        }
        PsiComment comment = (PsiComment)element;
        IElementType tokenType = comment.getTokenType();
        return JSTokenTypes.END_OF_LINE_COMMENT.equals(tokenType);
    }

    private static String getCommentContents(PsiComment comment) {
        return comment.getText().substring(2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/comment/JSChangeToCStyleCommentIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/comment/JSChangeToCStyleCommentIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EndOfLineCommentPredicate
    implements JSElementPredicate {
        private EndOfLineCommentPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                EndOfLineCommentPredicate.$$$reportNull$$$0(0);
            }
            if (!(element instanceof PsiComment)) {
                return false;
            }
            IElementType type = ((PsiComment)element).getTokenType();
            return JSTokenTypes.END_OF_LINE_COMMENT.equals(type);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/comment/JSChangeToCStyleCommentIntention$EndOfLineCommentPredicate", "satisfiedBy"));
        }
    }
}

