from typing import (
    Any,
    TypeVar,
    overload,
)

from collections.abc import Iterator


_T = TypeVar("_T")


class Record:
    @overload
    def get(self, key: str) -> Any | None: ...
    @overload
    def get(self, key: str, default: _T) -> Any | _T: ...
    def items(self) -> Iterator[tuple[str, Any]]: ...
    def keys(self) -> Iterator[str]: ...
    def values(self) -> Iterator[Any]: ...
    @overload
    def __getitem__(self, index: str) -> Any: ...
    @overload
    def __getitem__(self, index: int) -> Any: ...
    @overload
    def __getitem__(self, index: slice) -> tuple[Any, ...]: ...
    def __iter__(self) -> Iterator[Any]: ...
    def __contains__(self, x: object) -> bool: ...
    def __len__(self) -> int: ...
