/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpCookie;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import junit.framework.TestSuite;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.mime.FormBodyPartBuilder;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.AbstractContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.auth.DigestScheme;
import org.apache.http.impl.auth.RFC2617Scheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BasicHeader;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;
import org.wiztools.commons.MultiValueMap;
import org.wiztools.commons.StreamUtil;
import org.wiztools.commons.StringUtil;
import org.wiztools.restclient.HTTPClientUtil;
import org.wiztools.restclient.IGlobalOptions;
import org.wiztools.restclient.MultipleRequestInSameRequestExecuterException;
import org.wiztools.restclient.ProxyConfig;
import org.wiztools.restclient.ServiceLocator;
import org.wiztools.restclient.TestUtil;
import org.wiztools.restclient.View;
import org.wiztools.restclient.bean.Auth;
import org.wiztools.restclient.bean.AuthorizationHeaderAuth;
import org.wiztools.restclient.bean.BasicAuth;
import org.wiztools.restclient.bean.BasicDigestAuth;
import org.wiztools.restclient.bean.ContentType;
import org.wiztools.restclient.bean.DigestAuth;
import org.wiztools.restclient.bean.HTTPVersion;
import org.wiztools.restclient.bean.MultipartMode;
import org.wiztools.restclient.bean.NtlmAuth;
import org.wiztools.restclient.bean.ReqEntity;
import org.wiztools.restclient.bean.ReqEntityFilePart;
import org.wiztools.restclient.bean.ReqEntityMultipart;
import org.wiztools.restclient.bean.ReqEntityPart;
import org.wiztools.restclient.bean.ReqEntitySimple;
import org.wiztools.restclient.bean.ReqEntityStringPart;
import org.wiztools.restclient.bean.Request;
import org.wiztools.restclient.bean.RequestExecuter;
import org.wiztools.restclient.bean.ResponseBean;
import org.wiztools.restclient.bean.SSLHostnameVerifier;
import org.wiztools.restclient.bean.SSLReq;
import org.wiztools.restclient.bean.TestException;
import org.wiztools.restclient.bean.TestResult;
import org.wiztools.restclient.bean.UsernamePasswordAuth;
import org.wiztools.restclient.http.RESTClientCookieStore;
import org.wiztools.restclient.http.TrustAllTrustStrategy;
import org.wiztools.restclient.util.HttpUtil;
import org.wiztools.restclient.util.IDNUtil;
import org.wiztools.restclient.util.Util;

public class HTTPClientRequestExecuter
implements RequestExecuter {
    private static final Logger LOG = Logger.getLogger(HTTPClientRequestExecuter.class.getName());
    private CloseableHttpClient httpClient;
    private boolean interruptedShutdown = false;
    private boolean isRequestCompleted = false;
    private boolean isRequestStarted = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Request request, View ... views) {
        Auth auth;
        if (this.isRequestStarted) {
            throw new MultipleRequestInSameRequestExecuterException("A RequestExecuter object can be used only once!");
        }
        this.isRequestStarted = true;
        for (View view : views) {
            view.doStart(request);
        }
        HttpClientContext httpContext = null;
        HttpClientBuilder hcBuilder = HttpClientBuilder.create();
        RequestConfig.Builder rcBuilder = RequestConfig.custom();
        RequestBuilder reqBuilder = RequestBuilder.create(request.getMethod().name());
        hcBuilder.setRetryHandler(new DefaultHttpRequestRetryHandler(0, false));
        URL url = IDNUtil.getIDNizedURL(request.getUrl());
        String urlHost = url.getHost();
        int urlPort = url.getPort() == -1 ? url.getDefaultPort() : url.getPort();
        String urlProtocol = url.getProtocol();
        String urlStr = url.toString();
        reqBuilder.setUri(urlStr);
        HTTPVersion httpVersion = request.getHttpVersion();
        ProtocolVersion protocolVersion = httpVersion == HTTPVersion.HTTP_1_1 ? new ProtocolVersion("HTTP", 1, 1) : new ProtocolVersion("HTTP", 1, 0);
        reqBuilder.setVersion(protocolVersion);
        IGlobalOptions options = ServiceLocator.getInstance(IGlobalOptions.class);
        rcBuilder.setConnectionRequestTimeout(Integer.parseInt(options.getProperty("request-timeout-in-millis")));
        ProxyConfig proxy = ProxyConfig.getInstance();
        proxy.acquire();
        if (proxy.isEnabled()) {
            HttpHost proxyHost = new HttpHost(proxy.getHost(), proxy.getPort(), "http");
            if (proxy.isAuthEnabled()) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(proxy.getHost(), proxy.getPort()), new UsernamePasswordCredentials(proxy.getUsername(), new String(proxy.getPassword())));
                hcBuilder.setDefaultCredentialsProvider(credsProvider);
            }
            hcBuilder.setProxy(proxyHost);
        }
        proxy.release();
        if (request.getAuth() != null) {
            String pwd;
            String uid;
            UsernamePasswordAuth a;
            auth = request.getAuth();
            ArrayList<String> authPrefs = new ArrayList<String>();
            if (auth instanceof BasicAuth) {
                authPrefs.add("Basic");
            } else if (auth instanceof DigestAuth) {
                authPrefs.add("Digest");
            } else if (auth instanceof NtlmAuth) {
                authPrefs.add("NTLM");
            }
            rcBuilder.setTargetPreferredAuthSchemes(authPrefs);
            if (auth instanceof BasicAuth || auth instanceof DigestAuth) {
                a = (BasicDigestAuth)auth;
                uid = a.getUsername();
                pwd = new String(a.getPassword());
                String host = StringUtil.isEmpty(a.getHost()) ? urlHost : a.getHost();
                String realm = StringUtil.isEmpty(a.getRealm()) ? AuthScope.ANY_REALM : a.getRealm();
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(host, urlPort, realm), new UsernamePasswordCredentials(uid, pwd));
                hcBuilder.setDefaultCredentialsProvider(credsProvider);
                if (a.isPreemptive()) {
                    BasicAuthCache authCache = new BasicAuthCache();
                    RFC2617Scheme authScheme = a instanceof BasicAuth ? new BasicScheme() : new DigestScheme();
                    authCache.put(new HttpHost(urlHost, urlPort, urlProtocol), authScheme);
                    HttpClientContext localContext = HttpClientContext.create();
                    localContext.setAuthCache(authCache);
                    httpContext = localContext;
                }
            }
            if (auth instanceof NtlmAuth) {
                a = (NtlmAuth)auth;
                uid = a.getUsername();
                pwd = new String(a.getPassword());
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(AuthScope.ANY, new NTCredentials(uid, pwd, a.getWorkstation(), a.getDomain()));
                hcBuilder.setDefaultCredentialsProvider(credsProvider);
            }
        }
        try {
            ResponseBean response;
            block78: {
                Header[] responseHeaders;
                SSLReq sslReq;
                ReqEntity bean;
                Object a;
                String authHeader;
                auth = request.getAuth();
                if (auth != null && auth instanceof AuthorizationHeaderAuth && StringUtil.isNotEmpty(authHeader = (a = (AuthorizationHeaderAuth)auth).getAuthorizationHeaderValue())) {
                    Iterator<HttpCookie> header = new BasicHeader("Authorization", authHeader);
                    reqBuilder.addHeader((Header)((Object)header));
                }
                MultiValueMap<String, String> header_data = request.getHeaders();
                for (String key : header_data.keySet()) {
                    for (String value : header_data.get(key)) {
                        BasicHeader header = new BasicHeader(key, value);
                        reqBuilder.addHeader(header);
                    }
                }
                rcBuilder.setCookieSpec("default");
                RESTClientCookieStore store = new RESTClientCookieStore();
                List<HttpCookie> cookies = request.getCookies();
                for (HttpCookie cookie : cookies) {
                    BasicClientCookie c = new BasicClientCookie(cookie.getName(), cookie.getValue());
                    c.setVersion(cookie.getVersion());
                    c.setDomain(urlHost);
                    c.setPath("/");
                    store.addCookie(c);
                }
                hcBuilder.setDefaultCookieStore(store);
                if (HttpUtil.isEntityEnclosingMethod(reqBuilder.getMethod()) && (bean = request.getBody()) != null) {
                    try {
                        if (bean instanceof ReqEntitySimple) {
                            AbstractHttpEntity e = HTTPClientUtil.getEntity((ReqEntitySimple)bean);
                            reqBuilder.setEntity(e);
                        } else if (bean instanceof ReqEntityMultipart) {
                            ReqEntityMultipart multipart = (ReqEntityMultipart)bean;
                            MultipartEntityBuilder meb = MultipartEntityBuilder.create();
                            meb.setMimeSubtype(multipart.getSubtype().toString());
                            MultipartMode mpMode = multipart.getMode();
                            switch (mpMode) {
                                case BROWSER_COMPATIBLE: {
                                    meb.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
                                    break;
                                }
                                case RFC_6532: {
                                    meb.setMode(HttpMultipartMode.RFC6532);
                                    break;
                                }
                                case STRICT: {
                                    meb.setMode(HttpMultipartMode.STRICT);
                                }
                            }
                            for (ReqEntityPart part : multipart.getBody()) {
                                Object ct;
                                Object body;
                                ReqEntityPart p;
                                AbstractContentBody cb = null;
                                if (part instanceof ReqEntityStringPart) {
                                    p = (ReqEntityStringPart)part;
                                    body = p.getPart();
                                    ct = p.getContentType();
                                    cb = ct != null ? new StringBody((String)body, HTTPClientUtil.getContentType((ContentType)ct)) : new StringBody((String)body, org.apache.http.entity.ContentType.DEFAULT_TEXT);
                                } else if (part instanceof ReqEntityFilePart) {
                                    p = (ReqEntityFilePart)part;
                                    body = p.getPart();
                                    ct = p.getContentType();
                                    cb = ct != null ? new FileBody((File)body, HTTPClientUtil.getContentType((ContentType)ct), p.getFilename()) : new FileBody((File)body, org.apache.http.entity.ContentType.DEFAULT_BINARY, p.getFilename());
                                }
                                FormBodyPartBuilder bodyPart = FormBodyPartBuilder.create().setName(part.getName()).setBody(cb);
                                MultiValueMap<String, String> fields = part.getFields();
                                for (String string : fields.keySet()) {
                                    for (String value : fields.get(string)) {
                                        bodyPart.addField(string, value);
                                    }
                                }
                                meb.addPart(bodyPart.build());
                            }
                            reqBuilder.setEntity(meb.build());
                        }
                    }
                    catch (UnsupportedEncodingException ex) {
                        for (View view : views) {
                            view.doError(Util.getStackTrace(ex));
                            view.doEnd();
                        }
                        if (!this.interruptedShutdown) {
                            try {
                                if (this.httpClient != null) {
                                    this.httpClient.close();
                                }
                            }
                            catch (IOException ex2) {
                                LOG.log(Level.WARNING, "Exception when closing httpClient", ex2);
                            }
                        } else {
                            this.interruptedShutdown = false;
                        }
                        for (View view : views) {
                            view.doEnd();
                        }
                        this.isRequestCompleted = true;
                        return;
                    }
                }
                if ((sslReq = request.getSslReq()) != null) {
                    HostnameVerifier hcVerifier;
                    SSLHostnameVerifier verifier = sslReq.getHostNameVerifier();
                    switch (verifier) {
                        case ALLOW_ALL: {
                            hcVerifier = new NoopHostnameVerifier();
                            break;
                        }
                        default: {
                            hcVerifier = new DefaultHostnameVerifier();
                        }
                    }
                    KeyStore trustStore = sslReq.getTrustStore() == null ? null : sslReq.getTrustStore().getKeyStore();
                    KeyStore keyStore = sslReq.getKeyStore() == null ? null : sslReq.getKeyStore().getKeyStore();
                    TrustAllTrustStrategy trustStrategy = sslReq.isTrustAllCerts() ? new TrustAllTrustStrategy() : null;
                    SSLContext ctx = new SSLContextBuilder().loadKeyMaterial(keyStore, sslReq.getKeyStore() != null ? sslReq.getKeyStore().getPassword() : null).loadTrustMaterial(trustStore, trustStrategy).setSecureRandom(null).useProtocol("TLS").build();
                    SSLConnectionSocketFactory sf = new SSLConnectionSocketFactory(ctx, hcVerifier);
                    hcBuilder.setSSLSocketFactory(sf);
                }
                rcBuilder.setRedirectsEnabled(request.isFollowRedirect());
                long startTime = System.currentTimeMillis();
                RequestConfig rc = rcBuilder.build();
                reqBuilder.setConfig(rc);
                HttpUriRequest req = reqBuilder.build();
                this.httpClient = hcBuilder.build();
                CloseableHttpResponse http_res = this.httpClient.execute(req, httpContext);
                long endTime = System.currentTimeMillis();
                response = new ResponseBean();
                response.setExecutionTime(endTime - startTime);
                response.setStatusCode(http_res.getStatusLine().getStatusCode());
                response.setStatusLine(http_res.getStatusLine().toString());
                for (Header header : responseHeaders = http_res.getAllHeaders()) {
                    response.addHeader(header.getName(), header.getValue());
                }
                HttpEntity httpEntity = http_res.getEntity();
                if (httpEntity != null) {
                    if (request.isIgnoreResponseBody()) {
                        EntityUtils.consumeQuietly(httpEntity);
                    } else {
                        InputStream is = httpEntity.getContent();
                        try {
                            byte[] responseBody = StreamUtil.inputStream2Bytes(is);
                            if (responseBody != null) {
                                response.setResponseBody(responseBody);
                            }
                        }
                        catch (IOException ex) {
                            View[] viewArray = views;
                            int n = viewArray.length;
                            for (int i = 0; i < n; ++i) {
                                View view = viewArray[i];
                                view.doError("Byte array conversion from response body stream failed.");
                            }
                            LOG.log(Level.WARNING, ex.getMessage(), ex);
                        }
                    }
                }
                try {
                    TestSuite suite = TestUtil.getTestSuite(request, response);
                    if (suite == null) break block78;
                    TestResult testResult = TestUtil.execute(suite);
                    response.setTestResult(testResult);
                }
                catch (TestException ex) {
                    for (View view : views) {
                        view.doError(Util.getStackTrace(ex));
                    }
                }
            }
            for (View view : views) {
                view.doResponse(response);
            }
        }
        catch (IOException | IllegalStateException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | InvalidKeySpecException ex) {
            if (!this.interruptedShutdown) {
                for (View view : views) {
                    view.doError(Util.getStackTrace(ex));
                }
            } else {
                for (View view : views) {
                    view.doCancelled();
                }
            }
        }
        finally {
            if (!this.interruptedShutdown) {
                try {
                    if (this.httpClient != null) {
                        this.httpClient.close();
                    }
                }
                catch (IOException ex) {
                    LOG.log(Level.WARNING, "Exception when closing httpClient", ex);
                }
            } else {
                this.interruptedShutdown = false;
            }
            for (View view : views) {
                view.doEnd();
            }
            this.isRequestCompleted = true;
        }
    }

    @Override
    public void abortExecution() {
        if (!this.isRequestCompleted) {
            this.interruptedShutdown = true;
            try {
                if (this.httpClient != null) {
                    this.httpClient.close();
                }
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "Exception when closing httpClient", ex);
            }
        } else {
            LOG.info("Request already completed. Doing nothing.");
        }
    }
}

