/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ivy.ant.IvyTask;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.plugins.parser.m2.PomModuleDescriptorWriter;
import org.apache.ivy.plugins.parser.m2.PomWriterOptions;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorParser;
import org.apache.ivy.util.FileUtil;
import org.apache.tools.ant.BuildException;

public class IvyMakePom
extends IvyTask {
    private String artifactName;
    private String artifactPackaging;
    private File pomFile = null;
    private File headerFile = null;
    private File templateFile = null;
    private boolean printIvyInfo = true;
    private String conf;
    private File ivyFile = null;
    private String description;
    private Collection mappings = new ArrayList();
    private Collection dependencies = new ArrayList();

    public File getPomFile() {
        return this.pomFile;
    }

    public void setPomFile(File file) {
        this.pomFile = file;
    }

    public File getIvyFile() {
        return this.ivyFile;
    }

    public void setIvyFile(File file) {
        this.ivyFile = file;
    }

    public File getHeaderFile() {
        return this.headerFile;
    }

    public void setHeaderFile(File file) {
        this.headerFile = file;
    }

    public File getTemplateFile() {
        return this.templateFile;
    }

    public void setTemplateFile(File file) {
        this.templateFile = file;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public boolean isPrintIvyInfo() {
        return this.printIvyInfo;
    }

    public void setPrintIvyInfo(boolean bl) {
        this.printIvyInfo = bl;
    }

    public String getConf() {
        return this.conf;
    }

    public void setConf(String string) {
        this.conf = string;
    }

    public String getArtifactName() {
        return this.artifactName;
    }

    public void setArtifactName(String string) {
        this.artifactName = string;
    }

    public String getArtifactPackaging() {
        return this.artifactPackaging;
    }

    public void setArtifactPackaging(String string) {
        this.artifactPackaging = string;
    }

    public Mapping createMapping() {
        Mapping mapping = new Mapping();
        this.mappings.add(mapping);
        return mapping;
    }

    public Dependency createDependency() {
        Dependency dependency = new Dependency();
        this.dependencies.add(dependency);
        return dependency;
    }

    @Override
    public void doExecute() throws BuildException {
        try {
            if (this.ivyFile == null) {
                throw new BuildException("source ivy file is required for makepom task");
            }
            if (this.pomFile == null) {
                throw new BuildException("destination pom file is required for makepom task");
            }
            ModuleDescriptor moduleDescriptor = XmlModuleDescriptorParser.getInstance().parseDescriptor(this.getSettings(), this.ivyFile.toURI().toURL(), false);
            PomModuleDescriptorWriter.write(moduleDescriptor, this.pomFile, this.getPomWriterOptions());
        }
        catch (MalformedURLException malformedURLException) {
            throw new BuildException("unable to convert given ivy file to url: " + this.ivyFile + ": " + malformedURLException, (Throwable)malformedURLException);
        }
        catch (ParseException parseException) {
            this.log(parseException.getMessage(), 0);
            throw new BuildException("syntax errors in ivy file " + this.ivyFile + ": " + parseException, (Throwable)parseException);
        }
        catch (Exception exception) {
            throw new BuildException("impossible convert given ivy file to pom file: " + exception + " from=" + this.ivyFile + " to=" + this.pomFile, (Throwable)exception);
        }
    }

    private PomWriterOptions getPomWriterOptions() throws IOException {
        PomWriterOptions pomWriterOptions = new PomWriterOptions();
        pomWriterOptions.setConfs(this.splitConfs(this.conf)).setArtifactName(this.getArtifactName()).setArtifactPackaging(this.getArtifactPackaging()).setPrintIvyInfo(this.isPrintIvyInfo()).setDescription(this.getDescription()).setExtraDependencies(this.getDependencies()).setTemplate(this.getTemplateFile());
        if (!this.mappings.isEmpty()) {
            pomWriterOptions.setMapping(new PomWriterOptions.ConfigurationScopeMapping(this.getMappingsMap()));
        }
        if (this.headerFile != null) {
            pomWriterOptions.setLicenseHeader(FileUtil.readEntirely(this.getHeaderFile()));
        }
        return pomWriterOptions;
    }

    private Map getMappingsMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Mapping mapping : this.mappings) {
            String[] stringArray = this.splitConfs(mapping.getConf());
            for (int i = 0; i < stringArray.length; ++i) {
                if (hashMap.containsKey(stringArray[i])) continue;
                hashMap.put(stringArray[i], mapping.getScope());
            }
        }
        return hashMap;
    }

    private List getDependencies() {
        ArrayList<PomWriterOptions.ExtraDependency> arrayList = new ArrayList<PomWriterOptions.ExtraDependency>();
        for (Dependency dependency : this.dependencies) {
            arrayList.add(new PomWriterOptions.ExtraDependency(dependency.getGroup(), dependency.getArtifact(), dependency.getVersion(), dependency.getScope(), dependency.getType(), dependency.getClassifier(), dependency.getOptional()));
        }
        return arrayList;
    }

    public class Dependency {
        private String group = null;
        private String artifact = null;
        private String version = null;
        private String scope = null;
        private String type = null;
        private String classifier = null;
        private boolean optional = false;

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String string) {
            this.group = string;
        }

        public String getArtifact() {
            return this.artifact;
        }

        public void setArtifact(String string) {
            this.artifact = string;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String string) {
            this.version = string;
        }

        public String getScope() {
            return this.scope;
        }

        public void setScope(String string) {
            this.scope = string;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String string) {
            this.type = string;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public void setClassifier(String string) {
            this.classifier = string;
        }

        public boolean getOptional() {
            return this.optional;
        }

        public void setOptional(boolean bl) {
            this.optional = bl;
        }
    }

    public class Mapping {
        private String conf;
        private String scope;

        public String getConf() {
            return this.conf;
        }

        public void setConf(String string) {
            this.conf = string;
        }

        public String getScope() {
            return this.scope;
        }

        public void setScope(String string) {
            this.scope = string;
        }
    }
}

