/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.trigger;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.event.IvyEvent;
import org.apache.ivy.core.resolve.ResolveProcessException;
import org.apache.ivy.plugins.trigger.AbstractTrigger;
import org.apache.ivy.util.Message;

public class LogTrigger
extends AbstractTrigger {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private String message = "";
    private File file = null;
    private boolean append = true;
    private String encoding = "";

    @Override
    public void progress(IvyEvent ivyEvent) {
        this.log(IvyPatternHelper.substituteVariables(this.message, ivyEvent.getAttributes()));
    }

    protected void log(String string) {
        if (this.file == null) {
            Message.info(string);
        } else {
            Writer writer = null;
            try {
                string = string + LINE_SEPARATOR;
                String string2 = this.file.getAbsolutePath();
                writer = this.encoding == null || this.encoding.length() == 0 ? new FileWriter(string2, this.append) : new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string2, this.append), this.encoding));
                writer.write(string, 0, string.length());
            }
            catch (IOException iOException) {
                throw new ResolveProcessException(iOException);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {
                        throw new ResolveProcessException(iOException);
                    }
                }
            }
        }
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setAppend(boolean bl) {
        this.append = bl;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }
}

