/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin;

import com.l2fprod.gui.plaf.skin.CompoundSkin;
import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import com.l2fprod.util.WindowUtils;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoundedRangeModel;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.UIManager;

public class SkinPreviewWindow
extends JFrame {
    public SkinPreviewWindow() {
        JTabbedPane tabs = new JTabbedPane();
        this.getContentPane().add("Center", tabs);
        tabs.addTab("Buttons", new ButtonTest());
        tabs.addTab("CheckBox", new CheckBoxTest());
        tabs.addTab("Radio", new RadioTest());
        tabs.addTab("Progress", new ProgressTest());
        tabs.addTab("Desktop", new InternalTest());
        tabs.addTab("Scrollbars", new ScrollTest());
        tabs.addTab("List", new ListTest());
        tabs.addTab("Table", new TableTest());
        JMenuBar menubar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.add(new JCheckBoxMenuItem("Check Box ?"));
        JMenu submenu = new JMenu("Sub menu");
        submenu.add(new JMenuItem("Hi!"));
        menu.add(submenu);
        menu.add(new JMenuItem("Exit"));
        menubar.add(menu);
        this.setJMenuBar(menubar);
        WindowUtils.sizeTo(this, 0.5, 0.5);
        WindowUtils.centerOnScreen(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                SkinPreviewWindow.this.dispose();
            }
        });
    }

    public static void main(String[] args) throws Exception {
        Skin skin = null;
        skin = args.length > 1 ? new CompoundSkin(SkinLookAndFeel.loadSkin(args[0]), SkinLookAndFeel.loadSkin(args[1])) : SkinLookAndFeel.loadSkin(args[0]);
        SkinLookAndFeel.setSkin(skin);
        UIManager.setLookAndFeel("com.l2fprod.gui.plaf.skin.SkinLookAndFeel");
    }

    static class TableTest
    extends JPanel {
        TableTest() {
            this.setLayout(new BorderLayout());
            Object[] columns = new String[4];
            Object[][] rowData = new String[10][4];
            int c = rowData[0].length;
            for (int i = 0; i < c; ++i) {
                columns[i] = "Column" + i;
                int d = rowData.length;
                for (int j = 0; j < d; ++j) {
                    rowData[j][i] = "Cell(" + i + ", " + j + ")";
                }
            }
            this.add("Center", new JScrollPane(new JTable(rowData, columns)));
        }
    }

    static class ListTest
    extends JPanel {
        ListTest() {
            this.setLayout(new BorderLayout());
            String[] values = new String[50];
            int c = values.length;
            for (int i = 0; i < c; ++i) {
                values[i] = "Item " + i;
            }
            this.add("Center", new JScrollPane(new JList<String>(values)));
        }
    }

    static class ScrollTest
    extends JPanel {
        ScrollTest() {
            this.setLayout(new BorderLayout());
            this.add("Center", new JScrollPane(new JTree()));
        }
    }

    static class InternalTest
    extends JPanel {
        InternalTest() {
            this.setLayout(new BorderLayout());
            JDesktopPane desk = new JDesktopPane();
            this.add("Center", new JScrollPane(desk));
            desk.putClientProperty("JDesktopPane.backgroundEnabled", Boolean.TRUE);
            JInternalFrame frame = new JInternalFrame("A Frame", true, true, true, true);
            frame.getContentPane().add(new JButton("Ola"));
            frame.setVisible(true);
            frame.setSize(200, 100);
            desk.add(frame);
            frame = new JInternalFrame("An other Frame", true, true, true, true);
            frame.getContentPane().add(new JButton("Hello"));
            frame.setMaximizable(false);
            frame.setVisible(true);
            frame.setSize(200, 200);
            frame.setLocation(50, 50);
            desk.add(frame);
        }
    }

    static class ProgressTest
    extends JPanel {
        ProgressTest() {
            this.setLayout(new BorderLayout());
            DefaultBoundedRangeModel model = new DefaultBoundedRangeModel(0, 0, 0, 100);
            JProgressBar progress = new JProgressBar(model);
            this.add("South", progress);
            JSlider slider = new JSlider(model);
            this.add("North", slider);
            slider = new JSlider(1);
            slider.setModel(model);
            this.add("West", slider);
            progress = new JProgressBar(1);
            progress.setModel(model);
            this.add("East", progress);
            new Timer(50, new ActionListener(this, model){
                int counter;
                private final /* synthetic */ BoundedRangeModel val$model;
                private final /* synthetic */ ProgressTest this$0;
                {
                    this.this$0 = this$0;
                    this.val$model = val$model;
                    this.counter = 0;
                }

                public void actionPerformed(ActionEvent e) {
                    if (this.val$model.getValue() >= 100) {
                        this.counter += 20;
                        if (this.counter >= 500) {
                            this.val$model.setValue(0);
                        }
                    } else {
                        this.val$model.setValue(this.val$model.getValue() + 2);
                        this.counter = 0;
                    }
                }
            }).start();
        }
    }

    static class RadioTest
    extends JPanel {
        RadioTest() {
            ButtonGroup group = new ButtonGroup();
            this.setLayout(new GridLayout(3, 1));
            JRadioButton button = new JRadioButton("Hello 1");
            this.add(button);
            group.add(button);
            button = new JRadioButton("Hello 2");
            this.add(button);
            group.add(button);
            button = new JRadioButton("Hello 3");
            this.add(button);
            group.add(button);
        }
    }

    static class CheckBoxTest
    extends JPanel {
        CheckBoxTest() {
            this.setLayout(new BorderLayout());
            Box p = new Box(1);
            p.add(new JCheckBox("Hello ???"));
            p.add(Box.createVerticalStrut(3));
            p.add(new JComboBox<String>(new String[]{"1", "2", "4", "8"}));
            p.add(Box.createVerticalStrut(3));
            JComboBox<String> editable = new JComboBox<String>(new String[]{"1", "2", "4", "8"});
            editable.setEditable(true);
            p.add(editable);
            p.add(Box.createVerticalStrut(3));
            JPanel toggles = new JPanel();
            toggles.setLayout(new FlowLayout());
            ButtonGroup group = new ButtonGroup();
            JToggleButton button = new JToggleButton("Hello 1");
            toggles.add(button);
            group.add(button);
            button = new JToggleButton("Hello 2");
            toggles.add(button);
            group.add(button);
            button = new JToggleButton("Hello 3");
            toggles.add(button);
            group.add(button);
            p.add(toggles);
            this.add("North", p);
        }
    }

    static class ButtonTest
    extends JPanel {
        ButtonTest() {
            this.setLayout(new BorderLayout());
            this.add("North", new JButton("North"));
            this.add("East", new JButton("East"));
            this.add("South", new JButton("South"));
            this.add("West", new JButton("West"));
            JButton b = new JButton("Center");
            b.setEnabled(false);
            this.add("Center", b);
        }
    }
}

