/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.app;

import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.fife.ui.app.GUIApplication;

public abstract class StandardAction
extends AbstractAction {
    public static final String DEFAULT_ACCELERATOR = "StandardAction.DefaultAccelerator";
    private GUIApplication app;

    public StandardAction(GUIApplication app) {
        this.app = app;
    }

    public StandardAction(GUIApplication app, String key) {
        this(app, key, null);
    }

    public StandardAction(GUIApplication app, String key, String icon) {
        this(app, app.getResourceBundle(), key);
        if (icon != null) {
            this.setIcon(icon);
        }
    }

    public StandardAction(GUIApplication app, ResourceBundle msg, String key) {
        this(app);
        if (msg == null) {
            msg = app.getResourceBundle();
        }
        try {
            this.setName(msg.getString(key));
        }
        catch (MissingResourceException mre) {
            // empty catch block
        }
        try {
            String mnemonicKey = key + ".Mnemonic";
            this.setMnemonic(msg.getString(mnemonicKey).charAt(0));
        }
        catch (MissingResourceException mre) {
            // empty catch block
        }
        try {
            String accelKey = key + ".Accelerator";
            String temp = msg.getString(accelKey);
            if (temp != null) {
                temp = this.massageAcceleratorString(temp);
                KeyStroke ks = KeyStroke.getKeyStroke(temp);
                this.setAccelerator(ks);
                this.setDefaultAccelerator(ks);
            }
        }
        catch (MissingResourceException mre) {
            // empty catch block
        }
        try {
            String shortDescKey = key + ".ShortDesc";
            this.setShortDescription(msg.getString(shortDescKey));
        }
        catch (MissingResourceException mre) {
            // empty catch block
        }
    }

    public KeyStroke getAccelerator() {
        return (KeyStroke)this.getValue("AcceleratorKey");
    }

    public GUIApplication getApplication() {
        return this.app;
    }

    public KeyStroke getDefaultAccelerator() {
        return (KeyStroke)this.getValue(DEFAULT_ACCELERATOR);
    }

    public Icon getIcon() {
        return (Icon)this.getValue("SmallIcon");
    }

    public int getMnemonic() {
        Integer i = (Integer)this.getValue("MnemonicKey");
        return i != null ? i : -1;
    }

    public String getName() {
        return (String)this.getValue("Name");
    }

    public String getShortDescription() {
        return (String)this.getValue("ShortDescription");
    }

    private String massageAcceleratorString(String accelerator) {
        String DEFAULT = "default ";
        int index = accelerator.indexOf("default ");
        if (index > -1) {
            String replacement = this.app.getOS() == 2 ? "meta " : "control ";
            accelerator = accelerator.substring(0, index) + replacement + accelerator.substring(index + "default ".length());
        }
        return accelerator;
    }

    public void setAccelerator(KeyStroke accelerator) {
        this.putValue("AcceleratorKey", accelerator);
    }

    public void setDefaultAccelerator(KeyStroke accelerator) {
        this.putValue(DEFAULT_ACCELERATOR, accelerator);
    }

    public void setIcon(Icon icon) {
        this.putValue("SmallIcon", icon);
    }

    public void setIcon(String res) {
        this.setIcon(this.getClass().getResource(res));
    }

    public void setIcon(URL res) {
        this.setIcon(new ImageIcon(res));
    }

    public void setMnemonic(int mnemonic) {
        this.putValue("MnemonicKey", mnemonic > 0 ? new Integer(mnemonic) : null);
    }

    public void setName(String name) {
        this.putValue("Name", name);
    }

    public void setShortDescription(String desc) {
        this.putValue("ShortDescription", desc);
    }
}

