/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;

public class GDBus {
    static final String SWT_GDBUS_VERSION_INFO = "SWT_LIB GDbus firing up. Implementation v1.5";
    private static boolean initialized;
    private static List<GDBusMethod> gdbusMethods;
    private static final String DBUS_SERVICE_NAME = "org.eclipse.swt";
    private static final String DBUS_OBJECT_NAME = "/org/eclipse/swt";
    private static final String INTERFACE_NAME = "org.eclipse.swt";
    private static Callback onBusAcquired;
    private static Callback onNameAcquired;
    private static Callback onNameLost;
    private static Callback handleMethod;

    public static void init(GDBusMethod[] methods, String appName) {
        Object serviceName = "org.eclipse.swt";
        if (initialized) {
            return;
        }
        initialized = true;
        if (methods == null || methods.length == 0) {
            System.err.println("SWT Error, no gdbus methods to initialize.");
            return;
        }
        if (appName != null) {
            appName = appName.replaceAll("[^0-9A-Za-z_.\\-]", "-");
            serviceName = (String)serviceName + "." + appName;
        }
        gdbusMethods = Arrays.asList(methods);
        int owner_id = OS.g_bus_own_name(2, Converter.javaStringToCString((String)serviceName), 3, onBusAcquired.getAddress(), onNameAcquired.getAddress(), onNameLost.getAddress(), 0L, 0L);
        if (owner_id == 0) {
            System.err.println("SWT GDBus: Failed to aquire bus name: " + (String)serviceName);
        }
    }

    static void teardown_gdbus() {
    }

    private static long onBusAcquired(long gDBusConnection, long const_gchar_name, long user_data) {
        StringBuilder dbus_introspection_xml = new StringBuilder();
        dbus_introspection_xml.append("<node><interface name='org.eclipse.swt'>\n");
        for (GDBusMethod method : gdbusMethods) {
            dbus_introspection_xml.append("  <method name='" + method.name + "'>\n");
            dbus_introspection_xml.append("   " + method.getMethodArgsXmlSignature() + "\n");
            dbus_introspection_xml.append("  </method>\n");
        }
        dbus_introspection_xml.append("</interface></node>");
        long[] error = new long[1];
        long gdBusNodeInfo = OS.g_dbus_node_info_new_for_xml(Converter.javaStringToCString(dbus_introspection_xml.toString()), error);
        if (gdBusNodeInfo == 0L || error[0] != 0L) {
            System.err.println("SWT GDBus: Failed to get introspection data");
        }
        assert (gdBusNodeInfo != 0L) : "SWT GDBus: introspection data should not be 0";
        long[] error2 = new long[1];
        long interface_info = OS.g_dbus_node_info_lookup_interface(gdBusNodeInfo, Converter.javaStringToCString("org.eclipse.swt"));
        long[] vtable = new long[]{handleMethod.getAddress(), 0L, 0L};
        OS.g_dbus_connection_register_object(gDBusConnection, Converter.javaStringToCString(DBUS_OBJECT_NAME), interface_info, vtable, 0L, 0L, error2);
        if (error2[0] != 0L) {
            System.err.println("SWT GDBus: Failed to register object: /org/eclipse/swt");
            return 0L;
        }
        return 0L;
    }

    private static long onNameAcquired(long connection, long name, long user_data) {
        return 0L;
    }

    private static long onNameLost(long connection, long name, long user_data) {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long handleMethod(long connection, long sender, long object_path, long interface_name, long method_name, long gvar_parameters, long invocation, long user_data) {
        long resultGVariant = 0L;
        try {
            String java_method_name = Converter.cCharPtrToJavaString(method_name, false);
            for (GDBusMethod gdbusMethod : gdbusMethods) {
                if (!gdbusMethod.getName().equals(java_method_name)) continue;
                Object[] args = GDBus.convertGVariantToJava(gvar_parameters);
                Object[] returnVal = gdbusMethod.getUserFunction().apply(args);
                if (returnVal == null || returnVal instanceof Object[]) {
                    resultGVariant = GDBus.convertJavaToGVariant(returnVal);
                } else {
                    System.err.println("SWT GDBus error processing user return value: " + returnVal.toString() + ". Return value must be an Object[] or null.");
                }
                break;
            }
        }
        catch (Exception e) {
            System.err.println("SWT GDBUS ERROR: Error in handling method: \n" + e.getMessage());
        }
        finally {
            OS.g_dbus_method_invocation_return_value(invocation, resultGVariant);
        }
        return 0L;
    }

    private static Object[] convertGVariantToJava(long gVariant) {
        Object retVal = GDBus.convertGVariantToJavaHelper(gVariant);
        if (retVal instanceof Object[]) {
            return (Object[])retVal;
        }
        System.err.println("SWT GDBus Error converting arguments : Expecting object array, received Object.");
        return null;
    }

    private static Object convertGVariantToJavaHelper(long gVariant) {
        if (OS.g_variant_is_of_type(gVariant, OS.G_VARIANT_TYPE_STRING)) {
            return Converter.cCharPtrToJavaString(OS.g_variant_get_string(gVariant, null), false);
        }
        if (OS.g_variant_is_of_type(gVariant, OS.G_VARIANT_TYPE_BOOLEAN)) {
            return OS.g_variant_get_boolean(gVariant);
        }
        if (OS.g_variant_is_of_type(gVariant, OS.G_VARIANT_TYPE_IN32)) {
            return OS.g_variant_get_int32(gVariant);
        }
        if (OS.g_variant_is_of_type(gVariant, OS.G_VARIANT_TYPE_TUPLE)) {
            int length = (int)OS.g_variant_n_children(gVariant);
            Object[] result = new Object[length];
            for (int i = 0; i < length; ++i) {
                result[i] = GDBus.convertGVariantToJavaHelper(OS.g_variant_get_child_value(gVariant, i));
            }
            return result;
        }
        if (OS.g_variant_is_of_type(gVariant, OS.G_VARIANT_TYPE_STRING_ARRAY)) {
            int length = (int)OS.g_variant_n_children(gVariant);
            String[] result = new String[length];
            for (int i = 0; i < length; ++i) {
                result[i] = (String)GDBus.convertGVariantToJavaHelper(OS.g_variant_get_child_value(gVariant, i));
            }
            return result;
        }
        String typeString = Converter.cCharPtrToJavaString(OS.g_variant_get_type_string(gVariant), false);
        System.err.println("SWT GDBus: Error. Unhandled variant type (i.e DBus type):  " + typeString + "     You probably need to update  (SWT) GDBus.java:convertGVariantToJavaHelper() to support this type.");
        SWT.error(5);
        return null;
    }

    private static long convertJavaToGVariant(Object javaObject) throws SWTException {
        if (javaObject == null) {
            return 0L;
        }
        if (javaObject instanceof String) {
            return OS.g_variant_new_string(Converter.javaStringToCString((String)javaObject));
        }
        if (javaObject instanceof Boolean) {
            return OS.g_variant_new_boolean((Boolean)javaObject);
        }
        if (javaObject instanceof Integer) {
            return OS.g_variant_new_int32((Integer)javaObject);
        }
        if (javaObject instanceof Object[]) {
            Object[] arrayValue = (Object[])javaObject;
            int length = arrayValue.length;
            long[] variants = new long[length];
            for (int i = 0; i < length; ++i) {
                variants[i] = GDBus.convertJavaToGVariant(arrayValue[i]);
            }
            return OS.g_variant_new_tuple(variants, length);
        }
        System.err.println("SWT GDbus: Invalid object being returned to caller: " + javaObject.toString() + "   You probably need to update (SWT) GDBus.java:convertJavaToGVariant()");
        throw new SWTException(5);
    }

    static {
        onBusAcquired = new Callback(GDBus.class, "onBusAcquired", 3);
        onNameAcquired = new Callback(GDBus.class, "onNameAcquired", 3);
        onNameLost = new Callback(GDBus.class, "onNameLost", 3);
        handleMethod = new Callback(GDBus.class, "handleMethod", 8);
        String swt_lib_versions = OS.getEnvironmentalVariable("SWT_LIB_VERSIONS");
        if (swt_lib_versions != null && swt_lib_versions.equals("1")) {
            System.out.println(SWT_GDBUS_VERSION_INFO);
        }
    }

    public static class GDBusMethod {
        private final String name;
        private final Function<Object[], Object[]> userFunction;
        private final String methodArgsXmlSignature;

        public GDBusMethod(String name, String[][] inputArgs, String[][] outputArgs, Function<Object[], Object[]> userFunction) {
            this.name = name;
            this.userFunction = userFunction;
            StringBuilder gdbBusArgsXml = new StringBuilder();
            for (String[] dataType : inputArgs) {
                gdbBusArgsXml.append("     <arg type='" + dataType[0] + "' name='" + dataType[1] + "' direction='in'/>\n");
            }
            for (String[] dataType : outputArgs) {
                gdbBusArgsXml.append("     <arg type='" + dataType[0] + "' name='" + dataType[1] + "' direction='out'/>\n");
            }
            this.methodArgsXmlSignature = gdbBusArgsXml.toString();
        }

        private String getName() {
            return this.name;
        }

        private Function<Object[], Object[]> getUserFunction() {
            return this.userFunction;
        }

        private String getMethodArgsXmlSignature() {
            return this.methodArgsXmlSignature;
        }
    }
}

