/*
 * 
 * Copyright (C) 2012-2025 Uwe Waldmann
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this font software and associated files (the "Software"),
 * to deal in the Software without restriction, including without
 * limitation the rights to use, copy, modify, merge, publish,
 * distribute, embed, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 * 
 * (1) The above copyright notice, this permission notice, and the
 *     disclaimer below shall be included in all copies or substantial
 *     portions of the Software.
 * 
 * (2) If the design of any glyphs in the fonts that are contained in the
 *     Software or generated during the installation process is modified
 *     or if additional glyphs are added to the fonts, the fonts
 *     must be renamed. The new names may not contain the word "UW",
 *     irrespective of capitalisation; the new names may contain the word
 *     "ttyp0", irrespective of capitalisation, only if preceded by a
 *     foundry name different from "UW".
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

extern u_char UWTtyp0_9x18_data[];

struct wsdisplay_font UWTtyp0_9x18 = {
	"UW Ttyp0 9x18", /* typeface name */
	0, /* firstchar */
	256, /* numchars */
	WSDISPLAY_FONTENC_IBM, /* encoding */
	9, /* width */
	18, /* height */
	2, /* stride */
	WSDISPLAY_FONTORDER_L2R, /* bit order */
	WSDISPLAY_FONTORDER_L2R, /* byte order */
	UWTtyp0_9x18_data /* data */
};

static u_char UWTtyp0_9x18_data[] = {
	/* chr0 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x5A, 0x00,    /* .#.##.#.. */
	0x42, 0x00,    /* .#....#.. */
	0x00, 0x00,    /* ......... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x00, 0x00,    /* ......... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x00, 0x00,    /* ......... */
	0x42, 0x00,    /* .#....#.. */
	0x5A, 0x00,    /* .#.##.#.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr1 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x3C, 0x00,    /* ..####... */
	0x42, 0x00,    /* .#....#.. */
	0xA5, 0x00,    /* #.#..#.#. */
	0xA5, 0x00,    /* #.#..#.#. */
	0x81, 0x00,    /* #......#. */
	0xA5, 0x00,    /* #.#..#.#. */
	0x99, 0x00,    /* #..##..#. */
	0x42, 0x00,    /* .#....#.. */
	0x3C, 0x00,    /* ..####... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr2 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x3C, 0x00,    /* ..####... */
	0x7E, 0x00,    /* .######.. */
	0xDB, 0x00,    /* ##.##.##. */
	0xDB, 0x00,    /* ##.##.##. */
	0xFF, 0x00,    /* ########. */
	0xDB, 0x00,    /* ##.##.##. */
	0xE7, 0x00,    /* ###..###. */
	0x7E, 0x00,    /* .######.. */
	0x3C, 0x00,    /* ..####... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr3 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x36, 0x00,    /* ..##.##.. */
	0x7F, 0x00,    /* .#######. */
	0x7F, 0x00,    /* .#######. */
	0x7F, 0x00,    /* .#######. */
	0x3E, 0x00,    /* ..#####.. */
	0x1C, 0x00,    /* ...###... */
	0x08, 0x00,    /* ....#.... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr4 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x1C, 0x00,    /* ...###... */
	0x3E, 0x00,    /* ..#####.. */
	0x7F, 0x00,    /* .#######. */
	0x3E, 0x00,    /* ..#####.. */
	0x1C, 0x00,    /* ...###... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr5 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x08, 0x00,    /* ....#.... */
	0x1C, 0x00,    /* ...###... */
	0x1C, 0x00,    /* ...###... */
	0x6B, 0x00,    /* .##.#.##. */
	0x7F, 0x00,    /* .#######. */
	0x6B, 0x00,    /* .##.#.##. */
	0x08, 0x00,    /* ....#.... */
	0x1C, 0x00,    /* ...###... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr6 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x08, 0x00,    /* ....#.... */
	0x1C, 0x00,    /* ...###... */
	0x3E, 0x00,    /* ..#####.. */
	0x7F, 0x00,    /* .#######. */
	0x7F, 0x00,    /* .#######. */
	0x2A, 0x00,    /* ..#.#.#.. */
	0x08, 0x00,    /* ....#.... */
	0x1C, 0x00,    /* ...###... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr7 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x1C, 0x00,    /* ...###... */
	0x3E, 0x00,    /* ..#####.. */
	0x3E, 0x00,    /* ..#####.. */
	0x3E, 0x00,    /* ..#####.. */
	0x1C, 0x00,    /* ...###... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr8 */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xE3, 0x80,    /* ###...### */
	0xC1, 0x80,    /* ##.....## */
	0xC1, 0x80,    /* ##.....## */
	0xC1, 0x80,    /* ##.....## */
	0xE3, 0x80,    /* ###...### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */

	/* chr9 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x1C, 0x00,    /* ...###... */
	0x22, 0x00,    /* ..#...#.. */
	0x41, 0x00,    /* .#.....#. */
	0x41, 0x00,    /* .#.....#. */
	0x41, 0x00,    /* .#.....#. */
	0x22, 0x00,    /* ..#...#.. */
	0x1C, 0x00,    /* ...###... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr10 */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xE3, 0x80,    /* ###...### */
	0xDD, 0x80,    /* ##.###.## */
	0xBE, 0x80,    /* #.#####.# */
	0xBE, 0x80,    /* #.#####.# */
	0xBE, 0x80,    /* #.#####.# */
	0xDD, 0x80,    /* ##.###.## */
	0xE3, 0x80,    /* ###...### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */

	/* chr11 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x03, 0x00,    /* ......##. */
	0x0F, 0x00,    /* ....####. */
	0x03, 0x00,    /* ......##. */
	0x05, 0x00,    /* .....#.#. */
	0x04, 0x00,    /* .....#... */
	0x38, 0x00,    /* ..###.... */
	0x44, 0x00,    /* .#...#... */
	0x82, 0x00,    /* #.....#.. */
	0x82, 0x00,    /* #.....#.. */
	0x82, 0x00,    /* #.....#.. */
	0x44, 0x00,    /* .#...#... */
	0x38, 0x00,    /* ..###.... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr12 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x1C, 0x00,    /* ...###... */
	0x22, 0x00,    /* ..#...#.. */
	0x41, 0x00,    /* .#.....#. */
	0x41, 0x00,    /* .#.....#. */
	0x41, 0x00,    /* .#.....#. */
	0x22, 0x00,    /* ..#...#.. */
	0x1C, 0x00,    /* ...###... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x3E, 0x00,    /* ..#####.. */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr13 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x0C, 0x00,    /* ....##... */
	0x0A, 0x00,    /* ....#.#.. */
	0x09, 0x00,    /* ....#..#. */
	0x09, 0x00,    /* ....#..#. */
	0x09, 0x00,    /* ....#..#. */
	0x0A, 0x00,    /* ....#.#.. */
	0x08, 0x00,    /* ....#.... */
	0x38, 0x00,    /* ..###.... */
	0x78, 0x00,    /* .####.... */
	0x30, 0x00,    /* ..##..... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr14 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x01, 0x00,    /* .......#. */
	0x07, 0x00,    /* .....###. */
	0x19, 0x00,    /* ...##..#. */
	0x11, 0x00,    /* ...#...#. */
	0x11, 0x00,    /* ...#...#. */
	0x11, 0x00,    /* ...#...#. */
	0x11, 0x00,    /* ...#...#. */
	0x17, 0x00,    /* ...#.###. */
	0x1F, 0x00,    /* ...#####. */
	0x76, 0x00,    /* .###.##.. */
	0xF0, 0x00,    /* ####..... */
	0x60, 0x00,    /* .##...... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr15 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x08, 0x00,    /* ....#.... */
	0x88, 0x80,    /* #...#...# */
	0x49, 0x00,    /* .#..#..#. */
	0x3E, 0x00,    /* ..#####.. */
	0x22, 0x00,    /* ..#...#.. */
	0xE3, 0x80,    /* ###...### */
	0x22, 0x00,    /* ..#...#.. */
	0x3E, 0x00,    /* ..#####.. */
	0x49, 0x00,    /* .#..#..#. */
	0x88, 0x80,    /* #...#...# */
	0x08, 0x00,    /* ....#.... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr16 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x60, 0x00,    /* .##...... */
	0x7C, 0x00,    /* .#####... */
	0x7F, 0x00,    /* .#######. */
	0x7C, 0x00,    /* .#####... */
	0x60, 0x00,    /* .##...... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr17 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x03, 0x00,    /* ......##. */
	0x1F, 0x00,    /* ...#####. */
	0x7F, 0x00,    /* .#######. */
	0x1F, 0x00,    /* ...#####. */
	0x03, 0x00,    /* ......##. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr18 */
	0x00, 0x00,    /* ......... */
	0x08, 0x00,    /* ....#.... */
	0x1C, 0x00,    /* ...###... */
	0x2A, 0x00,    /* ..#.#.#.. */
	0x49, 0x00,    /* .#..#..#. */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x49, 0x00,    /* .#..#..#. */
	0x2A, 0x00,    /* ..#.#.#.. */
	0x1C, 0x00,    /* ...###... */
	0x08, 0x00,    /* ....#.... */
	0x00, 0x00,    /* ......... */

	/* chr19 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x22, 0x00,    /* ..#...#.. */
	0x22, 0x00,    /* ..#...#.. */
	0x22, 0x00,    /* ..#...#.. */
	0x22, 0x00,    /* ..#...#.. */
	0x22, 0x00,    /* ..#...#.. */
	0x22, 0x00,    /* ..#...#.. */
	0x22, 0x00,    /* ..#...#.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x22, 0x00,    /* ..#...#.. */
	0x22, 0x00,    /* ..#...#.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr20 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x3E, 0x00,    /* ..#####.. */
	0x4A, 0x00,    /* .#..#.#.. */
	0x4A, 0x00,    /* .#..#.#.. */
	0x4A, 0x00,    /* .#..#.#.. */
	0x3A, 0x00,    /* ..###.#.. */
	0x0A, 0x00,    /* ....#.#.. */
	0x0A, 0x00,    /* ....#.#.. */
	0x0A, 0x00,    /* ....#.#.. */
	0x0A, 0x00,    /* ....#.#.. */
	0x0A, 0x00,    /* ....#.#.. */
	0x0A, 0x00,    /* ....#.#.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr21 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x18, 0x00,    /* ...##.... */
	0x24, 0x00,    /* ..#..#... */
	0x20, 0x00,    /* ..#...... */
	0x10, 0x00,    /* ...#..... */
	0x18, 0x00,    /* ...##.... */
	0x24, 0x00,    /* ..#..#... */
	0x24, 0x00,    /* ..#..#... */
	0x24, 0x00,    /* ..#..#... */
	0x24, 0x00,    /* ..#..#... */
	0x18, 0x00,    /* ...##.... */
	0x08, 0x00,    /* ....#.... */
	0x04, 0x00,    /* .....#... */
	0x24, 0x00,    /* ..#..#... */
	0x18, 0x00,    /* ...##.... */
	0x00, 0x00,    /* ......... */

	/* chr22 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0xFF, 0x00,    /* ########. */
	0xFF, 0x00,    /* ########. */
	0xFF, 0x00,    /* ########. */
	0xFF, 0x00,    /* ########. */
	0xFF, 0x00,    /* ########. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr23 */
	0x00, 0x00,    /* ......... */
	0x08, 0x00,    /* ....#.... */
	0x1C, 0x00,    /* ...###... */
	0x2A, 0x00,    /* ..#.#.#.. */
	0x49, 0x00,    /* .#..#..#. */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x49, 0x00,    /* .#..#..#. */
	0x2A, 0x00,    /* ..#.#.#.. */
	0x1C, 0x00,    /* ...###... */
	0x08, 0x00,    /* ....#.... */
	0x7F, 0x00,    /* .#######. */
	0x00, 0x00,    /* ......... */

	/* chr24 */
	0x00, 0x00,    /* ......... */
	0x08, 0x00,    /* ....#.... */
	0x1C, 0x00,    /* ...###... */
	0x2A, 0x00,    /* ..#.#.#.. */
	0x49, 0x00,    /* .#..#..#. */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x00, 0x00,    /* ......... */

	/* chr25 */
	0x00, 0x00,    /* ......... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x49, 0x00,    /* .#..#..#. */
	0x2A, 0x00,    /* ..#.#.#.. */
	0x1C, 0x00,    /* ...###... */
	0x08, 0x00,    /* ....#.... */
	0x00, 0x00,    /* ......... */

	/* chr26 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x04, 0x00,    /* .....#... */
	0x04, 0x00,    /* .....#... */
	0x02, 0x00,    /* ......#.. */
	0xFF, 0x00,    /* ########. */
	0x02, 0x00,    /* ......#.. */
	0x04, 0x00,    /* .....#... */
	0x04, 0x00,    /* .....#... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr27 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x40, 0x00,    /* .#....... */
	0xFF, 0x80,    /* ######### */
	0x40, 0x00,    /* .#....... */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr28 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x7F, 0x00,    /* .#######. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr29 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x24, 0x00,    /* ..#..#... */
	0x24, 0x00,    /* ..#..#... */
	0x42, 0x00,    /* .#....#.. */
	0xFF, 0x00,    /* ########. */
	0x42, 0x00,    /* .#....#.. */
	0x24, 0x00,    /* ..#..#... */
	0x24, 0x00,    /* ..#..#... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr30 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x18, 0x00,    /* ...##.... */
	0x18, 0x00,    /* ...##.... */
	0x3C, 0x00,    /* ..####... */
	0x3C, 0x00,    /* ..####... */
	0x7E, 0x00,    /* .######.. */
	0x7E, 0x00,    /* .######.. */
	0xFF, 0x00,    /* ########. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr31 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0xFF, 0x00,    /* ########. */
	0x7E, 0x00,    /* .######.. */
	0x7E, 0x00,    /* .######.. */
	0x3C, 0x00,    /* ..####... */
	0x3C, 0x00,    /* ..####... */
	0x18, 0x00,    /* ...##.... */
	0x18, 0x00,    /* ...##.... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr32 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr33 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr34 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x24, 0x00,    /* ..#..#... */
	0x24, 0x00,    /* ..#..#... */
	0x24, 0x00,    /* ..#..#... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr35 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x24, 0x00,    /* ..#..#... */
	0x24, 0x00,    /* ..#..#... */
	0x7E, 0x00,    /* .######.. */
	0x24, 0x00,    /* ..#..#... */
	0x24, 0x00,    /* ..#..#... */
	0x7E, 0x00,    /* .######.. */
	0x24, 0x00,    /* ..#..#... */
	0x24, 0x00,    /* ..#..#... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr36 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x1C, 0x00,    /* ...###... */
	0x2A, 0x00,    /* ..#.#.#.. */
	0x28, 0x00,    /* ..#.#.... */
	0x28, 0x00,    /* ..#.#.... */
	0x18, 0x00,    /* ...##.... */
	0x0C, 0x00,    /* ....##... */
	0x0A, 0x00,    /* ....#.#.. */
	0x0A, 0x00,    /* ....#.#.. */
	0x2A, 0x00,    /* ..#.#.#.. */
	0x1C, 0x00,    /* ...###... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr37 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x21, 0x00,    /* ..#....#. */
	0x51, 0x00,    /* .#.#...#. */
	0x52, 0x00,    /* .#.#..#.. */
	0x54, 0x00,    /* .#.#.#... */
	0x24, 0x00,    /* ..#..#... */
	0x08, 0x00,    /* ....#.... */
	0x12, 0x00,    /* ...#..#.. */
	0x15, 0x00,    /* ...#.#.#. */
	0x25, 0x00,    /* ..#..#.#. */
	0x45, 0x00,    /* .#...#.#. */
	0x42, 0x00,    /* .#....#.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr38 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x18, 0x00,    /* ...##.... */
	0x24, 0x00,    /* ..#..#... */
	0x24, 0x00,    /* ..#..#... */
	0x24, 0x00,    /* ..#..#... */
	0x18, 0x00,    /* ...##.... */
	0x10, 0x00,    /* ...#..... */
	0x29, 0x00,    /* ..#.#..#. */
	0x4A, 0x00,    /* .#..#.#.. */
	0x44, 0x00,    /* .#...#... */
	0x46, 0x00,    /* .#...##.. */
	0x39, 0x00,    /* ..###..#. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr39 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x0C, 0x00,    /* ....##... */
	0x0C, 0x00,    /* ....##... */
	0x0C, 0x00,    /* ....##... */
	0x08, 0x00,    /* ....#.... */
	0x10, 0x00,    /* ...#..... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr40 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x04, 0x00,    /* .....#... */
	0x08, 0x00,    /* ....#.... */
	0x10, 0x00,    /* ...#..... */
	0x10, 0x00,    /* ...#..... */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x10, 0x00,    /* ...#..... */
	0x10, 0x00,    /* ...#..... */
	0x08, 0x00,    /* ....#.... */
	0x04, 0x00,    /* .....#... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr41 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x20, 0x00,    /* ..#...... */
	0x10, 0x00,    /* ...#..... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x04, 0x00,    /* .....#... */
	0x04, 0x00,    /* .....#... */
	0x04, 0x00,    /* .....#... */
	0x04, 0x00,    /* .....#... */
	0x04, 0x00,    /* .....#... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x10, 0x00,    /* ...#..... */
	0x20, 0x00,    /* ..#...... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr42 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x24, 0x00,    /* ..#..#... */
	0x18, 0x00,    /* ...##.... */
	0x7E, 0x00,    /* .######.. */
	0x18, 0x00,    /* ...##.... */
	0x24, 0x00,    /* ..#..#... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr43 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x7F, 0x00,    /* .#######. */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr44 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x18, 0x00,    /* ...##.... */
	0x18, 0x00,    /* ...##.... */
	0x18, 0x00,    /* ...##.... */
	0x10, 0x00,    /* ...#..... */
	0x20, 0x00,    /* ..#...... */
	0x00, 0x00,    /* ......... */

	/* chr45 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x7F, 0x00,    /* .#######. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr46 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x18, 0x00,    /* ...##.... */
	0x18, 0x00,    /* ...##.... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr47 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x01, 0x00,    /* .......#. */
	0x01, 0x00,    /* .......#. */
	0x02, 0x00,    /* ......#.. */
	0x02, 0x00,    /* ......#.. */
	0x04, 0x00,    /* .....#... */
	0x04, 0x00,    /* .....#... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x10, 0x00,    /* ...#..... */
	0x10, 0x00,    /* ...#..... */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x40, 0x00,    /* .#....... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr48 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x18, 0x00,    /* ...##.... */
	0x24, 0x00,    /* ..#..#... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x24, 0x00,    /* ..#..#... */
	0x18, 0x00,    /* ...##.... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr49 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x08, 0x00,    /* ....#.... */
	0x18, 0x00,    /* ...##.... */
	0x28, 0x00,    /* ..#.#.... */
	0x48, 0x00,    /* .#..#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr50 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x3C, 0x00,    /* ..####... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x02, 0x00,    /* ......#.. */
	0x02, 0x00,    /* ......#.. */
	0x04, 0x00,    /* .....#... */
	0x08, 0x00,    /* ....#.... */
	0x10, 0x00,    /* ...#..... */
	0x20, 0x00,    /* ..#...... */
	0x40, 0x00,    /* .#....... */
	0x7E, 0x00,    /* .######.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr51 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x3C, 0x00,    /* ..####... */
	0x42, 0x00,    /* .#....#.. */
	0x02, 0x00,    /* ......#.. */
	0x02, 0x00,    /* ......#.. */
	0x04, 0x00,    /* .....#... */
	0x1C, 0x00,    /* ...###... */
	0x02, 0x00,    /* ......#.. */
	0x02, 0x00,    /* ......#.. */
	0x02, 0x00,    /* ......#.. */
	0x42, 0x00,    /* .#....#.. */
	0x3C, 0x00,    /* ..####... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr52 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x04, 0x00,    /* .....#... */
	0x0C, 0x00,    /* ....##... */
	0x0C, 0x00,    /* ....##... */
	0x14, 0x00,    /* ...#.#... */
	0x24, 0x00,    /* ..#..#... */
	0x24, 0x00,    /* ..#..#... */
	0x44, 0x00,    /* .#...#... */
	0x7E, 0x00,    /* .######.. */
	0x04, 0x00,    /* .....#... */
	0x04, 0x00,    /* .....#... */
	0x04, 0x00,    /* .....#... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr53 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x7C, 0x00,    /* .#####... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x58, 0x00,    /* .#.##.... */
	0x64, 0x00,    /* .##..#... */
	0x42, 0x00,    /* .#....#.. */
	0x02, 0x00,    /* ......#.. */
	0x02, 0x00,    /* ......#.. */
	0x02, 0x00,    /* ......#.. */
	0x44, 0x00,    /* .#...#... */
	0x38, 0x00,    /* ..###.... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr54 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x1C, 0x00,    /* ...###... */
	0x20, 0x00,    /* ..#...... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x5C, 0x00,    /* .#.###... */
	0x62, 0x00,    /* .##...#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x3C, 0x00,    /* ..####... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr55 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x7E, 0x00,    /* .######.. */
	0x42, 0x00,    /* .#....#.. */
	0x02, 0x00,    /* ......#.. */
	0x04, 0x00,    /* .....#... */
	0x04, 0x00,    /* .....#... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x10, 0x00,    /* ...#..... */
	0x10, 0x00,    /* ...#..... */
	0x10, 0x00,    /* ...#..... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr56 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x3C, 0x00,    /* ..####... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x24, 0x00,    /* ..#..#... */
	0x3C, 0x00,    /* ..####... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x3C, 0x00,    /* ..####... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr57 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x3C, 0x00,    /* ..####... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x46, 0x00,    /* .#...##.. */
	0x3A, 0x00,    /* ..###.#.. */
	0x02, 0x00,    /* ......#.. */
	0x02, 0x00,    /* ......#.. */
	0x04, 0x00,    /* .....#... */
	0x38, 0x00,    /* ..###.... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr58 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x18, 0x00,    /* ...##.... */
	0x18, 0x00,    /* ...##.... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x18, 0x00,    /* ...##.... */
	0x18, 0x00,    /* ...##.... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr59 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x18, 0x00,    /* ...##.... */
	0x18, 0x00,    /* ...##.... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x18, 0x00,    /* ...##.... */
	0x18, 0x00,    /* ...##.... */
	0x18, 0x00,    /* ...##.... */
	0x10, 0x00,    /* ...#..... */
	0x20, 0x00,    /* ..#...... */
	0x00, 0x00,    /* ......... */

	/* chr60 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x02, 0x00,    /* ......#.. */
	0x04, 0x00,    /* .....#... */
	0x08, 0x00,    /* ....#.... */
	0x10, 0x00,    /* ...#..... */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x10, 0x00,    /* ...#..... */
	0x08, 0x00,    /* ....#.... */
	0x04, 0x00,    /* .....#... */
	0x02, 0x00,    /* ......#.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr61 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x7E, 0x00,    /* .######.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x7E, 0x00,    /* .######.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr62 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x20, 0x00,    /* ..#...... */
	0x10, 0x00,    /* ...#..... */
	0x08, 0x00,    /* ....#.... */
	0x04, 0x00,    /* .....#... */
	0x02, 0x00,    /* ......#.. */
	0x02, 0x00,    /* ......#.. */
	0x04, 0x00,    /* .....#... */
	0x08, 0x00,    /* ....#.... */
	0x10, 0x00,    /* ...#..... */
	0x20, 0x00,    /* ..#...... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr63 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x3E, 0x00,    /* ..#####.. */
	0x41, 0x00,    /* .#.....#. */
	0x41, 0x00,    /* .#.....#. */
	0x01, 0x00,    /* .......#. */
	0x02, 0x00,    /* ......#.. */
	0x04, 0x00,    /* .....#... */
	0x08, 0x00,    /* ....#.... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr64 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x1C, 0x00,    /* ...###... */
	0x22, 0x00,    /* ..#...#.. */
	0x49, 0x00,    /* .#..#..#. */
	0x55, 0x00,    /* .#.#.#.#. */
	0x55, 0x00,    /* .#.#.#.#. */
	0x55, 0x00,    /* .#.#.#.#. */
	0x55, 0x00,    /* .#.#.#.#. */
	0x4A, 0x00,    /* .#..#.#.. */
	0x20, 0x00,    /* ..#...... */
	0x1F, 0x00,    /* ...#####. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr65 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x22, 0x00,    /* ..#...#.. */
	0x22, 0x00,    /* ..#...#.. */
	0x3E, 0x00,    /* ..#####.. */
	0x41, 0x00,    /* .#.....#. */
	0x41, 0x00,    /* .#.....#. */
	0x41, 0x00,    /* .#.....#. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr66 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x7C, 0x00,    /* .#####... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x44, 0x00,    /* .#...#... */
	0x7C, 0x00,    /* .#####... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x7C, 0x00,    /* .#####... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr67 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x1C, 0x00,    /* ...###... */
	0x22, 0x00,    /* ..#...#.. */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x22, 0x00,    /* ..#...#.. */
	0x1C, 0x00,    /* ...###... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr68 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x78, 0x00,    /* .####.... */
	0x44, 0x00,    /* .#...#... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x44, 0x00,    /* .#...#... */
	0x78, 0x00,    /* .####.... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr69 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x7E, 0x00,    /* .######.. */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x78, 0x00,    /* .####.... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x7E, 0x00,    /* .######.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr70 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x3F, 0x00,    /* ..######. */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x3C, 0x00,    /* ..####... */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr71 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x1C, 0x00,    /* ...###... */
	0x22, 0x00,    /* ..#...#.. */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x4E, 0x00,    /* .#..###.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x22, 0x00,    /* ..#...#.. */
	0x1E, 0x00,    /* ...####.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr72 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x7E, 0x00,    /* .######.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr73 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x3E, 0x00,    /* ..#####.. */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x3E, 0x00,    /* ..#####.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr74 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x0E, 0x00,    /* ....###.. */
	0x04, 0x00,    /* .....#... */
	0x04, 0x00,    /* .....#... */
	0x04, 0x00,    /* .....#... */
	0x04, 0x00,    /* .....#... */
	0x04, 0x00,    /* .....#... */
	0x04, 0x00,    /* .....#... */
	0x04, 0x00,    /* .....#... */
	0x44, 0x00,    /* .#...#... */
	0x44, 0x00,    /* .#...#... */
	0x38, 0x00,    /* ..###.... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr75 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x44, 0x00,    /* .#...#... */
	0x44, 0x00,    /* .#...#... */
	0x48, 0x00,    /* .#..#.... */
	0x50, 0x00,    /* .#.#..... */
	0x68, 0x00,    /* .##.#.... */
	0x44, 0x00,    /* .#...#... */
	0x44, 0x00,    /* .#...#... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr76 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x7E, 0x00,    /* .######.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr77 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x41, 0x00,    /* .#.....#. */
	0x41, 0x00,    /* .#.....#. */
	0x63, 0x00,    /* .##...##. */
	0x63, 0x00,    /* .##...##. */
	0x55, 0x00,    /* .#.#.#.#. */
	0x55, 0x00,    /* .#.#.#.#. */
	0x49, 0x00,    /* .#..#..#. */
	0x49, 0x00,    /* .#..#..#. */
	0x41, 0x00,    /* .#.....#. */
	0x41, 0x00,    /* .#.....#. */
	0x41, 0x00,    /* .#.....#. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr78 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x62, 0x00,    /* .##...#.. */
	0x62, 0x00,    /* .##...#.. */
	0x52, 0x00,    /* .#.#..#.. */
	0x4A, 0x00,    /* .#..#.#.. */
	0x4A, 0x00,    /* .#..#.#.. */
	0x46, 0x00,    /* .#...##.. */
	0x46, 0x00,    /* .#...##.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr79 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x3C, 0x00,    /* ..####... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x3C, 0x00,    /* ..####... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr80 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x7C, 0x00,    /* .#####... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x7C, 0x00,    /* .#####... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr81 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x3C, 0x00,    /* ..####... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x52, 0x00,    /* .#.#..#.. */
	0x6A, 0x00,    /* .##.#.#.. */
	0x3C, 0x00,    /* ..####... */
	0x04, 0x00,    /* .....#... */
	0x03, 0x00,    /* ......##. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr82 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x7C, 0x00,    /* .#####... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x7C, 0x00,    /* .#####... */
	0x48, 0x00,    /* .#..#.... */
	0x44, 0x00,    /* .#...#... */
	0x44, 0x00,    /* .#...#... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr83 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x3C, 0x00,    /* ..####... */
	0x42, 0x00,    /* .#....#.. */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x20, 0x00,    /* ..#...... */
	0x18, 0x00,    /* ...##.... */
	0x04, 0x00,    /* .....#... */
	0x02, 0x00,    /* ......#.. */
	0x02, 0x00,    /* ......#.. */
	0x42, 0x00,    /* .#....#.. */
	0x3C, 0x00,    /* ..####... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr84 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x7F, 0x00,    /* .#######. */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr85 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x3C, 0x00,    /* ..####... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr86 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x41, 0x00,    /* .#.....#. */
	0x41, 0x00,    /* .#.....#. */
	0x41, 0x00,    /* .#.....#. */
	0x22, 0x00,    /* ..#...#.. */
	0x22, 0x00,    /* ..#...#.. */
	0x22, 0x00,    /* ..#...#.. */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr87 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x41, 0x00,    /* .#.....#. */
	0x41, 0x00,    /* .#.....#. */
	0x41, 0x00,    /* .#.....#. */
	0x49, 0x00,    /* .#..#..#. */
	0x49, 0x00,    /* .#..#..#. */
	0x49, 0x00,    /* .#..#..#. */
	0x55, 0x00,    /* .#.#.#.#. */
	0x55, 0x00,    /* .#.#.#.#. */
	0x22, 0x00,    /* ..#...#.. */
	0x22, 0x00,    /* ..#...#.. */
	0x22, 0x00,    /* ..#...#.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr88 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x24, 0x00,    /* ..#..#... */
	0x24, 0x00,    /* ..#..#... */
	0x18, 0x00,    /* ...##.... */
	0x18, 0x00,    /* ...##.... */
	0x18, 0x00,    /* ...##.... */
	0x24, 0x00,    /* ..#..#... */
	0x24, 0x00,    /* ..#..#... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr89 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x41, 0x00,    /* .#.....#. */
	0x41, 0x00,    /* .#.....#. */
	0x22, 0x00,    /* ..#...#.. */
	0x22, 0x00,    /* ..#...#.. */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr90 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x7E, 0x00,    /* .######.. */
	0x02, 0x00,    /* ......#.. */
	0x04, 0x00,    /* .....#... */
	0x04, 0x00,    /* .....#... */
	0x08, 0x00,    /* ....#.... */
	0x10, 0x00,    /* ...#..... */
	0x10, 0x00,    /* ...#..... */
	0x20, 0x00,    /* ..#...... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x7E, 0x00,    /* .######.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr91 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x3C, 0x00,    /* ..####... */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x3C, 0x00,    /* ..####... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr92 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x40, 0x00,    /* .#....... */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x10, 0x00,    /* ...#..... */
	0x10, 0x00,    /* ...#..... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x04, 0x00,    /* .....#... */
	0x04, 0x00,    /* .....#... */
	0x02, 0x00,    /* ......#.. */
	0x02, 0x00,    /* ......#.. */
	0x01, 0x00,    /* .......#. */
	0x01, 0x00,    /* .......#. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr93 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x3C, 0x00,    /* ..####... */
	0x04, 0x00,    /* .....#... */
	0x04, 0x00,    /* .....#... */
	0x04, 0x00,    /* .....#... */
	0x04, 0x00,    /* .....#... */
	0x04, 0x00,    /* .....#... */
	0x04, 0x00,    /* .....#... */
	0x04, 0x00,    /* .....#... */
	0x04, 0x00,    /* .....#... */
	0x04, 0x00,    /* .....#... */
	0x04, 0x00,    /* .....#... */
	0x04, 0x00,    /* .....#... */
	0x3C, 0x00,    /* ..####... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr94 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x08, 0x00,    /* ....#.... */
	0x14, 0x00,    /* ...#.#... */
	0x22, 0x00,    /* ..#...#.. */
	0x41, 0x00,    /* .#.....#. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr95 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x7F, 0x00,    /* .#######. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr96 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x18, 0x00,    /* ...##.... */
	0x18, 0x00,    /* ...##.... */
	0x18, 0x00,    /* ...##.... */
	0x08, 0x00,    /* ....#.... */
	0x04, 0x00,    /* .....#... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr97 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x3C, 0x00,    /* ..####... */
	0x02, 0x00,    /* ......#.. */
	0x02, 0x00,    /* ......#.. */
	0x3E, 0x00,    /* ..#####.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x46, 0x00,    /* .#...##.. */
	0x3A, 0x00,    /* ..###.#.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr98 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x5C, 0x00,    /* .#.###... */
	0x62, 0x00,    /* .##...#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x62, 0x00,    /* .##...#.. */
	0x5C, 0x00,    /* .#.###... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr99 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x1C, 0x00,    /* ...###... */
	0x22, 0x00,    /* ..#...#.. */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x22, 0x00,    /* ..#...#.. */
	0x1C, 0x00,    /* ...###... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr100 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x02, 0x00,    /* ......#.. */
	0x02, 0x00,    /* ......#.. */
	0x02, 0x00,    /* ......#.. */
	0x3A, 0x00,    /* ..###.#.. */
	0x46, 0x00,    /* .#...##.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x46, 0x00,    /* .#...##.. */
	0x3A, 0x00,    /* ..###.#.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr101 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x1C, 0x00,    /* ...###... */
	0x22, 0x00,    /* ..#...#.. */
	0x42, 0x00,    /* .#....#.. */
	0x7E, 0x00,    /* .######.. */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x22, 0x00,    /* ..#...#.. */
	0x1C, 0x00,    /* ...###... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr102 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x0E, 0x00,    /* ....###.. */
	0x10, 0x00,    /* ...#..... */
	0x10, 0x00,    /* ...#..... */
	0x10, 0x00,    /* ...#..... */
	0x7E, 0x00,    /* .######.. */
	0x10, 0x00,    /* ...#..... */
	0x10, 0x00,    /* ...#..... */
	0x10, 0x00,    /* ...#..... */
	0x10, 0x00,    /* ...#..... */
	0x10, 0x00,    /* ...#..... */
	0x10, 0x00,    /* ...#..... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr103 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x3A, 0x00,    /* ..###.#.. */
	0x44, 0x00,    /* .#...#... */
	0x44, 0x00,    /* .#...#... */
	0x44, 0x00,    /* .#...#... */
	0x44, 0x00,    /* .#...#... */
	0x38, 0x00,    /* ..###.... */
	0x40, 0x00,    /* .#....... */
	0x3C, 0x00,    /* ..####... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x3C, 0x00,    /* ..####... */
	0x00, 0x00,    /* ......... */

	/* chr104 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x5C, 0x00,    /* .#.###... */
	0x62, 0x00,    /* .##...#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr105 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x18, 0x00,    /* ...##.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x3E, 0x00,    /* ..#####.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr106 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x04, 0x00,    /* .....#... */
	0x04, 0x00,    /* .....#... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x1C, 0x00,    /* ...###... */
	0x04, 0x00,    /* .....#... */
	0x04, 0x00,    /* .....#... */
	0x04, 0x00,    /* .....#... */
	0x04, 0x00,    /* .....#... */
	0x04, 0x00,    /* .....#... */
	0x04, 0x00,    /* .....#... */
	0x04, 0x00,    /* .....#... */
	0x44, 0x00,    /* .#...#... */
	0x44, 0x00,    /* .#...#... */
	0x38, 0x00,    /* ..###.... */
	0x00, 0x00,    /* ......... */

	/* chr107 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x42, 0x00,    /* .#....#.. */
	0x44, 0x00,    /* .#...#... */
	0x48, 0x00,    /* .#..#.... */
	0x50, 0x00,    /* .#.#..... */
	0x70, 0x00,    /* .###..... */
	0x48, 0x00,    /* .#..#.... */
	0x44, 0x00,    /* .#...#... */
	0x42, 0x00,    /* .#....#.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr108 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x18, 0x00,    /* ...##.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x3E, 0x00,    /* ..#####.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr109 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x76, 0x00,    /* .###.##.. */
	0x49, 0x00,    /* .#..#..#. */
	0x49, 0x00,    /* .#..#..#. */
	0x49, 0x00,    /* .#..#..#. */
	0x49, 0x00,    /* .#..#..#. */
	0x49, 0x00,    /* .#..#..#. */
	0x49, 0x00,    /* .#..#..#. */
	0x49, 0x00,    /* .#..#..#. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr110 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x5C, 0x00,    /* .#.###... */
	0x62, 0x00,    /* .##...#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr111 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x3C, 0x00,    /* ..####... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x3C, 0x00,    /* ..####... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr112 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x5C, 0x00,    /* .#.###... */
	0x62, 0x00,    /* .##...#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x62, 0x00,    /* .##...#.. */
	0x5C, 0x00,    /* .#.###... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x00, 0x00,    /* ......... */

	/* chr113 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x3A, 0x00,    /* ..###.#.. */
	0x46, 0x00,    /* .#...##.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x46, 0x00,    /* .#...##.. */
	0x3A, 0x00,    /* ..###.#.. */
	0x02, 0x00,    /* ......#.. */
	0x02, 0x00,    /* ......#.. */
	0x02, 0x00,    /* ......#.. */
	0x00, 0x00,    /* ......... */

	/* chr114 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x6E, 0x00,    /* .##.###.. */
	0x32, 0x00,    /* ..##..#.. */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr115 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x3C, 0x00,    /* ..####... */
	0x42, 0x00,    /* .#....#.. */
	0x40, 0x00,    /* .#....... */
	0x30, 0x00,    /* ..##..... */
	0x0C, 0x00,    /* ....##... */
	0x02, 0x00,    /* ......#.. */
	0x42, 0x00,    /* .#....#.. */
	0x3C, 0x00,    /* ..####... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr116 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x10, 0x00,    /* ...#..... */
	0x10, 0x00,    /* ...#..... */
	0x7C, 0x00,    /* .#####... */
	0x10, 0x00,    /* ...#..... */
	0x10, 0x00,    /* ...#..... */
	0x10, 0x00,    /* ...#..... */
	0x10, 0x00,    /* ...#..... */
	0x10, 0x00,    /* ...#..... */
	0x12, 0x00,    /* ...#..#.. */
	0x0C, 0x00,    /* ....##... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr117 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x46, 0x00,    /* .#...##.. */
	0x3A, 0x00,    /* ..###.#.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr118 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x41, 0x00,    /* .#.....#. */
	0x41, 0x00,    /* .#.....#. */
	0x22, 0x00,    /* ..#...#.. */
	0x22, 0x00,    /* ..#...#.. */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr119 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x41, 0x00,    /* .#.....#. */
	0x41, 0x00,    /* .#.....#. */
	0x49, 0x00,    /* .#..#..#. */
	0x49, 0x00,    /* .#..#..#. */
	0x49, 0x00,    /* .#..#..#. */
	0x36, 0x00,    /* ..##.##.. */
	0x22, 0x00,    /* ..#...#.. */
	0x22, 0x00,    /* ..#...#.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr120 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x24, 0x00,    /* ..#..#... */
	0x18, 0x00,    /* ...##.... */
	0x18, 0x00,    /* ...##.... */
	0x24, 0x00,    /* ..#..#... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr121 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x24, 0x00,    /* ..#..#... */
	0x24, 0x00,    /* ..#..#... */
	0x14, 0x00,    /* ...#.#... */
	0x18, 0x00,    /* ...##.... */
	0x08, 0x00,    /* ....#.... */
	0x10, 0x00,    /* ...#..... */
	0x50, 0x00,    /* .#.#..... */
	0x20, 0x00,    /* ..#...... */
	0x00, 0x00,    /* ......... */

	/* chr122 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x7E, 0x00,    /* .######.. */
	0x02, 0x00,    /* ......#.. */
	0x04, 0x00,    /* .....#... */
	0x08, 0x00,    /* ....#.... */
	0x10, 0x00,    /* ...#..... */
	0x20, 0x00,    /* ..#...... */
	0x40, 0x00,    /* .#....... */
	0x7E, 0x00,    /* .######.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr123 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x06, 0x00,    /* .....##.. */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x10, 0x00,    /* ...#..... */
	0x30, 0x00,    /* ..##..... */
	0x10, 0x00,    /* ...#..... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x06, 0x00,    /* .....##.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr124 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr125 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x30, 0x00,    /* ..##..... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x04, 0x00,    /* .....#... */
	0x06, 0x00,    /* .....##.. */
	0x04, 0x00,    /* .....#... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x30, 0x00,    /* ..##..... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr126 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x32, 0x00,    /* ..##..#.. */
	0x5A, 0x00,    /* .#.##.#.. */
	0x4C, 0x00,    /* .#..##... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr127 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x08, 0x00,    /* ....#.... */
	0x14, 0x00,    /* ...#.#... */
	0x22, 0x00,    /* ..#...#.. */
	0x41, 0x00,    /* .#.....#. */
	0x41, 0x00,    /* .#.....#. */
	0x41, 0x00,    /* .#.....#. */
	0x41, 0x00,    /* .#.....#. */
	0x41, 0x00,    /* .#.....#. */
	0x7F, 0x00,    /* .#######. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr128 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x1C, 0x00,    /* ...###... */
	0x22, 0x00,    /* ..#...#.. */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x22, 0x00,    /* ..#...#.. */
	0x1C, 0x00,    /* ...###... */
	0x08, 0x00,    /* ....#.... */
	0x04, 0x00,    /* .....#... */
	0x18, 0x00,    /* ...##.... */
	0x00, 0x00,    /* ......... */

	/* chr129 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x24, 0x00,    /* ..#..#... */
	0x24, 0x00,    /* ..#..#... */
	0x00, 0x00,    /* ......... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x46, 0x00,    /* .#...##.. */
	0x3A, 0x00,    /* ..###.#.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr130 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x10, 0x00,    /* ...#..... */
	0x00, 0x00,    /* ......... */
	0x1C, 0x00,    /* ...###... */
	0x22, 0x00,    /* ..#...#.. */
	0x42, 0x00,    /* .#....#.. */
	0x7E, 0x00,    /* .######.. */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x22, 0x00,    /* ..#...#.. */
	0x1C, 0x00,    /* ...###... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr131 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x18, 0x00,    /* ...##.... */
	0x24, 0x00,    /* ..#..#... */
	0x00, 0x00,    /* ......... */
	0x3C, 0x00,    /* ..####... */
	0x02, 0x00,    /* ......#.. */
	0x02, 0x00,    /* ......#.. */
	0x3E, 0x00,    /* ..#####.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x46, 0x00,    /* .#...##.. */
	0x3A, 0x00,    /* ..###.#.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr132 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x24, 0x00,    /* ..#..#... */
	0x24, 0x00,    /* ..#..#... */
	0x00, 0x00,    /* ......... */
	0x3C, 0x00,    /* ..####... */
	0x02, 0x00,    /* ......#.. */
	0x02, 0x00,    /* ......#.. */
	0x3E, 0x00,    /* ..#####.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x46, 0x00,    /* .#...##.. */
	0x3A, 0x00,    /* ..###.#.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr133 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x10, 0x00,    /* ...#..... */
	0x10, 0x00,    /* ...#..... */
	0x08, 0x00,    /* ....#.... */
	0x00, 0x00,    /* ......... */
	0x3C, 0x00,    /* ..####... */
	0x02, 0x00,    /* ......#.. */
	0x02, 0x00,    /* ......#.. */
	0x3E, 0x00,    /* ..#####.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x46, 0x00,    /* .#...##.. */
	0x3A, 0x00,    /* ..###.#.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr134 */
	0x00, 0x00,    /* ......... */
	0x18, 0x00,    /* ...##.... */
	0x24, 0x00,    /* ..#..#... */
	0x24, 0x00,    /* ..#..#... */
	0x18, 0x00,    /* ...##.... */
	0x00, 0x00,    /* ......... */
	0x3C, 0x00,    /* ..####... */
	0x02, 0x00,    /* ......#.. */
	0x02, 0x00,    /* ......#.. */
	0x3E, 0x00,    /* ..#####.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x46, 0x00,    /* .#...##.. */
	0x3A, 0x00,    /* ..###.#.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr135 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x1C, 0x00,    /* ...###... */
	0x22, 0x00,    /* ..#...#.. */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x22, 0x00,    /* ..#...#.. */
	0x1C, 0x00,    /* ...###... */
	0x08, 0x00,    /* ....#.... */
	0x04, 0x00,    /* .....#... */
	0x18, 0x00,    /* ...##.... */
	0x00, 0x00,    /* ......... */

	/* chr136 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x0C, 0x00,    /* ....##... */
	0x12, 0x00,    /* ...#..#.. */
	0x00, 0x00,    /* ......... */
	0x1C, 0x00,    /* ...###... */
	0x22, 0x00,    /* ..#...#.. */
	0x42, 0x00,    /* .#....#.. */
	0x7E, 0x00,    /* .######.. */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x22, 0x00,    /* ..#...#.. */
	0x1C, 0x00,    /* ...###... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr137 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x24, 0x00,    /* ..#..#... */
	0x24, 0x00,    /* ..#..#... */
	0x00, 0x00,    /* ......... */
	0x1C, 0x00,    /* ...###... */
	0x22, 0x00,    /* ..#...#.. */
	0x42, 0x00,    /* .#....#.. */
	0x7E, 0x00,    /* .######.. */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x22, 0x00,    /* ..#...#.. */
	0x1C, 0x00,    /* ...###... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr138 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x10, 0x00,    /* ...#..... */
	0x10, 0x00,    /* ...#..... */
	0x08, 0x00,    /* ....#.... */
	0x00, 0x00,    /* ......... */
	0x1C, 0x00,    /* ...###... */
	0x22, 0x00,    /* ..#...#.. */
	0x42, 0x00,    /* .#....#.. */
	0x7E, 0x00,    /* .######.. */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x22, 0x00,    /* ..#...#.. */
	0x1C, 0x00,    /* ...###... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr139 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x24, 0x00,    /* ..#..#... */
	0x24, 0x00,    /* ..#..#... */
	0x00, 0x00,    /* ......... */
	0x18, 0x00,    /* ...##.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x3E, 0x00,    /* ..#####.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr140 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x18, 0x00,    /* ...##.... */
	0x24, 0x00,    /* ..#..#... */
	0x00, 0x00,    /* ......... */
	0x18, 0x00,    /* ...##.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x3E, 0x00,    /* ..#####.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr141 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x10, 0x00,    /* ...#..... */
	0x10, 0x00,    /* ...#..... */
	0x08, 0x00,    /* ....#.... */
	0x00, 0x00,    /* ......... */
	0x18, 0x00,    /* ...##.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x3E, 0x00,    /* ..#####.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr142 */
	0x12, 0x00,    /* ...#..#.. */
	0x12, 0x00,    /* ...#..#.. */
	0x00, 0x00,    /* ......... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x22, 0x00,    /* ..#...#.. */
	0x22, 0x00,    /* ..#...#.. */
	0x3E, 0x00,    /* ..#####.. */
	0x41, 0x00,    /* .#.....#. */
	0x41, 0x00,    /* .#.....#. */
	0x41, 0x00,    /* .#.....#. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr143 */
	0x1C, 0x00,    /* ...###... */
	0x22, 0x00,    /* ..#...#.. */
	0x22, 0x00,    /* ..#...#.. */
	0x1C, 0x00,    /* ...###... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x22, 0x00,    /* ..#...#.. */
	0x22, 0x00,    /* ..#...#.. */
	0x3E, 0x00,    /* ..#####.. */
	0x41, 0x00,    /* .#.....#. */
	0x41, 0x00,    /* .#.....#. */
	0x41, 0x00,    /* .#.....#. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr144 */
	0x04, 0x00,    /* .....#... */
	0x18, 0x00,    /* ...##.... */
	0x00, 0x00,    /* ......... */
	0x7E, 0x00,    /* .######.. */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x78, 0x00,    /* .####.... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x7E, 0x00,    /* .######.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr145 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x36, 0x00,    /* ..##.##.. */
	0x49, 0x00,    /* .#..#..#. */
	0x09, 0x00,    /* ....#..#. */
	0x3F, 0x00,    /* ..######. */
	0x48, 0x00,    /* .#..#.... */
	0x48, 0x00,    /* .#..#.... */
	0x49, 0x00,    /* .#..#..#. */
	0x76, 0x00,    /* .###.##.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr146 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x1F, 0x00,    /* ...#####. */
	0x18, 0x00,    /* ...##.... */
	0x28, 0x00,    /* ..#.#.... */
	0x28, 0x00,    /* ..#.#.... */
	0x28, 0x00,    /* ..#.#.... */
	0x4E, 0x00,    /* .#..###.. */
	0x48, 0x00,    /* .#..#.... */
	0x78, 0x00,    /* .####.... */
	0x88, 0x00,    /* #...#.... */
	0x88, 0x00,    /* #...#.... */
	0x8F, 0x00,    /* #...####. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr147 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x18, 0x00,    /* ...##.... */
	0x24, 0x00,    /* ..#..#... */
	0x00, 0x00,    /* ......... */
	0x3C, 0x00,    /* ..####... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x3C, 0x00,    /* ..####... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr148 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x24, 0x00,    /* ..#..#... */
	0x24, 0x00,    /* ..#..#... */
	0x00, 0x00,    /* ......... */
	0x3C, 0x00,    /* ..####... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x3C, 0x00,    /* ..####... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr149 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x10, 0x00,    /* ...#..... */
	0x10, 0x00,    /* ...#..... */
	0x08, 0x00,    /* ....#.... */
	0x00, 0x00,    /* ......... */
	0x3C, 0x00,    /* ..####... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x3C, 0x00,    /* ..####... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr150 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x18, 0x00,    /* ...##.... */
	0x24, 0x00,    /* ..#..#... */
	0x00, 0x00,    /* ......... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x46, 0x00,    /* .#...##.. */
	0x3A, 0x00,    /* ..###.#.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr151 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x10, 0x00,    /* ...#..... */
	0x10, 0x00,    /* ...#..... */
	0x08, 0x00,    /* ....#.... */
	0x00, 0x00,    /* ......... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x46, 0x00,    /* .#...##.. */
	0x3A, 0x00,    /* ..###.#.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr152 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x24, 0x00,    /* ..#..#... */
	0x24, 0x00,    /* ..#..#... */
	0x00, 0x00,    /* ......... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x24, 0x00,    /* ..#..#... */
	0x24, 0x00,    /* ..#..#... */
	0x14, 0x00,    /* ...#.#... */
	0x18, 0x00,    /* ...##.... */
	0x08, 0x00,    /* ....#.... */
	0x10, 0x00,    /* ...#..... */
	0x50, 0x00,    /* .#.#..... */
	0x20, 0x00,    /* ..#...... */
	0x00, 0x00,    /* ......... */

	/* chr153 */
	0x24, 0x00,    /* ..#..#... */
	0x24, 0x00,    /* ..#..#... */
	0x00, 0x00,    /* ......... */
	0x3C, 0x00,    /* ..####... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x3C, 0x00,    /* ..####... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr154 */
	0x24, 0x00,    /* ..#..#... */
	0x24, 0x00,    /* ..#..#... */
	0x00, 0x00,    /* ......... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x3C, 0x00,    /* ..####... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr155 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x02, 0x00,    /* ......#.. */
	0x1C, 0x00,    /* ...###... */
	0x26, 0x00,    /* ..#..##.. */
	0x48, 0x00,    /* .#..#.... */
	0x48, 0x00,    /* .#..#.... */
	0x50, 0x00,    /* .#.#..... */
	0x50, 0x00,    /* .#.#..... */
	0x22, 0x00,    /* ..#...#.. */
	0x3C, 0x00,    /* ..####... */
	0x40, 0x00,    /* .#....... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr156 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x1C, 0x00,    /* ...###... */
	0x22, 0x00,    /* ..#...#.. */
	0x22, 0x00,    /* ..#...#.. */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x78, 0x00,    /* .####.... */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x42, 0x00,    /* .#....#.. */
	0x7E, 0x00,    /* .######.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr157 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x41, 0x00,    /* .#.....#. */
	0x41, 0x00,    /* .#.....#. */
	0x22, 0x00,    /* ..#...#.. */
	0x22, 0x00,    /* ..#...#.. */
	0x14, 0x00,    /* ...#.#... */
	0x7F, 0x00,    /* .#######. */
	0x08, 0x00,    /* ....#.... */
	0x7F, 0x00,    /* .#######. */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr158 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x7C, 0x00,    /* .#####... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x7C, 0x00,    /* .#####... */
	0x40, 0x00,    /* .#....... */
	0x48, 0x00,    /* .#..#.... */
	0x5E, 0x00,    /* .#.####.. */
	0x48, 0x00,    /* .#..#.... */
	0x48, 0x00,    /* .#..#.... */
	0x48, 0x00,    /* .#..#.... */
	0x46, 0x00,    /* .#...##.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr159 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x07, 0x00,    /* .....###. */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x3E, 0x00,    /* ..#####.. */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x70, 0x00,    /* .###..... */
	0x00, 0x00,    /* ......... */

	/* chr160 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x10, 0x00,    /* ...#..... */
	0x00, 0x00,    /* ......... */
	0x3C, 0x00,    /* ..####... */
	0x02, 0x00,    /* ......#.. */
	0x02, 0x00,    /* ......#.. */
	0x3E, 0x00,    /* ..#####.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x46, 0x00,    /* .#...##.. */
	0x3A, 0x00,    /* ..###.#.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr161 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x04, 0x00,    /* .....#... */
	0x04, 0x00,    /* .....#... */
	0x08, 0x00,    /* ....#.... */
	0x00, 0x00,    /* ......... */
	0x18, 0x00,    /* ...##.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x3E, 0x00,    /* ..#####.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr162 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x10, 0x00,    /* ...#..... */
	0x00, 0x00,    /* ......... */
	0x3C, 0x00,    /* ..####... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x3C, 0x00,    /* ..####... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr163 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x10, 0x00,    /* ...#..... */
	0x00, 0x00,    /* ......... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x46, 0x00,    /* .#...##.. */
	0x3A, 0x00,    /* ..###.#.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr164 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x24, 0x00,    /* ..#..#... */
	0x58, 0x00,    /* .#.##.... */
	0x00, 0x00,    /* ......... */
	0x5C, 0x00,    /* .#.###... */
	0x62, 0x00,    /* .##...#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr165 */
	0x12, 0x00,    /* ...#..#.. */
	0x2C, 0x00,    /* ..#.##... */
	0x00, 0x00,    /* ......... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x62, 0x00,    /* .##...#.. */
	0x62, 0x00,    /* .##...#.. */
	0x52, 0x00,    /* .#.#..#.. */
	0x4A, 0x00,    /* .#..#.#.. */
	0x4A, 0x00,    /* .#..#.#.. */
	0x46, 0x00,    /* .#...##.. */
	0x46, 0x00,    /* .#...##.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr166 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x1C, 0x00,    /* ...###... */
	0x02, 0x00,    /* ......#.. */
	0x1E, 0x00,    /* ...####.. */
	0x22, 0x00,    /* ..#...#.. */
	0x1E, 0x00,    /* ...####.. */
	0x00, 0x00,    /* ......... */
	0x3E, 0x00,    /* ..#####.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr167 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x1C, 0x00,    /* ...###... */
	0x22, 0x00,    /* ..#...#.. */
	0x22, 0x00,    /* ..#...#.. */
	0x22, 0x00,    /* ..#...#.. */
	0x1C, 0x00,    /* ...###... */
	0x00, 0x00,    /* ......... */
	0x3E, 0x00,    /* ..#####.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr168 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x08, 0x00,    /* ....#.... */
	0x10, 0x00,    /* ...#..... */
	0x20, 0x00,    /* ..#...... */
	0x40, 0x00,    /* .#....... */
	0x41, 0x00,    /* .#.....#. */
	0x41, 0x00,    /* .#.....#. */
	0x3E, 0x00,    /* ..#####.. */
	0x00, 0x00,    /* ......... */

	/* chr169 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x7E, 0x00,    /* .######.. */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr170 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x7E, 0x00,    /* .######.. */
	0x02, 0x00,    /* ......#.. */
	0x02, 0x00,    /* ......#.. */
	0x02, 0x00,    /* ......#.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr171 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x20, 0x00,    /* ..#...... */
	0x61, 0x00,    /* .##....#. */
	0x21, 0x00,    /* ..#....#. */
	0x22, 0x00,    /* ..#...#.. */
	0x24, 0x00,    /* ..#..#... */
	0x24, 0x00,    /* ..#..#... */
	0x08, 0x00,    /* ....#.... */
	0x16, 0x00,    /* ...#.##.. */
	0x19, 0x00,    /* ...##..#. */
	0x21, 0x00,    /* ..#....#. */
	0x46, 0x00,    /* .#...##.. */
	0x48, 0x00,    /* .#..#.... */
	0x0F, 0x00,    /* ....####. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr172 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x20, 0x00,    /* ..#...... */
	0x61, 0x00,    /* .##....#. */
	0x21, 0x00,    /* ..#....#. */
	0x22, 0x00,    /* ..#...#.. */
	0x24, 0x00,    /* ..#..#... */
	0x24, 0x00,    /* ..#..#... */
	0x08, 0x00,    /* ....#.... */
	0x12, 0x00,    /* ...#..#.. */
	0x16, 0x00,    /* ...#.##.. */
	0x2A, 0x00,    /* ..#.#.#.. */
	0x4A, 0x00,    /* .#..#.#.. */
	0x4F, 0x00,    /* .#..####. */
	0x02, 0x00,    /* ......#.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr173 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x00, 0x00,    /* ......... */

	/* chr174 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x12, 0x00,    /* ...#..#.. */
	0x24, 0x00,    /* ..#..#... */
	0x48, 0x00,    /* .#..#.... */
	0x24, 0x00,    /* ..#..#... */
	0x12, 0x00,    /* ...#..#.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr175 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x48, 0x00,    /* .#..#.... */
	0x24, 0x00,    /* ..#..#... */
	0x12, 0x00,    /* ...#..#.. */
	0x24, 0x00,    /* ..#..#... */
	0x48, 0x00,    /* .#..#.... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr176 */
	0x44, 0x00,    /* .#...#... */
	0x88, 0x80,    /* #...#...# */
	0x22, 0x00,    /* ..#...#.. */
	0x11, 0x00,    /* ...#...#. */
	0x44, 0x00,    /* .#...#... */
	0x88, 0x80,    /* #...#...# */
	0x22, 0x00,    /* ..#...#.. */
	0x11, 0x00,    /* ...#...#. */
	0x44, 0x00,    /* .#...#... */
	0x88, 0x80,    /* #...#...# */
	0x22, 0x00,    /* ..#...#.. */
	0x11, 0x00,    /* ...#...#. */
	0x44, 0x00,    /* .#...#... */
	0x88, 0x80,    /* #...#...# */
	0x22, 0x00,    /* ..#...#.. */
	0x11, 0x00,    /* ...#...#. */
	0x44, 0x00,    /* .#...#... */
	0x88, 0x80,    /* #...#...# */

	/* chr177 */
	0x55, 0x00,    /* .#.#.#.#. */
	0xAA, 0x80,    /* #.#.#.#.# */
	0x55, 0x00,    /* .#.#.#.#. */
	0xAA, 0x80,    /* #.#.#.#.# */
	0x55, 0x00,    /* .#.#.#.#. */
	0xAA, 0x80,    /* #.#.#.#.# */
	0x55, 0x00,    /* .#.#.#.#. */
	0xAA, 0x80,    /* #.#.#.#.# */
	0x55, 0x00,    /* .#.#.#.#. */
	0xAA, 0x80,    /* #.#.#.#.# */
	0x55, 0x00,    /* .#.#.#.#. */
	0xAA, 0x80,    /* #.#.#.#.# */
	0x55, 0x00,    /* .#.#.#.#. */
	0xAA, 0x80,    /* #.#.#.#.# */
	0x55, 0x00,    /* .#.#.#.#. */
	0xAA, 0x80,    /* #.#.#.#.# */
	0x55, 0x00,    /* .#.#.#.#. */
	0xAA, 0x80,    /* #.#.#.#.# */

	/* chr178 */
	0x77, 0x00,    /* .###.###. */
	0xBB, 0x80,    /* #.###.### */
	0xEE, 0x80,    /* ###.###.# */
	0xDD, 0x80,    /* ##.###.## */
	0x77, 0x00,    /* .###.###. */
	0xBB, 0x80,    /* #.###.### */
	0xEE, 0x80,    /* ###.###.# */
	0xDD, 0x80,    /* ##.###.## */
	0x77, 0x00,    /* .###.###. */
	0xBB, 0x80,    /* #.###.### */
	0xEE, 0x80,    /* ###.###.# */
	0xDD, 0x80,    /* ##.###.## */
	0x77, 0x00,    /* .###.###. */
	0xBB, 0x80,    /* #.###.### */
	0xEE, 0x80,    /* ###.###.# */
	0xDD, 0x80,    /* ##.###.## */
	0x77, 0x00,    /* .###.###. */
	0xBB, 0x80,    /* #.###.### */

	/* chr179 */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */

	/* chr180 */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0xF8, 0x00,    /* #####.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */

	/* chr181 */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0xF8, 0x00,    /* #####.... */
	0x08, 0x00,    /* ....#.... */
	0xF8, 0x00,    /* #####.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */

	/* chr182 */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0xF4, 0x00,    /* ####.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */

	/* chr183 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0xFC, 0x00,    /* ######... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */

	/* chr184 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0xF8, 0x00,    /* #####.... */
	0x08, 0x00,    /* ....#.... */
	0xF8, 0x00,    /* #####.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */

	/* chr185 */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0xF4, 0x00,    /* ####.#... */
	0x04, 0x00,    /* .....#... */
	0xF4, 0x00,    /* ####.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */

	/* chr186 */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */

	/* chr187 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0xFC, 0x00,    /* ######... */
	0x04, 0x00,    /* .....#... */
	0xF4, 0x00,    /* ####.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */

	/* chr188 */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0xF4, 0x00,    /* ####.#... */
	0x04, 0x00,    /* .....#... */
	0xFC, 0x00,    /* ######... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr189 */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0xFC, 0x00,    /* ######... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr190 */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0xF8, 0x00,    /* #####.... */
	0x08, 0x00,    /* ....#.... */
	0xF8, 0x00,    /* #####.... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr191 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0xF8, 0x00,    /* #####.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */

	/* chr192 */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x0F, 0x80,    /* ....##### */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr193 */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0xFF, 0x80,    /* ######### */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr194 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0xFF, 0x80,    /* ######### */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */

	/* chr195 */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x0F, 0x80,    /* ....##### */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */

	/* chr196 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0xFF, 0x80,    /* ######### */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr197 */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0xFF, 0x80,    /* ######### */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */

	/* chr198 */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x0F, 0x80,    /* ....##### */
	0x08, 0x00,    /* ....#.... */
	0x0F, 0x80,    /* ....##### */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */

	/* chr199 */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x17, 0x80,    /* ...#.#### */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */

	/* chr200 */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x17, 0x80,    /* ...#.#### */
	0x10, 0x00,    /* ...#..... */
	0x1F, 0x80,    /* ...###### */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr201 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x1F, 0x80,    /* ...###### */
	0x10, 0x00,    /* ...#..... */
	0x17, 0x80,    /* ...#.#### */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */

	/* chr202 */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0xF7, 0x80,    /* ####.#### */
	0x00, 0x00,    /* ......... */
	0xFF, 0x80,    /* ######### */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr203 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0xFF, 0x80,    /* ######### */
	0x00, 0x00,    /* ......... */
	0xF7, 0x80,    /* ####.#### */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */

	/* chr204 */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x17, 0x80,    /* ...#.#### */
	0x10, 0x00,    /* ...#..... */
	0x17, 0x80,    /* ...#.#### */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */

	/* chr205 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0xFF, 0x80,    /* ######### */
	0x00, 0x00,    /* ......... */
	0xFF, 0x80,    /* ######### */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr206 */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0xF7, 0x80,    /* ####.#### */
	0x00, 0x00,    /* ......... */
	0xF7, 0x80,    /* ####.#### */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */

	/* chr207 */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0xFF, 0x80,    /* ######### */
	0x00, 0x00,    /* ......... */
	0xFF, 0x80,    /* ######### */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr208 */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0xFF, 0x80,    /* ######### */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr209 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0xFF, 0x80,    /* ######### */
	0x00, 0x00,    /* ......... */
	0xFF, 0x80,    /* ######### */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */

	/* chr210 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0xFF, 0x80,    /* ######### */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */

	/* chr211 */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x1F, 0x80,    /* ...###### */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr212 */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x0F, 0x80,    /* ....##### */
	0x08, 0x00,    /* ....#.... */
	0x0F, 0x80,    /* ....##### */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr213 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x0F, 0x80,    /* ....##### */
	0x08, 0x00,    /* ....#.... */
	0x0F, 0x80,    /* ....##### */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */

	/* chr214 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x1F, 0x80,    /* ...###### */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */

	/* chr215 */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0xF7, 0x80,    /* ####.#### */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */

	/* chr216 */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0xFF, 0x80,    /* ######### */
	0x00, 0x00,    /* ......... */
	0xFF, 0x80,    /* ######### */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */

	/* chr217 */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0xF8, 0x00,    /* #####.... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr218 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x0F, 0x80,    /* ....##### */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */

	/* chr219 */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */

	/* chr220 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */

	/* chr221 */
	0xF0, 0x00,    /* ####..... */
	0xF0, 0x00,    /* ####..... */
	0xF0, 0x00,    /* ####..... */
	0xF0, 0x00,    /* ####..... */
	0xF0, 0x00,    /* ####..... */
	0xF0, 0x00,    /* ####..... */
	0xF0, 0x00,    /* ####..... */
	0xF0, 0x00,    /* ####..... */
	0xF0, 0x00,    /* ####..... */
	0xF0, 0x00,    /* ####..... */
	0xF0, 0x00,    /* ####..... */
	0xF0, 0x00,    /* ####..... */
	0xF0, 0x00,    /* ####..... */
	0xF0, 0x00,    /* ####..... */
	0xF0, 0x00,    /* ####..... */
	0xF0, 0x00,    /* ####..... */
	0xF0, 0x00,    /* ####..... */
	0xF0, 0x00,    /* ####..... */

	/* chr222 */
	0x0F, 0x80,    /* ....##### */
	0x0F, 0x80,    /* ....##### */
	0x0F, 0x80,    /* ....##### */
	0x0F, 0x80,    /* ....##### */
	0x0F, 0x80,    /* ....##### */
	0x0F, 0x80,    /* ....##### */
	0x0F, 0x80,    /* ....##### */
	0x0F, 0x80,    /* ....##### */
	0x0F, 0x80,    /* ....##### */
	0x0F, 0x80,    /* ....##### */
	0x0F, 0x80,    /* ....##### */
	0x0F, 0x80,    /* ....##### */
	0x0F, 0x80,    /* ....##### */
	0x0F, 0x80,    /* ....##### */
	0x0F, 0x80,    /* ....##### */
	0x0F, 0x80,    /* ....##### */
	0x0F, 0x80,    /* ....##### */
	0x0F, 0x80,    /* ....##### */

	/* chr223 */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0xFF, 0x80,    /* ######### */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr224 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x19, 0x00,    /* ...##..#. */
	0x25, 0x00,    /* ..#..#.#. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x25, 0x00,    /* ..#..#.#. */
	0x19, 0x00,    /* ...##..#. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr225 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x38, 0x00,    /* ..###.... */
	0x44, 0x00,    /* .#...#... */
	0x44, 0x00,    /* .#...#... */
	0x44, 0x00,    /* .#...#... */
	0x48, 0x00,    /* .#..#.... */
	0x4C, 0x00,    /* .#..##... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x52, 0x00,    /* .#.#..#.. */
	0x4C, 0x00,    /* .#..##... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr226 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x3F, 0x00,    /* ..######. */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x20, 0x00,    /* ..#...... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr227 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x7F, 0x00,    /* .#######. */
	0x22, 0x00,    /* ..#...#.. */
	0x22, 0x00,    /* ..#...#.. */
	0x22, 0x00,    /* ..#...#.. */
	0x22, 0x00,    /* ..#...#.. */
	0x22, 0x00,    /* ..#...#.. */
	0x22, 0x00,    /* ..#...#.. */
	0x22, 0x00,    /* ..#...#.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr228 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x7E, 0x00,    /* .######.. */
	0x40, 0x00,    /* .#....... */
	0x20, 0x00,    /* ..#...... */
	0x10, 0x00,    /* ...#..... */
	0x08, 0x00,    /* ....#.... */
	0x04, 0x00,    /* .....#... */
	0x08, 0x00,    /* ....#.... */
	0x10, 0x00,    /* ...#..... */
	0x20, 0x00,    /* ..#...... */
	0x40, 0x00,    /* .#....... */
	0x7E, 0x00,    /* .######.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr229 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x3F, 0x00,    /* ..######. */
	0x48, 0x00,    /* .#..#.... */
	0x84, 0x00,    /* #....#... */
	0x84, 0x00,    /* #....#... */
	0x84, 0x00,    /* #....#... */
	0x84, 0x00,    /* #....#... */
	0x48, 0x00,    /* .#..#.... */
	0x30, 0x00,    /* ..##..... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr230 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x66, 0x00,    /* .##..##.. */
	0x59, 0x00,    /* .#.##..#. */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x00, 0x00,    /* ......... */

	/* chr231 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x7F, 0x00,    /* .#######. */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x06, 0x00,    /* .....##.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr232 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x08, 0x00,    /* ....#.... */
	0x1C, 0x00,    /* ...###... */
	0x2A, 0x00,    /* ..#.#.#.. */
	0x49, 0x00,    /* .#..#..#. */
	0x49, 0x00,    /* .#..#..#. */
	0x49, 0x00,    /* .#..#..#. */
	0x49, 0x00,    /* .#..#..#. */
	0x49, 0x00,    /* .#..#..#. */
	0x2A, 0x00,    /* ..#.#.#.. */
	0x1C, 0x00,    /* ...###... */
	0x08, 0x00,    /* ....#.... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr233 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x3C, 0x00,    /* ..####... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x7E, 0x00,    /* .######.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x3C, 0x00,    /* ..####... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr234 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x1C, 0x00,    /* ...###... */
	0x22, 0x00,    /* ..#...#.. */
	0x41, 0x00,    /* .#.....#. */
	0x41, 0x00,    /* .#.....#. */
	0x41, 0x00,    /* .#.....#. */
	0x41, 0x00,    /* .#.....#. */
	0x41, 0x00,    /* .#.....#. */
	0x22, 0x00,    /* ..#...#.. */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x77, 0x00,    /* .###.###. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr235 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x1C, 0x00,    /* ...###... */
	0x20, 0x00,    /* ..#...... */
	0x10, 0x00,    /* ...#..... */
	0x18, 0x00,    /* ...##.... */
	0x24, 0x00,    /* ..#..#... */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x42, 0x00,    /* .#....#.. */
	0x24, 0x00,    /* ..#..#... */
	0x18, 0x00,    /* ...##.... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr236 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x66, 0x00,    /* .##..##.. */
	0x99, 0x00,    /* #..##..#. */
	0x91, 0x00,    /* #..#...#. */
	0x89, 0x00,    /* #...#..#. */
	0x99, 0x00,    /* #..##..#. */
	0x66, 0x00,    /* .##..##.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr237 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x06, 0x00,    /* .....##.. */
	0x49, 0x00,    /* .#..#..#. */
	0x49, 0x00,    /* .#..#..#. */
	0x49, 0x00,    /* .#..#..#. */
	0x49, 0x00,    /* .#..#..#. */
	0x49, 0x00,    /* .#..#..#. */
	0x2A, 0x00,    /* ..#.#.#.. */
	0x1C, 0x00,    /* ...###... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x00, 0x00,    /* ......... */

	/* chr238 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x3C, 0x00,    /* ..####... */
	0x42, 0x00,    /* .#....#.. */
	0x40, 0x00,    /* .#....... */
	0x30, 0x00,    /* ..##..... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x42, 0x00,    /* .#....#.. */
	0x3C, 0x00,    /* ..####... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr239 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x1C, 0x00,    /* ...###... */
	0x22, 0x00,    /* ..#...#.. */
	0x41, 0x00,    /* .#.....#. */
	0x41, 0x00,    /* .#.....#. */
	0x41, 0x00,    /* .#.....#. */
	0x41, 0x00,    /* .#.....#. */
	0x41, 0x00,    /* .#.....#. */
	0x41, 0x00,    /* .#.....#. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr240 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x7F, 0x00,    /* .#######. */
	0x00, 0x00,    /* ......... */
	0x7F, 0x00,    /* .#######. */
	0x00, 0x00,    /* ......... */
	0x7F, 0x00,    /* .#######. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr241 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x7F, 0x00,    /* .#######. */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x00, 0x00,    /* ......... */
	0x7F, 0x00,    /* .#######. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr242 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x40, 0x00,    /* .#....... */
	0x30, 0x00,    /* ..##..... */
	0x0C, 0x00,    /* ....##... */
	0x02, 0x00,    /* ......#.. */
	0x02, 0x00,    /* ......#.. */
	0x0C, 0x00,    /* ....##... */
	0x30, 0x00,    /* ..##..... */
	0x40, 0x00,    /* .#....... */
	0x00, 0x00,    /* ......... */
	0x7E, 0x00,    /* .######.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr243 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x02, 0x00,    /* ......#.. */
	0x0C, 0x00,    /* ....##... */
	0x30, 0x00,    /* ..##..... */
	0x40, 0x00,    /* .#....... */
	0x40, 0x00,    /* .#....... */
	0x30, 0x00,    /* ..##..... */
	0x0C, 0x00,    /* ....##... */
	0x02, 0x00,    /* ......#.. */
	0x00, 0x00,    /* ......... */
	0x7E, 0x00,    /* .######.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr244 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x07, 0x00,    /* .....###. */
	0x09, 0x00,    /* ....#..#. */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */

	/* chr245 */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x48, 0x00,    /* .#..#.... */
	0x70, 0x00,    /* .###..... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr246 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x08, 0x00,    /* ....#.... */
	0x1C, 0x00,    /* ...###... */
	0x08, 0x00,    /* ....#.... */
	0x00, 0x00,    /* ......... */
	0x7F, 0x00,    /* .#######. */
	0x00, 0x00,    /* ......... */
	0x08, 0x00,    /* ....#.... */
	0x1C, 0x00,    /* ...###... */
	0x08, 0x00,    /* ....#.... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr247 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x32, 0x00,    /* ..##..#.. */
	0x5A, 0x00,    /* .#.##.#.. */
	0x4C, 0x00,    /* .#..##... */
	0x00, 0x00,    /* ......... */
	0x32, 0x00,    /* ..##..#.. */
	0x5A, 0x00,    /* .#.##.#.. */
	0x4C, 0x00,    /* .#..##... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr248 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x18, 0x00,    /* ...##.... */
	0x24, 0x00,    /* ..#..#... */
	0x24, 0x00,    /* ..#..#... */
	0x18, 0x00,    /* ...##.... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr249 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x1C, 0x00,    /* ...###... */
	0x3E, 0x00,    /* ..#####.. */
	0x3E, 0x00,    /* ..#####.. */
	0x3E, 0x00,    /* ..#####.. */
	0x1C, 0x00,    /* ...###... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr250 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x18, 0x00,    /* ...##.... */
	0x18, 0x00,    /* ...##.... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr251 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x01, 0x80,    /* .......## */
	0x01, 0x00,    /* .......#. */
	0x01, 0x00,    /* .......#. */
	0x01, 0x00,    /* .......#. */
	0x02, 0x00,    /* ......#.. */
	0x02, 0x00,    /* ......#.. */
	0x72, 0x00,    /* .###..#.. */
	0x14, 0x00,    /* ...#.#... */
	0x14, 0x00,    /* ...#.#... */
	0x0C, 0x00,    /* ....##... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x08, 0x00,    /* ....#.... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr252 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x2C, 0x00,    /* ..#.##... */
	0x32, 0x00,    /* ..##..#.. */
	0x22, 0x00,    /* ..#...#.. */
	0x22, 0x00,    /* ..#...#.. */
	0x22, 0x00,    /* ..#...#.. */
	0x22, 0x00,    /* ..#...#.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr253 */
	0x00, 0x00,    /* ......... */
	0x1C, 0x00,    /* ...###... */
	0x22, 0x00,    /* ..#...#.. */
	0x02, 0x00,    /* ......#.. */
	0x04, 0x00,    /* .....#... */
	0x08, 0x00,    /* ....#.... */
	0x10, 0x00,    /* ...#..... */
	0x20, 0x00,    /* ..#...... */
	0x3E, 0x00,    /* ..#####.. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr254 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x7F, 0x00,    /* .#######. */
	0x7F, 0x00,    /* .#######. */
	0x7F, 0x00,    /* .#######. */
	0x7F, 0x00,    /* .#######. */
	0x7F, 0x00,    /* .#######. */
	0x7F, 0x00,    /* .#######. */
	0x7F, 0x00,    /* .#######. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

	/* chr255 */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x41, 0x00,    /* .#.....#. */
	0x41, 0x00,    /* .#.....#. */
	0x7F, 0x00,    /* .#######. */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */
	0x00, 0x00,    /* ......... */

};
