/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.swing.renderer;

import java.awt.Color;
import java.awt.Dimension;
import java.text.Format;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.graalvm.visualvm.lib.ui.swing.renderer.MultiRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.NumberRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.PercentRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.ProfilerRenderer;

public class NumberPercentRenderer
extends MultiRenderer {
    private final ProfilerRenderer valueRenderer;
    private final PercentRenderer percentRenderer;
    private final ProfilerRenderer[] renderers;
    private Dimension percentSize;

    public NumberPercentRenderer() {
        this((Format)null);
    }

    public NumberPercentRenderer(Format customFormat) {
        this(NumberPercentRenderer.createNumberRenderer(customFormat));
    }

    public NumberPercentRenderer(ProfilerRenderer renderer) {
        int fixedWidth;
        this.valueRenderer = renderer;
        this.percentRenderer = new PercentRenderer(){

            @Override
            public void setForeground(Color foreground) {
                if (foreground == null) {
                    foreground = Color.BLACK;
                }
                super.setForeground(UIUtils.getDisabledForeground(foreground));
            }

            @Override
            public Dimension getPreferredSize() {
                if (NumberPercentRenderer.this.percentSize == null) {
                    NumberPercentRenderer.this.percentSize = super.getPreferredSize();
                }
                return NumberPercentRenderer.this.percentSize;
            }
        };
        this.percentRenderer.changeFontSize(-1);
        this.percentRenderer.setMargin(3, 0, 3, 3);
        this.percentRenderer.setHorizontalAlignment(11);
        this.percentRenderer.setMaxValue(100L);
        this.percentRenderer.setValue(9999, -1);
        this.percentSize.width = fixedWidth = this.percentRenderer.getPreferredSize().width;
        this.renderers = new ProfilerRenderer[]{this.valueRenderer, this.percentRenderer};
        this.setOpaque(true);
        this.setHorizontalAlignment(11);
    }

    @Override
    protected ProfilerRenderer[] valueRenderers() {
        return this.renderers;
    }

    public void setMaxValue(long maxValue) {
        this.percentRenderer.setMaxValue(maxValue);
    }

    @Override
    public void setValue(Object value, int row) {
        this.valueRenderer.setValue(value, row);
        this.percentRenderer.setValue(value, row);
    }

    @Override
    public void setDiffMode(boolean diffMode) {
        this.percentRenderer.setVisible(!diffMode);
        super.setDiffMode(diffMode);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = this.valueRenderer.getComponent().getPreferredSize();
        if (this.percentRenderer.isVisible()) {
            dim.width += this.percentRenderer.getPreferredSize().width;
        }
        return this.sharedDimension(dim);
    }

    private static ProfilerRenderer createNumberRenderer(Format customFormat) {
        NumberRenderer numberRenderer = new NumberRenderer(customFormat);
        numberRenderer.setMargin(3, 3, 3, 3);
        return numberRenderer;
    }

    @Override
    public String toString() {
        if (!this.percentRenderer.isVisible()) {
            return this.valueRenderer.toString();
        }
        return this.valueRenderer.toString() + " " + this.percentRenderer.toString();
    }
}

