/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http;

import com.sun.grizzly.DefaultSelectionKeyHandler;
import com.sun.grizzly.http.KeepAliveThreadAttachment;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.util.Copyable;
import com.sun.grizzly.util.SelectionKeyAttachment;
import java.nio.channels.SelectionKey;
import java.util.Iterator;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectorThreadKeyHandler
extends DefaultSelectionKeyHandler {
    private SelectorThread selectorThread;

    public SelectorThreadKeyHandler() {
    }

    public SelectorThreadKeyHandler(SelectorThread selectorThread) {
        this.selectorThread = selectorThread;
    }

    public void copyTo(Copyable copy) {
        super.copyTo(copy);
        SelectorThreadKeyHandler copyHandler = (SelectorThreadKeyHandler)copy;
        copyHandler.selectorThread = this.selectorThread;
    }

    public void doRegisterKey(SelectionKey key, int ops, long currentTime) {
        Object attachment = key.attachment();
        if (attachment instanceof KeepAliveThreadAttachment) {
            if (!key.isValid()) {
                this.selectorThread.cancelKey(key);
                return;
            }
            KeepAliveThreadAttachment k = (KeepAliveThreadAttachment)((Object)attachment);
            k.setTimeout(currentTime);
        } else {
            this.addExpirationStamp(key);
        }
        key.interestOps(key.interestOps() | ops);
    }

    public void cancel(SelectionKey key) {
        if (key == null) {
            return;
        }
        Object attachment = key.attachment();
        if (attachment instanceof KeepAliveThreadAttachment) {
            KeepAliveThreadAttachment k = (KeepAliveThreadAttachment)((Object)attachment);
            k.resetKeepAliveCount();
        }
        super.cancel(key);
    }

    public void resetExpiration() {
        this.nextKeysExpiration = 0L;
    }

    public void expire(Iterator<SelectionKey> iterator) {
        long currentTime = System.currentTimeMillis();
        if (currentTime < this.nextKeysExpiration) {
            return;
        }
        this.nextKeysExpiration = currentTime + 1000L;
        while (iterator.hasNext()) {
            KeepAliveThreadAttachment k;
            long idleLimit;
            long expire;
            Object attachment;
            SelectionKey key = iterator.next();
            if (!key.isValid() || (attachment = key.attachment()) == null || (expire = this.getExpirationStamp(attachment)) == Long.MIN_VALUE) continue;
            if (attachment instanceof KeepAliveThreadAttachment) {
                long activeThreadTimeout = ((KeepAliveThreadAttachment)((Object)attachment)).getActiveThreadTimeout();
                if (activeThreadTimeout != Long.MIN_VALUE) {
                    idleLimit = activeThreadTimeout;
                } else {
                    idleLimit = ((SelectionKeyAttachment)attachment).getIdleTimeoutDelay();
                    if (idleLimit == Long.MIN_VALUE) {
                        idleLimit = this.timeout;
                    }
                }
            } else {
                idleLimit = this.timeout;
            }
            if (idleLimit == -1L || currentTime - expire < idleLimit) continue;
            if (attachment instanceof Response.ResponseAttachment) {
                ((Response.ResponseAttachment)attachment).timeout();
                key.attach(null);
                continue;
            }
            if (attachment instanceof KeepAliveThreadAttachment && (k = (KeepAliveThreadAttachment)((Object)attachment)).activeThread() != null) {
                if (this.logger.isLoggable(Level.WARNING)) {
                    this.logger.log(Level.WARNING, "Interrupting idle Thread: " + k.activeThread().getName());
                }
                k.activeThread().interrupt();
            }
            this.cancel(key);
        }
    }

    private long getExpirationStamp(Object attachment) {
        if (attachment instanceof SelectionKeyAttachment) {
            return ((SelectionKeyAttachment)attachment).getTimeout();
        }
        if (attachment instanceof Response.ResponseAttachment) {
            return ((Response.ResponseAttachment)attachment).getExpirationTime() - this.timeout;
        }
        return Long.MIN_VALUE;
    }
}

