### R code from vignette source 'sets.Rnw'

###################################################
### code chunk number 1: preliminaries
###################################################
library("sets")
options(prompt = "R> ", continue = "+  ", width = 77)


###################################################
### code chunk number 2: sets.Rnw:146-149
###################################################
s <- list(1, "1")
union(s, s)
intersect(s, s)


###################################################
### code chunk number 3: sets1
###################################################
s <- set(1L, 2L, 3L)
print(s)


###################################################
### code chunk number 4: sets.Rnw:323-324
###################################################
set("test", c, set("a", 2.5), list(1, 2))


###################################################
### code chunk number 5: sets.Rnw:328-329
###################################################
set(1, pair(1,2), tuple(1L, 2L, 3L))


###################################################
### code chunk number 6: sets.Rnw:333-335
###################################################
s2 <- as.set(2:4)
print(s2)


###################################################
### code chunk number 7: setpredicates
###################################################
set_is_empty(set())
set(1) <= set(1,2)


###################################################
### code chunk number 8: sets.Rnw:347-348
###################################################
1:4 %e% set(1L, 2L, 3L)


###################################################
### code chunk number 9: sets.Rnw:357-358
###################################################
length(s)


###################################################
### code chunk number 10: sets.Rnw:362-365
###################################################
s | set("a")
s & s2
s %D% s2


###################################################
### code chunk number 11: sets.Rnw:369-371
###################################################
s * s2
s ^ 2L


###################################################
### code chunk number 12: sets.Rnw:374-375
###################################################
2 ^ s


###################################################
### code chunk number 13: sets.Rnw:384-385
###################################################
set_complement(set(1), set(1,2,3))


###################################################
### code chunk number 14: >
###################################################
!set(1)


###################################################
### code chunk number 15: <
###################################################
## subsets
set_combn(s, 2L)


###################################################
### code chunk number 16: sets.Rnw:410-413
###################################################
cl <- closure(set(set(1), set(2), set(3)), "union")
print(cl)
reduction(cl, "union")


###################################################
### code chunk number 17: setsummary
###################################################
sum(s)
range(s)


###################################################
### code chunk number 18: sets.Rnw:425-431
###################################################
s2 <- set(1,2, c, list(1,2))
print(s2)
s2[[c]] <- "foo"
s2[[list(1, 2)]] <- "bar"
print(s2)
s2[list("foo", 1)]


###################################################
### code chunk number 19: iterators
###################################################
sapply(s, sqrt)
for (i in s) print(i)


###################################################
### code chunk number 20: setouter
###################################################
set_outer(set(1,2), set(1,2,3), "/")


###################################################
### code chunk number 21: sets.Rnw:498-500
###################################################
X <- c("A", "B", "C")
gset(support = X)


###################################################
### code chunk number 22: sets.Rnw:505-506
###################################################
gset(support = X, universe = LETTERS[1:10])


###################################################
### code chunk number 23: sets.Rnw:509-511
###################################################
multi <- 1:3
gset(support = X, memberships = multi)


###################################################
### code chunk number 24: sets.Rnw:514-516
###################################################
ms <- c(0.1, 0.3, 1)
gset(support = X, memberships = ms)


###################################################
### code chunk number 25: sets.Rnw:520-521
###################################################
gset(elements = list(e("A", 0.1), e("B", 0.2), e("C", 0.3)))


###################################################
### code chunk number 26: sets.Rnw:525-527
###################################################
f <- function(x) switch(x, A = 0.1, B = 0.2, C = 1, 0)
gset(universe = X, charfun = f)


###################################################
### code chunk number 27: sets.Rnw:532-535
###################################################
ms2 <- list(c(0.1, 0.3, 0.4), c(1, 1),
  gset(support = ms, memberships = multi))
gset(support = X, memberships = ms2)


###################################################
### code chunk number 28: sets.Rnw:550-555
###################################################
X <- gset(c("A", "B", "C"), 4:6)
Y <- gset(c("B", "C", "D"), 1:3)

X | Y
X & Y


###################################################
### code chunk number 29: sets.Rnw:561-564
###################################################
X + Y
X - Y
gset_product(X, Y)


###################################################
### code chunk number 30: sets.Rnw:568-573
###################################################
!gset(1, 0.3)
X <- gset("a", universe = letters[1:3])
!X
!!X
!gset(1L, 2, universe = 1:3, bound = 3)


###################################################
### code chunk number 31: sets.Rnw:579-585
###################################################
x <- gset(1:3, 1:3/3)
y <- gset(1:2, 1:2/2)
gset_mean(x, y)
gset_mean(x, y, "harmonic")

gset_mean(set(1), set(1, 2))


###################################################
### code chunk number 32: sets.Rnw:592-594
###################################################
x <- gset(1:10, 1:10/10)
gset_transform_memberships(x, pmax, 0.5)


###################################################
### code chunk number 33: sets.Rnw:599-601
###################################################
x <- gset(1, 2)
gset_transform_memberships(x, `*`, 0.5)


###################################################
### code chunk number 34: sets.Rnw:605-606
###################################################
rep(x, 0.5)


###################################################
### code chunk number 35: sets.Rnw:614-617
###################################################
gset_dilate(y)
gset_concentrate(y)
gset_normalize(y, 0.5)


###################################################
### code chunk number 36: fuzzy
###################################################
x <- 1:10 / 10
y <- rev(x)
.S.(x, y)
fuzzy_logic("Fodor")
.S.(x, y)


###################################################
### code chunk number 37: sets.Rnw:650-654
###################################################
X <- gset(c("A", "B", "C"), c(0.3, 0.5, 0.8))
print(X)
Y <- gset(c("B", "C", "D"), c(0.1, 0.3, 0.9))
print(Y)


###################################################
### code chunk number 38: sets.Rnw:657-661
###################################################
fuzzy_logic("Zadeh")
X & Y
X | Y
gset_complement(X, Y)


###################################################
### code chunk number 39: sets.Rnw:664-668
###################################################
fuzzy_logic("Fodor")
X & Y
X | Y
gset_complement(X, Y)


###################################################
### code chunk number 40: fuzzyoff
###################################################
fuzzy_logic("Zadeh")


###################################################
### code chunk number 41: sets.Rnw:677-678
###################################################
cut(X, 0.5)


###################################################
### code chunk number 42: sets.Rnw:700-704
###################################################
N <- fuzzy_normal(mean = 0, sd = 1)
N(-3:3)

gset(charfun = N, universe = -3:3)


###################################################
### code chunk number 43: sets.Rnw:709-710
###################################################
fuzzy_normal_gset(universe = -3:3)


###################################################
### code chunk number 44: sets.Rnw:716-718
###################################################
fuzzy_poisson <- charfun_generator(dpois)
gset(charfun = fuzzy_poisson(10), universe = seq(0, 20, 2))


###################################################
### code chunk number 45: sets.Rnw:726-728
###################################################
## creating a series of fuzzy normal sets
fuzzy_tuple(fuzzy_normal, 5)


###################################################
### code chunk number 46: plot1
###################################################
## a fuzzy multiset
X <- gset(c("A", "B"), list(1:2/2, 0.5))
plot(X)


###################################################
### code chunk number 47: plot2
###################################################
plot(fuzzy_bell)


###################################################
### code chunk number 48: plot3
###################################################
## creating a sequence of sets
plot(fuzzy_tuple(fuzzy_cone, 10), col = gray.colors(10))


###################################################
### code chunk number 49: plot4
###################################################
x <- fuzzy_normal_gset()
y <- fuzzy_trapezoid_gset(corners = c(5, 10, 15, 17), height = c(0.7, 1))
plot(tuple(x, y), lty = 3)
lines(x | y, col = 2)
lines(gset_mean(x, y), col = 3, lty = 2)


###################################################
### code chunk number 50: plot1fig
###################################################
## a fuzzy multiset
X <- gset(c("A", "B"), list(1:2/2, 0.5))
plot(X)


###################################################
### code chunk number 51: plot2fig
###################################################
plot(fuzzy_bell)


###################################################
### code chunk number 52: plot3fig
###################################################
## creating a sequence of sets
plot(fuzzy_tuple(fuzzy_cone, 10), col = gray.colors(10))


###################################################
### code chunk number 53: plot4fig
###################################################
x <- fuzzy_normal_gset()
y <- fuzzy_trapezoid_gset(corners = c(5, 10, 15, 17), height = c(0.7, 1))
plot(tuple(x, y), lty = 3)
lines(x | y, col = 2)
lines(gset_mean(x, y), col = 3, lty = 2)


###################################################
### code chunk number 54: sets.Rnw:822-830
###################################################
x <- set("1", 1L, 1, 3.3 - 2.2, 1.1)
print(x)

y <- set(1, 1.1, 2L, "2")
print(y)
1L %e% y

x | y


###################################################
### code chunk number 55: sets.Rnw:834-840
###################################################
X <- cset(x, matchfun = match)
print(X)
Y <- cset(y, matchfun = match)
print(Y)
1L %e% Y
X | Y


###################################################
### code chunk number 56: sets.Rnw:850-858
###################################################
FUN <- matchfun(function(x, y) isTRUE(all.equal(x, y)))
X <- cset(x, matchfun = FUN)
print(X)
Y <- cset(y, matchfun = FUN)
print(Y)
1L %e% Y

X | Y


###################################################
### code chunk number 57: sets.Rnw:863-868
###################################################
sets_options("matchfun", match)
cset(x)
cset(y)

cset(1:3) <= cset(c("1", "2", "3"))


###################################################
### code chunk number 58: sets.Rnw:870-872
###################################################
### restore package defaults
sets_options("matchfun", NULL)


###################################################
### code chunk number 59: sets.Rnw:888-894
###################################################
cset(letters[1:5], orderfun = 5:1)

FUN <- function(x) order(as.character(x), decreasing = TRUE)
Z <- cset(letters[1:5], orderfun = FUN)
print(Z)
as.character(Z)


###################################################
### code chunk number 60: sets.Rnw:897-901
###################################################
o <- ordered(c("a", "b", "a"), levels = c("b", "a"))
as.set(o)
as.gset(o)
as.cset(o)


###################################################
### code chunk number 61: sets.Rnw:905-907
###################################################
as.cset(c("A", "quick", "brown", "fox"))
as.cset(c("A", "quick", "brown", "fox", "quick"))


###################################################
### code chunk number 62: sets.Rnw:923-925
###################################################
set.seed(4711)
l <- r2dtable(1000, r = 1:2, c = 2:1)


###################################################
### code chunk number 63: sets.Rnw:932-933
###################################################
l[1:2]


###################################################
### code chunk number 64: sets.Rnw:937-939
###################################################
s <- as.gset(l)
print(s)


###################################################
### code chunk number 65: sets.Rnw:942-944
###################################################
for (i in s) s[[i]] <- i[1]
print(s)


###################################################
### code chunk number 66: sets.Rnw:948-949
###################################################
gset_memberships(s) / 1000


###################################################
### code chunk number 67: sets.Rnw:953-954
###################################################
fisher.test(l[[1]])$p.value


###################################################
### code chunk number 68: sets.Rnw:969-971
###################################################
data("fuzzy_docs")
print(fuzzy_docs[8:9])


###################################################
### code chunk number 69: sets.Rnw:988-990
###################################################
library("proxy")
d <- dist(fuzzy_docs, gset_dissimilarity)


###################################################
### code chunk number 70: sets.Rnw:993-994
###################################################
cl1 <- hclust(d, "ward")


###################################################
### code chunk number 71: sets.Rnw:999-1001
###################################################
labs1 <- cutree(cl1, 2)
print(labs1)


###################################################
### code chunk number 72: clusterplot
###################################################
plot(cl1)


###################################################
### code chunk number 73: sets.Rnw:1022-1025
###################################################
tdm <- set_outer(c("neural networks", "fuzzy", "image"),
  fuzzy_docs, `%in%`)
print(tdm)


###################################################
### code chunk number 74: sets.Rnw:1028-1029
###################################################
d <- dist(tdm, "Jaccard", by_rows = FALSE)


###################################################
### code chunk number 75: sets.Rnw:1033-1034
###################################################
cl2 <- hclust(d, "ward")


###################################################
### code chunk number 76: sets.Rnw:1038-1041
###################################################
labs2 <- cutree(cl2, 2)
print(labs2)
table(labs1, labs2)


###################################################
### code chunk number 77: clusterplot2
###################################################
plot(cl2)


