/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.DataInput;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.composites.CType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.ObjectSizes;

public class IndexHelper {
    public static void skipBloomFilter(DataInput in) throws IOException {
        int size = in.readInt();
        FileUtils.skipBytesFully(in, size);
    }

    public static void skipIndex(DataInput in) throws IOException {
        int columnIndexSize = in.readInt();
        if (in instanceof FileDataInput) {
            FileUtils.skipBytesFully(in, columnIndexSize);
        } else {
            byte[] skip = new byte[columnIndexSize];
            in.readFully(skip);
        }
    }

    public static int indexFor(Composite name, List<IndexInfo> indexList, CType comparator, boolean reversed, int lastIndex) {
        int index;
        if (name.isEmpty()) {
            return lastIndex >= 0 ? lastIndex : (reversed ? indexList.size() - 1 : 0);
        }
        if (lastIndex >= indexList.size()) {
            return -1;
        }
        IndexInfo target = new IndexInfo(name, name, 0L, 0L);
        int startIdx = 0;
        List<IndexInfo> toSearch = indexList;
        if (lastIndex >= 0) {
            if (reversed) {
                toSearch = indexList.subList(0, lastIndex + 1);
            } else {
                startIdx = lastIndex;
                toSearch = indexList.subList(lastIndex, indexList.size());
            }
        }
        return startIdx + ((index = Collections.binarySearch(toSearch, target, IndexHelper.getComparator(comparator, reversed))) < 0 ? -index - (reversed ? 2 : 1) : index);
    }

    public static Comparator<IndexInfo> getComparator(CType nameComparator, boolean reversed) {
        return reversed ? nameComparator.indexReverseComparator() : nameComparator.indexComparator();
    }

    public static class IndexInfo {
        private static final long EMPTY_SIZE = ObjectSizes.measure(new IndexInfo(null, null, 0L, 0L));
        public final long width;
        public final Composite lastName;
        public final Composite firstName;
        public final long offset;

        public IndexInfo(Composite firstName, Composite lastName, long offset, long width) {
            this.firstName = firstName;
            this.lastName = lastName;
            this.offset = offset;
            this.width = width;
        }

        public long unsharedHeapSize() {
            return EMPTY_SIZE + this.firstName.unsharedHeapSize() + this.lastName.unsharedHeapSize();
        }

        public static class Serializer
        implements ISerializer<IndexInfo> {
            private final CType type;

            public Serializer(CType type) {
                this.type = type;
            }

            @Override
            public void serialize(IndexInfo info, DataOutputPlus out) throws IOException {
                this.type.serializer().serialize(info.firstName, out);
                this.type.serializer().serialize(info.lastName, out);
                out.writeLong(info.offset);
                out.writeLong(info.width);
            }

            @Override
            public IndexInfo deserialize(DataInput in) throws IOException {
                return new IndexInfo((Composite)this.type.serializer().deserialize(in), (Composite)this.type.serializer().deserialize(in), in.readLong(), in.readLong());
            }

            @Override
            public long serializedSize(IndexInfo info, TypeSizes typeSizes) {
                return this.type.serializer().serializedSize(info.firstName, typeSizes) + this.type.serializer().serializedSize(info.lastName, typeSizes) + (long)typeSizes.sizeof(info.offset) + (long)typeSizes.sizeof(info.width);
            }
        }
    }
}

