/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.generate;

import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.stress.generate.PartitionGenerator;
import org.apache.cassandra.stress.generate.Row;
import org.apache.cassandra.stress.generate.Seed;
import org.apache.cassandra.stress.generate.SeedManager;
import org.apache.cassandra.stress.generate.values.Generator;
import org.apache.cassandra.utils.Pair;

public abstract class PartitionIterator
implements Iterator<Row> {
    PartitionGenerator.Order order;
    long idseed;
    Seed seed;
    final PartitionGenerator generator;
    final SeedManager seedManager;
    final Object[] partitionKey;
    final Row row;

    abstract boolean reset(double var1, double var3, int var5, boolean var6, PartitionGenerator.Order var7);

    public abstract Pair<Row, Row> resetToBounds(Seed var1, int var2);

    public static PartitionIterator get(PartitionGenerator generator, SeedManager seedManager) {
        if (generator.clusteringComponents.size() > 0) {
            return new MultiRowIterator(generator, seedManager);
        }
        return new SingleRowIterator(generator, seedManager);
    }

    private PartitionIterator(PartitionGenerator generator, SeedManager seedManager) {
        this.generator = generator;
        this.seedManager = seedManager;
        this.partitionKey = new Object[generator.partitionKey.size()];
        this.row = new Row(this.partitionKey, new Object[generator.clusteringComponents.size() + generator.valueComponents.size()]);
    }

    void setSeed(Seed seed) {
        long idseed = 0L;
        for (int i = 0; i < this.partitionKey.length; ++i) {
            Generator generator = this.generator.partitionKey.get(i);
            generator.setSeed(seed.seed);
            Object key = generator.generate();
            this.partitionKey[i] = key;
            idseed = PartitionIterator.seed(key, generator.type, idseed);
        }
        this.seed = seed;
        this.idseed = idseed;
    }

    public boolean reset(Seed seed, double useChance, double rowPopulationRatio, boolean isWrite) {
        this.setSeed(seed);
        this.order = this.generator.order;
        return this.reset(useChance, rowPopulationRatio, 0, isWrite, this.order);
    }

    public boolean reset(Seed seed, int targetCount, double rowPopulationRatio, boolean isWrite) {
        this.setSeed(seed);
        this.order = this.generator.order;
        return this.reset(Double.NaN, rowPopulationRatio, targetCount, isWrite, this.order);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    static long seed(Object object, AbstractType type, long seed) {
        if (object instanceof ByteBuffer) {
            ByteBuffer buf = (ByteBuffer)object;
            for (int i = buf.position(); i < buf.limit(); ++i) {
                seed = 31L * seed + (long)buf.get(i);
            }
            return seed;
        }
        if (object instanceof String) {
            String str = (String)object;
            for (int i = 0; i < str.length(); ++i) {
                seed = 31L * seed + (long)str.charAt(i);
            }
            return seed;
        }
        if (object instanceof Number) {
            return seed * 31L + ((Number)object).longValue();
        }
        if (object instanceof UUID) {
            return seed * 31L + (((UUID)object).getLeastSignificantBits() ^ ((UUID)object).getMostSignificantBits());
        }
        return PartitionIterator.seed(type.decompose(object), (AbstractType)BytesType.instance, seed);
    }

    public Object getPartitionKey(int i) {
        return this.partitionKey[i];
    }

    public String getKeyAsString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (Object key : this.partitionKey) {
            if (i > 0) {
                sb.append("|");
            }
            AbstractType type = this.generator.partitionKey.get((int)i++).type;
            sb.append(type.getString(type.decompose(key)));
        }
        return sb.toString();
    }

    public ByteBuffer getToken() {
        return this.generator.partitionKey.get((int)0).type.decompose(this.partitionKey[0]);
    }

    static class MultiRowIterator
    extends PartitionIterator {
        final long[] clusteringSeeds;
        final Deque<Object>[] clusteringComponents;
        double useChance;
        double rowPopulationRatio;
        final double totalValueColumns;
        final double[] chancemodifier;
        final double[] rollmodifier;
        final int[] currentRow;
        final int[] lastRow;
        boolean hasNext;
        boolean isFirstWrite;
        boolean isWrite;
        final Set<Object> unique;
        final List<Object> tosort;

        MultiRowIterator(PartitionGenerator generator, SeedManager seedManager) {
            super(generator, seedManager);
            this.clusteringSeeds = new long[this.generator.clusteringComponents.size()];
            this.clusteringComponents = new ArrayDeque[this.generator.clusteringComponents.size()];
            this.chancemodifier = new double[this.generator.clusteringComponents.size()];
            this.rollmodifier = new double[this.generator.clusteringComponents.size()];
            this.currentRow = new int[this.generator.clusteringComponents.size()];
            this.lastRow = new int[this.currentRow.length];
            this.unique = new HashSet<Object>();
            this.tosort = new ArrayList<Object>();
            for (int i = 0; i < this.clusteringComponents.length; ++i) {
                this.clusteringComponents[i] = new ArrayDeque<Object>();
            }
            this.rollmodifier[0] = 1.0;
            this.chancemodifier[0] = generator.clusteringDescendantAverages[0];
            this.totalValueColumns = generator.valueComponents.size();
        }

        @Override
        boolean reset(double useChance, double rowPopulationRatio, int targetCount, boolean isWrite, PartitionGenerator.Order order) {
            this.isWrite = isWrite;
            this.rowPopulationRatio = rowPopulationRatio;
            this.order = order;
            this.generator.clusteringComponents.get(0).setSeed(this.idseed);
            int firstComponentCount = (int)this.generator.clusteringComponents.get((int)0).clusteringDistribution.next();
            int position = this.seed.position();
            int expectedRowCount = isWrite ? firstComponentCount * this.generator.clusteringDescendantAverages[0] : (position != 0 ? this.setLastRow(position - 1) : this.setNoLastRow(firstComponentCount));
            if (Double.isNaN(useChance)) {
                useChance = Math.max(0.0, Math.min(1.0, (double)targetCount / (double)expectedRowCount));
            }
            this.setUseChance(useChance);
            while (true) {
                for (Deque<Object> q : this.clusteringComponents) {
                    q.clear();
                }
                this.fill(0);
                if (!isWrite) {
                    if (this.seek(0) != State.SUCCESS) {
                        throw new IllegalStateException();
                    }
                    return true;
                }
                int count = this.seed.visits == 1 ? 1 + (int)this.generator.maxRowCount : Math.max(1, expectedRowCount / this.seed.visits);
                position = this.seed.moveForwards(count);
                this.isFirstWrite = position == 0;
                this.setLastRow(position + count - 1);
                switch (this.seek(position)) {
                    case END_OF_PARTITION: {
                        return false;
                    }
                    case SUCCESS: {
                        return true;
                    }
                }
            }
        }

        void setUseChance(double useChance) {
            if (this.useChance < 1.0) {
                Arrays.fill(this.rollmodifier, 1.0);
                Arrays.fill(this.chancemodifier, 1.0);
            }
            this.useChance = useChance;
        }

        @Override
        public Pair<Row, Row> resetToBounds(Seed seed, int clusteringComponentDepth) {
            this.setSeed(seed);
            this.setUseChance(1.0);
            if (clusteringComponentDepth == 0) {
                this.reset(1.0, 1.0, -1, false, PartitionGenerator.Order.SORTED);
                return Pair.create((Object)new Row(this.partitionKey), (Object)new Row(this.partitionKey));
            }
            this.order = PartitionGenerator.Order.SORTED;
            assert (clusteringComponentDepth <= this.clusteringComponents.length);
            for (Deque<Object> q : this.clusteringComponents) {
                q.clear();
            }
            this.fill(0);
            Pair<int[], Object[]> bound1 = this.randomBound(clusteringComponentDepth);
            Pair<int[], Object[]> bound2 = this.randomBound(clusteringComponentDepth);
            if (MultiRowIterator.compare((int[])bound1.left, (int[])bound2.left) > 0) {
                Pair<int[], Object[]> tmp = bound1;
                bound1 = bound2;
                bound2 = tmp;
            }
            Arrays.fill(this.lastRow, 0);
            System.arraycopy(bound2.left, 0, this.lastRow, 0, ((int[])bound2.left).length);
            Arrays.fill(this.currentRow, 0);
            System.arraycopy(bound1.left, 0, this.currentRow, 0, ((int[])bound1.left).length);
            this.seekToCurrentRow();
            return Pair.create((Object)new Row(this.partitionKey, (Object[])bound1.right), (Object)new Row(this.partitionKey, (Object[])bound2.right));
        }

        private int setNoLastRow(int firstComponentCount) {
            Arrays.fill(this.lastRow, Integer.MAX_VALUE);
            return firstComponentCount * this.generator.clusteringDescendantAverages[0];
        }

        private int setLastRow(int position) {
            if (position < 0) {
                throw new IllegalStateException();
            }
            this.decompose(position, this.lastRow);
            int expectedRowCount = 0;
            for (int i = 0; i < this.lastRow.length; ++i) {
                int l = this.lastRow[i];
                expectedRowCount += l * this.generator.clusteringDescendantAverages[i];
            }
            return expectedRowCount + 1;
        }

        private int compareToLastRow(int depth) {
            int prev = 0;
            for (int i = 0; i <= depth; ++i) {
                int p = this.currentRow[i];
                int l = this.lastRow[i];
                int r = this.clusteringComponents[i].size();
                if (prev < 0) {
                    if (r <= 1) continue;
                    return -1;
                }
                if (p > l) {
                    return 1;
                }
                if (p == l) continue;
                if (r == 1) {
                    prev = p - l;
                    continue;
                }
                return -1;
            }
            return 0;
        }

        private void decompose(int scalar, int[] decomposed) {
            int avg;
            int i;
            for (i = 0; i < decomposed.length; ++i) {
                avg = this.generator.clusteringDescendantAverages[i];
                decomposed[i] = scalar / avg;
                scalar %= avg;
            }
            for (i = this.lastRow.length - 1; i > 0; --i) {
                avg = this.generator.clusteringComponentAverages[i];
                if (decomposed[i] < avg) continue;
                int n = i - 1;
                decomposed[n] = decomposed[n] + decomposed[i] / avg;
                int n2 = i;
                decomposed[n2] = decomposed[n2] % avg;
            }
        }

        private static int compare(int[] l, int[] r) {
            for (int i = 0; i < l.length; ++i) {
                if (l[i] == r[i]) continue;
                return Integer.compare(l[i], r[i]);
            }
            return 0;
        }

        private State seek(int scalar) {
            if (scalar == 0) {
                this.currentRow[0] = -1;
                this.clusteringComponents[0].addFirst(this);
                return this.setHasNext(this.advance(0, true));
            }
            this.decompose(scalar, this.currentRow);
            return this.seekToCurrentRow();
        }

        private State seekToCurrentRow() {
            int[] position = this.currentRow;
            for (int i = 0; i < position.length; ++i) {
                if (i != 0) {
                    this.fill(i);
                }
                for (int c = position[i]; c > 0; --c) {
                    this.clusteringComponents[i].poll();
                }
                if (this.clusteringComponents[i].isEmpty()) {
                    int j = i;
                    do {
                        if (--j < 0) {
                            return this.setHasNext(false);
                        }
                        this.clusteringComponents[j].poll();
                    } while (this.clusteringComponents[j].isEmpty());
                    int n = j;
                    position[n] = position[n] + 1;
                    Arrays.fill(position, j + 1, position.length, 0);
                    while (j < i) {
                        this.fill(++j);
                    }
                }
                this.row.row[i] = this.clusteringComponents[i].peek();
            }
            if (this.compareToLastRow(this.currentRow.length - 1) > 0) {
                return this.setHasNext(false);
            }
            int n = position.length - 1;
            position[n] = position[n] - 1;
            this.clusteringComponents[position.length - 1].addFirst(this);
            return this.setHasNext(this.advance(position.length - 1, true));
        }

        Row advance() {
            int depth = this.clusteringComponents.length - 1;
            long parentSeed = this.clusteringSeeds[depth];
            long rowSeed = MultiRowIterator.seed(this.clusteringComponents[depth].peek(), this.generator.clusteringComponents.get((int)depth).type, parentSeed);
            Row result = this.row.copy();
            double valueColumn = 0.0;
            for (int i = this.clusteringSeeds.length; i < this.row.row.length; ++i) {
                double d;
                Generator gen = this.generator.valueComponents.get(i - this.clusteringSeeds.length);
                valueColumn += 1.0;
                if (d / this.totalValueColumns > this.rowPopulationRatio) {
                    result.row[i] = null;
                    continue;
                }
                gen.setSeed(rowSeed);
                result.row[i] = gen.generate();
            }
            this.setHasNext(this.advance(depth, false));
            return result;
        }

        private boolean advance(int depth, boolean first) {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            this.clusteringComponents[depth].poll();
            int n = depth;
            this.currentRow[n] = this.currentRow[n] + 1;
            while (true) {
                if (this.clusteringComponents[depth].isEmpty()) {
                    if (depth == 0) {
                        return false;
                    }
                    this.clusteringComponents[--depth].poll();
                    int n2 = depth;
                    this.currentRow[n2] = this.currentRow[n2] + 1;
                    if (this.currentRow[n2] <= this.lastRow[depth]) continue;
                    return false;
                }
                int compareToLastRow = this.compareToLastRow(depth);
                if (compareToLastRow > 0) {
                    assert (!first);
                    return false;
                }
                boolean forceReturnOne = first && compareToLastRow == 0;
                double thischance = this.useChance * this.chancemodifier[depth];
                if (forceReturnOne || thischance > (double)0.99999f || thischance >= random.nextDouble()) {
                    this.row.row[depth] = this.clusteringComponents[depth].peek();
                    if (++depth == this.clusteringComponents.length) {
                        return true;
                    }
                    if (this.useChance < 1.0) {
                        this.rollmodifier[depth] = this.rollmodifier[depth - 1] / Math.min(1.0, thischance);
                        this.chancemodifier[depth] = (double)this.generator.clusteringDescendantAverages[depth] * this.rollmodifier[depth];
                    }
                    this.currentRow[depth] = 0;
                    this.fill(depth);
                    continue;
                }
                if (compareToLastRow >= 0) {
                    return false;
                }
                this.clusteringComponents[depth].poll();
                int n3 = depth;
                this.currentRow[n3] = this.currentRow[n3] + 1;
            }
        }

        private Pair<int[], Object[]> randomBound(int clusteringComponentDepth) {
            int d;
            ThreadLocalRandom rnd = ThreadLocalRandom.current();
            int[] position = new int[clusteringComponentDepth];
            Object[] bound = new Object[clusteringComponentDepth];
            position[0] = rnd.nextInt(this.clusteringComponents[0].size());
            bound[0] = Iterables.get(this.clusteringComponents[0], (int)position[0]);
            for (d = 1; d < clusteringComponentDepth; ++d) {
                this.fill(d);
                position[d] = rnd.nextInt(this.clusteringComponents[d].size());
                bound[d] = Iterables.get(this.clusteringComponents[d], (int)position[d]);
            }
            for (d = 1; d < clusteringComponentDepth; ++d) {
                this.clusteringComponents[d].clear();
            }
            return Pair.create((Object)position, (Object)bound);
        }

        void fill(int depth) {
            long seed = depth == 0 ? this.idseed : this.clusteringSeeds[depth - 1];
            Generator gen = this.generator.clusteringComponents.get(depth);
            gen.setSeed(seed);
            this.fill(this.clusteringComponents[depth], (int)gen.clusteringDistribution.next(), gen);
            this.clusteringSeeds[depth] = MultiRowIterator.seed(this.clusteringComponents[depth].peek(), this.generator.clusteringComponents.get((int)depth).type, seed);
        }

        void fill(Queue<Object> queue, int count, Generator generator) {
            if (count == 1) {
                queue.add(generator.generate());
                return;
            }
            switch (this.order) {
                case SORTED: {
                    if (Comparable.class.isAssignableFrom(generator.clazz)) {
                        int i;
                        this.tosort.clear();
                        for (i = 0; i < count; ++i) {
                            this.tosort.add(generator.generate());
                        }
                        Collections.sort(this.tosort);
                        for (i = 0; i < count; ++i) {
                            if (i != 0 && ((Comparable)this.tosort.get(i - 1)).compareTo(this.tosort.get(i)) >= 0) continue;
                            queue.add(this.tosort.get(i));
                        }
                        break;
                    }
                }
                case ARBITRARY: {
                    this.unique.clear();
                    for (int i = 0; i < count; ++i) {
                        Object next = generator.generate();
                        if (!this.unique.add(next)) continue;
                        queue.add(next);
                    }
                    break;
                }
                case SHUFFLED: {
                    int i;
                    this.unique.clear();
                    this.tosort.clear();
                    ThreadLocalRandom rand = ThreadLocalRandom.current();
                    for (i = 0; i < count; ++i) {
                        Object next = generator.generate();
                        if (!this.unique.add(next)) continue;
                        this.tosort.add(next);
                    }
                    for (i = 0; i < this.tosort.size(); ++i) {
                        int index = rand.nextInt(i, this.tosort.size());
                        Object obj = this.tosort.get(index);
                        this.tosort.set(index, this.tosort.get(i));
                        queue.add(obj);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public Row next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.advance();
        }

        public boolean finishedPartition() {
            return this.clusteringComponents[0].isEmpty();
        }

        private State setHasNext(boolean hasNext) {
            this.hasNext = hasNext;
            if (!hasNext) {
                boolean isLast = this.finishedPartition();
                if (this.isWrite) {
                    boolean isFirst = this.isFirstWrite;
                    if (isFirst) {
                        this.seedManager.markFirstWrite(this.seed, isLast);
                    }
                    if (isLast) {
                        this.seedManager.markLastWrite(this.seed, isFirst);
                    }
                }
                return isLast ? State.END_OF_PARTITION : State.AFTER_LIMIT;
            }
            return State.SUCCESS;
        }

        static enum State {
            END_OF_PARTITION,
            AFTER_LIMIT,
            SUCCESS;

        }
    }

    static class SingleRowIterator
    extends PartitionIterator {
        boolean done;
        boolean isWrite;
        double rowPopulationRatio;
        final double totalValueColumns;

        private SingleRowIterator(PartitionGenerator generator, SeedManager seedManager) {
            super(generator, seedManager);
            this.totalValueColumns = generator.valueComponents.size();
        }

        @Override
        public Pair<Row, Row> resetToBounds(Seed seed, int clusteringComponentDepth) {
            assert (clusteringComponentDepth == 0);
            this.setSeed(seed);
            this.reset(1.0, 1.0, 1, false, PartitionGenerator.Order.SORTED);
            return Pair.create((Object)new Row(this.partitionKey), (Object)new Row(this.partitionKey));
        }

        @Override
        boolean reset(double useChance, double rowPopulationRatio, int targetCount, boolean isWrite, PartitionGenerator.Order order) {
            this.done = false;
            this.isWrite = isWrite;
            this.rowPopulationRatio = rowPopulationRatio;
            return true;
        }

        @Override
        public boolean hasNext() {
            return !this.done;
        }

        @Override
        public Row next() {
            if (this.done) {
                throw new NoSuchElementException();
            }
            double valueColumn = 0.0;
            for (int i = 0; i < this.row.row.length; ++i) {
                if (this.generator.permitNulls(i)) {
                    double d;
                    valueColumn += 1.0;
                    if (d / this.totalValueColumns > this.rowPopulationRatio) {
                        this.row.row[i] = null;
                        continue;
                    }
                }
                Generator gen = this.generator.valueComponents.get(i);
                gen.setSeed(this.idseed);
                this.row.row[i] = gen.generate();
            }
            this.done = true;
            if (this.isWrite) {
                this.seedManager.markFirstWrite(this.seed, true);
                this.seedManager.markLastWrite(this.seed, true);
            }
            return this.row;
        }
    }
}

